/*
 * Decompiled with CFR 0.152.
 */
package ch.icit.pegasus.client.gui.submodules.tool.customer.sobconfiguration.utils;

import ch.icit.pegasus.client.gui.table.TableColumnInfo;
import ch.icit.pegasus.client.gui.table2.Table2;
import ch.icit.pegasus.client.gui.table2.Table2ButtonHandler;
import ch.icit.pegasus.client.gui.table2.Table2Model;
import ch.icit.pegasus.client.gui.table2.Table2RowModel;
import ch.icit.pegasus.client.gui.table2.Table2RowPanel;
import ch.icit.pegasus.client.gui.utils.CheckedListAdder;
import ch.icit.pegasus.client.gui.utils.DefaultLayout;
import ch.icit.pegasus.client.gui.utils.Nodable;
import ch.icit.pegasus.client.gui.utils.buttons.Button;
import ch.icit.pegasus.client.gui.utils.buttons.ButtonListener;
import ch.icit.pegasus.client.gui.utils.buttons.CheckBox;
import ch.icit.pegasus.client.gui.utils.buttons.DeleteButton;
import ch.icit.pegasus.client.gui.utils.datechooser.TitledPeriodEditor;
import ch.icit.pegasus.client.gui.utils.skins.SizedSkin1Field;
import ch.icit.pegasus.client.gui.utils.textfield.NumberTextField;
import ch.icit.pegasus.client.gui.utils.textfield.TextField;
import ch.icit.pegasus.client.gui.utils.textfield.TextFieldType;
import ch.icit.pegasus.client.node.INodeCreator;
import ch.icit.pegasus.client.node.impls.Node;
import ch.icit.pegasus.server.core.dtos.ADTO;
import ch.icit.pegasus.server.core.dtos.masterdata.PeriodComplete;
import ch.icit.pegasus.server.core.dtos.sob.SobCurrencyExchangeComplete;
import ch.icit.pegasus.server.core.i18n.Words;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.sql.Date;
import java.util.ArrayList;
import java.util.List;

public class SobCurrencyConfigurationTable
extends Table2
implements Nodable {
    private static final long serialVersionUID = 1L;

    public SobCurrencyConfigurationTable() {
        super(true, Words.TABLE_ADD, true, true);
        this.setTableText(Words.CURRENCY_SPECIFICATION);
        this.setTitleText("Periods");
        this.setButtonHandler(new Table2ButtonHandler(){

            @Override
            public void childRemoved() {
            }

            @Override
            public void addButtonPressed(int x, int y, Button source) {
                if (SobCurrencyConfigurationTable.this.getModel().getNode() != null) {
                    SobCurrencyExchangeComplete c = new SobCurrencyExchangeComplete();
                    c.setClientOId(Long.valueOf(ADTO.getNextId()));
                    c.setExChangeRate(Double.valueOf(1.0));
                    c.setIsChange(Boolean.valueOf(false));
                    c.setMinimumAmount(Double.valueOf(1.0));
                    c.setPersonalCheques(Boolean.valueOf(false));
                    c.setRoundingValue(Double.valueOf(1.0));
                    PeriodComplete p = new PeriodComplete(new Date(System.currentTimeMillis()), new Date(System.currentTimeMillis()));
                    c.setValidityPeriod(p);
                    Node n = INodeCreator.getDefaultImpl().getNode4DTO((Object)c, true, false);
                    SobCurrencyConfigurationTable.this.getModel().getNode().addChild(n, 0L);
                }
            }
        });
        ArrayList<TableColumnInfo> columns = new ArrayList<TableColumnInfo>();
        int dw = TitledPeriodEditor.getPreferredWidth(this) + CheckBox.getPreferredWidth() + 3 * this.getCellPadding();
        columns.add(new TableColumnInfo(Words.FROM, null, null, null, "", dw, dw, dw));
        columns.add(new TableColumnInfo(Words.RATE, null, null, null, "", 100, 100, 100));
        columns.add(new TableColumnInfo(Words.MINIMUM, null, null, null, "", 100, 100, 100));
        columns.add(new TableColumnInfo(Words.ROUNDING, null, null, null, "", 100, 100, 100));
        columns.add(new TableColumnInfo(Words.CHEQUES, null, null, null, "", 80, 80, 80));
        columns.add(new TableColumnInfo(Words.RET, null, null, null, "", 60, 60, 60));
        int tw = 2 * this.getCellPadding() + DeleteButton.getPreferredWidth(SizedSkin1Field.SkinSize.SMALL);
        columns.add(new TableColumnInfo("", null, null, null, "", tw, tw, tw));
        ((TableColumnInfo)columns.get(0)).setxExpand(0.0);
        ((TableColumnInfo)columns.get(1)).setxExpand(0.3);
        ((TableColumnInfo)columns.get(2)).setxExpand(0.3);
        ((TableColumnInfo)columns.get(3)).setxExpand(0.4);
        ((TableColumnInfo)columns.get(4)).setxExpand(0.0);
        ((TableColumnInfo)columns.get(5)).setxExpand(0.0);
        ((TableColumnInfo)columns.get(6)).setxExpand(0.0);
        this.setModel(new Table2Model(columns, model1 -> new TableRowImpl(model1)));
        this.setNode(null);
    }

    @Override
    public void setNode(Node<?> node) {
        if (node == null) {
            this.setEnabled(false);
        } else {
            this.setEnabled(true);
        }
        this.getModel().setNode(node);
    }

    @Override
    public Node<?> getNode() {
        return this.getModel().getNode();
    }

    private class TableRowImpl
    extends Table2RowPanel
    implements ButtonListener {
        private static final long serialVersionUID = 1L;
        private TitledPeriodEditor from;
        private TextField rate;
        private TextField min;
        private TextField rounding;
        private CheckBox cheque;
        private CheckBox retCurrency;
        private DeleteButton delete;

        public TableRowImpl(Table2RowModel m) {
            super(m);
            this.setUseControlSkin(Table2RowPanel.TableControlsType.ONE);
            this.from = new TitledPeriodEditor(null, false, null);
            this.from.enableInfinity(false, true);
            this.from.setStartDateNode(m.getNode().getChildNamed(new String[]{"validityPeriod-startDate"}));
            this.from.setEndDateNode(m.getNode().getChildNamed(new String[]{"validityPeriod-endDate"}));
            this.rate = new NumberTextField(m.getNode().getChildNamed(new String[]{"exChangeRate"}), TextFieldType.DOUBLE);
            this.min = new NumberTextField(m.getNode().getChildNamed(new String[]{"minimumAmount"}), TextFieldType.DOUBLE);
            this.rounding = new NumberTextField(m.getNode().getChildNamed(new String[]{"roundingValue"}), TextFieldType.DOUBLE);
            this.cheque = new CheckBox((Node<Boolean>)m.getNode().getChildNamed(new String[]{"personalCheques"}));
            this.retCurrency = new CheckBox((Node<Boolean>)m.getNode().getChildNamed(new String[]{"isChange"}));
            this.delete = new DeleteButton();
            this.delete.addButtonListener(this);
            this.setLayout(new Layout());
            this.add(this.from);
            this.add(this.rate);
            this.add(this.min);
            this.add(this.rounding);
            this.add(this.cheque);
            this.add(this.retCurrency);
            this.add(this.delete);
        }

        @Override
        public List<Component> getFocusComponents() {
            ArrayList<Component> a = new ArrayList<Component>();
            CheckedListAdder.addToList(a, this.from);
            CheckedListAdder.addToList(a, this.rate);
            CheckedListAdder.addToList(a, this.min);
            CheckedListAdder.addToList(a, this.rounding);
            CheckedListAdder.addToList(a, this.cheque);
            CheckedListAdder.addToList(a, this.retCurrency);
            CheckedListAdder.addToList(a, this.delete);
            return a;
        }

        @Override
        public Object getObject4Column(int column) {
            return this.model.getNode().getChildNamed(new String[]{"validityPeriod-startDate"}).getValue();
        }

        @Override
        public void setEnabled(boolean isEnabled) {
            super.setEnabled(isEnabled);
            this.from.setEnabled(isEnabled);
            this.rate.setEnabled(isEnabled);
            this.min.setEnabled(isEnabled);
            this.rounding.setEnabled(isEnabled);
            this.cheque.setEnabled(isEnabled);
            this.retCurrency.setEnabled(isEnabled);
            this.delete.setEnabled(isEnabled);
        }

        @Override
        public void kill() {
            if (this.isKilled()) {
                return;
            }
            super.kill();
            this.from.kill();
            this.from = null;
            this.rate.kill();
            this.rate = null;
            this.min.kill();
            this.min = null;
            this.rounding.kill();
            this.rounding = null;
            this.cheque.kill();
            this.cheque = null;
            this.retCurrency.kill();
            this.retCurrency = null;
            this.delete.kill();
            this.delete = null;
        }

        @Override
        public void buttonPressed(Button source, int x, int y) {
            if (source == this.delete) {
                this.model.getNode().getParent().removeChild(this.model.getNode(), 0L);
            }
        }

        private class Layout
        extends DefaultLayout {
            private Layout() {
            }

            @Override
            public Dimension preferredLayoutSize(Container parent) {
                return new Dimension(0, TableRowImpl.this.getDefaultRowHeight());
            }

            @Override
            public void layoutContainer(Container parent) {
                int currentX = 0;
                int w = TableRowImpl.this.getModel().getParentModel().getColumnWidth(0);
                TableRowImpl.this.from.setLocation(currentX + TableRowImpl.this.getCellPadding(), (int)(((double)parent.getHeight() - TableRowImpl.this.from.getPreferredSize().getHeight()) / 2.0));
                TableRowImpl.this.from.setSize(w - 2 * TableRowImpl.this.getCellPadding(), (int)TableRowImpl.this.from.getPreferredSize().getHeight());
                currentX += w;
                w = TableRowImpl.this.model.getParentModel().getColumnWidth(1);
                TableRowImpl.this.rate.setLocation(currentX + TableRowImpl.this.getCellPadding(), (int)(((double)parent.getHeight() - TableRowImpl.this.rate.getPreferredSize().getHeight()) / 2.0));
                TableRowImpl.this.rate.setSize(w - 2 * TableRowImpl.this.getCellPadding(), (int)TableRowImpl.this.rate.getPreferredSize().getHeight());
                currentX += w;
                w = TableRowImpl.this.model.getParentModel().getColumnWidth(2);
                TableRowImpl.this.min.setLocation(currentX + TableRowImpl.this.getCellPadding(), (int)(((double)parent.getHeight() - TableRowImpl.this.min.getPreferredSize().getHeight()) / 2.0));
                TableRowImpl.this.min.setSize(w - 2 * TableRowImpl.this.getCellPadding(), (int)TableRowImpl.this.min.getPreferredSize().getHeight());
                currentX += w;
                w = TableRowImpl.this.model.getParentModel().getColumnWidth(3);
                TableRowImpl.this.rounding.setLocation(currentX + TableRowImpl.this.getCellPadding(), (int)(((double)parent.getHeight() - TableRowImpl.this.rounding.getPreferredSize().getHeight()) / 2.0));
                TableRowImpl.this.rounding.setSize(w - 2 * TableRowImpl.this.getCellPadding(), (int)TableRowImpl.this.rounding.getPreferredSize().getHeight());
                currentX += w;
                w = TableRowImpl.this.model.getParentModel().getColumnWidth(4);
                TableRowImpl.this.cheque.setLocation(currentX + TableRowImpl.this.getCellPadding(), (int)(((double)parent.getHeight() - TableRowImpl.this.cheque.getPreferredSize().getHeight()) / 2.0));
                TableRowImpl.this.cheque.setSize(w - 2 * TableRowImpl.this.getCellPadding(), (int)TableRowImpl.this.cheque.getPreferredSize().getHeight());
                currentX += w;
                w = TableRowImpl.this.model.getParentModel().getColumnWidth(5);
                TableRowImpl.this.retCurrency.setLocation(currentX + TableRowImpl.this.getCellPadding(), (int)(((double)parent.getHeight() - TableRowImpl.this.retCurrency.getPreferredSize().getHeight()) / 2.0));
                TableRowImpl.this.retCurrency.setSize(TableRowImpl.this.retCurrency.getPreferredSize());
                currentX += w;
                w = TableRowImpl.this.model.getParentModel().getColumnWidth(6);
                TableRowImpl.this.setControlsX(currentX);
                TableRowImpl.this.delete.setLocation(currentX + TableRowImpl.this.getCellPadding(), (int)(((double)parent.getHeight() - TableRowImpl.this.delete.getPreferredSize().getHeight()) / 2.0));
                TableRowImpl.this.delete.setSize(TableRowImpl.this.delete.getPreferredSize());
            }
        }
    }
}

