/*
 * Decompiled with CFR 0.152.
 */
package ch.icit.pegasus.client.gui.submodules.tool.flight.rcdrawerbased;

import ch.icit.pegasus.client.converter.controller.ConverterRegistry;
import ch.icit.pegasus.client.gui.ConfigurationPanel;
import ch.icit.pegasus.client.gui.hud.smartscreen.RowSmartScreen;
import ch.icit.pegasus.client.gui.screentemplates.SubModuleScreenInsert;
import ch.icit.pegasus.client.gui.screentemplates.overview.data.IDataHandler;
import ch.icit.pegasus.client.gui.submodules.tool.flight.rcdrawerbased.ReturnsBreadCrumbTable;
import ch.icit.pegasus.client.gui.submodules.tool.flight.rcdrawerbased.utils.DepartmentConverter;
import ch.icit.pegasus.client.gui.table.fake.FakeSmartScreenTableRow;
import ch.icit.pegasus.client.gui.utils.DefaultLayout;
import ch.icit.pegasus.client.gui.utils.InnerPopUpListener2;
import ch.icit.pegasus.client.gui.utils.RowTransferObject;
import ch.icit.pegasus.client.gui.utils.TitledItem;
import ch.icit.pegasus.client.gui.utils.buttons.ButtonListener;
import ch.icit.pegasus.client.gui.utils.combobox.ComboBox;
import ch.icit.pegasus.client.gui.utils.filterchain.FilterChainConfiguration;
import ch.icit.pegasus.client.gui.utils.focus.CustomFocusCyclePolicy;
import ch.icit.pegasus.client.gui.utils.panels.LoadingAnimation;
import ch.icit.pegasus.client.gui.utils.popup.InnerPopUp2;
import ch.icit.pegasus.client.gui.utils.popup.InnerPopupFactory;
import ch.icit.pegasus.client.gui.utils.rightdependant.RDProvider;
import ch.icit.pegasus.client.node.INodeCreator;
import ch.icit.pegasus.client.node.impls.DTOProxyNode;
import ch.icit.pegasus.client.node.impls.Node;
import ch.icit.pegasus.client.node.impls.ViewNode;
import ch.icit.pegasus.client.services.ServiceManagerRegistry;
import ch.icit.pegasus.client.services.interfaces.DefaultServiceManager;
import ch.icit.pegasus.client.services.interfaces.flight.FlightServiceManager;
import ch.icit.pegasus.client.services.interfaces.masterdata.MasterDataServiceManager;
import ch.icit.pegasus.client.services.interfaces.system.UserServiceManager;
import ch.icit.pegasus.client.util.HUDToolkit;
import ch.icit.pegasus.client.util.RemoteLoader;
import ch.icit.pegasus.client.util.ScreenValidationList;
import ch.icit.pegasus.client.util.ScreenValidationObject;
import ch.icit.pegasus.client.util.async.ThreadSafeExecutable;
import ch.icit.pegasus.client.util.async.ThreadSafeLoader;
import ch.icit.pegasus.client.util.exception.ClientException;
import ch.icit.pegasus.client.util.exception.ClientServerCallException;
import ch.icit.pegasus.client.util.toolkits.StowingToolkit;
import ch.icit.pegasus.server.core.dtos.ADTO;
import ch.icit.pegasus.server.core.dtos.company.CostCenterComplete;
import ch.icit.pegasus.server.core.dtos.company.InternalCostCenterComplete;
import ch.icit.pegasus.server.core.dtos.flightschedule.FlightLight;
import ch.icit.pegasus.server.core.dtos.flightschedule.FlightReference;
import ch.icit.pegasus.server.core.dtos.flightschedule.FlightStateE;
import ch.icit.pegasus.server.core.dtos.flightschedule.ReturnsCountStateE;
import ch.icit.pegasus.server.core.dtos.flightschedule.returnscount.ReturnsCountDeliverySpaceComplete;
import ch.icit.pegasus.server.core.dtos.flightschedule.returnscount.ReturnsCountDeliverySpaceComplete_;
import ch.icit.pegasus.server.core.dtos.flightschedule.returnscount.ReturnsCountEquipmentComplete;
import ch.icit.pegasus.server.core.dtos.flightschedule.returnscount.ReturnsCountEquipmentComplete_;
import ch.icit.pegasus.server.core.dtos.flightschedule.returnscount.ReturnsCountFlightComplete;
import ch.icit.pegasus.server.core.dtos.flightschedule.returnscount.ReturnsCountFlightComplete_;
import ch.icit.pegasus.server.core.dtos.flightschedule.returnscount.ReturnsCountParameterConfig;
import ch.icit.pegasus.server.core.dtos.flightschedule.returnscount.ReturnsCountProductComplete;
import ch.icit.pegasus.server.core.dtos.masterdata.UserLight;
import ch.icit.pegasus.server.core.dtos.rightmanagement.access.ModuleAccessRightComplete;
import ch.icit.pegasus.server.core.dtos.rightmanagement.definition.SubModuleDefinitionComplete;
import ch.icit.pegasus.server.core.dtos.rightmanagement.template.SubModuleAccessDefinition;
import ch.icit.pegasus.server.core.dtos.rightmanagement.template.def.FlightAccess;
import ch.icit.pegasus.server.core.i18n.Words;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class ReturnsCountDrawerBasedSubModule
extends SubModuleScreenInsert<FlightLight>
implements RowSmartScreen<FlightLight>,
ItemListener,
ButtonListener {
    private static final long serialVersionUID = 1L;
    private boolean autoUpdateSales;
    private Node<List<ReturnsCountEquipmentComplete>> node;
    private FakeSmartScreenTableRow<FlightLight> currentRowModel;
    private LoadingAnimation animationPanel;
    private IDataHandler dataHandler;
    private int currentState = 0;
    private FlightLight flight;
    private ReturnsBreadCrumbTable detailsPanel;
    private ConfigurationPanel confPanel;
    private ComboBox costCenterChooser;
    private ComboBox editorStyle;
    private boolean init = true;
    protected ReturnsCountFlightComplete currentFlight;
    private RDProvider provider;
    public Node<ReturnsCountFlightComplete> flightNode;

    public ReturnsCountDrawerBasedSubModule() {
        ModuleAccessRightComplete m = HUDToolkit.getCurrentAccessRight(FlightAccess.MODULE_FLIGHT, ((UserServiceManager)ServiceManagerRegistry.getService(UserServiceManager.class)).getCurrentUser());
        this.provider = new RDProvider(m, false);
    }

    public EditorType isManualSales() {
        return EditorType.RETURNS_COUNT_TRAY_BASED;
    }

    public boolean isSalesEditAllowed() {
        return this.provider.isWritable("editSales");
    }

    void createFocusCycle() {
    }

    public RDProvider getProvider() {
        return this.provider;
    }

    public String getCountColumnName() {
        return "RETURN [STOCK]";
    }

    @Override
    public void saveAndBackDocument() {
        this.currentState = 11;
        this.save();
    }

    @Override
    public void saveDocument() {
        this.currentState = 7;
        this.save();
    }

    private void save() {
        this.setEnabled(false);
        if (this.getFlight().getFlightState() == FlightStateE.OPEN || this.getFlight().getFlightState() == FlightStateE.EN_ROUTE) {
            Map m = (Map)this.flightNode.getChildNamed(ReturnsCountFlightComplete_.departments).getValue();
            HashMap<CostCenterComplete, Boolean> nm = new HashMap<CostCenterComplete, Boolean>();
            for (CostCenterComplete c : m.keySet()) {
                nm.put(c, false);
            }
            Node n = this.flightNode.getChildNamed(ReturnsCountFlightComplete_.departments);
            n.setValue(nm, 0L);
            this.continueSaveing();
        } else {
            this.flightNode.commit();
            ReturnsCountFlightComplete r = (ReturnsCountFlightComplete)this.flightNode.getValue();
            this.validateRC(r);
        }
    }

    public void updateProductsBeforeSaving() {
    }

    private void validateRC(ReturnsCountFlightComplete r) {
        this.updateProductsBeforeSaving();
        ScreenValidationList warnings = new ScreenValidationList();
        for (ReturnsCountEquipmentComplete e : r.getEquipments()) {
            for (ReturnsCountDeliverySpaceComplete d : e.getDeliverySpaces()) {
                for (ReturnsCountProductComplete p : d.getProducts()) {
                    int loaded;
                    if (Boolean.TRUE.equals(p.getProduct().getSalesOnBoard())) {
                        int missing;
                        int waste;
                        loaded = p.getUseRevisedDeliveredAmount() != false ? p.getRevisedDeliveredAmount() : p.getCalculatedDeliveredAmount();
                        int sold = p.getSoldAmount();
                        if (sold + (waste = p.getWasteAmount().intValue()) + (missing = p.getMissingAmount().intValue()) > loaded) {
                            String t = "Product " + p.getProduct().getNumber() + ": ";
                            if (waste > 0) {
                                t = t + "Waste (" + waste + ") ";
                            }
                            if (sold > 0) {
                                t = t + "sold (" + sold + ") ";
                            }
                            if (missing > 0) {
                                t = t + "missing (" + missing + ") ";
                            }
                            t = t + "Amount is greater than delivered (" + loaded + ") Amount";
                            warnings.add((Object)new ScreenValidationObject(ScreenValidationObject.ValidationStateE.FATAL, t));
                            continue;
                        }
                        int returned = loaded - (sold + waste + missing);
                        p.setCountedAmount(Integer.valueOf(returned));
                        if (!Boolean.TRUE.equals(p.getProduct().getSalesOnBoard()) || this.isManualSales() != EditorType.RETURNS_COUNT_TRAY_BASED || this.editorStyle == null || this.editorStyle.getSelectedItem() != EditorStyle.SALES) continue;
                        int factor = p.getConversionFactor();
                        if (factor <= 0) {
                            factor = 1;
                        }
                        p.setMachineSalesAmount(Integer.valueOf((loaded - returned) * factor));
                        continue;
                    }
                    loaded = p.getUseRevisedDeliveredAmount() != false ? p.getRevisedDeliveredAmount() : p.getCalculatedDeliveredAmount();
                    int returned = p.getCountedAmount();
                    int sold = loaded - returned;
                    int waste = 0;
                    int missing = 0;
                    p.setSoldAmount(Integer.valueOf(sold));
                    p.setWasteAmount(Integer.valueOf(waste));
                    p.setMissingAmount(Integer.valueOf(missing));
                    if (returned <= loaded) continue;
                    warnings.add((Object)new ScreenValidationObject(ScreenValidationObject.ValidationStateE.FATAL, "Product " + p.getProduct().getNumber() + ": returned Amount is greater than delivered Amount."));
                }
            }
        }
        if (!warnings.isEmpty()) {
            InnerPopupFactory.showErrorDialog((List<ScreenValidationObject>)warnings, "Unable to save Returns Count data", new InnerPopUpListener2(){

                @Override
                public void popUpClosed(InnerPopUp2 source, Object ... xargs) {
                    ReturnsCountDrawerBasedSubModule.this.setEnabled(true);
                }
            }, (Component)this);
        } else {
            this.askUser();
        }
    }

    private void askUser() {
        switch (this.isManualSales()) {
            case MANUAL_SALES: {
                this.continueSaveing();
                break;
            }
            case RC_AND_MANUAL_SALES: {
                this.askForFinishing();
                break;
            }
            case RETURNS_COUNT_EQUIMENT_BASED: 
            case RETURNS_COUNT_TRAY_BASED: {
                if (this.getCurrentEditorStyle() == EditorStyle.SALES) {
                    this.askForUpdateSales();
                    return;
                }
                this.askForFinishing();
                break;
            }
        }
    }

    private void askForFinishing() {
        String t = "<b>Returns Count for choosen department completed?</b><br/><br/>Press YES if you have entered all Returns Count data for given department, otherwise press NO.<br/>The data are saved anyway.";
        InnerPopupFactory.showDesicionPopup("Returns Count finished", t, this, new InnerPopUpListener2(){

            @Override
            public void popUpClosed(InnerPopUp2 source, Object ... xargs) {
                Map m = (Map)ReturnsCountDrawerBasedSubModule.this.flightNode.getChildNamed(ReturnsCountFlightComplete_.departments).getValue();
                HashMap<CostCenterComplete, Boolean> nm = new HashMap<CostCenterComplete, Boolean>();
                Object item = ReturnsCountDrawerBasedSubModule.this.costCenterChooser.getSelectedItem();
                if (item instanceof Node) {
                    item = ((Node)item).getValue();
                }
                for (CostCenterComplete c : m.keySet()) {
                    if (xargs == null) {
                        m.put(c, false);
                        continue;
                    }
                    boolean all = item == null;
                    nm.put(c, c.equals(item) || all);
                }
                Node n = ReturnsCountDrawerBasedSubModule.this.flightNode.getChildNamed(ReturnsCountFlightComplete_.departments);
                n.setValue(nm, 0L);
                n.updateNode();
                n = ReturnsCountDrawerBasedSubModule.this.flightNode.getChildNamed(ReturnsCountFlightComplete_.department);
                n.setValue(item, 0L);
                ReturnsCountDrawerBasedSubModule.this.flightNode.commit();
                ReturnsCountDrawerBasedSubModule.this.continueSaveing();
            }
        }, 350, 200);
    }

    private void askForUpdateSales() {
        String t = "<b>Auto Update Sales Data?</b><br/><br/>Press YES if you want to update the Sales data with the entered Returns Count data.";
        InnerPopupFactory.showDesicionPopup("Auto Update Sales", t, this, new InnerPopUpListener2(){

            @Override
            public void popUpClosed(InnerPopUp2 source, Object ... xargs) {
                if (xargs == null) {
                    ReturnsCountDrawerBasedSubModule.this.setAutoUpdateSales(false);
                } else {
                    ReturnsCountDrawerBasedSubModule.this.setAutoUpdateSales(true);
                }
                ReturnsCountDrawerBasedSubModule.this.askForFinishing();
            }
        }, 350, 200);
    }

    private void continueSaveing() {
        this.showAnimation(Words.SAVE_DATA);
        this.doSaveDocument();
    }

    public void doSaveDocument() {
        ThreadSafeExecutable run = new ThreadSafeExecutable(this){

            @Override
            public Node<?> loadData() throws Exception {
                ReturnsCountDrawerBasedSubModule.this.flightNode.commit();
                ReturnsCountFlightComplete r = (ReturnsCountFlightComplete)ReturnsCountDrawerBasedSubModule.this.flightNode.getValue();
                if (r.getEquipments().isEmpty()) {
                    ViewNode rt = new ViewNode("Error");
                    rt.setValue((Object)new ScreenValidationObject(ScreenValidationObject.ValidationStateE.FATAL, "No Equipments found in current Flight."), 0L);
                    return rt;
                }
                boolean updateSeals = false;
                switch (ReturnsCountDrawerBasedSubModule.this.getFlight().getFlightState()) {
                    case CANCELLED: 
                    case CLOSED: 
                    case DISPATCHED: {
                        updateSeals = true;
                        break;
                    }
                    case EN_ROUTE: 
                    case OPEN: 
                    case PLANNED: {
                        updateSeals = false;
                        break;
                    }
                }
                if (updateSeals) {
                    StowingToolkit.ensureSeals((ReturnsCountFlightComplete)r);
                }
                ReturnsCountDrawerBasedSubModule.this.currentFlight = ReturnsCountDrawerBasedSubModule.this.updateReturnsCountFlight(r);
                ReturnsCountDrawerBasedSubModule.this.performTransactionReturnsCountData((FlightReference)r.getFlight());
                return null;
            }

            @Override
            public RemoteLoader getInvoker() {
                return ReturnsCountDrawerBasedSubModule.this;
            }

            @Override
            public long getID() {
                return 0L;
            }
        };
        ThreadSafeLoader.run(run);
    }

    public ReturnsCountFlightComplete updateReturnsCountFlight(ReturnsCountFlightComplete r) throws ClientServerCallException {
        return (ReturnsCountFlightComplete)((FlightServiceManager)ServiceManagerRegistry.getService(FlightServiceManager.class)).updateCountItems(r, this.getAutoUpdateSales(), false).getValue();
    }

    @Override
    public void setEnabled(boolean isEnabled) {
        super.setEnabled(isEnabled);
        this.detailsPanel.setEnabled(isEnabled);
        this.confPanel.setEnabled(isEnabled);
    }

    public Node getNode() {
        return this.node;
    }

    public Node createView(Node node) {
        ViewNode n = new ViewNode("");
        ViewNode all = new ViewNode("");
        n.addChild((Node)all, 0L);
        Iterator it = node.getFailSafeChildIterator();
        while (it.hasNext()) {
            Node nn = (Node)it.next();
            ViewNode n2 = new ViewNode("");
            n2.setValue(nn.getValue(), 0L);
            n.addChild((Node)n2, 0L);
            Iterator it2 = nn.getChildNamed(ReturnsCountEquipmentComplete_.deliverySpaces).getFailSafeChildIterator();
            while (it2.hasNext()) {
                Node d = (Node)it2.next();
                Iterator it3 = d.getChildNamed(ReturnsCountDeliverySpaceComplete_.products).getFailSafeChildIterator();
                while (it3.hasNext()) {
                    Node p = (Node)it3.next();
                    all.addChild(p, 0L);
                    n2.addChild(p, 0L);
                }
            }
        }
        return n;
    }

    @Override
    public String getScreenTitle() {
        return FlightAccess.TOOL_RETURNS_COUNT_DRAWER_BASED.getDisplayName();
    }

    private void init(FakeSmartScreenTableRow<FlightLight> model) {
        this.currentRowModel = model;
        this.setRow(model);
        this.detailsPanel = new ReturnsBreadCrumbTable(this.dataHandler, this);
        this.confPanel = new ConfigurationPanel();
        this.costCenterChooser = new ComboBox((Node)new DTOProxyNode(), null, ConverterRegistry.getConverter(DepartmentConverter.class));
        this.confPanel.addItem(this.costCenterChooser, TitledItem.TitledItemOrientation.NORTH, "costCenter", Words.COSTCENTER);
        FlightStateE fs = ((FlightLight)model.getNode().getValue()).getFlightState();
        if (this.isManualSales() == EditorType.RC_AND_MANUAL_SALES && fs != FlightStateE.OPEN && fs != FlightStateE.EN_ROUTE) {
            this.editorStyle = new ComboBox();
            this.confPanel.addItem(this.editorStyle, TitledItem.TitledItemOrientation.NORTH, "editorStyle", Words.AUTO_UPDATE);
            this.editorStyle.addItem(EditorStyle.NONE);
            this.editorStyle.addItem(EditorStyle.RETURNS);
            this.editorStyle.addItem(EditorStyle.SALES);
        }
        if ((this.isManualSales() == EditorType.RETURNS_COUNT_TRAY_BASED || this.isManualSales() == EditorType.RETURNS_COUNT_EQUIMENT_BASED) && fs != FlightStateE.OPEN && fs != FlightStateE.EN_ROUTE) {
            this.editorStyle = new ComboBox();
            this.confPanel.addItem(this.editorStyle, TitledItem.TitledItemOrientation.NORTH, "editorStyle", Words.AUTO_UPDATE);
            this.editorStyle.addItem(EditorStyle.NONE);
            this.editorStyle.addItem(EditorStyle.SALES);
        }
        FilterChainConfiguration config = FilterChainConfiguration.loadConfiguration(this.getSubModuleDefinition().getInvokingName(), (UserLight)((UserServiceManager)ServiceManagerRegistry.getService(UserServiceManager.class)).getCurrentUser(), ((DefaultServiceManager)ServiceManagerRegistry.getService(DefaultServiceManager.class)).getServerName(), ((DefaultServiceManager)ServiceManagerRegistry.getService(DefaultServiceManager.class)).getCustomerCode());
        if (this.editorStyle != null) {
            if (config != null) {
                for (String[] s : config.getProperties()) {
                    if (s.length < 2 || !s[0].equals("editorStyle")) continue;
                    switch (s[1]) {
                        case "sales": {
                            this.editorStyle.setSelectedItem((Object)EditorStyle.SALES);
                            break;
                        }
                        case "returns": {
                            this.editorStyle.setSelectedItem((Object)EditorStyle.RETURNS);
                            break;
                        }
                        case "none": {
                            this.editorStyle.setSelectedItem((Object)EditorStyle.NONE);
                        }
                    }
                }
            }
            this.editorStyle.addItemListener(this);
        }
        ArrayList<Component> a = new ArrayList<Component>();
        this.costCenterChooser.setDefaultComboChooseText(Words.ALL);
        CustomFocusCyclePolicy.revalidateFocusCyclePolicy(a, this);
        this.setOpaque(false);
        this.setLayout(new Layout());
        this.detailsPanel.setProvider(this.provider);
        this.add(this.confPanel);
        this.add(this.detailsPanel);
    }

    public EditorStyle getCurrentEditorStyle() {
        if (this.editorStyle == null) {
            return EditorStyle.NONE;
        }
        return (EditorStyle)((Object)this.editorStyle.getSelectedItem());
    }

    private void showAnimation(String text) {
        this.setEnabled(false);
        if (this.animationPanel == null) {
            this.animationPanel = new LoadingAnimation();
            this.animationPanel.stateChanged(text);
            this.animationPanel.start();
            this.animationPanel.fadeIn();
            this.add((Component)this.animationPanel, 0);
            this.revalidate();
        }
    }

    private void hideAnimation() {
        if (this.animationPanel != null) {
            this.animationPanel.stop();
            this.animationPanel.fadeOut(true);
            this.revalidate();
        }
        this.animationPanel = null;
        this.setEnabled(true);
    }

    @Override
    public void stopAnimationsImmediately() {
    }

    public void redo() {
    }

    public void undo() {
    }

    @Override
    public void remoteObjectLoaded(Node<?> node) {
        if (node != null) {
            if (node.getValue() instanceof ScreenValidationObject) {
                InnerPopupFactory.showErrorDialog(ScreenValidationObject.createList((ScreenValidationObject[])new ScreenValidationObject[]{(ScreenValidationObject)node.getValue()}), "Unable to save Returns Count data", (Component)this);
                this.setEnabled(true);
                return;
            }
            if (node.getValue() instanceof ScreenValidationList) {
                InnerPopupFactory.showErrorDialog((List)node.getValue(), "Unable to save Returns Count data", (Component)this);
                this.setEnabled(true);
                return;
            }
        }
        if (this.currentState == 5) {
            this.filterDepartments();
            this.hideAnimation();
            if (this.init) {
                this.init = false;
                ArrayList l = new ArrayList();
                l.addAll(this.currentFlight.getReturnsCountDepartments());
                Node c = INodeCreator.getDefaultImpl().createNodes(l, true);
                Node possiblesWithNull = ComboBox.getPossiblesWithNull(c);
                this.costCenterChooser.refreshPossibleValues(possiblesWithNull);
                this.costCenterChooser.addItemListener(this);
                Node selected = null;
                Iterator it = possiblesWithNull.getFailSafeChildIterator();
                while (it.hasNext()) {
                    InternalCostCenterComplete icc;
                    Node n = (Node)it.next();
                    if (n == null || n.getValue() == null || !(n.getValue() instanceof InternalCostCenterComplete) || !Boolean.TRUE.equals((icc = (InternalCostCenterComplete)n.getValue()).getDefaultRCDepartment())) continue;
                    selected = n;
                }
                this.costCenterChooser.setSelectedItem(selected);
            }
            this.createFocusCycle();
        } else if (this.currentState == 11) {
            this.cancelDocument();
        } else if (this.currentState == 7) {
            this.startDataDownload();
        }
    }

    @Override
    public void errorOccurred(ClientException exception) {
        this.hideAnimation();
        this.setEnabled(true);
        super.errorOccurred(exception);
    }

    public IDataHandler getDataHandler() {
        return this.dataHandler;
    }

    @Override
    public void escapeKeyPressed() {
    }

    @Override
    public void saveKeyPressed() {
    }

    @Override
    public void screenSet() {
    }

    @Override
    public void startDataDownload() {
        this.currentState = 5;
        this.showAnimation(Words.LOAD_DATA);
        ThreadSafeExecutable run = new ThreadSafeExecutable(this){

            @Override
            public Node<?> loadData() throws Exception {
                Node cc = null;
                if (ReturnsCountDrawerBasedSubModule.this.costCenterChooser.getSelectedItem() instanceof Node) {
                    cc = (Node)ReturnsCountDrawerBasedSubModule.this.costCenterChooser.getSelectedItem();
                }
                ((MasterDataServiceManager)ServiceManagerRegistry.getService(MasterDataServiceManager.class)).getAllCached(CostCenterComplete.class);
                ReturnsCountDrawerBasedSubModule.this.currentFlight = ReturnsCountDrawerBasedSubModule.this.getReturnsCountFlight((Node<CostCenterComplete>)cc);
                ReturnsCountDrawerBasedSubModule.this.flightNode = INodeCreator.getDefaultImpl().getNode4DTO((Object)ReturnsCountDrawerBasedSubModule.this.currentFlight, false, false);
                Iterator it = ReturnsCountDrawerBasedSubModule.this.flightNode.getChildNamed(ReturnsCountFlightComplete_.equipments).getFailSafeChildIterator();
                while (it.hasNext()) {
                    Node e = (Node)it.next();
                    Iterator it2 = e.getChildNamed(ReturnsCountEquipmentComplete_.deliverySpaces).getFailSafeChildIterator();
                    while (it2.hasNext()) {
                        Node d = (Node)it2.next();
                        Iterator it3 = d.getChildNamed(ReturnsCountDeliverySpaceComplete_.products).getFailSafeChildIterator();
                        while (it3.hasNext()) {
                            Node node = (Node)it3.next();
                        }
                    }
                }
                ReturnsCountDrawerBasedSubModule.this.detailsPanel.setFlightNode((Node<FlightLight>)INodeCreator.getDefaultImpl().getNode4DTO((Object)ReturnsCountDrawerBasedSubModule.this.getFlight(), false, false));
                for (ReturnsCountEquipmentComplete rf : ReturnsCountDrawerBasedSubModule.this.currentFlight.getEquipments()) {
                    for (ReturnsCountDeliverySpaceComplete ds : rf.getDeliverySpaces()) {
                        for (ReturnsCountProductComplete p : ds.getProducts()) {
                            int waste;
                            int sold;
                            int loaded;
                            if (p.getClientOId() == null) {
                                p.setClientOId(Long.valueOf(ADTO.getNextId()));
                            }
                            if (p.getMachineSalesAmount() == null) {
                                p.setMachineSalesAmount(Integer.valueOf(0));
                            }
                            if (ReturnsCountDrawerBasedSubModule.this.getFlight().getReturnsCountState() != ReturnsCountStateE.NOT_COUNTED) continue;
                            if (Boolean.TRUE.equals(p.getProduct().getSalesOnBoard())) {
                                loaded = p.getUseRevisedDeliveredAmount() != false ? p.getRevisedDeliveredAmount() : p.getCalculatedDeliveredAmount();
                                sold = p.getMachineSalesAmount();
                                waste = 0;
                                int counted = loaded - (sold + waste);
                                p.setCountedAmount(Integer.valueOf(counted));
                            }
                            if (!p.getProduct().getReturnsCountType().isCounted().booleanValue()) continue;
                            loaded = p.getUseRevisedDeliveredAmount() != false ? p.getRevisedDeliveredAmount() : p.getCalculatedDeliveredAmount();
                            sold = p.getMachineSoldAmount();
                            waste = 0;
                            int missing = 0;
                            p.setSoldAmount(Integer.valueOf(sold));
                            p.setWasteAmount(Integer.valueOf(waste));
                            p.setCountedAmount(Integer.valueOf(loaded));
                            p.setMissingAmount(Integer.valueOf(missing));
                        }
                    }
                }
                return null;
            }

            @Override
            public RemoteLoader getInvoker() {
                return ReturnsCountDrawerBasedSubModule.this;
            }

            @Override
            public long getID() {
                return 0L;
            }
        };
        ThreadSafeLoader.run(run);
    }

    public ReturnsCountFlightComplete getReturnsCountFlight(Node<CostCenterComplete> cc) throws ClientServerCallException {
        return (ReturnsCountFlightComplete)((FlightServiceManager)ServiceManagerRegistry.getService(FlightServiceManager.class)).getCountItems(new FlightReference(this.getFlight().getId()), new ReturnsCountParameterConfig(cc != null ? (CostCenterComplete)cc.getValue() : null, this.getFlight().getUpliftCount())).getValue();
    }

    @Override
    public void kill() {
        if (this.isKilled()) {
            return;
        }
        super.kill();
        if (this.currentRowModel != null) {
            this.currentRowModel.kill();
        }
        if (this.animationPanel != null) {
            this.animationPanel.kill();
        }
        if (this.detailsPanel != null) {
            this.detailsPanel.kill();
        }
        if (this.confPanel != null) {
            this.confPanel.kill();
        }
        this.confPanel = null;
        this.node = null;
        this.dataHandler = null;
        this.flight = null;
        if (this.costCenterChooser != null) {
            this.costCenterChooser.kill();
        }
        this.costCenterChooser = null;
        if (this.editorStyle != null) {
            this.editorStyle.kill();
        }
        this.editorStyle = null;
        this.currentFlight = null;
        this.provider = null;
        this.flightNode = null;
    }

    public boolean isReturnsCount() {
        return true;
    }

    @Override
    public void itemStateChanged(ItemEvent e) {
        if (e.getStateChange() == 1) {
            if (e.getSource() == this.costCenterChooser) {
                this.filterDepartments();
            } else if (e.getSource() == this.editorStyle) {
                this.writeFilterChainConfiguration();
            }
        }
    }

    private void writeFilterChainConfiguration() {
        if (this.editorStyle != null) {
            FilterChainConfiguration c = new FilterChainConfiguration();
            String t = null;
            if (this.editorStyle.getSelectedItem() == EditorStyle.NONE) {
                t = "none";
            } else if (this.editorStyle.getSelectedItem() == EditorStyle.RETURNS) {
                t = "returns";
            } else if (this.editorStyle.getSelectedItem() == EditorStyle.SALES) {
                t = "sales";
            }
            c.addProperty("editorStyle", t);
            FilterChainConfiguration.saveConfiguration(this.getSubModuleDefinition().getInvokingName(), (UserLight)((UserServiceManager)ServiceManagerRegistry.getService(UserServiceManager.class)).getCurrentUser(), c, ((DefaultServiceManager)ServiceManagerRegistry.getService(DefaultServiceManager.class)).getServerName(), ((DefaultServiceManager)ServiceManagerRegistry.getService(DefaultServiceManager.class)).getCustomerCode());
        }
    }

    private void filterDepartments() {
        Node n;
        Node cc = null;
        if (this.costCenterChooser.getSelectedItem() instanceof Node) {
            cc = (Node)this.costCenterChooser.getSelectedItem();
        }
        ArrayList<ReturnsCountEquipmentComplete> eqs = new ArrayList<ReturnsCountEquipmentComplete>();
        for (ReturnsCountEquipmentComplete e : this.currentFlight.getEquipments()) {
            if (cc != null && cc.getValue() != null && !e.getDepartments().contains(cc.getValue())) continue;
            eqs.add(e);
        }
        this.node = n = INodeCreator.getDefaultImpl().createNodes(eqs, true);
        this.detailsPanel.setNode(this.node);
    }

    @Override
    public void setRowAttributes(RowTransferObject<FlightLight> o) {
        this.setFlight((FlightLight)o.getDto());
        FakeSmartScreenTableRow<FlightLight> rowM = o.getFakeRow();
        this.dataHandler = o.getDatahandler();
        this.init(rowM);
    }

    @Override
    public SubModuleDefinitionComplete getSubModuleDefinition() {
        return FlightAccess.getSubModuleDefinition((SubModuleAccessDefinition)FlightAccess.TOOL_RETURNS_COUNT_DRAWER_BASED);
    }

    public FlightLight getFlight() {
        return this.flight;
    }

    public void setFlight(FlightLight flight) {
        this.flight = flight;
    }

    public Node getProductsNode(Node node2) {
        return node2.getChildNamed(new String[]{"products"});
    }

    public boolean getAutoUpdateSales() {
        return this.autoUpdateSales;
    }

    public void setAutoUpdateSales(boolean autoUpdateSales) {
        this.autoUpdateSales = autoUpdateSales;
    }

    public void performTransactionReturnsCountData(FlightReference r) throws ClientServerCallException {
        ((FlightServiceManager)ServiceManagerRegistry.getService(FlightServiceManager.class)).performTransactionReturnsCountData(r);
    }

    private class Layout
    extends DefaultLayout {
        private Layout() {
        }

        @Override
        public void layoutContainer(Container parent) {
            int y = ReturnsCountDrawerBasedSubModule.this.layoutTitle(parent);
            y = ReturnsCountDrawerBasedSubModule.this.layoutTitleBar(y, parent.getWidth());
            ReturnsCountDrawerBasedSubModule.this.confPanel.setLocation(0, y + 10);
            ReturnsCountDrawerBasedSubModule.this.confPanel.setSize(parent.getWidth(), (int)ReturnsCountDrawerBasedSubModule.this.confPanel.getPreferredSize().getHeight());
            ReturnsCountDrawerBasedSubModule.this.detailsPanel.setLocation(0, ReturnsCountDrawerBasedSubModule.this.confPanel.getY() + ReturnsCountDrawerBasedSubModule.this.confPanel.getHeight() + 10);
            ReturnsCountDrawerBasedSubModule.this.detailsPanel.setSize(parent.getWidth(), parent.getHeight() - ReturnsCountDrawerBasedSubModule.this.detailsPanel.getY());
            if (ReturnsCountDrawerBasedSubModule.this.animationPanel != null) {
                ReturnsCountDrawerBasedSubModule.this.animationPanel.setSize(ReturnsCountDrawerBasedSubModule.this.animationPanel.getPreferredSize());
                ReturnsCountDrawerBasedSubModule.this.animationPanel.setLocation(ReturnsCountDrawerBasedSubModule.this.detailsPanel.getX() + (ReturnsCountDrawerBasedSubModule.this.detailsPanel.getWidth() - ReturnsCountDrawerBasedSubModule.this.animationPanel.getWidth()) / 2, ReturnsCountDrawerBasedSubModule.this.detailsPanel.getY() + (ReturnsCountDrawerBasedSubModule.this.detailsPanel.getHeight() - ReturnsCountDrawerBasedSubModule.this.animationPanel.getHeight()) / 2);
            }
        }

        @Override
        public Dimension preferredLayoutSize(Container parent) {
            return null;
        }
    }

    public static enum EditorStyle {
        SALES,
        RETURNS,
        NONE;


        public String toString() {
            switch (this) {
                case NONE: {
                    return Words.NONE;
                }
                case RETURNS: {
                    return Words.RETURNSCOUNT;
                }
                case SALES: {
                    return Words.SALES;
                }
            }
            return "";
        }
    }

    public static enum EditorType {
        RETURNS_COUNT_TRAY_BASED,
        MANUAL_SALES,
        RC_AND_MANUAL_SALES,
        RETURNS_COUNT_EQUIMENT_BASED;

    }
}

