/*
 * Decompiled with CFR 0.152.
 */
package ch.icit.pegasus.client.gui.submodules.tool.galleyconfigurator.gui;

import ch.icit.pegasus.client.comparators.controller.ComparatorRegistry;
import ch.icit.pegasus.client.gui.submodules.tool.galleyconfigurator.gui.PegasusSubModule;
import ch.icit.pegasus.client.gui.submodules.tool.galleyconfigurator.gui.comparators.AlphabeticComparator;
import ch.icit.pegasus.client.gui.submodules.tool.galleyconfigurator.gui.list.ListView;
import ch.icit.pegasus.client.gui.submodules.tool.galleyconfigurator.gui.list.ListViewItem;
import ch.icit.pegasus.client.gui.submodules.tool.galleyconfigurator.gui.list.ListViewModel;
import ch.icit.pegasus.client.node.impls.Node;
import ch.icit.pegasus.client.node.impls.NodeListener;
import ch.icit.pegasus.server.core.dtos.masterdata.StowagePositionTypeComplete;
import java.util.ArrayList;

public class DefaultListViewModel
implements NodeListener,
ListViewModel {
    protected Node<?> theNode;
    protected ListView theList;
    protected ArrayList<Node<?>> theListenChilds = new ArrayList();
    protected String theDefaultToolTip = "";
    protected PegasusSubModule pegasus;
    private boolean isBlocked = false;
    protected boolean isKilled;

    public DefaultListViewModel(ListView list, PegasusSubModule peg) {
        this.theList = list;
        this.pegasus = peg;
        this.theList.setComparator(ComparatorRegistry.getComparator(AlphabeticComparator.class));
    }

    public void setDefaultToolTip(String tt) {
        this.theDefaultToolTip = tt;
    }

    public Node<?> getNode() {
        return this.theNode;
    }

    @Override
    public void setNode(Node node) {
        if (node == this.theNode) {
            return;
        }
        this.theList.resetList();
        if (this.theNode != null) {
            this.theNode.removeNodeListener((NodeListener)this);
        }
        for (Node<?> n : this.theListenChilds) {
            n.removeNodeListener((NodeListener)this);
        }
        this.theListenChilds.clear();
        this.theList.layoutPanel(this.theList.getWidth(), this.theList.getHeight(), false);
        this.theNode = node;
        if (this.theNode != null) {
            if (this.theNode.getName().equals("Boxes") || this.theNode.getName().equals("EquipmentTypes")) {
                this.theList.setTitle((String)this.theNode.getFormattedValue());
            }
            this.isBlocked = true;
            this.theNode.addNodeListener((NodeListener)this);
            this.theNode.getAllChildAddEventsFor((NodeListener)this, new String[0]);
            this.isBlocked = false;
            this.theList.updateOrder();
        }
    }

    public void childAdded(Node<?> parent, Node<?> child) {
        ListViewItem aParent;
        if (parent == this.theNode) {
            if (child.getValue() != null && child.getValue() instanceof StowagePositionTypeComplete) {
                ListViewItem aItem = new ListViewItem(child, null, this.theList, 11, true, this.pegasus);
                this.theList.addChild(aItem);
                this.theListenChilds.add(child);
                child.addNodeListener((NodeListener)this);
                child.getAllChildAddEventsFor((NodeListener)this, new String[0]);
            }
        } else if ((child.getName().equals("Item") || child.getName().equals("Category") || child.getName().equals("Galley") || child.getName().equals("StowagePosition")) && !this.checkIfContains(child) && (aParent = this.theList.getItem4Object(parent)) != null) {
            ListViewItem aItem = null;
            aItem = aParent.getParentItem() == null ? new ListViewItem(child, aParent, this.theList, 5, true, this.pegasus) : new ListViewItem(child, aParent, this.theList, 11, true, this.pegasus);
            aItem.setToolTipText(this.theDefaultToolTip);
            aParent.addChild(aItem);
            this.theListenChilds.add(child);
            child.addNodeListener((NodeListener)this);
            child.getAllChildAddEventsFor((NodeListener)this, new String[0]);
        }
        if (!this.isBlocked) {
            this.theList.updateOrder();
        }
    }

    public void childRemoved(Node<?> parent, Node<?> child) {
        ListViewItem item = this.theList.getItem4Object(child);
        if (item != null) {
            ListViewItem aParent = item.getParentItem();
            if (aParent != null) {
                aParent.removeChild(item);
            } else {
                this.theList.removeChild(item);
            }
            this.theList.layoutPanel(this.theList.getWidth(), this.theList.getHeight(), false);
        }
        if (this.theListenChilds.contains(child)) {
            this.theListenChilds.remove(child);
        }
        child.removeNodeListener((NodeListener)this);
        if (!this.isBlocked) {
            this.theList.updateOrder();
        }
    }

    @Override
    public boolean checkIfContains(Node node) {
        ListViewItem aItem = this.theList.getItem4Object(node);
        return aItem != null;
    }

    public void valueChanged(Node<?> node) {
        if (this.theNode == node) {
            this.theList.setTitle((String)this.theNode.getFormattedValue());
        }
    }

    @Override
    public int getPegasusState() {
        return this.pegasus.getCurrentState();
    }

    @Override
    public void kill() {
        this.isKilled = true;
        if (this.theNode != null) {
            this.theNode.removeNodeListener((NodeListener)this);
        }
        this.theNode = null;
        this.theList = null;
        for (Node<?> n : this.theListenChilds) {
            n.removeNodeListener((NodeListener)this);
        }
        this.theListenChilds.clear();
        this.theListenChilds = null;
        this.pegasus = null;
    }

    public void childrenAdded(Node<?> source, Node<?> ... nodes) {
    }

    public boolean isSwingOnly() {
        return true;
    }
}

