/*
 * Decompiled with CFR 0.152.
 */
package ch.icit.pegasus.client.gui.submodules.tool.galleyconfigurator.gui;

import ch.icit.pegasus.client.gui.submodules.tool.galleyconfigurator.gui.PegasusSubModule;
import ch.icit.pegasus.client.gui.submodules.tool.galleyconfigurator.gui.galley.DefaultGalleyModel;
import ch.icit.pegasus.client.gui.submodules.tool.galleyconfigurator.gui.galley.Galley;
import ch.icit.pegasus.client.gui.submodules.tool.galleyconfigurator.gui.galley.GalleyBox;
import ch.icit.pegasus.client.gui.submodules.tool.galleyconfigurator.gui.galley.GalleyGridPanel;
import ch.icit.pegasus.client.node.impls.Node;
import ch.icit.pegasus.client.node.impls.NodeListener;
import ch.icit.pegasus.server.core.dtos.flightschedule.stowing.GalleyEquipmentSetTypeE;
import ch.icit.pegasus.server.core.dtos.flightschedule.stowing.GalleyEquipmentSpecificationComplete;
import ch.icit.pegasus.server.core.i18n.Words;
import ch.icit.pegasus.server.core.util.StringUtil;
import java.awt.Point;
import java.util.ArrayList;
import javax.swing.SwingUtilities;

public class PegasusGalleyModel
extends DefaultGalleyModel {
    private PegasusSubModule thePegasus;
    private int theState = 0;
    private int theInnerState = 0;
    private ArrayList<Node> theListenChilds = new ArrayList();
    private Node equipmentList;
    private Node stowingListNode;
    private Node aircraftNode;
    private Node galleyCode;
    private boolean isInit = false;
    private boolean isGalleyListInited = false;
    protected GalleyEquipmentSetTypeE currentType;

    public PegasusGalleyModel(PegasusSubModule peg) {
        this.thePegasus = peg;
    }

    @Override
    public void setView(GalleyGridPanel panel) {
        super.setView(panel);
        if (this.theView != null) {
            this.theView.setTitleString(Words.GALLEY_VIEWER);
        }
    }

    @Override
    public GalleyEquipmentSetTypeE getCurrentSetType() {
        return this.theView.getCurrentEquipmentType();
    }

    public void setAircraftNode(Node node) {
        this.aircraftNode = node;
        this.isGalleyListInited = false;
    }

    public PegasusSubModule getPegasus() {
        return this.thePegasus;
    }

    @Override
    public int getState() {
        return this.theInnerState;
    }

    public Node getStowingListNode() {
        return this.stowingListNode;
    }

    public void setStowingListNode(Node stowingListNode) {
        this.stowingListNode = stowingListNode;
        this.isGalleyListInited = false;
    }

    @Override
    public int getPegasusState() {
        return this.thePegasus.getCurrentState();
    }

    @Override
    public void kill() {
        if (this.isKilled) {
            return;
        }
        super.kill();
        for (Node n : this.theListenChilds) {
            n.removeNodeListener((NodeListener)this);
        }
        this.theListenChilds.clear();
        this.theListenChilds = null;
        if (this.equipmentList != null) {
            this.equipmentList.removeNodeListener((NodeListener)this);
        }
        this.equipmentList = null;
        if (this.stowingListNode != null) {
            this.stowingListNode.removeNodeListener((NodeListener)this);
        }
        this.stowingListNode = null;
        if (this.aircraftNode != null) {
            this.aircraftNode.removeNodeListener((NodeListener)this);
        }
        this.aircraftNode = null;
        if (this.galleyCode != null) {
            this.galleyCode.removeNodeListener((NodeListener)this);
        }
        this.galleyCode = null;
        this.thePegasus = null;
    }

    public void createGalleyList() {
        if (!this.isGalleyListInited) {
            this.isGalleyListInited = true;
            Node node = null;
            ((Galley)this.theView).clearGalleyList();
            if (this.theState == 3) {
                node = this.aircraftNode.getChildNamed(new String[]{"galleys"});
            } else {
                if (this.stowingListNode == null) {
                    this.isGalleyListInited = false;
                    return;
                }
                node = this.stowingListNode.getChildNamed(new String[]{"galleyEquipmentSets"});
            }
            if (node != null) {
                node.addNodeListener((NodeListener)this);
                node.getAllChildAddEventsFor((NodeListener)this, new String[0]);
            }
        }
    }

    @Override
    public void setState(int t) {
        if (this.theState != t) {
            switch (t) {
                case 3: {
                    if (((Galley)this.theView).getSubGalley() != null) {
                        this.theView.remove(((Galley)this.theView).getSubGalley());
                    }
                    if (this.theView.getGrid() != ((Galley)this.theView).getOldGrid()) {
                        this.theView.remove(this.theView.getGrid());
                        ((Galley)this.theView).setGrid(((Galley)this.theView).getOldGrid());
                        this.theView.add(this.theView.getGrid());
                    }
                    this.theInnerState = 3;
                    break;
                }
                case 7: {
                    this.theView.add(((Galley)this.theView).getSubGalley());
                    this.theInnerState = 3;
                }
            }
            this.theState = t;
            this.theView.layoutPanel(this.theView.getWidth(), this.theView.getHeight(), false);
        }
    }

    @Override
    public boolean setNode(Node node) {
        this.isInit = true;
        if (node == this.theNode && node != null && this.currentType == this.theView.getCurrentEquipmentType()) {
            this.isInit = false;
            this.theView.setSelectedGalley(this.theNode);
            return false;
        }
        this.currentType = this.theView.getCurrentEquipmentType();
        this.theView.getGrid().removeAll();
        if (this.theNode != null) {
            this.theNode.removeNodeListener((NodeListener)this);
        }
        for (Node n : this.theListenChilds) {
            n.removeNodeListener((NodeListener)this);
        }
        this.theListenChilds.clear();
        if (this.equipmentList != null) {
            this.equipmentList.removeNodeListener((NodeListener)this);
        }
        if (this.galleyCode != null) {
            this.galleyCode.removeNodeListener((NodeListener)this);
        }
        this.theNode = node;
        if (this.theNode == null) {
            this.isInit = false;
            return true;
        }
        Node n = null;
        n = this.thePegasus.getCurrentState() == 3 ? this.theNode.getChildNamed(new String[]{"code"}) : this.theNode.getChildNamed(new String[]{"galleyCode"});
        this.theView.getGrid().setGridBoxAreaInvalid();
        if (this.thePegasus.getCurrentState() == 3) {
            this.theNode.addNodeListener((NodeListener)this);
            this.childAdded(this.theNode, this.theNode.getChildNamed(new String[]{"stowagePositionSpecifications"}));
            this.theView.setSelectedGalley(this.theNode);
        } else {
            this.theNode.addNodeListener((NodeListener)this);
            this.childAdded(this.theNode, this.theNode.getChildNamed(new String[]{"galleyEquipmentSpecifications"}));
            this.childAdded(this.theNode, this.theNode.getChildNamed(new String[]{"galleyCode"}));
            this.theNode.getAllChildAddEventsFor((NodeListener)this, new String[0]);
        }
        if (!this.theView.getGrid().isGridBoxAreaValid()) {
            this.theView.getGrid().validateGridBoxArea();
        }
        this.isInit = false;
        return true;
    }

    @Override
    public void valueChanged(Node node) {
        if (this.thePegasus == null || this.thePegasus.getCurrentState() != 3 || node.getName().equals("code")) {
            // empty if block
        }
    }

    @Override
    public void childAdded(Node parent, Node child) {
        if (this.thePegasus == null) {
            return;
        }
        if (this.thePegasus.getCurrentState() == 3) {
            if (!this.isInit && parent.getName().equals("galleys")) {
                this.theView.insertSelectivGalley(child);
            } else if (parent.getName().equals("stowagePositionSpecifications")) {
                this.isInitialisation = true;
                this.theView.insertBox((Node<String>)child);
                this.isInitialisation = false;
                GalleyBox g = this.theView.getBox4Node(child);
                double x = g.getDX() + g.getDWidth() + 1.0;
                double y = g.getDY() + g.getDHeight() + 1.0;
                this.theView.ensureGridSize(x, y, false);
            } else if (child.getName().equals("stowagePositionSpecifications")) {
                this.theListenChilds.add(child);
                child.addNodeListener((NodeListener)this);
                child.getAllChildAddEventsFor((NodeListener)this, new String[0]);
            }
        } else if (!this.isInit && parent.getName().equals("galleyEquipmentSets")) {
            Node n = child.getChildNamed(new String[]{"galleyCode"});
            this.theView.insertSelectivGalley(child);
        } else if (this.theNode == parent) {
            if (!StringUtil.isBlank((String)child.getName())) {
                if (child.getName().equals("galleyEquipmentSpecifications")) {
                    this.equipmentList = child;
                    child.addNodeListener((NodeListener)this);
                    child.getAllChildAddEventsFor((NodeListener)this, new String[0]);
                } else if (child.getName().equals("galleyCode")) {
                    this.galleyCode = child;
                    this.galleyCode.addNodeListener((NodeListener)this);
                }
            }
        } else if (this.equipmentList == parent) {
            if (child.getValue().equals(child.getParent().getParent().getChildNamed(new String[]{"looseEquipment"}).getValue())) {
                ((Galley)this.theView).setLosePositionNode(child);
            } else if (!((GalleyEquipmentSpecificationComplete)child.getValue()).getUsedGalleyEquipment().isEmpty()) {
                this.insertBoxIntoView(child);
            }
        }
    }

    private void insertBoxIntoView(Node child) {
        GalleyBox g = this.theView.insertBox((Node<String>)child);
        double x = g.getDX() + g.getDWidth() + 1.0;
        double y = g.getDY() + g.getDHeight() + 1.0;
        this.theView.ensureGridSize(x, y, false);
    }

    @Override
    public boolean isDefinition() {
        return false;
    }

    @Override
    public void childRemoved(Node parent, Node child) {
        if (parent.getName().equals("stowagePositionSpecifications")) {
            GalleyBox box = this.theView.getBox4Node(child);
            if (box != null) {
                this.theView.getGrid().removeBox(box);
                box.fadeOut(true);
                this.theView.deactivateEditorIfDeleted(box);
            }
        } else if (parent.getName().equals("galleys")) {
            this.theView.removeSelectivGalley(child);
        } else if (parent.getName().equals("galleyEquipmentSets")) {
            this.theView.removeSelectivGalley(child);
        }
    }

    public void selectFirstElement() {
        if (this.thePegasus.getCurrentState() == 3) {
            if (this.theView.getSelectedGalley() != null) {
                this.theView.selectFirstGalley();
                Node IReadableNodeSelect = this.theView.getSelectedGalley();
                this.theView.getGlobalSelectionContoller().newNodeSelected(IReadableNodeSelect, this.theView, 3, null);
            } else {
                this.theView.getGlobalSelectionContoller().newNodeSelected(null, this.theView, 3, null);
            }
        } else {
            this.theView.selectFirstGalley();
            Node readableNodeSelect = this.theView.getSelectedGalley();
            this.theView.getGlobalSelectionContoller().newNodeSelected(readableNodeSelect, this.theView, 3, null);
        }
    }

    @Override
    public Point getTranslatedPoint() {
        return SwingUtilities.convertPoint(this.theView.getGrid(), 0, 0, this.thePegasus);
    }

    public void childrenAdded(Node source, Node ... nodes) {
    }

    public boolean isSwingOnly() {
        return false;
    }
}

