/*
 * Decompiled with CFR 0.152.
 */
package ch.icit.pegasus.client.gui.submodules.tool.galleyconfigurator.gui.equipmentconf;

import ch.icit.pegasus.client.gui.submodules.tool.galleyconfigurator.gui.PegasusGalleyModel;
import ch.icit.pegasus.client.gui.submodules.tool.galleyconfigurator.gui.PegasusSubModule;
import ch.icit.pegasus.client.gui.submodules.tool.galleyconfigurator.gui.galley.Galley;
import ch.icit.pegasus.client.gui.submodules.tool.galleyconfigurator.gui.galley.GalleyBox;
import ch.icit.pegasus.client.gui.utils.popup.InnerPopupFactory;
import ch.icit.pegasus.client.node.impls.Node;
import ch.icit.pegasus.client.node.impls.NodeListener;
import ch.icit.pegasus.server.core.dtos.flightschedule.stowing.GalleyEquipmentSpecificationComplete;
import java.awt.Component;
import java.awt.Point;
import java.util.ArrayList;
import java.util.List;
import javax.swing.SwingUtilities;

public class GalleyEquipmentModel
extends PegasusGalleyModel {
    private PegasusSubModule thePegasus;
    private int theState = 0;
    private int theInnerState = 0;
    private Node equipmentList;
    private Node stowingListNode;
    private Node galleyCode;
    private List<Node> registeredNodes2Listen = new ArrayList<Node>();

    public GalleyEquipmentModel(PegasusSubModule peg) {
        super(peg);
        this.thePegasus = peg;
    }

    @Override
    public PegasusSubModule getPegasus() {
        return this.thePegasus;
    }

    @Override
    public boolean isDefinition() {
        return true;
    }

    @Override
    public int getState() {
        return this.theInnerState;
    }

    @Override
    public Node getStowingListNode() {
        return this.stowingListNode;
    }

    @Override
    public void setStowingListNode(Node stowingListNode) {
        this.stowingListNode = stowingListNode;
    }

    @Override
    public int getPegasusState() {
        return this.thePegasus.getCurrentState();
    }

    @Override
    public void createGalleyList() {
        if (this.stowingListNode != null) {
            Node node = this.stowingListNode.getChildNamed(new String[]{"galleyEquipmentSets"});
            if (node != null) {
                this.registeredNodes2Listen.add(node);
                node.addNodeListener((NodeListener)this);
                node.getAllChildAddEventsFor((NodeListener)this, new String[0]);
            } else {
                InnerPopupFactory.showErrorDialog("<b>Unexpected Error occured</b><br/><ul><li>Please reopen Stowing List Specification</li></", (Component)this.thePegasus);
                return;
            }
        }
    }

    @Override
    public void setState(int t) {
        if (this.theState != t) {
            switch (t) {
                case 7: {
                    if (this.needsSubgalley()) {
                        this.theView.add(((Galley)this.theView).getSubGalley());
                    }
                    this.theInnerState = 3;
                }
            }
            this.theState = t;
            this.theView.layoutPanel(this.theView.getWidth(), this.theView.getHeight(), false);
        }
    }

    @Override
    public boolean setNode(Node node) {
        if (node == this.theNode && node != null && this.currentType == this.theView.getCurrentEquipmentType()) {
            return false;
        }
        this.currentType = this.theView.getCurrentEquipmentType();
        for (Node n : this.registeredNodes2Listen) {
            n.removeNodeListener((NodeListener)this);
        }
        this.theView.getGrid().removeAll();
        if (this.equipmentList != null) {
            this.equipmentList.removeNodeListener((NodeListener)this);
        }
        if (this.galleyCode != null) {
            this.galleyCode.removeNodeListener((NodeListener)this);
        }
        this.theNode = node;
        if (this.theNode == null) {
            return true;
        }
        if (this.thePegasus.getCurrentState() == 7) {
            if (this.theNode.getName().equals("galleyCode")) {
                this.theNode = this.theNode.getParent();
            }
            this.registeredNodes2Listen.add(this.theNode);
            this.theNode.addNodeListener((NodeListener)this);
            this.theNode.getAllChildAddEventsFor((NodeListener)this, new String[0]);
            this.equipmentList = this.theNode.getChildNamed(new String[]{"galleyEquipmentSpecifications"});
            this.registeredNodes2Listen.add(this.equipmentList);
            this.equipmentList.addNodeListener((NodeListener)this);
            this.equipmentList.getAllChildAddEventsFor((NodeListener)this, new String[0]);
            this.galleyCode = this.theNode.getChildNamed(new String[]{"galleyCode"});
            this.registeredNodes2Listen.add(this.galleyCode);
            this.galleyCode.addNodeListener((NodeListener)this);
        }
        return true;
    }

    @Override
    public void valueChanged(Node node) {
    }

    @Override
    public void childAdded(Node parent, Node child) {
        if (this.thePegasus.getCurrentState() == 7) {
            if (this.equipmentList == parent) {
                if (child.getValue().equals(child.getParent().getParent().getChildNamed(new String[]{"looseEquipment"}).getValue())) {
                    ((Galley)this.theView).setLosePositionNode(child);
                } else if (!((GalleyEquipmentSpecificationComplete)child.getValue()).getUsedGalleyEquipment().isEmpty()) {
                    this.insertIntoView(child);
                }
            } else if (parent.getName().equals("galleyEquipmentSets")) {
                Node t = child.getChildNamed(new String[]{"galleyCode"});
                this.theView.insertSelectivGalley(t);
            }
        }
    }

    @Override
    public void kill() {
        if (this.isKilled) {
            return;
        }
        super.kill();
        this.thePegasus = null;
        for (Node n : this.registeredNodes2Listen) {
            if (n == null) continue;
            n.removeNodeListener((NodeListener)this);
        }
        this.equipmentList = null;
        this.stowingListNode = null;
        this.galleyCode = null;
    }

    private void insertIntoView(Node child) {
        GalleyBox g = this.theView.insertBox((Node<String>)child);
        double x = g.getDX() + g.getDWidth() + 1.0;
        double y = g.getDY() + g.getDHeight() + 1.0;
        this.theView.ensureGridSize(x, y, false);
    }

    @Override
    public void childRemoved(Node parent, Node child) {
        if (parent.getName().equals("stowagePositionSpecifications")) {
            GalleyBox box = this.theView.getBox4Node(child);
            if (box != null) {
                this.theView.getGrid().removeBox(box);
                box.fadeOut(true);
            }
        } else if (parent.getName().equals("galleys")) {
            Node n = child.getChildNamed(new String[]{"code"});
            this.theView.removeSelectivGalley(n);
        } else if (parent.getName().equals("galleyEquipmentSets")) {
            Node t = child.getChildNamed(new String[]{"galleyCode"});
            this.theView.removeSelectivGalley(t);
        }
    }

    @Override
    public void selectFirstElement() {
        if (this.theView.getSelectedGalley() != null) {
            this.theView.selectFirstGalley();
            this.theView.getGlobalSelectionContoller().newNodeSelected(this.theView.getSelectedGalley().getParent(), this.theView, 3, null);
        } else {
            this.theView.getGlobalSelectionContoller().newNodeSelected(null, this.theView, 3, null);
        }
    }

    @Override
    public Point getTranslatedPoint() {
        return SwingUtilities.convertPoint(this.theView.getGrid(), 0, 0, this.thePegasus);
    }
}

