/*
 * Decompiled with CFR 0.152.
 */
package ch.icit.pegasus.client.gui.submodules.tool.galleyconfigurator.gui.list;

import ch.icit.pegasus.client.converter.Converter;
import ch.icit.pegasus.client.converter.IngredientConverter;
import ch.icit.pegasus.client.converter.controller.ConverterRegistry;
import ch.icit.pegasus.client.gui.submodules.tool.galleyconfigurator.gui.list.ListView;
import ch.icit.pegasus.client.gui.submodules.tool.galleyconfigurator.gui.list.ListViewItem;
import ch.icit.pegasus.client.gui.submodules.tool.galleyconfigurator.gui.list.ListViewItemView;
import ch.icit.pegasus.client.gui.utils.AttributesConverter;
import ch.icit.pegasus.client.gui.utils.buttons.Button;
import ch.icit.pegasus.client.gui.utils.skins.Skin9Field;
import ch.icit.pegasus.client.laf.LafLoader;
import ch.icit.pegasus.client.node.impls.Node;
import ch.icit.pegasus.server.core.dtos.masterdata.CommodityLight;
import ch.icit.pegasus.server.core.dtos.supply.BasicArticleLight;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;

public class DefaultListViewItemView
implements ListViewItemView {
    protected ListViewItem theItem;
    protected ListView theList;
    private String paintString;
    private Converter viewConverter;

    public DefaultListViewItemView(ListViewItem item, ListView list) {
        this.theList = list;
        this.theItem = item;
    }

    @Override
    public void setViewConverter(Converter viewConverter) {
        this.viewConverter = viewConverter;
        this.paintString = null;
        this.createPrintString();
    }

    @Override
    public String getPrintString(int w, int x, int y) {
        if (this.paintString == null) {
            this.paintString = this.createPrintString();
            if (this.isStringCutted(this.theList.getFontMetrics(AttributesConverter.getFont4String(LafLoader.getLafLoader().getAttribute("default_font"), LafLoader.getLafLoader().getAttribute("default_font_size"), LafLoader.getLafLoader().getAttribute("default_font_type"))), this.paintString, x, y, w)) {
                this.theItem.setToolTipText(this.paintString);
            }
        }
        return this.paintString;
    }

    @Override
    public void kill() {
        this.theItem = null;
        this.theList = null;
        this.paintString = null;
    }

    @Override
    public void paintView(Graphics g, boolean isCloning, Skin9Field theShadowSkin, int w, int h) {
        Graphics2D g2 = (Graphics2D)g;
        g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        if (isCloning) {
            theShadowSkin.paint(g2, 0, 0, w, h, Button.ButtonState.UP);
        }
        int selectType = 7;
        if (this.theList.getSelectedItem() == this.theItem) {
            selectType = this.theList.getGlobalSelectionController().getMainSelection() == this.theItem ? 2 : 3;
        }
        switch (selectType) {
            case 2: {
                g2.setColor(AttributesConverter.getColor4String(LafLoader.getLafLoader().getAttribute("default_main_selection_color")));
                g2.setFont(AttributesConverter.getFont4String(LafLoader.getLafLoader().getAttribute("default_font"), LafLoader.getLafLoader().getAttribute("default_font_size"), LafLoader.getLafLoader().getAttribute("default_selected_font_type")));
                if (isCloning) {
                    g2.fillRect(0, 0, w - theShadowSkin.getImage32(Button.ButtonState.UP).getWidth(), h - theShadowSkin.getImage23(Button.ButtonState.UP).getHeight());
                    g2.setColor(AttributesConverter.getColor4String(LafLoader.getLafLoader().getAttribute("gc_galley_box_line_color")));
                    g2.drawRect(0, 0, w - theShadowSkin.getImage32(Button.ButtonState.UP).getWidth() - 1, h - theShadowSkin.getImage23(Button.ButtonState.UP).getHeight() - 1);
                    break;
                }
                g2.fillRect(0, 0, w, h);
                break;
            }
            case 3: {
                g2.setColor(AttributesConverter.getColor4String(LafLoader.getLafLoader().getAttribute("default_main_selection_color")));
                g2.setFont(AttributesConverter.getFont4String(LafLoader.getLafLoader().getAttribute("default_font"), LafLoader.getLafLoader().getAttribute("default_font_size"), LafLoader.getLafLoader().getAttribute("default_font_type")));
                if (isCloning) {
                    g2.fillRect(0, 0, w - theShadowSkin.getImage32(Button.ButtonState.UP).getWidth(), h - theShadowSkin.getImage23(Button.ButtonState.UP).getHeight());
                    g2.setColor(AttributesConverter.getColor4String(LafLoader.getLafLoader().getAttribute("gc_galley_box_line_color")));
                    g2.drawRect(0, 0, w - theShadowSkin.getImage32(Button.ButtonState.UP).getWidth() - 1, h - theShadowSkin.getImage23(Button.ButtonState.UP).getHeight() - 1);
                    break;
                }
                g2.fillRect(0, 0, w, h);
                break;
            }
            case 7: {
                g2.setColor(AttributesConverter.getColor4String(LafLoader.getLafLoader().getAttribute("inner_table_panel_background_color")));
                g2.setFont(AttributesConverter.getFont4String(LafLoader.getLafLoader().getAttribute("default_font"), LafLoader.getLafLoader().getAttribute("default_font_size"), LafLoader.getLafLoader().getAttribute("default_font_type")));
                if (isCloning) {
                    g2.fillRect(0, 0, w - theShadowSkin.getImage32(Button.ButtonState.UP).getWidth(), h - theShadowSkin.getImage23(Button.ButtonState.UP).getHeight());
                    g2.setColor(AttributesConverter.getColor4String(LafLoader.getLafLoader().getAttribute("gc_galley_box_line_color")));
                    g2.drawRect(0, 0, w - theShadowSkin.getImage32(Button.ButtonState.UP).getWidth() - 1, h - theShadowSkin.getImage23(Button.ButtonState.UP).getHeight() - 1);
                    break;
                }
                g2.fillRect(0, 0, w, h);
            }
        }
        switch (this.theItem.getType()) {
            case 3: {
                g2.setColor(AttributesConverter.getColor4String(LafLoader.getLafLoader().getAttribute("default_foreground_color")));
                this.printString(g2, this.getPrintString(w, 23, 12), 23, 12, w);
                if (this.theItem.getChildCount() <= 0) break;
                int[] xCoo = new int[3];
                int[] yCoo = new int[3];
                if (this.theItem.isExpanded()) {
                    xCoo[0] = 10;
                    xCoo[1] = 14;
                    xCoo[2] = 18;
                    yCoo[0] = 4;
                    yCoo[1] = 11;
                    yCoo[2] = 4;
                } else {
                    xCoo[0] = 10;
                    xCoo[1] = 17;
                    xCoo[2] = 10;
                    yCoo[0] = 4;
                    yCoo[1] = 8;
                    yCoo[2] = 11;
                }
                g2.setColor(AttributesConverter.getColor4String(LafLoader.getLafLoader().getAttribute("gc_listview_arrow_color")));
                g2.fillPolygon(xCoo, yCoo, 3);
                break;
            }
            case 5: {
                g2.setColor(AttributesConverter.getColor4String(LafLoader.getLafLoader().getAttribute("default_foreground_color")));
                this.printString(g2, this.getPrintString(w, 30, 12), 30, 12, w);
                if (this.theItem.getChildCount() <= 0) break;
                int[] xCoo = new int[3];
                int[] yCoo = new int[3];
                if (this.theItem.isExpanded()) {
                    xCoo[0] = 20;
                    xCoo[1] = 24;
                    xCoo[2] = 28;
                    yCoo[0] = 4;
                    yCoo[1] = 11;
                    yCoo[2] = 4;
                } else {
                    xCoo[0] = 20;
                    xCoo[1] = 27;
                    xCoo[2] = 20;
                    yCoo[0] = 4;
                    yCoo[1] = 8;
                    yCoo[2] = 11;
                }
                g2.setColor(AttributesConverter.getColor4String(LafLoader.getLafLoader().getAttribute("gc_listview_arrow_color")));
                g2.fillPolygon(xCoo, yCoo, 3);
                break;
            }
            case 7: {
                g2.setColor(AttributesConverter.getColor4String(LafLoader.getLafLoader().getAttribute("default_foreground_color")));
                this.printString(g2, "GROUP3", 35, 12, w);
                break;
            }
            case 11: {
                g2.setColor(AttributesConverter.getColor4String(LafLoader.getLafLoader().getAttribute("default_foreground_color")));
                this.printString(g2, this.getPrintString(w, 35, 12), 35, 12, w);
            }
        }
    }

    protected boolean isStringCutted(FontMetrics fm, String text, int x, int y, int width) {
        if (text == null) {
            return false;
        }
        int usedWidth = width;
        int gap2Back = 5;
        int w = fm.stringWidth(text);
        int currentIndex = text.length() - 2;
        boolean cutIt = false;
        if ((w += x + gap2Back) > (usedWidth -= this.theList.getScrollBarWidth()) && currentIndex > 0) {
            cutIt = true;
        }
        return cutIt;
    }

    protected boolean printString(Graphics2D g2, String text, int x, int y, int width) {
        int usedWidth = width;
        usedWidth -= this.theList.getScrollBarWidth();
        int gap2Back = 5;
        int w = g2.getFontMetrics().stringWidth(text);
        String printText = text;
        w += x + gap2Back;
        boolean cutIt = false;
        for (int currentIndex = text.length() - 2; w > usedWidth && currentIndex > 0; --currentIndex) {
            printText = text.substring(0, currentIndex) + "...";
            w = g2.getFontMetrics().stringWidth(printText) + x + gap2Back;
            cutIt = true;
        }
        g2.drawString(printText, x, y);
        return cutIt;
    }

    @Override
    public void userObjectAdded() {
    }

    @Override
    public String createPrintString() {
        if (this.paintString == null) {
            if (this.viewConverter != null) {
                if (this.theItem.getUserObject(0) instanceof Node) {
                    Node aNode = (Node)this.theItem.getUserObject(0);
                    this.paintString = (String)this.viewConverter.convert(aNode.getValue(), aNode, new Object[0]);
                } else {
                    this.paintString = (String)this.viewConverter.convert(this.theItem.getUserObject(0), null, new Object[0]);
                }
            } else if (this.theList.getConverter() != null) {
                Node aNode = (Node)this.theItem.getUserObject(0);
                this.paintString = (String)this.theList.getConverter().convert(aNode.getValue(), aNode, new Object[0]);
            } else {
                Node n;
                if (this.theItem.getUserObject(0) instanceof Node && (n = (Node)this.theItem.getUserObject(0)).getValue() instanceof BasicArticleLight) {
                    this.paintString = ((IngredientConverter)ConverterRegistry.getConverter(IngredientConverter.class)).convert((CommodityLight)((BasicArticleLight)n.getValue()), n, new Object[0]);
                }
                if (this.paintString == null) {
                    this.paintString = this.theItem.getUserObject(0).toString();
                }
            }
        }
        if (this.paintString == null) {
            this.paintString = "not set";
        }
        return this.paintString;
    }
}

