/*
 * Decompiled with CFR 0.152.
 */
package ch.icit.pegasus.client.gui.submodules.tool.store.article.inventorynew;

import ch.icit.pegasus.client.gui.submodules.tool.store.article.inventorynew.InventoryCBSubModuleNEW;
import ch.icit.pegasus.client.gui.submodules.tool.store.article.inventorynew.TableRowImplNEW;
import ch.icit.pegasus.client.gui.submodules.tool.store.article.inventorynew.utils.IInventoryCountImportUtil;
import ch.icit.pegasus.client.gui.submodules.tool.store.article.inventorynew.utils.InventoryCountImportUtil;
import ch.icit.pegasus.client.gui.table2.Table2RowPanel;
import ch.icit.pegasus.client.gui.utils.popup.InnerPopupFactory;
import ch.icit.pegasus.client.node.INodeCreator;
import ch.icit.pegasus.client.node.impls.DTONode;
import ch.icit.pegasus.client.node.impls.Node;
import ch.icit.pegasus.client.search.SearchAlgorithm;
import ch.icit.pegasus.client.search.controller.SearchAlgorithmRegistry;
import ch.icit.pegasus.client.search.impls.remote.StoreContentSearchAlgorithm;
import ch.icit.pegasus.client.services.ServiceManagerRegistry;
import ch.icit.pegasus.client.services.interfaces.supply.StoreServiceManager;
import ch.icit.pegasus.client.util.RemoteLoader;
import ch.icit.pegasus.client.util.ScreenValidationObject;
import ch.icit.pegasus.client.util.async.ThreadSafeExecutable;
import ch.icit.pegasus.client.util.async.ThreadSafeLoader;
import ch.icit.pegasus.client.util.exception.ClientException;
import ch.icit.pegasus.server.core.dtos.ADTO;
import ch.icit.pegasus.server.core.dtos.inventory.InventoryCheckinComplete;
import ch.icit.pegasus.server.core.dtos.masterdata.ArticleCategoryReference;
import ch.icit.pegasus.server.core.dtos.masterdata.QuantityComplete;
import ch.icit.pegasus.server.core.dtos.rightmanagement.template.def.StoreAccess;
import ch.icit.pegasus.server.core.dtos.search.StoreContentSearchConfiguration;
import ch.icit.pegasus.server.core.dtos.store.StoreComplete;
import ch.icit.pegasus.server.core.dtos.store.StorePositionContentComplete;
import ch.icit.pegasus.server.core.dtos.store.StoreReference;
import ch.icit.pegasus.server.core.dtos.supply.CustomerLight;
import ch.icit.pegasus.server.core.dtos.supply.CustomerReference;
import ch.icit.pegasus.server.core.dtos.util.BondedStateE;
import ch.icit.pegasus.server.core.dtos.util.DeletedStateE;
import ch.icit.pegasus.server.core.dtos.util.InUseStateE;
import ch.icit.pegasus.server.core.general.ASearchConfiguration;
import ch.icit.pegasus.server.core.i18n.Words;
import ch.icit.pegasus.server.core.search.SortDirection;
import ch.icit.pegasus.server.core.util.StringUtil;
import ch.icit.pegasus.server.core.util.Tuple;
import ch.icit.utils.ExcelRow;
import ch.icit.utils.ExcelToolkit;
import ch.icit.utils.ExcelToolkitException;
import java.awt.Component;
import java.awt.Desktop;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InventoryPBSubModuleNEW
extends InventoryCBSubModuleNEW
implements IInventoryCountImportUtil {
    private static final long serialVersionUID = 1L;
    private final Logger log = LoggerFactory.getLogger(InventoryPBSubModuleNEW.class);
    private List<Tuple<Integer, String>> notOkList = new ArrayList<Tuple<Integer, String>>();

    @Override
    public boolean isChargeBased() {
        return false;
    }

    @Override
    public String getScreenTitle() {
        return StoreAccess.TOOL_STORE_INVENTORY_PB.getDisplayName();
    }

    @Override
    public String getPanelTitle() {
        return "Articles";
    }

    @Override
    protected ASearchConfiguration<? extends ADTO, ? extends Enum<?>> getSearchConfig(String id, Object value) {
        if ("Article".equals(id)) {
            this.currentArticle = (String)value;
            if (this.currentArticle != null && this.currentArticle.trim().isEmpty()) {
                this.currentArticle = null;
            }
        } else if ("Position".equals(id)) {
            this.currentPosition = (String)value;
            if (this.currentPosition != null && this.currentPosition.trim().isEmpty()) {
                this.currentPosition = null;
            }
        } else if ("Customer".equals(id)) {
            this.customer = value instanceof Node ? (CustomerReference)((Node)value).getValue() : (value instanceof CustomerLight ? (CustomerReference)value : null);
        } else if ("MainCat".equals(id)) {
            if (value instanceof Node) {
                this.mainCat = (ArticleCategoryReference)((Node)value).getValue();
            } else {
                this.mainCat = null;
                this.mainGroup = null;
                this.subGroup = null;
            }
        } else if ("MainGroup".equals(id)) {
            if (value instanceof Node) {
                this.mainGroup = (ArticleCategoryReference)((Node)value).getValue();
            } else {
                this.mainGroup = null;
                this.subGroup = null;
            }
        } else if ("SubGroup".equals(id)) {
            this.subGroup = value instanceof Node ? (ArticleCategoryReference)((Node)value).getValue() : null;
        } else if ("Bonded".equals(id)) {
            BondedStateE state = BondedStateE.ALL;
            if (value instanceof BondedStateE) {
                state = (BondedStateE)value;
            } else if (value instanceof Node && ((Node)value).getValue() instanceof BondedStateE) {
                state = (BondedStateE)((Node)value).getValue();
            }
            switch (state) {
                case ALL: {
                    this.isBonded = null;
                    break;
                }
                case NOT_BONDED: {
                    this.isBonded = false;
                    break;
                }
                case ONLY_BONDED: {
                    this.isBonded = true;
                }
            }
        } else if ("Deleted".equals(id)) {
            if (value instanceof DeletedStateE) {
                this.fc8 = (DeletedStateE)value;
            }
        } else if ("Inuse".equals(id)) {
            if (value instanceof InUseStateE) {
                this.fc9 = (InUseStateE)value;
            }
        } else if ("orderField".equals(id) && value instanceof String) {
            if (Words.ARTICLE_NUMBER.equals(value)) {
                this.sortRow = 1;
            } else if (Words.ARTICLE_NAME.equals(value)) {
                this.sortRow = 3;
            } else if (Words.CUSTOMER_ARTICLE_NUMBER.equals(value)) {
                this.sortRow = 2;
            }
        }
        StoreContentSearchConfiguration c = new StoreContentSearchConfiguration();
        String t = this.currentArticle;
        Integer ti = null;
        try {
            ti = Integer.valueOf(t);
        }
        catch (NumberFormatException e) {
            ti = null;
        }
        switch (this.miniCombo.getSelectedType()) {
            case ALL: {
                c.setArticleName(t);
                c.setArticleNumber(ti);
                c.setCustomerArticleNumber(t);
                break;
            }
            case ARTICLE_NAME: {
                c.setArticleName(t);
                break;
            }
            case ARTICLE_NUMBER: {
                c.setArticleNumber(ti);
                break;
            }
            case CUSTOMER_NUMBER: {
                c.setCustomerArticleNumber(t);
                break;
            }
        }
        c.setStore((StoreReference)this.storeDTO);
        c.setStorePositionName(this.currentPosition);
        c.setCustomer(this.customer);
        c.setMainCategory(this.mainCat);
        c.setMainGroup(this.mainGroup);
        c.setSubGroup(this.subGroup);
        c.setBonded(this.isBonded);
        if (this.fc8 != null) {
            switch (this.fc8) {
                case ALL: {
                    c.setIsDeleted(null);
                    break;
                }
                case NOT_DELETED: {
                    c.setIsDeleted(Boolean.valueOf(false));
                    break;
                }
                case ONLY_DELETED: {
                    c.setIsDeleted(Boolean.valueOf(true));
                    break;
                }
                default: {
                    c.setIsDeleted(null);
                }
            }
        }
        if (this.fc9 != null) {
            switch (this.fc9) {
                case ALL: {
                    c.setInUse(null);
                    break;
                }
                case NOT_USED: {
                    c.setInUse(Boolean.valueOf(false));
                    break;
                }
                case ONLY_USED: {
                    c.setInUse(Boolean.valueOf(true));
                    break;
                }
                default: {
                    c.setInUse(null);
                }
            }
        }
        c.setSortDirection(SortDirection.ASCENDING);
        switch (this.sortRow) {
            case 1: {
                c.setSortColumn((Enum)StoreContentSearchConfiguration.STORE_POSITION_CONTENT_COLUMN.ARTICLE_NUMBER);
                break;
            }
            case 2: {
                c.setSortColumn((Enum)StoreContentSearchConfiguration.STORE_POSITION_CONTENT_COLUMN.CUSTOMER_ARTICLE_NUMBER);
                break;
            }
            case 3: {
                c.setSortColumn((Enum)StoreContentSearchConfiguration.STORE_POSITION_CONTENT_COLUMN.ARTICLE_NAME);
            }
        }
        c.setNumResults(30);
        return c;
    }

    @Override
    public void importInventoryCountData(final File file) {
        ThreadSafeExecutable run = new ThreadSafeExecutable(){

            @Override
            public Node<?> loadData() throws Exception {
                List<ExcelRow> excelRows;
                boolean importedWithoutProblems = true;
                try {
                    StoreComplete store = (StoreComplete)((StoreServiceManager)ServiceManagerRegistry.getService(StoreServiceManager.class)).getStoreByReference(new StoreReference(InventoryPBSubModuleNEW.this.storeDTO.getId())).getValue();
                    excelRows = ExcelToolkit.readRows((File)file, (int)0, (boolean)true);
                    excelRows.removeIf(excelRow -> {
                        boolean foundValue = false;
                        for (Object cell : excelRow.getCells()) {
                            if (cell == null) continue;
                            if (cell instanceof String) {
                                if (StringUtil.isBlank((String)((String)cell))) continue;
                                foundValue = true;
                                continue;
                            }
                            foundValue = true;
                        }
                        return !foundValue;
                    });
                    InventoryCountImportUtil util = new InventoryCountImportUtil(InventoryPBSubModuleNEW.this, InventoryPBSubModuleNEW.this.isChargeBased());
                    InventoryPBSubModuleNEW.this.notOkList = util.importRows(excelRows, store);
                    if (InventoryPBSubModuleNEW.this.notOkList == null) {
                        InventoryPBSubModuleNEW.this.notOkList = new ArrayList();
                        importedWithoutProblems = false;
                    }
                }
                catch (ExcelToolkitException e) {
                    excelRows = new ArrayList();
                    InnerPopupFactory.showErrorDialog("Could not read Excel file. Ensure file is closed.", (Component)InventoryPBSubModuleNEW.this);
                    importedWithoutProblems = false;
                }
                if (!InventoryPBSubModuleNEW.this.notOkList.isEmpty()) {
                    ArrayList<ScreenValidationObject> validations = new ArrayList<ScreenValidationObject>();
                    for (Tuple tuple : InventoryPBSubModuleNEW.this.notOkList) {
                        validations.add(new ScreenValidationObject(ScreenValidationObject.ValidationStateE.FATAL, "Article : " + tuple.getS() + " " + (String)tuple.getT()));
                    }
                    importedWithoutProblems = false;
                    InventoryPBSubModuleNEW.this.showErrorsAndDownloadExcel(validations, excelRows);
                }
                Node n = new Node();
                n.setValue((Object)new Boolean(importedWithoutProblems), 0L);
                return n;
            }

            @Override
            public RemoteLoader getInvoker() {
                return new RemoteLoader(){

                    public void remoteObjectLoaded(Node<?> node) {
                        Boolean importedWithoutProblems = (Boolean)node.getValue();
                        if (Boolean.TRUE.equals(importedWithoutProblems)) {
                            InnerPopupFactory.showMessageDialog("Inventory data imported", InventoryPBSubModuleNEW.this);
                        }
                        InventoryPBSubModuleNEW.this.upperTable.hideLoadingAnimation();
                        InventoryPBSubModuleNEW.this.upperTable.setEnabled(true);
                    }

                    public void errorOccurred(ClientException exception) {
                        InnerPopupFactory.showErrorDialog((Exception)((Object)exception), (Component)InventoryPBSubModuleNEW.this);
                        if (InventoryPBSubModuleNEW.this.upperTable != null) {
                            InventoryPBSubModuleNEW.this.upperTable.setEnabled(true);
                        }
                    }
                };
            }

            @Override
            public long getID() {
                return 0L;
            }
        };
        ThreadSafeLoader.run(run);
    }

    private void showErrorsAndDownloadExcel(List<ScreenValidationObject> validations, List<ExcelRow> excelRows) {
        this.lowerTable.hideLoadingAnimation();
        InnerPopupFactory.showErrorDialog(validations, "Import Inventory", "Unable to import", (source, xargs) -> {
            try {
                File pegFile = new InventoryCountImportUtil(this, this.isChargeBased()).createExcelWithErrors(excelRows);
                Desktop.getDesktop().open(pegFile);
            }
            catch (IOException e) {
                this.log.error("Unable to generate Excel File", (Throwable)e);
            }
        }, this);
    }

    @Override
    public void openErrorDialog(String message) {
        InnerPopupFactory.showErrorDialog(message, (Component)this);
    }

    @Override
    public String getDuplicationText() {
        return "Already added to counted list";
    }

    @Override
    protected SearchAlgorithm getSearchAlgorithm() {
        return SearchAlgorithmRegistry.getSearchAlgorithm(StoreContentSearchAlgorithm.class);
    }

    @Override
    public void revalidateTables() {
        HashSet<Tuple> used = new HashSet<Tuple>();
        for (Table2RowPanel tableRowPanel : this.lowerTable.getModel().getTable().getRowsFailSafe()) {
            if (!(tableRowPanel.getModel().getNode().getValue() instanceof StorePositionContentComplete)) continue;
            used.add(new Tuple((Object)((StorePositionContentComplete)tableRowPanel.getModel().getNode().getValue()).getArticle().getId(), (Object)((StorePositionContentComplete)tableRowPanel.getModel().getNode().getValue()).getStorePosition().getId()));
        }
        for (Table2RowPanel tableRowPanel : this.upperTable.getModel().getTable().getRowsFailSafe()) {
            if (!(tableRowPanel.getModel().getNode().getValue() instanceof StorePositionContentComplete)) continue;
            if (used.contains(new Tuple((Object)((StorePositionContentComplete)tableRowPanel.getModel().getNode().getValue()).getArticle().getId(), (Object)((StorePositionContentComplete)tableRowPanel.getModel().getNode().getValue()).getStorePosition().getId()))) {
                ((TableRowImplNEW)tableRowPanel).setBlocked(true);
                continue;
            }
            ((TableRowImplNEW)tableRowPanel).setBlocked(false);
        }
    }

    @Override
    public void showLoadingAnimation(int currentRow, int maxRow) {
        this.upperTable.updateLoadingAnimation("Importing " + (int)((double)currentRow / (double)maxRow * 100.0) + "%");
    }

    @Override
    public boolean addToLower(StorePositionContentComplete content, QuantityComplete quantityComplete) {
        return this.addToLowerTable(content, quantityComplete);
    }

    @Override
    public boolean checkForDuplicationsInLower(int artNo, InventoryCheckinComplete scc) {
        String already_counted = "Already counted";
        boolean alreadyCounted = false;
        boolean doRemove = true;
        Iterator it = this.lowerTable.getModel().getNode().getFailSafeChildIterator();
        while (it.hasNext()) {
            boolean samePosition;
            boolean sameNumber;
            Object o = it.next();
            Object value = ((DTONode)o).getValue();
            if (value instanceof StorePositionContentComplete) {
                sameNumber = ((StorePositionContentComplete)value).getArticle().getNumber().equals(artNo);
                samePosition = ((StorePositionContentComplete)value).getStorePosition().getId().equals(scc.getStorePosition().getId());
                if (sameNumber && samePosition) {
                    this.addToNotOkList(artNo, already_counted);
                    alreadyCounted = true;
                    doRemove = false;
                    continue;
                }
            }
            if (!(value instanceof InventoryCheckinComplete)) continue;
            sameNumber = ((InventoryCheckinComplete)value).getArticle().getNumber().equals(artNo);
            samePosition = ((InventoryCheckinComplete)value).getStorePosition().getId().equals(scc.getStorePosition().getId());
            if (!sameNumber || !samePosition) continue;
            this.addToNotOkList(artNo, already_counted);
            alreadyCounted = true;
            doRemove = false;
        }
        if (!alreadyCounted) {
            Node n = INodeCreator.getDefaultImpl().getNode4DTO((Object)scc, true, false);
            n.setManuallyAdded(true);
            this.lowerTable.getModel().getNode().addChild(n, 0L);
            this.getAlgorithm().addNodeToAll(n);
        }
        return doRemove;
    }

    private void addToNotOkList(Integer artNo, String message) {
        this.notOkList.add((Tuple<Integer, String>)new Tuple((Object)artNo, (Object)message));
    }
}

