/*
 * Decompiled with CFR 0.152.
 */
package ch.icit.pegasus.client.gui.table;

import ch.icit.pegasus.client.gui.table.DetailsEditorParagraph;
import ch.icit.pegasus.client.gui.table.RowModel;
import ch.icit.pegasus.client.gui.table.VariantMessageProvidedRowEditor;
import ch.icit.pegasus.client.gui.utils.buttons.Button;
import ch.icit.pegasus.client.gui.utils.popup.InnerPopupFactory;
import ch.icit.pegasus.client.node.DtoFieldConstants;
import ch.icit.pegasus.client.node.impls.Node;
import ch.icit.pegasus.client.node.impls.ProxyNode;
import ch.icit.pegasus.server.core.dtos.product.ProductComplete_;
import ch.icit.pegasus.server.dtos.IDTO;
import java.awt.Component;
import java.util.ArrayList;
import java.util.HashSet;

public class ProductVariantMessageProvidedRowEditor<T extends IDTO>
extends VariantMessageProvidedRowEditor<T> {
    private static final long serialVersionUID = 1L;
    private DetailsEditorParagraph variantPanel;
    private boolean isUpdatable;

    public ProductVariantMessageProvidedRowEditor(RowModel<T> model, String messageSuffix) {
        super(model, messageSuffix);
    }

    @Override
    public void setVariantPanel(DetailsEditorParagraph p) {
        this.variantPanel = p;
    }

    private String getMessage() {
        return "Do you want to copy your changes in the Tender Scenario Variant? Accepted Tender Scenario aren't changed.";
    }

    private void copyChanges(boolean copy) {
        Node cc = this.model.getNode().getChildNamed(DtoFieldConstants.copyChanges);
        if (cc == null) {
            cc = new Node();
            cc.setName(DtoFieldConstants.copyChanges);
            this.model.getNode().addChild(cc, 0L);
        }
        cc.setValue((Object)copy, 0L);
    }

    @Override
    public void buttonPressed(Button source, int x, int y) {
        if (source == this.add) {
            this.showCommittingAnimation("Validate Data");
            this.doValidation();
        } else if (source == this.cancel) {
            this.setEnabled(false);
            this.currentSaveState = -1;
            boolean hasChanges = false;
            try {
                hasChanges = this.getModel().getNode().hasDataChanged(new HashSet());
            }
            catch (Exception e) {
                this.log.error("Error while check for changes", (Throwable)e);
            }
            if (hasChanges) {
                InnerPopupFactory.CANCEL_TYPES type = InnerPopupFactory.CANCEL_TYPES.CANCEL_NORMAL;
                if (this.overrideType != null) {
                    type = this.overrideType;
                } else if (this.model.isAddRow()) {
                    type = InnerPopupFactory.CANCEL_TYPES.CANCEL_ADD;
                }
                InnerPopupFactory.showEnsureCancelPopup(this.cancel, x, y, this, type);
            } else {
                Object[] o = new Object[]{};
                this.popUpClosed(null, o);
            }
        }
    }

    @Override
    public void setNode2Panels(Node node, ArrayList<ArrayList<Component>> comps) {
        if (this.model.isAddRow()) {
            Node n = this.model.getNode().getChildNamed(ProductComplete_.currentVariant);
            if (n instanceof ProxyNode) {
                n = ((ProxyNode)n).getRefNode();
            }
            for (ArrayList<Component> cc : comps) {
                for (Component c : cc) {
                    if (c == null) continue;
                    ((DetailsEditorParagraph)((Object)c)).setNode(n);
                }
            }
        } else {
            this.variantPanel.setNode(this.model.getNode());
        }
    }

    public void setUpdateable(boolean isUpdatable) {
        this.isUpdatable = isUpdatable;
    }
}

