/*
 * Decompiled with CFR 0.152.
 */
package ch.icit.pegasus.client.gui.table.renderer;

import ch.icit.pegasus.client.gui.table.CellModel;
import ch.icit.pegasus.client.gui.table.CellRenderer;
import ch.icit.pegasus.client.gui.utils.DefaultLayout;
import ch.icit.pegasus.client.gui.utils.buttons.ImageIndicatorButton;
import ch.icit.pegasus.server.core.dtos.file.PegasusFileComplete;
import java.awt.Container;
import java.awt.Dimension;

public class CellViewImageChooser
extends CellRenderer {
    private PegasusFileComplete fileRef;
    private ImageIndicatorButton button;
    private String attName;

    public CellViewImageChooser(CellModel model, String attributeName) {
        this.attName = attributeName;
        if (this.attName.startsWith("#")) {
            this.attName = this.attName.substring(1, this.attName.length());
        }
        if (model.getParentModel().getNode().getChildNamed(new String[]{this.attName}) != null && model.getParentModel().getNode().getChildNamed(new String[]{this.attName}).getValue() != null) {
            this.fileRef = (PegasusFileComplete)model.getParentModel().getNode().getChildNamed(new String[]{this.attName}).getValue();
        }
        this.button = new ImageIndicatorButton();
        this.button.setChosen(this.fileRef != null);
        this.button.setUserObject(model.getParentModel().getNode().getChildNamed(new String[]{this.attName}));
        this.setLayout(new Layout());
        this.add(this.button);
    }

    @Override
    public void willExpand(boolean b) {
        this.setEnabled(!b);
    }

    @Override
    public String getStringValue() {
        return CellViewImageChooser.getValueString(this.fileRef);
    }

    @Override
    public void setEnabled(boolean isEnabled) {
        super.setEnabled(isEnabled);
        this.button.setEnabled(isEnabled);
    }

    @Override
    public void kill() {
        if (this.isKilled()) {
            return;
        }
        super.kill();
        this.button.kill();
        this.button = null;
    }

    public static String getValueString(PegasusFileComplete value) {
        return value != null ? "set" : "";
    }

    private class Layout
    extends DefaultLayout {
        private Layout() {
        }

        @Override
        public void layoutContainer(Container parent) {
            CellViewImageChooser.this.button.setLocation((int)(((double)parent.getWidth() - CellViewImageChooser.this.button.getPreferredSize().getWidth()) / 2.0), (int)((double)parent.getHeight() - CellViewImageChooser.this.button.getPreferredSize().getHeight()) / 2);
            CellViewImageChooser.this.button.setSize(CellViewImageChooser.this.button.getPreferredSize());
        }

        @Override
        public Dimension preferredLayoutSize(Container parent) {
            return CellViewImageChooser.this.button.getPreferredSize();
        }
    }
}

