/*
 * Decompiled with CFR 0.152.
 */
package ch.icit.pegasus.client.gui.utils;

import ch.icit.pegasus.client.gui.utils.CheckedListAdder;
import ch.icit.pegasus.client.gui.utils.DefaultLayout;
import ch.icit.pegasus.client.gui.utils.Selectable;
import ch.icit.pegasus.client.gui.utils.TextLabel;
import ch.icit.pegasus.client.gui.utils.TitledItem;
import ch.icit.pegasus.client.gui.utils.buttons.RadioButton;
import ch.icit.pegasus.client.gui.utils.focus.Focusable;
import ch.icit.pegasus.client.gui.utils.focus.VisibleContainer;
import ch.icit.pegasus.client.gui.utils.panels.defaults.JPanelFadable;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.util.ArrayList;
import java.util.List;

public class PrintStyleChooser
extends JPanelFadable
implements Focusable {
    private static final long serialVersionUID = 1L;
    private TextLabel title;
    private TitledItem<RadioButton> tableBased;
    private TitledItem<RadioButton> boxBased;
    private int border = 10;
    private Color c;
    private Font f;

    public PrintStyleChooser(boolean withBox, String title1, String t1, String t2) {
        this.setOpaque(false);
        this.title = new TextLabel(title1);
        this.tableBased = new TitledItem<RadioButton>(new RadioButton(), t1, TitledItem.TitledItemOrientation.WEST);
        this.c = this.tableBased.getTitle().getComponentForeground();
        this.f = this.tableBased.getTitle().getFont();
        if (withBox) {
            this.boxBased = new TitledItem<RadioButton>(new RadioButton(), t2, TitledItem.TitledItemOrientation.WEST);
            this.boxBased.setTitleForeground(this.title.getComponentForeground());
            this.boxBased.setTitleFont(this.title.getDefaultFont());
            this.boxBased.getElement().setChecked(false);
        }
        this.tableBased.setTitleForeground(this.title.getComponentForeground());
        this.tableBased.setTitleFont(this.title.getDefaultFont());
        this.title.setForeground(this.c);
        this.title.setFont(this.f);
        this.tableBased.getElement().setChecked(true);
        this.setProgress(1.0f);
        this.setLayout(new Layout());
        this.add(this.title);
        this.add(this.tableBased);
        if (this.boxBased != null) {
            this.add(this.boxBased);
        }
    }

    public PrintStyleChooser(boolean withBox) {
        this(withBox, "PRINT STYLE", "Table based", "Box based");
    }

    public Color getCColor() {
        return this.c;
    }

    public Font getCFont() {
        return this.f;
    }

    @Override
    public void setEnabled(boolean isEnabled) {
        super.setEnabled(isEnabled);
        this.title.setEnabled(isEnabled);
        this.tableBased.setEnabled(isEnabled);
        if (this.boxBased != null) {
            this.boxBased.setEnabled(isEnabled);
        }
    }

    @Override
    public void setVisible(boolean vis) {
        this.title.setVisible(vis);
        this.tableBased.setVisible(vis);
        if (this.boxBased != null) {
            this.boxBased.setVisible(vis);
        }
    }

    public boolean isTableBased() {
        if (this.boxBased == null) {
            return true;
        }
        return this.tableBased.getElement().isChecked();
    }

    @Override
    public List<Component> getFocusComponents() {
        ArrayList<Component> a = new ArrayList<Component>();
        CheckedListAdder.addToList(a, this.tableBased);
        CheckedListAdder.addToList(a, this.boxBased);
        return a;
    }

    @Override
    public void setVisibleContainer(VisibleContainer pane) {
        this.tableBased.setVisibleContainer(pane);
        if (this.boxBased != null) {
            this.boxBased.setVisibleContainer(pane);
        }
    }

    @Override
    public Selectable getSelectDelegationComponent() {
        return null;
    }

    @Override
    public void requestFocusInWindowNow() {
        this.tableBased.requestFocusInWindowNow();
    }

    @Override
    public void kill() {
        if (this.isKilled()) {
            return;
        }
        super.kill();
        this.title.kill();
        if (this.boxBased != null) {
            this.boxBased.kill();
        }
        this.tableBased.kill();
        this.title = null;
        this.boxBased = null;
        this.tableBased = null;
    }

    private class Layout
    extends DefaultLayout {
        private Layout() {
        }

        @Override
        public Dimension preferredLayoutSize(Container parent) {
            int h = 0;
            h = (int)((double)h + PrintStyleChooser.this.title.getPreferredSize().getHeight());
            h += PrintStyleChooser.this.border;
            h = (int)((double)h + PrintStyleChooser.this.tableBased.getPreferredSize().getHeight());
            return new Dimension(0, h);
        }

        @Override
        public void layoutContainer(Container parent) {
            int cy = 0;
            PrintStyleChooser.this.title.setLocation(0, 0);
            PrintStyleChooser.this.title.setSize(parent.getWidth() - 2 * PrintStyleChooser.this.border, (int)PrintStyleChooser.this.title.getPreferredSize().getHeight());
            cy += PrintStyleChooser.this.title.getHeight() + PrintStyleChooser.this.border;
            int tw = (parent.getWidth() - 2 * PrintStyleChooser.this.border) / 2;
            if ((double)tw > PrintStyleChooser.this.tableBased.getPreferredSize().getWidth()) {
                tw = (int)PrintStyleChooser.this.tableBased.getPreferredSize().getWidth();
            }
            PrintStyleChooser.this.tableBased.setLocation(0, cy);
            PrintStyleChooser.this.tableBased.setSize(tw, (int)PrintStyleChooser.this.tableBased.getPreferredSize().getHeight());
            tw = (parent.getWidth() - PrintStyleChooser.this.border) / 2;
            if (PrintStyleChooser.this.boxBased != null) {
                if ((double)tw > PrintStyleChooser.this.boxBased.getPreferredSize().getWidth()) {
                    tw = (int)PrintStyleChooser.this.boxBased.getPreferredSize().getWidth();
                }
                PrintStyleChooser.this.boxBased.setLocation(PrintStyleChooser.this.tableBased.getX() + PrintStyleChooser.this.tableBased.getWidth() + 2 * PrintStyleChooser.this.border, cy);
                PrintStyleChooser.this.boxBased.setSize(tw, (int)PrintStyleChooser.this.boxBased.getPreferredSize().getHeight());
            }
        }
    }
}

