/*
 * Decompiled with CFR 0.152.
 */
package ch.icit.pegasus.client.gui.utils.buttons;

import ch.icit.pegasus.client.gui.utils.InnerPopUpListener2;
import ch.icit.pegasus.client.gui.utils.Validatable;
import ch.icit.pegasus.client.gui.utils.buttons.Button;
import ch.icit.pegasus.client.gui.utils.buttons.ButtonListener;
import ch.icit.pegasus.client.gui.utils.buttons.prototypes.ToggleSkinButton_NEW;
import ch.icit.pegasus.client.gui.utils.popup.IPopUpInsert;
import ch.icit.pegasus.client.gui.utils.popup.InnerPopUp2;
import ch.icit.pegasus.client.gui.utils.popup.InnerPopupFactory;
import ch.icit.pegasus.client.gui.utils.skins.ToggleSkin1Field;
import ch.icit.pegasus.client.gui.utils.skins.impls.defaults.DefaultSkins;
import ch.icit.pegasus.client.node.impls.Node;
import ch.icit.pegasus.client.node.impls.NodeListener;
import ch.icit.pegasus.server.core.i18n.Words;

public class RemarkButton
extends ToggleSkinButton_NEW
implements Validatable,
ButtonListener,
NodeListener {
    private static final long serialVersionUID = 1L;
    private IPopUpInsert popUpView;
    private Node<String> remarkNode;
    private boolean editable;

    public RemarkButton(boolean hasInnerPop) {
        super(DefaultSkins.RemarkIcon, false);
        this.setToolTipText(Words.SHOW_REMARK);
        if (hasInnerPop) {
            this.addButtonListener(this);
        }
        this.setChoosen(false);
    }

    public boolean isEditable() {
        return this.editable;
    }

    public void setEditable(boolean editable) {
        this.editable = editable;
    }

    public RemarkButton(Node<String> remarkNode) {
        this(remarkNode, true);
    }

    public RemarkButton(Node<String> remarkNode, boolean canEdit) {
        this(true);
        this.setNode(remarkNode);
    }

    public Node<String> getNode() {
        return this.remarkNode;
    }

    @Override
    public void kill() {
        super.kill();
        if (this.remarkNode != null) {
            this.remarkNode.removeNodeListener((NodeListener)this);
        }
    }

    public void setChoosen(boolean isChoosen) {
        super.setChecked(isChoosen);
    }

    public IPopUpInsert getPopUpView() {
        return this.popUpView;
    }

    public void setPopUpView(IPopUpInsert popUpView) {
        this.popUpView = popUpView;
    }

    @Override
    public void popUpClosed(InnerPopUp2 source, Object ... xargs) {
        super.popUpClosed(source, xargs);
        if (this.remarkNode != null && this.remarkNode.getValue() != null && ((String)this.remarkNode.getValue()).isEmpty()) {
            this.remarkNode.setValue(null, 0L);
        }
        this.revalidateChooseState();
    }

    public static int getPreferredWidth() {
        ToggleSkin1Field skin = (ToggleSkin1Field)DefaultSkins.RemarkIcon.createDynamicSkin();
        return skin.getImage(Button.ButtonState.UP).getWidth();
    }

    @Override
    public void setInvalid() {
        this.setState(Button.ButtonState.ERROR);
    }

    @Override
    public void setValid() {
        if (this.state == Button.ButtonState.ERROR) {
            this.setState(Button.ButtonState.UP);
        }
    }

    @Override
    public void setWarning() {
    }

    @Override
    public void buttonPressed(Button source, int x, int y) {
        InnerPopUp2 popUp = null;
        if (popUp == null) {
            popUp = InnerPopUp2.getInnerPopUp();
            popUp.setAttributes(null, false, false, "Remark");
            if (this.editable) {
                InnerPopupFactory.showEnterMessagePopup("Remark", new InnerPopUpListener2(){

                    @Override
                    public void popUpClosed(InnerPopUp2 source, Object ... xargs) {
                        RemarkButton.this.popUpClosed(source, xargs);
                    }
                }, source, this.remarkNode, x, y);
            } else {
                InnerPopupFactory.showRemarkPopup(source, x, y, null, this.remarkNode);
            }
        }
    }

    public void setNode(Node<String> remark) {
        if (this.remarkNode != null) {
            this.remarkNode.removeNodeListener((NodeListener)this);
        }
        this.remarkNode = remark;
        this.revalidateChooseState();
        if (this.remarkNode != null) {
            this.remarkNode.addNodeListener((NodeListener)this);
        }
    }

    private void revalidateChooseState() {
        if (this.remarkNode != null && this.remarkNode.getValue() != null) {
            this.setChoosen(true);
        } else {
            this.setChoosen(false);
        }
    }

    @Override
    public void setPermanent(boolean isPermantent) {
    }

    public void valueChanged(Node<?> node) {
        this.revalidateChooseState();
    }

    public void childAdded(Node<?> source, Node<?> child) {
    }

    public void childRemoved(Node<?> source, Node<?> child) {
    }

    public void childrenAdded(Node<?> source, Node<?> ... nodes) {
    }

    public boolean isSwingOnly() {
        return true;
    }
}

