/*
 * Decompiled with CFR 0.152.
 */
package ch.icit.pegasus.client.gui.utils.panels;

import ch.icit.pegasus.client.gui.utils.AttributesConverter;
import ch.icit.pegasus.client.gui.utils.CheckedListAdder;
import ch.icit.pegasus.client.gui.utils.DefaultLayout;
import ch.icit.pegasus.client.gui.utils.MultiLineTextLabel;
import ch.icit.pegasus.client.gui.utils.Selectable;
import ch.icit.pegasus.client.gui.utils.TitledItem;
import ch.icit.pegasus.client.gui.utils.buttons.Button;
import ch.icit.pegasus.client.gui.utils.buttons.ButtonListener;
import ch.icit.pegasus.client.gui.utils.buttons.CheckBox;
import ch.icit.pegasus.client.gui.utils.buttons.RadioButton;
import ch.icit.pegasus.client.gui.utils.filterchain.FilterChainConfiguration;
import ch.icit.pegasus.client.gui.utils.filterchain.UIStateLoadable;
import ch.icit.pegasus.client.gui.utils.focus.Focusable;
import ch.icit.pegasus.client.gui.utils.focus.VisibleContainer;
import ch.icit.pegasus.client.gui.utils.panels.ConfigPanel;
import ch.icit.pegasus.client.gui.utils.rightdependant.RDProvider;
import ch.icit.pegasus.client.laf.LafLoader;
import ch.icit.pegasus.client.services.ServiceManagerRegistry;
import ch.icit.pegasus.client.services.interfaces.system.UserServiceManager;
import ch.icit.pegasus.client.util.HUDToolkit;
import ch.icit.pegasus.client.util.ScreenValidationObject;
import ch.icit.pegasus.server.core.dtos.report.generic.FlightAnalysisDeliverySlipsConfiguration;
import ch.icit.pegasus.server.core.dtos.rightmanagement.access.ModuleAccessRightComplete;
import ch.icit.pegasus.server.core.dtos.rightmanagement.template.def.FlightAccess;
import ch.icit.pegasus.server.core.dtos.util.SalesOnBoardReportStateE;
import ch.icit.pegasus.server.core.i18n.Words;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.util.ArrayList;
import java.util.List;

public class DeliverySlipConfigPanel
extends ConfigPanel
implements Focusable,
ButtonListener,
UIStateLoadable {
    private static final long serialVersionUID = 1L;
    protected int border = 10;
    private boolean showSobState = true;
    private boolean isHideNSDSActive = false;
    protected TitledItem<CheckBox> finalizeFlight;
    protected TitledItem<RadioButton> useCATITNo;
    protected TitledItem<RadioButton> useCustomerNo;
    protected TitledItem<RadioButton> useProductLabelName;
    protected TitledItem<RadioButton> useAISName;
    protected TitledItem<RadioButton> useProductName;
    protected TitledItem<RadioButton> quantityBased;
    protected TitledItem<RadioButton> cashBased;
    protected TitledItem<CheckBox> sortProductsByNumber;
    protected TitledItem<CheckBox> includeArticles;
    protected TitledItem<CheckBox> includeHandlings;
    protected TitledItem<CheckBox> includeStandard;
    protected TitledItem<CheckBox> includeNullValues;
    protected TitledItem<CheckBox> includePaxUpdate;
    protected TitledItem<CheckBox> includeDrawersCount;
    protected TitledItem<CheckBox> includeTemperature;
    protected TitledItem<CheckBox> includeSeals;
    protected TitledItem<CheckBox> includeAIS;
    protected TitledItem<CheckBox> groupAdditionals;
    protected TitledItem<CheckBox> showAdditionalsSeparately;
    protected TitledItem<CheckBox> showSpecialMealsSeparately;
    protected TitledItem<CheckBox> includeCrewPaxes;
    protected TitledItem<CheckBox> summarizeCrew;
    protected TitledItem<CheckBox> excludeZeroPax;
    protected TitledItem<CheckBox> hideFlightFromToNSDS;
    protected MultiLineTextLabel infoLabel;
    protected TitledItem<RadioButton> showAllProducts;
    protected TitledItem<RadioButton> showSobProductsOnly;
    protected TitledItem<RadioButton> showNoSobProductsOnly;
    protected TitledItem<RadioButton> printAll;
    protected TitledItem<RadioButton> printTitlepageOnly;
    protected TitledItem<RadioButton> printWithoutTitlepage;
    protected TitledItem<CheckBox> printProducesText;
    protected TitledItem<CheckBox> printIngredientListInfo;
    FilterChainConfiguration conf;
    private static final String AIS_CONFIG = "sign_ais";
    private static final String CASH_CONFIG_NAME = "cash";
    private static final String ARTICLES_CONFIG_NAME = "overview";
    private static final String HANDLING_CONFIG_NAME = "handlings";
    private static final String STANDARD_CONFIG_NAME = "standard";
    private static final String DRAWER_CONFIG_NAME = "drawer";
    private static final String TEMPERATURE_CONFIG_NAME = "temperature";
    private static final String SEALS_CONFIG_NAME = "seals";
    private static final String CREW_PAX_CONFIG_NAME = "crewpax";
    private static final String NUMBER_CONFIG_NAME = "number";
    private static final String AIS_NAME = "ais";
    private static final String PRODUCT_LABEL_NAME = "productName";
    private static final String PRODUCT_NAME = "useproductname";
    private static final String INCLUDE_NULL_CONFIG_NAME = "include_null";
    private static final String SUMMARIZE_CREW = "summarize_crew";
    private static final String HIDE_NS_DS_FLIGHTS = "hide_ns_ds_flights";
    private static final String SOB_STATE = "sobState";
    private static final String GROUP_ADDITIONALS = "groupAdditional";
    private static final String EXCLUDE_ZERO_PAX_ = "excludeZeroPax";
    private static final String SHOW_ADDITIONALS_SEPARATELY = "showAdditionalSeparately";
    private static final String SHOW_SPMLS_SEPARATELY = "showSPMLsSeparately";
    private static final String SHOW_ALL_PRODUCTS = "showAllProducts";
    private static final String SHOW_SOB_ONLY = "showSobOnly";
    private static final String SHOW_NON_SOB_ONLY = "showNonSobOnly";
    private static final String PRINT_ALL = "printAll";
    private static final String PRINT_TITLEPAGE_ONLY = "printTitlePageOnly";
    private static final String PRINT_WITHOUT_TITLEPAGE = "printWithoutTitlePage";
    private static final String FINALIZE_FLIGHT = "finalizeFlight";
    private static final String PRINT_PRODUCES_TEXT_TYPE = "printProducesText";
    private static final String PRINT_INGREDIENT_LIST_INFO_TYPE = "printIngredientListInfo";

    public DeliverySlipConfigPanel() {
        ModuleAccessRightComplete m = HUDToolkit.getCurrentAccessRight(FlightAccess.MODULE_FLIGHT, ((UserServiceManager)ServiceManagerRegistry.getService(UserServiceManager.class)).getCurrentUser());
        RDProvider provider = new RDProvider(m, false);
        this.quantityBased = new TitledItem<RadioButton>(new RadioButton(), Words.QUANTITY_DELIVERY_SLIP, TitledItem.TitledItemOrientation.EAST);
        this.quantityBased.getElement().addButtonListener(this);
        if (provider.isWritable("printCostDeliverySlip", false)) {
            this.cashBased = new TitledItem<RadioButton>(new RadioButton(), Words.CASH_DELIVERY_SLIP, TitledItem.TitledItemOrientation.EAST);
            this.cashBased.getElement().addButtonListener(this);
        }
        this.quantityBased.getElement().setChecked(true);
        Font f = AttributesConverter.getFont4String(LafLoader.getLafLoader().getAttribute("default_font"), LafLoader.getLafLoader().getAttribute("default_font_size"), LafLoader.getLafLoader().getAttribute("default_font_type"));
        Color fb = AttributesConverter.getColor4String(LafLoader.getLafLoader().getAttribute("default_foreground_color"));
        ArrayList<RadioButton> l = new ArrayList<RadioButton>();
        l.add(this.quantityBased.getElement());
        if (this.cashBased != null) {
            l.add(this.cashBased.getElement());
        }
        this.quantityBased.getElement().setEffectedRadioButtons(l);
        if (this.cashBased != null) {
            this.cashBased.getElement().setEffectedRadioButtons(l);
        }
        this.quantityBased.getTitle().setForeground(fb);
        this.quantityBased.getTitle().setFont(f);
        if (this.cashBased != null) {
            this.cashBased.getTitle().setForeground(fb);
            this.cashBased.getTitle().setFont(f);
        }
        this.add(this.quantityBased);
        if (this.cashBased != null) {
            this.add(this.cashBased);
        }
        this.useCATITNo = new TitledItem<RadioButton>(new RadioButton(), Words.SHOW_CATIT_PRODUCT_NO, TitledItem.TitledItemOrientation.EAST);
        this.useCustomerNo = new TitledItem<RadioButton>(new RadioButton(), Words.SHOW_CUSTOMER_PRODUCT_NO, TitledItem.TitledItemOrientation.EAST);
        this.useCATITNo.getElement().setChecked(true);
        this.useCustomerNo.getElement().setChecked(false);
        ArrayList<RadioButton> l2 = new ArrayList<RadioButton>();
        l2.add(this.useCATITNo.getElement());
        l2.add(this.useCustomerNo.getElement());
        this.useCATITNo.getElement().setEffectedRadioButtons(l2);
        this.useCustomerNo.getElement().setEffectedRadioButtons(l2);
        this.useCATITNo.getTitle().setForeground(fb);
        this.useCATITNo.getTitle().setFont(f);
        this.useCustomerNo.getTitle().setForeground(fb);
        this.useCustomerNo.getTitle().setFont(f);
        this.add(this.useCATITNo);
        this.add(this.useCustomerNo);
        this.useProductLabelName = new TitledItem<RadioButton>(new RadioButton(), Words.USE_LABEL_NAME, TitledItem.TitledItemOrientation.EAST);
        this.useAISName = new TitledItem<RadioButton>(new RadioButton(), Words.USE_ALLERGEN_SHEET_NAME, TitledItem.TitledItemOrientation.EAST);
        this.useProductName = new TitledItem<RadioButton>(new RadioButton(), Words.USE_PRODUCT_NAME, TitledItem.TitledItemOrientation.EAST);
        this.useProductLabelName.getElement().setChecked(true);
        this.useAISName.getElement().setChecked(false);
        this.useProductName.getElement().setChecked(false);
        ArrayList<RadioButton> l3 = new ArrayList<RadioButton>();
        l3.add(this.useProductLabelName.getElement());
        l3.add(this.useAISName.getElement());
        l3.add(this.useProductName.getElement());
        this.useProductLabelName.getElement().setEffectedRadioButtons(l3);
        this.useAISName.getElement().setEffectedRadioButtons(l3);
        this.useProductName.getElement().setEffectedRadioButtons(l3);
        this.useProductLabelName.getTitle().setForeground(fb);
        this.useProductLabelName.getTitle().setFont(f);
        this.useAISName.getTitle().setForeground(fb);
        this.useAISName.getTitle().setFont(f);
        this.useProductName.getTitle().setForeground(fb);
        this.useProductName.getTitle().setFont(f);
        this.add(this.useProductLabelName);
        this.add(this.useAISName);
        this.add(this.useProductName);
        this.sortProductsByNumber = new TitledItem<CheckBox>(new CheckBox(), Words.SORT_BY_NUMBER, TitledItem.TitledItemOrientation.EAST);
        this.sortProductsByNumber.getTitle().setForeground(fb);
        this.sortProductsByNumber.getElement().setChecked(true);
        this.includeArticles = new TitledItem<CheckBox>(new CheckBox(), Words.INCLUDE_ARTICLE + " *", TitledItem.TitledItemOrientation.EAST);
        this.includeArticles.getTitle().setForeground(fb);
        this.includeArticles.getElement().setChecked(true);
        this.includeHandlings = new TitledItem<CheckBox>(new CheckBox(), Words.INCLUDE_HANDLING, TitledItem.TitledItemOrientation.EAST);
        this.includeHandlings.getTitle().setForeground(fb);
        this.includeHandlings.getElement().setChecked(true);
        this.includeStandard = new TitledItem<CheckBox>(new CheckBox(), Words.INCLUDE_STANDARD, TitledItem.TitledItemOrientation.EAST);
        this.includeStandard.getTitle().setForeground(fb);
        this.includeStandard.getElement().setChecked(true);
        this.includePaxUpdate = new TitledItem<CheckBox>(new CheckBox(), Words.INCLUDE_PAX_UPDATE, TitledItem.TitledItemOrientation.EAST);
        this.includePaxUpdate.getTitle().setForeground(fb);
        this.includePaxUpdate.getElement().setChecked(false);
        this.includeDrawersCount = new TitledItem<CheckBox>(new CheckBox(), Words.INCLUDE_DRAWER_COUNT, TitledItem.TitledItemOrientation.EAST);
        this.includeDrawersCount.getTitle().setForeground(fb);
        this.includeDrawersCount.getElement().setChecked(false);
        this.includeTemperature = new TitledItem<CheckBox>(new CheckBox(), Words.INCLUDE_TEMPERATURE, TitledItem.TitledItemOrientation.EAST);
        this.includeTemperature.getTitle().setForeground(fb);
        this.includeTemperature.getElement().setChecked(false);
        this.includeSeals = new TitledItem<CheckBox>(new CheckBox(), Words.INCLUDE_SEALS, TitledItem.TitledItemOrientation.EAST);
        this.includeSeals.getTitle().setForeground(fb);
        this.includeSeals.getElement().setChecked(false);
        this.includeAIS = new TitledItem<CheckBox>(new CheckBox(), Words.INCLUDE_AIS_SIGN, TitledItem.TitledItemOrientation.EAST);
        this.includeAIS.getTitle().setForeground(fb);
        this.includeAIS.getElement().setChecked(false);
        this.excludeZeroPax = new TitledItem<CheckBox>(new CheckBox(), Words.HIDE_CLASS_WITHOUT_PAX, TitledItem.TitledItemOrientation.EAST);
        this.excludeZeroPax.getTitle().setForeground(fb);
        this.includeCrewPaxes = new TitledItem<CheckBox>(new CheckBox(), Words.INCLUDE_CREW_PAX, TitledItem.TitledItemOrientation.EAST);
        this.includeCrewPaxes.getTitle().setForeground(fb);
        this.includeCrewPaxes.getElement().setChecked(true);
        this.includeCrewPaxes.getElement().addButtonListener(this);
        this.summarizeCrew = new TitledItem<CheckBox>(new CheckBox(), Words.SUMMARIZE_CREW, TitledItem.TitledItemOrientation.EAST);
        this.summarizeCrew.getTitle().setForeground(fb);
        this.includeNullValues = new TitledItem<CheckBox>(new CheckBox(), Words.INCLUDE_NULL_VALUES, TitledItem.TitledItemOrientation.EAST);
        this.includeNullValues.getTitle().setForeground(fb);
        this.includeNullValues.getElement().setChecked(true);
        this.groupAdditionals = new TitledItem<CheckBox>(new CheckBox(), Words.GROUP_ADDITONALS, TitledItem.TitledItemOrientation.EAST);
        this.groupAdditionals.getTitle().setForeground(fb);
        this.groupAdditionals.getElement().setChecked(false);
        this.showAdditionalsSeparately = new TitledItem<CheckBox>(new CheckBox(), Words.SHOW_ADDITIONALS_SEPARATELY, TitledItem.TitledItemOrientation.EAST);
        this.showAdditionalsSeparately.getTitle().setForeground(fb);
        this.showAdditionalsSeparately.getElement().setChecked(true);
        this.showSpecialMealsSeparately = new TitledItem<CheckBox>(new CheckBox(), Words.SHOW_SPML_SEPARATELY, TitledItem.TitledItemOrientation.EAST);
        this.showSpecialMealsSeparately.getTitle().setForeground(fb);
        this.showSpecialMealsSeparately.getElement().setChecked(true);
        if (this.isHideNSDSActive) {
            this.hideFlightFromToNSDS = new TitledItem<CheckBox>(new CheckBox(), Words.HIDE_FLIGHTS_FROMTO_NS_DS, TitledItem.TitledItemOrientation.EAST);
            this.hideFlightFromToNSDS.getTitle().setForeground(fb);
            this.hideFlightFromToNSDS.getElement().setChecked(false);
        }
        if (this.showSobState) {
            l = new ArrayList();
            this.showAllProducts = new TitledItem<RadioButton>(new RadioButton(), Words.SHOW_ALL_PRODUCTS, TitledItem.TitledItemOrientation.EAST);
            this.showSobProductsOnly = new TitledItem<RadioButton>(new RadioButton(), Words.SHOW_SOB_ONLY, TitledItem.TitledItemOrientation.EAST);
            this.showNoSobProductsOnly = new TitledItem<RadioButton>(new RadioButton(), Words.SHOW_NON_SOB_ONLY, TitledItem.TitledItemOrientation.EAST);
            this.showAllProducts.getTitle().setForeground(fb);
            this.showSobProductsOnly.getTitle().setForeground(fb);
            this.showNoSobProductsOnly.getTitle().setForeground(fb);
            l.add(this.showAllProducts.getElement());
            l.add(this.showSobProductsOnly.getElement());
            l.add(this.showNoSobProductsOnly.getElement());
            this.showAllProducts.getElement().setChecked(true);
            this.showAllProducts.getElement().setEffectedRadioButtons(l);
            this.showSobProductsOnly.getElement().setEffectedRadioButtons(l);
            this.showNoSobProductsOnly.getElement().setEffectedRadioButtons(l);
        }
        l = new ArrayList();
        this.printAll = new TitledItem<RadioButton>(new RadioButton(), Words.PRINT_ALL, TitledItem.TitledItemOrientation.EAST);
        this.printTitlepageOnly = new TitledItem<RadioButton>(new RadioButton(), Words.PRINT_TITLEPAGE_ONLY, TitledItem.TitledItemOrientation.EAST);
        this.printWithoutTitlepage = new TitledItem<RadioButton>(new RadioButton(), Words.PRINT_WITHOUT_TITLEPAGE, TitledItem.TitledItemOrientation.EAST);
        this.printAll.getTitle().setForeground(fb);
        this.printTitlepageOnly.getTitle().setForeground(fb);
        this.printWithoutTitlepage.getTitle().setForeground(fb);
        l.add(this.printAll.getElement());
        l.add(this.printTitlepageOnly.getElement());
        l.add(this.printWithoutTitlepage.getElement());
        this.printAll.getElement().setChecked(true);
        this.printAll.getElement().setEffectedRadioButtons(l);
        this.printTitlepageOnly.getElement().setEffectedRadioButtons(l);
        this.printWithoutTitlepage.getElement().setEffectedRadioButtons(l);
        this.printProducesText = new TitledItem<CheckBox>(new CheckBox(), Words.PRINT_PRODUCES_TEXT, TitledItem.TitledItemOrientation.EAST);
        this.printProducesText.getTitle().setForeground(fb);
        this.printProducesText.getElement().setChecked(true);
        this.printIngredientListInfo = new TitledItem<CheckBox>(new CheckBox(), Words.PRINT_INGREDIENT_LIST_INFO, TitledItem.TitledItemOrientation.EAST);
        this.printIngredientListInfo.getTitle().setForeground(fb);
        this.printIngredientListInfo.getElement().setChecked(true);
        this.infoLabel = new MultiLineTextLabel("<html>* Be aware of<ul><li>Articles and Products marked as 'always on Delivery Sheet' are shown anyway</li><li>Articles show their Label Name, if none is defined, Article's Name is shown</li></ul></html>");
        this.add(this.includeArticles);
        this.add(this.includeHandlings);
        this.add(this.includeStandard);
        this.add(this.includePaxUpdate);
        this.add(this.includeDrawersCount);
        this.add(this.includeTemperature);
        this.add(this.includePaxUpdate);
        this.add(this.includeSeals);
        this.add(this.includeAIS);
        this.add(this.excludeZeroPax);
        this.add(this.includeCrewPaxes);
        this.add(this.summarizeCrew);
        this.add(this.infoLabel);
        this.add(this.includeNullValues);
        this.add(this.groupAdditionals);
        this.add(this.showAdditionalsSeparately);
        this.add(this.showSpecialMealsSeparately);
        this.add(this.sortProductsByNumber);
        this.add(this.printProducesText);
        this.add(this.printIngredientListInfo);
        if (this.hideFlightFromToNSDS != null) {
            this.add(this.hideFlightFromToNSDS);
        }
        if (this.showSobState) {
            this.add(this.showAllProducts);
            this.add(this.showSobProductsOnly);
            this.add(this.showNoSobProductsOnly);
        }
        this.add(this.printAll);
        this.add(this.printTitlepageOnly);
        this.add(this.printWithoutTitlepage);
        if (this.finalizeFlight != null) {
            this.add(this.finalizeFlight);
        }
        this.setLayout(new Layout());
    }

    @Override
    public void setEnabled(boolean isEnabled) {
        super.setEnabled(isEnabled);
        if (this.quantityBased != null) {
            this.quantityBased.setEnabled(isEnabled);
        }
        if (this.cashBased != null) {
            this.cashBased.setEnabled(isEnabled);
        }
        this.useCATITNo.setEnabled(isEnabled);
        this.useCustomerNo.setEnabled(isEnabled);
        this.useProductLabelName.setEnabled(isEnabled);
        this.useAISName.setEnabled(isEnabled);
        this.useProductName.setEnabled(isEnabled);
        if (this.sortProductsByNumber != null) {
            this.sortProductsByNumber.setEnabled(isEnabled);
        }
        if (this.finalizeFlight != null) {
            this.finalizeFlight.setEnabled(isEnabled);
        }
        this.includeArticles.setEnabled(isEnabled);
        this.includeHandlings.setEnabled(isEnabled);
        this.includeStandard.setEnabled(isEnabled);
        this.includePaxUpdate.setEnabled(isEnabled);
        this.includeDrawersCount.setEnabled(isEnabled);
        this.includeTemperature.setEnabled(isEnabled);
        this.includeSeals.setEnabled(isEnabled);
        this.includeAIS.setEnabled(isEnabled);
        this.groupAdditionals.setEnabled(isEnabled);
        this.showAdditionalsSeparately.setEnabled(isEnabled);
        this.showSpecialMealsSeparately.setEnabled(isEnabled);
        this.excludeZeroPax.setEnabled(isEnabled);
        this.includeCrewPaxes.setEnabled(isEnabled);
        this.summarizeCrew.setEnabled(isEnabled && this.includeCrewPaxes.getElement().isChecked());
        this.includeNullValues.setEnabled(isEnabled);
        if (this.hideFlightFromToNSDS != null) {
            this.hideFlightFromToNSDS.setEnabled(isEnabled);
        }
        if (this.showSobState) {
            this.showAllProducts.setEnabled(isEnabled);
            this.showSobProductsOnly.setEnabled(isEnabled);
            this.showNoSobProductsOnly.setEnabled(isEnabled);
        }
        this.printAll.setEnabled(isEnabled);
        this.printTitlepageOnly.setEnabled(isEnabled);
        this.printWithoutTitlepage.setEnabled(isEnabled);
        this.printProducesText.setEnabled(isEnabled);
        this.printIngredientListInfo.setEnabled(isEnabled);
    }

    @Override
    public void buttonPressed(Button source, int x, int y) {
        this.setEnabled(this.isEnabled());
    }

    @Override
    public List<Component> getFocusComponents() {
        ArrayList<Component> a = new ArrayList<Component>();
        CheckedListAdder.addToList(a, this.printAll);
        CheckedListAdder.addToList(a, this.printTitlepageOnly);
        CheckedListAdder.addToList(a, this.printWithoutTitlepage);
        CheckedListAdder.addToList(a, this.quantityBased);
        if (this.cashBased != null) {
            CheckedListAdder.addToList(a, this.cashBased);
        }
        CheckedListAdder.addToList(a, this.useCATITNo);
        CheckedListAdder.addToList(a, this.useCustomerNo);
        CheckedListAdder.addToList(a, this.sortProductsByNumber);
        CheckedListAdder.addToList(a, this.finalizeFlight);
        CheckedListAdder.addToList(a, this.useProductLabelName);
        CheckedListAdder.addToList(a, this.useAISName);
        CheckedListAdder.addToList(a, this.useProductName);
        CheckedListAdder.addToList(a, this.includeStandard);
        CheckedListAdder.addToList(a, this.includeHandlings);
        CheckedListAdder.addToList(a, this.includeArticles);
        CheckedListAdder.addToList(a, this.includeNullValues);
        CheckedListAdder.addToList(a, this.includePaxUpdate);
        CheckedListAdder.addToList(a, this.includeDrawersCount);
        CheckedListAdder.addToList(a, this.includeTemperature);
        CheckedListAdder.addToList(a, this.includeSeals);
        CheckedListAdder.addToList(a, this.includeAIS);
        CheckedListAdder.addToList(a, this.groupAdditionals);
        CheckedListAdder.addToList(a, this.printProducesText);
        CheckedListAdder.addToList(a, this.printIngredientListInfo);
        CheckedListAdder.addToList(a, this.showAdditionalsSeparately);
        CheckedListAdder.addToList(a, this.showSpecialMealsSeparately);
        CheckedListAdder.addToList(a, this.excludeZeroPax);
        CheckedListAdder.addToList(a, this.includeCrewPaxes);
        CheckedListAdder.addToList(a, this.summarizeCrew);
        CheckedListAdder.addToList(a, this.hideFlightFromToNSDS);
        CheckedListAdder.addToList(a, this.showAllProducts);
        CheckedListAdder.addToList(a, this.showSobProductsOnly);
        CheckedListAdder.addToList(a, this.showNoSobProductsOnly);
        CheckedListAdder.addToList(a, this.printAll);
        CheckedListAdder.addToList(a, this.printTitlepageOnly);
        CheckedListAdder.addToList(a, this.printWithoutTitlepage);
        CheckedListAdder.addToList(a, this.printProducesText);
        CheckedListAdder.addToList(a, this.printIngredientListInfo);
        return a;
    }

    @Override
    public void setVisibleContainer(VisibleContainer pane) {
    }

    @Override
    public Selectable getSelectDelegationComponent() {
        return null;
    }

    @Override
    public void requestFocusInWindowNow() {
    }

    @Override
    public void kill() {
        if (this.isKilled()) {
            return;
        }
        super.kill();
        if (this.finalizeFlight != null) {
            this.finalizeFlight.kill();
        }
        if (this.includeStandard != null) {
            this.includeStandard.kill();
        }
        if (this.includeArticles != null) {
            this.includeArticles.kill();
        }
        if (this.includeTemperature != null) {
            this.includeTemperature.kill();
        }
        if (this.includeSeals != null) {
            this.includeSeals.kill();
        }
        if (this.sortProductsByNumber != null) {
            this.sortProductsByNumber.kill();
        }
        if (this.includeAIS != null) {
            this.includeAIS.kill();
        }
        if (this.infoLabel != null) {
            this.infoLabel.kill();
        }
        this.infoLabel = null;
        if (this.showAllProducts != null) {
            this.showAllProducts.kill();
        }
        this.showAllProducts = null;
        if (this.showSobProductsOnly != null) {
            this.showSobProductsOnly.kill();
        }
        this.showSobProductsOnly = null;
        if (this.showNoSobProductsOnly != null) {
            this.showNoSobProductsOnly.kill();
        }
        this.showNoSobProductsOnly = null;
        if (this.includeHandlings != null) {
            this.includeHandlings.kill();
        }
        if (this.includePaxUpdate != null) {
            this.includePaxUpdate.kill();
        }
        this.includePaxUpdate = null;
        this.includeHandlings = null;
        if (this.cashBased != null) {
            this.cashBased.kill();
        }
        if (this.quantityBased != null) {
            this.quantityBased.kill();
        }
        if (this.includePaxUpdate != null) {
            this.includePaxUpdate.kill();
        }
        if (this.includeDrawersCount != null) {
            this.includeDrawersCount.kill();
        }
        if (this.useCATITNo != null) {
            this.useCATITNo.kill();
        }
        this.useCATITNo = null;
        if (this.useCustomerNo != null) {
            this.useCustomerNo.kill();
        }
        this.useCustomerNo = null;
        if (this.useAISName != null) {
            this.useAISName.kill();
        }
        this.useAISName = null;
        if (this.useProductLabelName != null) {
            this.useProductLabelName.kill();
        }
        this.useProductLabelName = null;
        if (this.useProductName != null) {
            this.useProductName.kill();
        }
        this.useProductName = null;
        if (this.excludeZeroPax != null) {
            this.excludeZeroPax.kill();
        }
        this.excludeZeroPax = null;
        if (this.includeCrewPaxes != null) {
            this.includeCrewPaxes.kill();
        }
        this.includeCrewPaxes = null;
        if (this.includeNullValues != null) {
            this.includeNullValues.kill();
        }
        this.includeNullValues = null;
        if (this.summarizeCrew != null) {
            this.summarizeCrew.kill();
        }
        this.summarizeCrew = null;
        if (this.groupAdditionals != null) {
            this.groupAdditionals.kill();
        }
        this.groupAdditionals = null;
        if (this.showAdditionalsSeparately != null) {
            this.showAdditionalsSeparately.kill();
        }
        this.showAdditionalsSeparately = null;
        if (this.showSpecialMealsSeparately != null) {
            this.showSpecialMealsSeparately.kill();
        }
        this.showSpecialMealsSeparately = null;
        if (this.hideFlightFromToNSDS != null) {
            this.hideFlightFromToNSDS.kill();
        }
        this.hideFlightFromToNSDS = null;
        if (this.printProducesText != null) {
            this.printProducesText.kill();
        }
        this.printProducesText = null;
        if (this.printIngredientListInfo != null) {
            this.printIngredientListInfo.kill();
        }
        this.printIngredientListInfo = null;
        this.finalizeFlight = null;
        this.includePaxUpdate = null;
        this.includeDrawersCount = null;
        this.includeSeals = null;
        this.cashBased = null;
        this.includeStandard = null;
        this.includeArticles = null;
        this.quantityBased = null;
        this.includeAIS = null;
        this.sortProductsByNumber = null;
        if (this.printAll != null) {
            this.printAll.kill();
        }
        if (this.printTitlepageOnly != null) {
            this.printTitlepageOnly.kill();
        }
        if (this.printWithoutTitlepage != null) {
            this.printWithoutTitlepage.kill();
        }
    }

    @Override
    public String getPersistString() {
        return null;
    }

    @Override
    public void loadState(String state, String id) {
    }

    @Override
    public String getID() {
        return null;
    }

    @Override
    public boolean shouldPersist() {
        return false;
    }

    @Override
    public void setShouldPersist(boolean isPersisting) {
    }

    public List<ScreenValidationObject> validateBeforePrint() {
        ArrayList<ScreenValidationObject> l = new ArrayList<ScreenValidationObject>();
        return l;
    }

    public void fillReportConfiguration(FlightAnalysisDeliverySlipsConfiguration config) {
        config.setUseLabelNames(Boolean.valueOf(true));
        if (this.cashBased != null) {
            config.setCashDeliverySlip(Boolean.valueOf(this.cashBased.getElement().isChecked()));
        } else {
            config.setCashDeliverySlip(Boolean.valueOf(false));
        }
        config.setIncludeNullValues(Boolean.valueOf(this.includeNullValues.getElement().isChecked()));
        config.setIncludeArticles(Boolean.valueOf(this.includeArticles.getElement().isChecked()));
        config.setIncludeDrawers(Boolean.valueOf(this.includeDrawersCount.getElement().isChecked()));
        config.setIncludeTemperature(Boolean.valueOf(this.includeTemperature.getElement().isChecked()));
        config.setIncludeSeals(Boolean.valueOf(this.includeSeals.getElement().isChecked()));
        config.setIncludeAIS(Boolean.valueOf(this.includeAIS.getElement().isChecked()));
        config.setIncludeHandlings(Boolean.valueOf(this.includeHandlings.getElement().isChecked()));
        config.setIncludeStandard(Boolean.valueOf(this.includeStandard.getElement().isChecked()));
        config.setUseCATITProductNo(Boolean.valueOf(this.useCATITNo.getElement().isChecked()));
        config.setIncludeCrewClasses(Boolean.valueOf(this.includeCrewPaxes.getElement().isChecked()));
        config.setSummarizeCrew(Boolean.valueOf(this.summarizeCrew.getElement().isChecked()));
        config.setGroupAdditionals(Boolean.valueOf(this.groupAdditionals.getElement().isChecked()));
        config.setIncludePaxUpdateField(Boolean.valueOf(this.includePaxUpdate.getElement().isChecked()));
        config.setShowAdditionalSeparately(Boolean.valueOf(this.showAdditionalsSeparately.getElement().isChecked()));
        config.setShowSpecialMealSeparately(Boolean.valueOf(this.showSpecialMealsSeparately.getElement().isChecked()));
        config.setExcludeZeroPax(Boolean.valueOf(this.excludeZeroPax.getElement().isChecked()));
        config.setUseLabelNames(Boolean.valueOf(this.useProductLabelName.getElement().isChecked()));
        config.setSortByNumber(Boolean.valueOf(this.sortProductsByNumber.getElement().isChecked()));
        config.setUseName(Boolean.valueOf(this.useProductName.getElement().isChecked()));
        config.setPrintProducesText(Boolean.valueOf(this.printProducesText.getElement().isChecked()));
        config.setPrintIngredientListInfo(Boolean.valueOf(this.printIngredientListInfo.getElement().isChecked()));
        if (this.hideFlightFromToNSDS != null) {
            config.setHideFlightFromToNSDS(Boolean.valueOf(this.hideFlightFromToNSDS.getElement().isChecked()));
        }
        if (this.showSobState) {
            if (this.showAllProducts.getElement().isChecked()) {
                config.setSobState(SalesOnBoardReportStateE.ALL);
            } else if (this.showSobProductsOnly.getElement().isChecked()) {
                config.setSobState(SalesOnBoardReportStateE.ONLY_SOB_PRODUCTS);
            } else if (this.showNoSobProductsOnly.getElement().isChecked()) {
                config.setSobState(SalesOnBoardReportStateE.NO_SOB_PRODUCTS);
            }
        } else {
            config.setSobState(SalesOnBoardReportStateE.ALL);
        }
        if (this.printAll.getElement().isChecked()) {
            config.setPrintTitlepage(Boolean.valueOf(true));
            config.setPrintBody(Boolean.valueOf(true));
        } else if (this.printTitlepageOnly.getElement().isChecked()) {
            config.setPrintTitlepage(Boolean.valueOf(true));
            config.setPrintBody(Boolean.valueOf(false));
        } else if (this.printWithoutTitlepage.getElement().isChecked()) {
            config.setPrintTitlepage(Boolean.valueOf(false));
            config.setPrintBody(Boolean.valueOf(true));
        }
        if (this.finalizeFlight != null) {
            config.setFinalizeFlight(Boolean.valueOf(this.finalizeFlight.getElement().isChecked()));
        }
        config.setPrintProducesText(Boolean.valueOf(this.printProducesText.getElement().isChecked()));
        config.setPrintIngredientListInfo(Boolean.valueOf(this.printIngredientListInfo.getElement().isChecked()));
    }

    @Override
    public void updateConfiguration(FilterChainConfiguration conf) {
        this.conf = conf;
        for (String[] s : conf.getProperties()) {
            String n = s[0];
            String v = s[1];
            Boolean b = false;
            try {
                b = Boolean.valueOf(v);
            }
            catch (Exception exception) {
                // empty catch block
            }
            switch (n) {
                case "cash": {
                    if (this.cashBased != null) {
                        this.cashBased.getElement().setChecked(b);
                    }
                    if (this.quantityBased == null) break;
                    this.quantityBased.getElement().setChecked(b == false);
                    break;
                }
                case "standard": {
                    this.includeStandard.getElement().setChecked(b);
                    break;
                }
                case "overview": {
                    this.includeArticles.getElement().setChecked(b);
                    break;
                }
                case "handlings": {
                    this.includeHandlings.getElement().setChecked(b);
                    break;
                }
                case "drawer": {
                    this.includeDrawersCount.getElement().setChecked(b);
                    break;
                }
                case "temperature": {
                    this.includeTemperature.getElement().setChecked(b);
                    break;
                }
                case "seals": {
                    this.includeSeals.getElement().setChecked(b);
                    break;
                }
                case "sign_ais": {
                    this.includeAIS.getElement().setChecked(b);
                    break;
                }
                case "crewpax": {
                    this.includeCrewPaxes.getElement().setChecked(b);
                    break;
                }
                case "number": {
                    this.useCATITNo.getElement().setChecked(b);
                    this.useCustomerNo.getElement().setChecked(b == false);
                    break;
                }
                case "ais": {
                    this.useAISName.getElement().setChecked(b);
                    this.useProductLabelName.getElement().setChecked(b == false);
                    this.useProductName.getElement().setChecked(b == false);
                    break;
                }
                case "productName": {
                    this.useAISName.getElement().setChecked(b == false);
                    this.useProductLabelName.getElement().setChecked(b);
                    this.useProductName.getElement().setChecked(b == false);
                    break;
                }
                case "useproductname": {
                    this.useAISName.getElement().setChecked(b == false);
                    this.useProductLabelName.getElement().setChecked(b == false);
                    this.useProductName.getElement().setChecked(b);
                    break;
                }
                case "include_null": {
                    this.includeNullValues.getElement().setChecked(b);
                    break;
                }
                case "summarize_crew": {
                    this.summarizeCrew.getElement().setChecked(b);
                    break;
                }
                case "hide_ns_ds_flights": {
                    if (this.hideFlightFromToNSDS == null) break;
                    this.hideFlightFromToNSDS.getElement().setChecked(b);
                    break;
                }
                case "groupAdditional": {
                    if (this.groupAdditionals == null) break;
                    this.groupAdditionals.getElement().setChecked(b);
                    break;
                }
                case "excludeZeroPax": {
                    if (this.excludeZeroPax == null) break;
                    this.excludeZeroPax.getElement().setChecked(b);
                    break;
                }
                case "showAdditionalSeparately": {
                    if (this.showAdditionalsSeparately == null) break;
                    this.showAdditionalsSeparately.getElement().setChecked(b);
                    break;
                }
                case "showSPMLsSeparately": {
                    if (this.showSpecialMealsSeparately == null) break;
                    this.showSpecialMealsSeparately.getElement().setChecked(b);
                    break;
                }
                case "showAllProducts": {
                    if (this.showAllProducts == null) break;
                    this.showAllProducts.getElement().setChecked(b);
                    break;
                }
                case "showSobOnly": {
                    if (this.showSobProductsOnly == null) break;
                    this.showSobProductsOnly.getElement().setChecked(b);
                    break;
                }
                case "showNonSobOnly": {
                    if (this.showNoSobProductsOnly == null) break;
                    this.showNoSobProductsOnly.getElement().setChecked(b);
                    break;
                }
                case "printAll": {
                    if (this.printAll == null) break;
                    this.printAll.getElement().setChecked(b);
                    break;
                }
                case "printTitlePageOnly": {
                    if (this.printTitlepageOnly == null) break;
                    this.printTitlepageOnly.getElement().setChecked(b);
                    break;
                }
                case "printWithoutTitlePage": {
                    if (this.printWithoutTitlepage == null) break;
                    this.printWithoutTitlepage.getElement().setChecked(b);
                    break;
                }
                case "finalizeFlight": {
                    if (this.finalizeFlight == null) break;
                    this.finalizeFlight.getElement().setChecked(b);
                    break;
                }
                case "sortByNumber": {
                    if (this.sortProductsByNumber == null) break;
                    this.sortProductsByNumber.getElement().setChecked(b);
                    break;
                }
                case "includePaxUpdate": {
                    if (this.includePaxUpdate == null) break;
                    this.includePaxUpdate.getElement().setChecked(b);
                    break;
                }
                case "printProducesText": {
                    this.printProducesText.getElement().setChecked(b);
                    break;
                }
                case "printIngredientListInfo": {
                    this.printIngredientListInfo.getElement().setChecked(b);
                }
            }
        }
        this.setEnabled(this.isEnabled());
    }

    @Override
    public FilterChainConfiguration createFilterChainConfig() {
        FilterChainConfiguration conf = new FilterChainConfiguration();
        if (this.quantityBased != null) {
            conf.addProperty(CASH_CONFIG_NAME, "" + !this.quantityBased.getElement().isChecked());
        }
        conf.addProperty(AIS_NAME, "" + this.useAISName.getElement().isChecked());
        conf.addProperty(NUMBER_CONFIG_NAME, "" + this.useCATITNo.getElement().isChecked());
        conf.addProperty(STANDARD_CONFIG_NAME, "" + this.includeStandard.getElement().isChecked());
        conf.addProperty(ARTICLES_CONFIG_NAME, "" + this.includeArticles.getElement().isChecked());
        conf.addProperty(HANDLING_CONFIG_NAME, "" + this.includeHandlings.getElement().isChecked());
        conf.addProperty(DRAWER_CONFIG_NAME, "" + this.includeDrawersCount.getElement().isChecked());
        conf.addProperty(TEMPERATURE_CONFIG_NAME, "" + this.includeTemperature.getElement().isChecked());
        conf.addProperty(SEALS_CONFIG_NAME, "" + this.includeSeals.getElement().isChecked());
        conf.addProperty(AIS_CONFIG, "" + this.includeAIS.getElement().isChecked());
        conf.addProperty(CREW_PAX_CONFIG_NAME, "" + this.includeCrewPaxes.getElement().isChecked());
        conf.addProperty(INCLUDE_NULL_CONFIG_NAME, "" + this.includeNullValues.getElement().isChecked());
        conf.addProperty(SUMMARIZE_CREW, "" + this.summarizeCrew.getElement().isChecked());
        conf.addProperty(GROUP_ADDITIONALS, "" + this.groupAdditionals.getElement().isChecked());
        conf.addProperty(EXCLUDE_ZERO_PAX_, "" + this.excludeZeroPax.getElement().isChecked());
        conf.addProperty(SHOW_ADDITIONALS_SEPARATELY, "" + this.showAdditionalsSeparately.getElement().isChecked());
        conf.addProperty(SHOW_SPMLS_SEPARATELY, "" + this.showSpecialMealsSeparately.getElement().isChecked());
        conf.addProperty(SHOW_ALL_PRODUCTS, "" + this.showAllProducts.getElement().isChecked());
        conf.addProperty(SHOW_SOB_ONLY, "" + this.showSobProductsOnly.getElement().isChecked());
        conf.addProperty(SHOW_NON_SOB_ONLY, "" + this.showNoSobProductsOnly.getElement().isChecked());
        conf.addProperty(PRINT_ALL, "" + this.printAll.getElement().isChecked());
        conf.addProperty(PRINT_TITLEPAGE_ONLY, "" + this.printTitlepageOnly.getElement().isChecked());
        conf.addProperty(PRINT_WITHOUT_TITLEPAGE, "" + this.printWithoutTitlepage.getElement().isChecked());
        if (this.finalizeFlight != null) {
            conf.addProperty(FINALIZE_FLIGHT, "" + this.finalizeFlight.getElement().isChecked());
        }
        if (this.hideFlightFromToNSDS != null) {
            conf.addProperty(HIDE_NS_DS_FLIGHTS, "" + this.hideFlightFromToNSDS.getElement().isChecked());
        }
        conf.addProperty("sortByNumber", "" + this.sortProductsByNumber.getElement().isChecked());
        conf.addProperty("includePaxUpdate", "" + this.includePaxUpdate.getElement().isChecked());
        conf.addProperty(PRINT_PRODUCES_TEXT_TYPE, "" + this.printProducesText.getElement().isChecked());
        conf.addProperty(PRINT_INGREDIENT_LIST_INFO_TYPE, "" + this.printIngredientListInfo.getElement().isChecked());
        this.conf = conf;
        return conf;
    }

    private class Layout
    extends DefaultLayout {
        private Layout() {
        }

        @Override
        public void layoutContainer(Container parent) {
            int y = 0;
            if (DeliverySlipConfigPanel.this.printAll != null) {
                DeliverySlipConfigPanel.this.printAll.setLocation(DeliverySlipConfigPanel.this.border, y);
                DeliverySlipConfigPanel.this.printAll.setSize(parent.getWidth() - (DeliverySlipConfigPanel.this.printAll.getX() + DeliverySlipConfigPanel.this.border), (int)DeliverySlipConfigPanel.this.printAll.getPreferredSize().getHeight());
                y = DeliverySlipConfigPanel.this.printAll.getY() + DeliverySlipConfigPanel.this.printAll.getHeight() + DeliverySlipConfigPanel.this.border / 4;
                DeliverySlipConfigPanel.this.printTitlepageOnly.setLocation(DeliverySlipConfigPanel.this.border, y);
                DeliverySlipConfigPanel.this.printTitlepageOnly.setSize(parent.getWidth() - (DeliverySlipConfigPanel.this.printTitlepageOnly.getX() + DeliverySlipConfigPanel.this.border), (int)DeliverySlipConfigPanel.this.printTitlepageOnly.getPreferredSize().getHeight());
                y = DeliverySlipConfigPanel.this.printTitlepageOnly.getY() + DeliverySlipConfigPanel.this.printTitlepageOnly.getHeight() + DeliverySlipConfigPanel.this.border / 4;
                DeliverySlipConfigPanel.this.printWithoutTitlepage.setLocation(DeliverySlipConfigPanel.this.border, y);
                DeliverySlipConfigPanel.this.printWithoutTitlepage.setSize(parent.getWidth() - (DeliverySlipConfigPanel.this.printWithoutTitlepage.getX() + DeliverySlipConfigPanel.this.border), (int)DeliverySlipConfigPanel.this.printWithoutTitlepage.getPreferredSize().getHeight());
                y = DeliverySlipConfigPanel.this.printWithoutTitlepage.getY() + DeliverySlipConfigPanel.this.printWithoutTitlepage.getHeight() + DeliverySlipConfigPanel.this.border / 4;
            }
            y += DeliverySlipConfigPanel.this.border;
            if (DeliverySlipConfigPanel.this.quantityBased != null) {
                DeliverySlipConfigPanel.this.quantityBased.setLocation(DeliverySlipConfigPanel.this.border, y);
                DeliverySlipConfigPanel.this.quantityBased.setSize(parent.getWidth() - 2 * DeliverySlipConfigPanel.this.border, (int)DeliverySlipConfigPanel.this.quantityBased.getPreferredSize().getHeight());
                y = DeliverySlipConfigPanel.this.quantityBased.getY() + DeliverySlipConfigPanel.this.quantityBased.getHeight();
            }
            if (DeliverySlipConfigPanel.this.cashBased != null) {
                DeliverySlipConfigPanel.this.cashBased.setLocation(DeliverySlipConfigPanel.this.border, y += DeliverySlipConfigPanel.this.border / 4);
                DeliverySlipConfigPanel.this.cashBased.setSize(parent.getWidth() - 2 * DeliverySlipConfigPanel.this.border, (int)DeliverySlipConfigPanel.this.cashBased.getPreferredSize().getHeight());
                y = DeliverySlipConfigPanel.this.cashBased.getY() + DeliverySlipConfigPanel.this.cashBased.getHeight();
            }
            y += DeliverySlipConfigPanel.this.border;
            if (DeliverySlipConfigPanel.this.sortProductsByNumber != null) {
                DeliverySlipConfigPanel.this.sortProductsByNumber.setLocation(DeliverySlipConfigPanel.this.border, y);
                DeliverySlipConfigPanel.this.sortProductsByNumber.setSize(parent.getWidth() - 2 * DeliverySlipConfigPanel.this.border, (int)DeliverySlipConfigPanel.this.sortProductsByNumber.getPreferredSize().getHeight());
                y = DeliverySlipConfigPanel.this.sortProductsByNumber.getY() + DeliverySlipConfigPanel.this.sortProductsByNumber.getHeight() + DeliverySlipConfigPanel.this.border;
            }
            if (DeliverySlipConfigPanel.this.finalizeFlight != null) {
                DeliverySlipConfigPanel.this.finalizeFlight.setLocation(DeliverySlipConfigPanel.this.border, y);
                DeliverySlipConfigPanel.this.finalizeFlight.setSize(parent.getWidth() - 2 * DeliverySlipConfigPanel.this.border, (int)DeliverySlipConfigPanel.this.finalizeFlight.getPreferredSize().getHeight());
                y = DeliverySlipConfigPanel.this.finalizeFlight.getY() + DeliverySlipConfigPanel.this.finalizeFlight.getHeight() + DeliverySlipConfigPanel.this.border;
            }
            if (DeliverySlipConfigPanel.this.useCATITNo != null && DeliverySlipConfigPanel.this.useCustomerNo != null) {
                DeliverySlipConfigPanel.this.useCATITNo.setLocation(DeliverySlipConfigPanel.this.border, y);
                DeliverySlipConfigPanel.this.useCATITNo.setSize(parent.getWidth() - 2 * DeliverySlipConfigPanel.this.border, (int)DeliverySlipConfigPanel.this.useCATITNo.getPreferredSize().getHeight());
                y = DeliverySlipConfigPanel.this.useCATITNo.getY() + DeliverySlipConfigPanel.this.useCATITNo.getHeight() + DeliverySlipConfigPanel.this.border / 4;
                DeliverySlipConfigPanel.this.useCustomerNo.setLocation(DeliverySlipConfigPanel.this.border, y);
                DeliverySlipConfigPanel.this.useCustomerNo.setSize(parent.getWidth() - 2 * DeliverySlipConfigPanel.this.border, (int)DeliverySlipConfigPanel.this.useCustomerNo.getPreferredSize().getHeight());
                y = DeliverySlipConfigPanel.this.useCustomerNo.getY() + DeliverySlipConfigPanel.this.useCustomerNo.getHeight() + DeliverySlipConfigPanel.this.border;
            }
            if (DeliverySlipConfigPanel.this.useAISName != null && DeliverySlipConfigPanel.this.useProductLabelName != null && DeliverySlipConfigPanel.this.useProductName != null) {
                DeliverySlipConfigPanel.this.useProductLabelName.setLocation(DeliverySlipConfigPanel.this.border, y);
                DeliverySlipConfigPanel.this.useProductLabelName.setSize(parent.getWidth() - 2 * DeliverySlipConfigPanel.this.border, (int)DeliverySlipConfigPanel.this.useProductLabelName.getPreferredSize().getHeight());
                y = DeliverySlipConfigPanel.this.useProductLabelName.getY() + DeliverySlipConfigPanel.this.useProductLabelName.getHeight() + DeliverySlipConfigPanel.this.border / 4;
                DeliverySlipConfigPanel.this.useAISName.setLocation(DeliverySlipConfigPanel.this.border, y);
                DeliverySlipConfigPanel.this.useAISName.setSize(parent.getWidth() - 2 * DeliverySlipConfigPanel.this.border, (int)DeliverySlipConfigPanel.this.useAISName.getPreferredSize().getHeight());
                y = DeliverySlipConfigPanel.this.useAISName.getY() + DeliverySlipConfigPanel.this.useAISName.getHeight() + DeliverySlipConfigPanel.this.border / 4;
                DeliverySlipConfigPanel.this.useProductName.setLocation(DeliverySlipConfigPanel.this.border, y);
                DeliverySlipConfigPanel.this.useProductName.setSize(parent.getWidth() - 2 * DeliverySlipConfigPanel.this.border, (int)DeliverySlipConfigPanel.this.useProductName.getPreferredSize().getHeight());
                y = DeliverySlipConfigPanel.this.useProductName.getY() + DeliverySlipConfigPanel.this.useProductName.getHeight() + DeliverySlipConfigPanel.this.border;
            }
            if (DeliverySlipConfigPanel.this.includeStandard != null) {
                DeliverySlipConfigPanel.this.includeStandard.setLocation(DeliverySlipConfigPanel.this.border, y);
                DeliverySlipConfigPanel.this.includeStandard.setSize(parent.getWidth() - 2 * DeliverySlipConfigPanel.this.border, (int)DeliverySlipConfigPanel.this.includeStandard.getPreferredSize().getHeight());
                y = DeliverySlipConfigPanel.this.includeStandard.getY() + DeliverySlipConfigPanel.this.includeStandard.getHeight() + DeliverySlipConfigPanel.this.border / 4;
            }
            if (DeliverySlipConfigPanel.this.includeHandlings != null) {
                DeliverySlipConfigPanel.this.includeHandlings.setLocation(DeliverySlipConfigPanel.this.border, y);
                DeliverySlipConfigPanel.this.includeHandlings.setSize(parent.getWidth() - 2 * DeliverySlipConfigPanel.this.border, (int)DeliverySlipConfigPanel.this.includeHandlings.getPreferredSize().getHeight());
                y = DeliverySlipConfigPanel.this.includeHandlings.getY() + DeliverySlipConfigPanel.this.includeHandlings.getHeight() + DeliverySlipConfigPanel.this.border / 4;
            }
            if (DeliverySlipConfigPanel.this.includeArticles != null) {
                DeliverySlipConfigPanel.this.includeArticles.setLocation(DeliverySlipConfigPanel.this.border, y);
                DeliverySlipConfigPanel.this.includeArticles.setSize(parent.getWidth() - 2 * DeliverySlipConfigPanel.this.border, (int)DeliverySlipConfigPanel.this.includeArticles.getPreferredSize().getHeight());
                y = DeliverySlipConfigPanel.this.includeArticles.getY() + DeliverySlipConfigPanel.this.includeArticles.getHeight() + DeliverySlipConfigPanel.this.border / 4;
            }
            if (DeliverySlipConfigPanel.this.includeNullValues != null) {
                DeliverySlipConfigPanel.this.includeNullValues.setLocation(DeliverySlipConfigPanel.this.border, y);
                DeliverySlipConfigPanel.this.includeNullValues.setSize(parent.getWidth() - 2 * DeliverySlipConfigPanel.this.border, (int)DeliverySlipConfigPanel.this.includeNullValues.getPreferredSize().getHeight());
                y = DeliverySlipConfigPanel.this.includeNullValues.getY() + DeliverySlipConfigPanel.this.includeNullValues.getHeight() + DeliverySlipConfigPanel.this.border;
            }
            if (DeliverySlipConfigPanel.this.includePaxUpdate != null) {
                DeliverySlipConfigPanel.this.includePaxUpdate.setLocation(DeliverySlipConfigPanel.this.border, y);
                DeliverySlipConfigPanel.this.includePaxUpdate.setSize(parent.getWidth() - 2 * DeliverySlipConfigPanel.this.border, (int)DeliverySlipConfigPanel.this.includePaxUpdate.getPreferredSize().getHeight());
                y = DeliverySlipConfigPanel.this.includePaxUpdate.getY() + DeliverySlipConfigPanel.this.includePaxUpdate.getHeight() + DeliverySlipConfigPanel.this.border / 4;
            }
            if (DeliverySlipConfigPanel.this.includeDrawersCount != null) {
                DeliverySlipConfigPanel.this.includeDrawersCount.setLocation(DeliverySlipConfigPanel.this.border, y);
                DeliverySlipConfigPanel.this.includeDrawersCount.setSize(parent.getWidth() - 2 * DeliverySlipConfigPanel.this.border, (int)DeliverySlipConfigPanel.this.includeDrawersCount.getPreferredSize().getHeight());
                y = DeliverySlipConfigPanel.this.includeDrawersCount.getY() + DeliverySlipConfigPanel.this.includeDrawersCount.getHeight() + DeliverySlipConfigPanel.this.border / 4;
            }
            if (DeliverySlipConfigPanel.this.includeTemperature != null) {
                DeliverySlipConfigPanel.this.includeTemperature.setLocation(DeliverySlipConfigPanel.this.border, y);
                DeliverySlipConfigPanel.this.includeTemperature.setSize(parent.getWidth() - 2 * DeliverySlipConfigPanel.this.border, (int)DeliverySlipConfigPanel.this.includeTemperature.getPreferredSize().getHeight());
                y = DeliverySlipConfigPanel.this.includeTemperature.getY() + DeliverySlipConfigPanel.this.includeTemperature.getHeight() + DeliverySlipConfigPanel.this.border / 4;
            }
            if (DeliverySlipConfigPanel.this.includeSeals != null) {
                DeliverySlipConfigPanel.this.includeSeals.setLocation(DeliverySlipConfigPanel.this.border, y);
                DeliverySlipConfigPanel.this.includeSeals.setSize(parent.getWidth() - 2 * DeliverySlipConfigPanel.this.border, (int)DeliverySlipConfigPanel.this.includeSeals.getPreferredSize().getHeight());
                y = DeliverySlipConfigPanel.this.includeSeals.getY() + DeliverySlipConfigPanel.this.includeSeals.getHeight() + DeliverySlipConfigPanel.this.border / 4;
            }
            if (DeliverySlipConfigPanel.this.includeAIS != null) {
                DeliverySlipConfigPanel.this.includeAIS.setLocation(DeliverySlipConfigPanel.this.border, y);
                DeliverySlipConfigPanel.this.includeAIS.setSize(parent.getWidth() - 2 * DeliverySlipConfigPanel.this.border, (int)DeliverySlipConfigPanel.this.includeAIS.getPreferredSize().getHeight());
                y = DeliverySlipConfigPanel.this.includeAIS.getY() + DeliverySlipConfigPanel.this.includeAIS.getHeight() + DeliverySlipConfigPanel.this.border;
            }
            if (DeliverySlipConfigPanel.this.groupAdditionals != null) {
                DeliverySlipConfigPanel.this.groupAdditionals.setLocation(DeliverySlipConfigPanel.this.border, y);
                DeliverySlipConfigPanel.this.groupAdditionals.setSize(parent.getWidth() - (DeliverySlipConfigPanel.this.groupAdditionals.getX() + DeliverySlipConfigPanel.this.border), (int)DeliverySlipConfigPanel.this.groupAdditionals.getPreferredSize().getHeight());
                y = DeliverySlipConfigPanel.this.groupAdditionals.getY() + DeliverySlipConfigPanel.this.groupAdditionals.getHeight() + DeliverySlipConfigPanel.this.border;
            }
            if (DeliverySlipConfigPanel.this.printProducesText != null) {
                DeliverySlipConfigPanel.this.printProducesText.setLocation(DeliverySlipConfigPanel.this.border, y);
                DeliverySlipConfigPanel.this.printProducesText.setSize(parent.getWidth() - 2 * DeliverySlipConfigPanel.this.border, (int)DeliverySlipConfigPanel.this.printProducesText.getPreferredSize().getHeight());
                y = DeliverySlipConfigPanel.this.printProducesText.getY() + DeliverySlipConfigPanel.this.printProducesText.getHeight() + DeliverySlipConfigPanel.this.border / 4;
            }
            if (DeliverySlipConfigPanel.this.printIngredientListInfo != null) {
                DeliverySlipConfigPanel.this.printIngredientListInfo.setLocation(DeliverySlipConfigPanel.this.border, y);
                DeliverySlipConfigPanel.this.printIngredientListInfo.setSize(parent.getWidth() - 2 * DeliverySlipConfigPanel.this.border, (int)DeliverySlipConfigPanel.this.printIngredientListInfo.getPreferredSize().getHeight());
                y = DeliverySlipConfigPanel.this.printIngredientListInfo.getY() + DeliverySlipConfigPanel.this.printIngredientListInfo.getHeight() + DeliverySlipConfigPanel.this.border;
            }
            if (DeliverySlipConfigPanel.this.showAdditionalsSeparately != null) {
                DeliverySlipConfigPanel.this.showAdditionalsSeparately.setLocation(DeliverySlipConfigPanel.this.border, y);
                DeliverySlipConfigPanel.this.showAdditionalsSeparately.setSize(parent.getWidth() - (DeliverySlipConfigPanel.this.showAdditionalsSeparately.getX() + DeliverySlipConfigPanel.this.border), (int)DeliverySlipConfigPanel.this.showAdditionalsSeparately.getPreferredSize().getHeight());
                y = DeliverySlipConfigPanel.this.showAdditionalsSeparately.getY() + DeliverySlipConfigPanel.this.showAdditionalsSeparately.getHeight() + DeliverySlipConfigPanel.this.border / 4;
            }
            if (DeliverySlipConfigPanel.this.showSpecialMealsSeparately != null) {
                DeliverySlipConfigPanel.this.showSpecialMealsSeparately.setLocation(DeliverySlipConfigPanel.this.border, y);
                DeliverySlipConfigPanel.this.showSpecialMealsSeparately.setSize(parent.getWidth() - (DeliverySlipConfigPanel.this.showSpecialMealsSeparately.getX() + DeliverySlipConfigPanel.this.border), (int)DeliverySlipConfigPanel.this.showSpecialMealsSeparately.getPreferredSize().getHeight());
                y = DeliverySlipConfigPanel.this.showSpecialMealsSeparately.getY() + DeliverySlipConfigPanel.this.showSpecialMealsSeparately.getHeight() + DeliverySlipConfigPanel.this.border;
            }
            if (DeliverySlipConfigPanel.this.excludeZeroPax != null) {
                DeliverySlipConfigPanel.this.excludeZeroPax.setLocation(DeliverySlipConfigPanel.this.border, y);
                DeliverySlipConfigPanel.this.excludeZeroPax.setSize(parent.getWidth() - 2 * DeliverySlipConfigPanel.this.border, (int)DeliverySlipConfigPanel.this.excludeZeroPax.getPreferredSize().getHeight());
                y = DeliverySlipConfigPanel.this.excludeZeroPax.getY() + DeliverySlipConfigPanel.this.excludeZeroPax.getHeight() + DeliverySlipConfigPanel.this.border / 4;
            }
            if (DeliverySlipConfigPanel.this.includeCrewPaxes != null) {
                DeliverySlipConfigPanel.this.includeCrewPaxes.setLocation(DeliverySlipConfigPanel.this.border, y);
                DeliverySlipConfigPanel.this.includeCrewPaxes.setSize(parent.getWidth() - 2 * DeliverySlipConfigPanel.this.border, (int)DeliverySlipConfigPanel.this.includeCrewPaxes.getPreferredSize().getHeight());
                y = DeliverySlipConfigPanel.this.includeCrewPaxes.getY() + DeliverySlipConfigPanel.this.includeCrewPaxes.getHeight() + DeliverySlipConfigPanel.this.border / 4;
            }
            if (DeliverySlipConfigPanel.this.summarizeCrew != null) {
                if (DeliverySlipConfigPanel.this.includeCrewPaxes != null) {
                    DeliverySlipConfigPanel.this.summarizeCrew.setLocation(DeliverySlipConfigPanel.this.border + DeliverySlipConfigPanel.this.includeCrewPaxes.getElement().getWidth() + DeliverySlipConfigPanel.this.includeCrewPaxes.getInnerGap(), y);
                } else {
                    DeliverySlipConfigPanel.this.summarizeCrew.setLocation(DeliverySlipConfigPanel.this.border, y);
                }
                DeliverySlipConfigPanel.this.summarizeCrew.setSize(parent.getWidth() - (DeliverySlipConfigPanel.this.summarizeCrew.getX() + DeliverySlipConfigPanel.this.border), (int)DeliverySlipConfigPanel.this.summarizeCrew.getPreferredSize().getHeight());
                y = DeliverySlipConfigPanel.this.summarizeCrew.getY() + DeliverySlipConfigPanel.this.summarizeCrew.getHeight() + DeliverySlipConfigPanel.this.border;
            }
            if (DeliverySlipConfigPanel.this.hideFlightFromToNSDS != null) {
                DeliverySlipConfigPanel.this.hideFlightFromToNSDS.setLocation(DeliverySlipConfigPanel.this.border, y);
                DeliverySlipConfigPanel.this.hideFlightFromToNSDS.setSize(parent.getWidth() - (DeliverySlipConfigPanel.this.hideFlightFromToNSDS.getX() + DeliverySlipConfigPanel.this.border), (int)DeliverySlipConfigPanel.this.hideFlightFromToNSDS.getPreferredSize().getHeight());
                y = DeliverySlipConfigPanel.this.hideFlightFromToNSDS.getY() + DeliverySlipConfigPanel.this.hideFlightFromToNSDS.getHeight() + DeliverySlipConfigPanel.this.border;
            }
            if (DeliverySlipConfigPanel.this.showSobState && DeliverySlipConfigPanel.this.showAllProducts != null) {
                DeliverySlipConfigPanel.this.showAllProducts.setLocation(DeliverySlipConfigPanel.this.border, y);
                DeliverySlipConfigPanel.this.showAllProducts.setSize(parent.getWidth() - (DeliverySlipConfigPanel.this.showAllProducts.getX() + DeliverySlipConfigPanel.this.border), (int)DeliverySlipConfigPanel.this.showAllProducts.getPreferredSize().getHeight());
                y = DeliverySlipConfigPanel.this.showAllProducts.getY() + DeliverySlipConfigPanel.this.showAllProducts.getHeight() + DeliverySlipConfigPanel.this.border / 4;
                DeliverySlipConfigPanel.this.showSobProductsOnly.setLocation(DeliverySlipConfigPanel.this.border, y);
                DeliverySlipConfigPanel.this.showSobProductsOnly.setSize(parent.getWidth() - (DeliverySlipConfigPanel.this.showSobProductsOnly.getX() + DeliverySlipConfigPanel.this.border), (int)DeliverySlipConfigPanel.this.showSobProductsOnly.getPreferredSize().getHeight());
                y = DeliverySlipConfigPanel.this.showSobProductsOnly.getY() + DeliverySlipConfigPanel.this.showSobProductsOnly.getHeight() + DeliverySlipConfigPanel.this.border / 4;
                DeliverySlipConfigPanel.this.showNoSobProductsOnly.setLocation(DeliverySlipConfigPanel.this.border, y);
                DeliverySlipConfigPanel.this.showNoSobProductsOnly.setSize(parent.getWidth() - (DeliverySlipConfigPanel.this.showNoSobProductsOnly.getX() + DeliverySlipConfigPanel.this.border), (int)DeliverySlipConfigPanel.this.showNoSobProductsOnly.getPreferredSize().getHeight());
                y = DeliverySlipConfigPanel.this.showNoSobProductsOnly.getY() + DeliverySlipConfigPanel.this.showNoSobProductsOnly.getHeight() + DeliverySlipConfigPanel.this.border / 2;
            }
            if (DeliverySlipConfigPanel.this.infoLabel != null) {
                DeliverySlipConfigPanel.this.infoLabel.setLocation(DeliverySlipConfigPanel.this.border, y);
                DeliverySlipConfigPanel.this.infoLabel.setSize(parent.getWidth() - 2 * DeliverySlipConfigPanel.this.infoLabel.getX(), (int)DeliverySlipConfigPanel.this.infoLabel.getPreferredSize().getHeight());
                y = DeliverySlipConfigPanel.this.infoLabel.getY() + DeliverySlipConfigPanel.this.infoLabel.getHeight() + DeliverySlipConfigPanel.this.border / 2;
            }
        }

        @Override
        public Dimension preferredLayoutSize(Container parent) {
            int h = 0;
            h += DeliverySlipConfigPanel.this.border;
            if (DeliverySlipConfigPanel.this.printAll != null) {
                h = (int)((double)h + (DeliverySlipConfigPanel.this.printAll.getPreferredSize().getHeight() + (double)(DeliverySlipConfigPanel.this.border / 4)));
                h = (int)((double)h + (DeliverySlipConfigPanel.this.printTitlepageOnly.getPreferredSize().getHeight() + (double)(DeliverySlipConfigPanel.this.border / 4)));
                h = (int)((double)h + (DeliverySlipConfigPanel.this.printWithoutTitlepage.getPreferredSize().getHeight() + (double)(DeliverySlipConfigPanel.this.border / 2)));
            }
            if (DeliverySlipConfigPanel.this.quantityBased != null) {
                h = (int)((double)h + DeliverySlipConfigPanel.this.quantityBased.getPreferredSize().getHeight());
            }
            if (DeliverySlipConfigPanel.this.cashBased != null) {
                h = (int)((double)h + ((double)(DeliverySlipConfigPanel.this.border / 4) + DeliverySlipConfigPanel.this.cashBased.getPreferredSize().getHeight()));
            }
            h += DeliverySlipConfigPanel.this.border;
            if (DeliverySlipConfigPanel.this.useCATITNo != null && DeliverySlipConfigPanel.this.useCustomerNo != null) {
                h = (int)((double)h + (DeliverySlipConfigPanel.this.useCATITNo.getPreferredSize().getHeight() + (double)(DeliverySlipConfigPanel.this.border / 4)));
                h = (int)((double)h + (DeliverySlipConfigPanel.this.useCustomerNo.getPreferredSize().getHeight() + (double)DeliverySlipConfigPanel.this.border));
            }
            if (DeliverySlipConfigPanel.this.useProductLabelName != null && DeliverySlipConfigPanel.this.useAISName != null && DeliverySlipConfigPanel.this.useProductName != null) {
                h = (int)((double)h + (DeliverySlipConfigPanel.this.useProductLabelName.getPreferredSize().getHeight() + (double)(DeliverySlipConfigPanel.this.border / 4)));
                h = (int)((double)h + (DeliverySlipConfigPanel.this.useAISName.getPreferredSize().getHeight() + (double)(DeliverySlipConfigPanel.this.border / 4)));
                h = (int)((double)h + (DeliverySlipConfigPanel.this.useProductName.getPreferredSize().getHeight() + (double)DeliverySlipConfigPanel.this.border));
            }
            if (DeliverySlipConfigPanel.this.sortProductsByNumber != null) {
                h = (int)((double)h + (DeliverySlipConfigPanel.this.sortProductsByNumber.getPreferredSize().getHeight() + (double)DeliverySlipConfigPanel.this.border));
            }
            if (DeliverySlipConfigPanel.this.finalizeFlight != null) {
                h = (int)((double)h + (DeliverySlipConfigPanel.this.finalizeFlight.getPreferredSize().getHeight() + (double)(DeliverySlipConfigPanel.this.border / 4)));
            }
            if (DeliverySlipConfigPanel.this.includeStandard != null) {
                h = (int)((double)h + (DeliverySlipConfigPanel.this.includeStandard.getPreferredSize().getHeight() + (double)(DeliverySlipConfigPanel.this.border / 4)));
            }
            if (DeliverySlipConfigPanel.this.includeHandlings != null) {
                h = (int)((double)h + (DeliverySlipConfigPanel.this.includeHandlings.getPreferredSize().getHeight() + (double)(DeliverySlipConfigPanel.this.border / 4)));
            }
            if (DeliverySlipConfigPanel.this.includeArticles != null) {
                h = (int)((double)h + (DeliverySlipConfigPanel.this.includeArticles.getPreferredSize().getHeight() + (double)(DeliverySlipConfigPanel.this.border / 4)));
            }
            if (DeliverySlipConfigPanel.this.includeNullValues != null) {
                h = (int)((double)h + (DeliverySlipConfigPanel.this.includeNullValues.getPreferredSize().getHeight() + (double)DeliverySlipConfigPanel.this.border));
            }
            if (DeliverySlipConfigPanel.this.includePaxUpdate != null) {
                h = (int)((double)h + (DeliverySlipConfigPanel.this.includePaxUpdate.getPreferredSize().getHeight() + (double)(DeliverySlipConfigPanel.this.border / 4)));
            }
            if (DeliverySlipConfigPanel.this.includeDrawersCount != null) {
                h = (int)((double)h + (DeliverySlipConfigPanel.this.includeDrawersCount.getPreferredSize().getHeight() + (double)(DeliverySlipConfigPanel.this.border / 4)));
            }
            if (DeliverySlipConfigPanel.this.includeTemperature != null) {
                h = (int)((double)h + (DeliverySlipConfigPanel.this.includeTemperature.getPreferredSize().getHeight() + (double)(DeliverySlipConfigPanel.this.border / 4)));
            }
            if (DeliverySlipConfigPanel.this.includeSeals != null) {
                h = (int)((double)h + (DeliverySlipConfigPanel.this.includeSeals.getPreferredSize().getHeight() + (double)(DeliverySlipConfigPanel.this.border / 4)));
            }
            if (DeliverySlipConfigPanel.this.includeAIS != null) {
                h = (int)((double)h + (DeliverySlipConfigPanel.this.includeAIS.getPreferredSize().getHeight() + (double)DeliverySlipConfigPanel.this.border));
            }
            if (DeliverySlipConfigPanel.this.groupAdditionals != null) {
                h = (int)((double)h + (DeliverySlipConfigPanel.this.groupAdditionals.getPreferredSize().getHeight() + (double)(DeliverySlipConfigPanel.this.border / 4)));
            }
            if (DeliverySlipConfigPanel.this.showAdditionalsSeparately != null) {
                h = (int)((double)h + (DeliverySlipConfigPanel.this.showAdditionalsSeparately.getPreferredSize().getHeight() + (double)(DeliverySlipConfigPanel.this.border / 4)));
            }
            if (DeliverySlipConfigPanel.this.showSpecialMealsSeparately != null) {
                h = (int)((double)h + (DeliverySlipConfigPanel.this.showSpecialMealsSeparately.getPreferredSize().getHeight() + (double)DeliverySlipConfigPanel.this.border));
            }
            if (DeliverySlipConfigPanel.this.excludeZeroPax != null) {
                h = (int)((double)h + (DeliverySlipConfigPanel.this.excludeZeroPax.getPreferredSize().getHeight() + (double)(DeliverySlipConfigPanel.this.border / 4)));
            }
            if (DeliverySlipConfigPanel.this.includeCrewPaxes != null) {
                h = (int)((double)h + (DeliverySlipConfigPanel.this.includeCrewPaxes.getPreferredSize().getHeight() + (double)(DeliverySlipConfigPanel.this.border / 4)));
            }
            if (DeliverySlipConfigPanel.this.summarizeCrew != null) {
                h = (int)((double)h + (DeliverySlipConfigPanel.this.summarizeCrew.getPreferredSize().getHeight() + (double)(DeliverySlipConfigPanel.this.border / 4)));
            }
            if (DeliverySlipConfigPanel.this.hideFlightFromToNSDS != null) {
                h = (int)((double)h + (DeliverySlipConfigPanel.this.hideFlightFromToNSDS.getPreferredSize().getHeight() + (double)(DeliverySlipConfigPanel.this.border / 4)));
            }
            if (DeliverySlipConfigPanel.this.showSobState && DeliverySlipConfigPanel.this.showAllProducts != null) {
                h = (int)((double)h + (DeliverySlipConfigPanel.this.showAllProducts.getPreferredSize().getHeight() + (double)(DeliverySlipConfigPanel.this.border / 4)));
                h = (int)((double)h + (DeliverySlipConfigPanel.this.showSobProductsOnly.getPreferredSize().getHeight() + (double)(DeliverySlipConfigPanel.this.border / 4)));
                h = (int)((double)h + (DeliverySlipConfigPanel.this.showNoSobProductsOnly.getPreferredSize().getHeight() + (double)(DeliverySlipConfigPanel.this.border / 2)));
            }
            if (DeliverySlipConfigPanel.this.infoLabel != null) {
                h = (int)((double)h + (DeliverySlipConfigPanel.this.infoLabel.getPreferredSize().getHeight() + (double)(DeliverySlipConfigPanel.this.border / 2)));
            }
            if (DeliverySlipConfigPanel.this.printProducesText != null) {
                h = (int)((double)h + (DeliverySlipConfigPanel.this.printProducesText.getPreferredSize().getHeight() + (double)DeliverySlipConfigPanel.this.border));
            }
            if (DeliverySlipConfigPanel.this.printIngredientListInfo != null) {
                h = (int)((double)h + (DeliverySlipConfigPanel.this.printIngredientListInfo.getPreferredSize().getHeight() + (double)DeliverySlipConfigPanel.this.border));
            }
            return new Dimension(0, h);
        }
    }
}

