/*
 * Decompiled with CFR 0.152.
 */
package ch.icit.pegasus.client.gui.utils.panels;

import ch.icit.pegasus.client.gui.table.fake.FakeSmartScreenTableRow;
import ch.icit.pegasus.client.gui.utils.DefaultLayout;
import ch.icit.pegasus.client.gui.utils.InnerPopUpListener2;
import ch.icit.pegasus.client.gui.utils.buttons.Button;
import ch.icit.pegasus.client.gui.utils.buttons.ButtonListener;
import ch.icit.pegasus.client.gui.utils.buttons.TabbedBackButton;
import ch.icit.pegasus.client.gui.utils.buttons.TabbedBackButtonContainer;
import ch.icit.pegasus.client.gui.utils.panels.defaults.JPanelFadable;
import ch.icit.pegasus.client.gui.utils.popup.InnerPopUp2;
import ch.icit.pegasus.client.gui.utils.popup.InnerPopupFactory;
import ch.icit.pegasus.client.laf.LafLoader;
import java.awt.Container;
import java.awt.Dimension;

public abstract class FrameIconBar
extends JPanelFadable
implements ButtonListener,
InnerPopUpListener2 {
    private static final long serialVersionUID = 1L;
    protected FakeSmartScreenTableRow selectedRow;
    protected TabbedBackButtonContainer buttons;
    protected TabbedBackButton backButton;
    protected TabbedBackButton saveButton;
    protected TabbedBackButton cancelButton;
    protected String loadingNames;
    private boolean hasSaveButton;
    private boolean hasCancelButton;
    private boolean ignoreCancelFunction;

    public FrameIconBar(FakeSmartScreenTableRow selectedView, String loadingNames) {
        this(selectedView, true, true, loadingNames);
    }

    public FrameIconBar(FakeSmartScreenTableRow selectedView, boolean hasSave, boolean hasCancel, String loadingNames) {
        this.selectedRow = selectedView;
        this.loadingNames = loadingNames;
        this.hasSaveButton = hasSave;
        this.hasCancelButton = hasCancel;
        this.install();
    }

    private void recalculateRow(int newWidth) {
        this.selectedRow.relayoutRow(newWidth);
    }

    @Override
    public void kill() {
        if (this.isKilled()) {
            return;
        }
        super.kill();
        if (this.selectedRow != null) {
            this.selectedRow.kill();
        }
        this.selectedRow = null;
        this.buttons.kill();
        this.buttons = null;
        if (this.backButton != null) {
            this.backButton.kill();
        }
        this.backButton = null;
        if (this.saveButton != null) {
            this.saveButton.kill();
        }
        this.saveButton = null;
        if (this.cancelButton != null) {
            this.cancelButton.kill();
        }
        this.cancelButton = null;
        this.loadingNames = null;
    }

    @Override
    public void setEnabled(boolean isEnabled) {
        super.setEnabled(isEnabled);
        this.selectedRow.setEnabled(isEnabled);
        if (this.backButton != null) {
            this.backButton.setEnabled(isEnabled);
        }
        if (this.saveButton != null) {
            this.saveButton.setEnabled(isEnabled);
        }
        if (this.saveButton != null) {
            this.cancelButton.setEnabled(isEnabled);
        }
    }

    public FakeSmartScreenTableRow getSelectedModel() {
        return this.selectedRow;
    }

    private void install() {
        this.setOpaque(false);
        this.buttons = new TabbedBackButtonContainer();
        this.backButton = new TabbedBackButton(LafLoader.getLafLoader().getAttribute("smartscreen_back_backbutton_up"), TabbedBackButton.ViewState.Left);
        this.backButton.addButtonListener(this);
        if (this.hasSaveButton) {
            this.saveButton = new TabbedBackButton(LafLoader.getLafLoader().getAttribute("smartscreen_save_backbutton_up"), TabbedBackButton.ViewState.Middle);
            this.saveButton.addButtonListener(this);
        }
        if (this.hasCancelButton) {
            this.cancelButton = new TabbedBackButton(LafLoader.getLafLoader().getAttribute("smartscreen_close_backbutton_up"), TabbedBackButton.ViewState.Right);
            this.cancelButton.addButtonListener(this);
        }
        this.buttons.addButton(this.backButton);
        if (this.hasSaveButton) {
            this.buttons.addButton(this.saveButton);
        }
        if (this.hasCancelButton) {
            this.buttons.addButton(this.cancelButton);
        }
        this.setLayout(new IconBarLayout());
        this.add(this.selectedRow);
        this.add(this.buttons);
    }

    public void layoutPanel(int w, int h, boolean resize) {
        int aHeight = (int)this.getPreferredSize().getHeight();
        this.setSize(w, aHeight);
    }

    public void movePanel(int x, int y, boolean smooth) {
    }

    protected abstract void backButtonPressed(Button var1, int var2, int var3);

    protected abstract void saveButtonPressed(Button var1, int var2, int var3);

    protected abstract void cancelButtonPressed(Button var1, int var2, int var3);

    @Override
    public void buttonPressed(Button source, int x, int y) {
        if (source == this.backButton) {
            this.backButtonPressed(source, x, y);
        } else if (source == this.saveButton) {
            this.saveButtonPressed(source, x, y);
        } else if (source == this.cancelButton) {
            if (this.ignoreCancelFunction) {
                this.cancelButtonPressed(this.cancelButton, 0, 0);
            } else {
                InnerPopupFactory.showEnsureCancelPopup(this.cancelButton, x, y, this, InnerPopupFactory.CANCEL_TYPES.CANCEL_AND_BACK);
            }
        }
    }

    @Override
    public void popUpClosed(InnerPopUp2 source, Object ... xargs) {
        if (xargs != null) {
            this.cancelButtonPressed(this.cancelButton, 0, 0);
        }
    }

    public boolean getIgnoreCancelFunction() {
        return this.ignoreCancelFunction;
    }

    public void setIgnoreCancelFunction(boolean ignoreCancelFunction) {
        this.ignoreCancelFunction = ignoreCancelFunction;
    }

    private class IconBarLayout
    extends DefaultLayout {
        private IconBarLayout() {
        }

        @Override
        public void layoutContainer(Container parent) {
            int w = parent.getWidth();
            int h = parent.getHeight();
            int exSpace = 0;
            int aBorder = 10;
            FrameIconBar.this.buttons.setLocation(0, (int)(((double)h - FrameIconBar.this.buttons.getPreferredSize().getHeight()) / 2.0));
            FrameIconBar.this.buttons.setSize(FrameIconBar.this.buttons.getPreferredSize());
            FrameIconBar.this.selectedRow.setLocation(FrameIconBar.this.buttons.getX() + FrameIconBar.this.buttons.getWidth() + aBorder, (h - FrameIconBar.this.selectedRow.getPreferredHeight()) / 2);
            FrameIconBar.this.recalculateRow(w - (exSpace + FrameIconBar.this.selectedRow.getX()));
        }

        @Override
        public Dimension preferredLayoutSize(Container parent) {
            int h = FrameIconBar.this.selectedRow.getPreferredHeight();
            if ((double)h < FrameIconBar.this.buttons.getPreferredSize().getHeight()) {
                h = (int)FrameIconBar.this.buttons.getPreferredSize().getHeight();
            }
            return new Dimension(0, h);
        }
    }
}

