/*
 * Decompiled with CFR 0.152.
 */
package ch.icit.pegasus.client.gui.utils.panels;

import ch.icit.pegasus.client.gui.table.TableColumnInfo;
import ch.icit.pegasus.client.gui.table2.Table2;
import ch.icit.pegasus.client.gui.table2.Table2ButtonHandler;
import ch.icit.pegasus.client.gui.table2.Table2Model;
import ch.icit.pegasus.client.gui.table2.Table2RowModel;
import ch.icit.pegasus.client.gui.table2.Table2RowPanel;
import ch.icit.pegasus.client.gui.utils.CheckedListAdder;
import ch.icit.pegasus.client.gui.utils.DefaultLayout;
import ch.icit.pegasus.client.gui.utils.TitledItem;
import ch.icit.pegasus.client.gui.utils.buttons.Button;
import ch.icit.pegasus.client.gui.utils.buttons.ButtonListener;
import ch.icit.pegasus.client.gui.utils.buttons.DeleteButton;
import ch.icit.pegasus.client.gui.utils.filterchain.UIStateLoadable;
import ch.icit.pegasus.client.gui.utils.focus.VisibleContainer;
import ch.icit.pegasus.client.gui.utils.panels.DefaultPanel;
import ch.icit.pegasus.client.gui.utils.skins.SizedSkin1Field;
import ch.icit.pegasus.client.gui.utils.textfield.TextField;
import ch.icit.pegasus.client.node.DtoFieldConstants;
import ch.icit.pegasus.client.node.impls.ListNode;
import ch.icit.pegasus.client.node.impls.Node;
import ch.icit.pegasus.server.core.i18n.Words;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class ManualFlightLabelPanel
extends DefaultPanel
implements ButtonListener,
UIStateLoadable {
    private static final long serialVersionUID = 1L;
    private TitledItem<TextField> equipmentType;
    private Table2 entries;

    public ManualFlightLabelPanel() {
        this.setLayout(new Layout());
        this.equipmentType = new TitledItem<TextField>(new TextField(), Words.EQUIPMENT_TEXT, TitledItem.TitledItemOrientation.NORTH);
        this.entries = new Table2(true, Words.ADD, true, true, Words.ENTRIES);
        this.entries.setButtonHandler(new Table2ButtonHandler(){

            @Override
            public void childRemoved() {
            }

            @Override
            public void addButtonPressed(int x, int y, Button source) {
                Node nameNode = new Node();
                nameNode.setName(DtoFieldConstants.name);
                Node countNode = new Node();
                countNode.setName(DtoFieldConstants.count);
                Node group = new Node();
                group.addChild(nameNode, 0L);
                group.addChild(countNode, 0L);
                ManualFlightLabelPanel.this.entries.getModel().getNode().addChild(group, System.currentTimeMillis());
            }
        });
        ArrayList<TableColumnInfo> columns = new ArrayList<TableColumnInfo>();
        columns.add(new TableColumnInfo(Words.TEXT, null, null, null, "", 40, 40, 40));
        columns.add(new TableColumnInfo(Words.COUNT, null, null, null, "", 40, 40, 40));
        int tw = 2 * this.entries.getCellPadding() + DeleteButton.getPreferredWidth(SizedSkin1Field.SkinSize.MEDIUM);
        columns.add(new TableColumnInfo("", null, null, null, "", tw, tw, tw));
        ((TableColumnInfo)columns.get(0)).setxExpand(0.5);
        ((TableColumnInfo)columns.get(1)).setxExpand(0.5);
        ((TableColumnInfo)columns.get(2)).setxExpand(0.0);
        this.entries.setModel(new Table2Model(columns, model -> new TableRowImpl(model)));
        this.entries.getModel().setNode((Node)new ListNode());
        this.add(this.equipmentType);
        this.add(this.entries);
        this.setEnabled(this.isEnabled());
    }

    @Override
    public List<Component> getFocusComponents() {
        ArrayList<Component> a = new ArrayList<Component>();
        CheckedListAdder.addToList(a, this.equipmentType);
        CheckedListAdder.addToList(a, this.entries);
        return a;
    }

    @Override
    public void setEnabled(boolean isEnabled) {
        super.setEnabled(isEnabled);
        this.equipmentType.setEnabled(isEnabled);
        this.entries.setEnabled(isEnabled);
    }

    @Override
    public void setVisibleContainer(VisibleContainer pane) {
    }

    public String getEquipmentTypeName() {
        return this.equipmentType.getElement().getText();
    }

    public Map<String, Integer> getEntries() {
        HashMap<String, Integer> map = new HashMap<String, Integer>();
        Iterator it = this.entries.getModel().getNode().getFailSafeChildIterator();
        while (it.hasNext()) {
            Node node = (Node)it.next();
            Node color = node.getChildNamed(DtoFieldConstants.name);
            Node text = node.getChildNamed(DtoFieldConstants.count);
            if (color.getValue() == null || text.getValue() == null) continue;
            Integer iCount = null;
            String iColor = (String)color.getValue();
            try {
                iCount = Integer.valueOf((String)text.getValue());
            }
            catch (Exception e) {
                continue;
            }
            map.put(iColor, iCount);
        }
        return map;
    }

    @Override
    public void requestFocusInWindowNow() {
    }

    @Override
    public void buttonPressed(Button source, int x, int y) {
        this.setEnabled(this.isEnabled());
    }

    @Override
    public String getPersistString() {
        return null;
    }

    @Override
    public void loadState(String state, String id) {
    }

    @Override
    public String getID() {
        return null;
    }

    @Override
    public boolean shouldPersist() {
        return false;
    }

    @Override
    public void setShouldPersist(boolean isPersisting) {
    }

    private class TableRowImpl
    extends Table2RowPanel
    implements ButtonListener {
        private static final long serialVersionUID = 1L;
        private TextField text;
        private TextField count;
        private DeleteButton delete;

        public TableRowImpl(Table2RowModel m) {
            super(m);
            this.setUseControlSkin(Table2RowPanel.TableControlsType.ONE);
            this.text = new TextField(m.getNode().getChildNamed(DtoFieldConstants.name));
            this.count = new TextField(m.getNode().getChildNamed(DtoFieldConstants.count));
            this.delete = new DeleteButton();
            this.delete.addButtonListener(this);
            this.setLayout(new InnerLayout());
            this.add(this.text);
            this.add(this.count);
            this.add(this.delete);
        }

        @Override
        public List<Component> getFocusComponents() {
            ArrayList<Component> a = new ArrayList<Component>();
            CheckedListAdder.addToList(a, this.text);
            CheckedListAdder.addToList(a, this.count);
            CheckedListAdder.addToList(a, this.delete);
            return a;
        }

        @Override
        public Object getObject4Column(int column) {
            return null;
        }

        @Override
        public void buttonPressed(Button source, int x, int y) {
            this.getModel().getNode().getParent().removeChild(this.getModel().getNode(), 0L);
        }

        private class InnerLayout
        extends DefaultLayout {
            private InnerLayout() {
            }

            @Override
            public void layoutContainer(Container parent) {
                int currentX = 0;
                int w = TableRowImpl.this.getModel().getParentModel().getColumnWidth(0);
                TableRowImpl.this.text.setLocation(currentX + TableRowImpl.this.getCellPadding(), (int)(((double)parent.getHeight() - TableRowImpl.this.text.getPreferredSize().getHeight()) / 2.0));
                TableRowImpl.this.text.setSize(w - 2 * TableRowImpl.this.getCellPadding(), (int)TableRowImpl.this.text.getPreferredSize().getHeight());
                currentX += w;
                w = TableRowImpl.this.getModel().getParentModel().getColumnWidth(1);
                TableRowImpl.this.count.setLocation(currentX + TableRowImpl.this.getCellPadding(), (int)(((double)parent.getHeight() - TableRowImpl.this.count.getPreferredSize().getHeight()) / 2.0));
                TableRowImpl.this.count.setSize(w - 2 * TableRowImpl.this.getCellPadding(), (int)TableRowImpl.this.count.getPreferredSize().getHeight());
                TableRowImpl.this.setControlsX(currentX += w);
                TableRowImpl.this.delete.setLocation(currentX + TableRowImpl.this.getCellPadding(), (int)(((double)parent.getHeight() - TableRowImpl.this.delete.getPreferredSize().getHeight()) / 2.0));
                TableRowImpl.this.delete.setSize(TableRowImpl.this.delete.getPreferredSize());
            }

            @Override
            public Dimension preferredLayoutSize(Container arg0) {
                return new Dimension(0, TableRowImpl.this.getDefaultRowHeight());
            }
        }
    }

    private class Layout
    extends DefaultLayout {
        int border = 10;

        private Layout() {
        }

        @Override
        public Dimension preferredLayoutSize(Container parent) {
            int h = 0;
            h = (int)((double)h + ManualFlightLabelPanel.this.equipmentType.getPreferredSize().getHeight());
            h += this.border / 2;
            return new Dimension(0, h += 200);
        }

        @Override
        public void layoutContainer(Container parent) {
            ManualFlightLabelPanel.this.equipmentType.setLocation(0, 0);
            ManualFlightLabelPanel.this.equipmentType.setSize(parent.getWidth(), (int)ManualFlightLabelPanel.this.equipmentType.getPreferredSize().getHeight());
            ManualFlightLabelPanel.this.entries.setLocation(0, ManualFlightLabelPanel.this.equipmentType.getY() + ManualFlightLabelPanel.this.equipmentType.getHeight() + this.border / 2);
            ManualFlightLabelPanel.this.entries.setSize(parent.getWidth(), parent.getHeight() - ManualFlightLabelPanel.this.entries.getY());
        }
    }
}

