/*
 * Decompiled with CFR 0.152.
 */
package ch.icit.pegasus.client.gui.utils.panels;

import ch.icit.pegasus.client.gui.utils.CheckedListAdder;
import ch.icit.pegasus.client.gui.utils.DefaultLayout;
import ch.icit.pegasus.client.gui.utils.Nodable;
import ch.icit.pegasus.client.gui.utils.Selectable;
import ch.icit.pegasus.client.gui.utils.TextLabel;
import ch.icit.pegasus.client.gui.utils.focus.Focusable;
import ch.icit.pegasus.client.gui.utils.focus.VisibleContainer;
import ch.icit.pegasus.client.gui.utils.panels.defaults.JPanelFadable;
import ch.icit.pegasus.client.gui.utils.textfield.NumberTextField;
import ch.icit.pegasus.client.gui.utils.textfield.TextField;
import ch.icit.pegasus.client.gui.utils.textfield.TextFieldType;
import ch.icit.pegasus.client.node.impls.Node;
import ch.icit.pegasus.client.node.impls.NodeListener;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.util.ArrayList;
import java.util.List;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;

public class PhoneField
extends JPanelFadable
implements Focusable,
DocumentListener,
NodeListener,
Nodable {
    private static final long serialVersionUID = 1L;
    private TextLabel plus;
    private TextField firstField;
    private TextField secondField;
    private Node phoneNr;

    public PhoneField(Node node) {
        this.setOpaque(false);
        this.setLayout(new Layout());
        this.plus = new TextLabel("+");
        this.firstField = new NumberTextField(TextFieldType.INT);
        this.secondField = new NumberTextField(TextFieldType.INT);
        this.firstField.addDocumentListener(this);
        this.secondField.addDocumentListener(this);
        this.setNode(node);
        this.add(this.plus);
        this.add(this.firstField);
        this.add(this.secondField);
    }

    @Override
    public Node<?> getNode() {
        return this.phoneNr;
    }

    public void setNode(Node node) {
        if (this.phoneNr != null) {
            this.phoneNr.removeNodeListener((NodeListener)this);
        }
        this.phoneNr = node;
        if (this.phoneNr != null) {
            this.phoneNr.addNodeListener((NodeListener)this);
            this.valueChanged(this.phoneNr);
        }
    }

    @Override
    public void kill() {
        if (this.isKilled()) {
            return;
        }
        super.kill();
        this.plus.kill();
        this.firstField.kill();
        this.secondField.kill();
        this.plus = null;
        this.firstField = null;
        this.secondField = null;
    }

    @Override
    public List<Component> getFocusComponents() {
        ArrayList<Component> a = new ArrayList<Component>();
        CheckedListAdder.addToList(a, this.firstField);
        CheckedListAdder.addToList(a, this.secondField);
        return a;
    }

    private void stringValueChanged() {
        String orgValue = this.processTextValue();
        if (this.phoneNr != null && this.phoneNr instanceof Node) {
            this.phoneNr.setValueSilent((Object)orgValue, false, System.currentTimeMillis(), new NodeListener[]{this});
        }
    }

    @Override
    public void changedUpdate(DocumentEvent e) {
        this.stringValueChanged();
    }

    @Override
    public void insertUpdate(DocumentEvent e) {
        this.stringValueChanged();
    }

    @Override
    public void removeUpdate(DocumentEvent e) {
        this.stringValueChanged();
    }

    public void childAdded(Node<?> source, Node<?> child) {
    }

    public void childRemoved(Node<?> source, Node<?> child) {
    }

    public void valueChanged(Node<?> node) {
        String t = (String)node.getValue();
        this.processPhoneNr(t);
    }

    private void processPhoneNr(String t) {
        this.firstField.removeDocumentListener(this);
        this.secondField.removeDocumentListener(this);
        boolean unableToWrite = false;
        if (t != null) {
            int i = t.indexOf("-");
            if (i != -1) {
                this.firstField.setText(t.substring(1, i));
                this.secondField.setText(t.substring(i + 1, t.length()));
            } else if (t.length() > 1) {
                this.firstField.setText("");
                this.secondField.setText(t.substring(1, t.length()));
            } else {
                unableToWrite = true;
            }
        } else {
            unableToWrite = true;
        }
        if (unableToWrite) {
            this.firstField.setText("");
            this.secondField.setText("");
        }
        this.firstField.addDocumentListener(this);
        this.secondField.addDocumentListener(this);
    }

    private String processTextValue() {
        String t = this.plus.getText() + this.firstField.getText() + "-" + this.secondField.getText();
        return t;
    }

    public void childrenAdded(Node<?> source, Node<?> ... nodes) {
    }

    @Override
    public void setVisibleContainer(VisibleContainer pane) {
        this.firstField.setVisibleContainer(pane);
        this.secondField.setVisibleContainer(pane);
    }

    @Override
    public Selectable getSelectDelegationComponent() {
        return null;
    }

    @Override
    public void requestFocusInWindowNow() {
        this.firstField.requestFocusInWindowNow();
    }

    public boolean isSwingOnly() {
        return true;
    }

    private class Layout
    extends DefaultLayout {
        private Layout() {
        }

        @Override
        public void layoutContainer(Container parent) {
            PhoneField.this.plus.setLocation(0, (int)(((double)parent.getHeight() - PhoneField.this.plus.getPreferredSize().getHeight()) / 2.0));
            PhoneField.this.plus.setSize(PhoneField.this.plus.getPreferredSize());
            PhoneField.this.firstField.setLocation(PhoneField.this.plus.getX() + PhoneField.this.plus.getWidth() + 5, (int)(((double)parent.getHeight() - PhoneField.this.firstField.getPreferredSize().getHeight()) / 2.0));
            PhoneField.this.firstField.setSize(40, (int)PhoneField.this.firstField.getPreferredSize().getHeight());
            PhoneField.this.secondField.setLocation(PhoneField.this.firstField.getX() + PhoneField.this.firstField.getWidth() + 5, (int)(((double)parent.getHeight() - PhoneField.this.secondField.getPreferredSize().getHeight()) / 2.0));
            PhoneField.this.secondField.setSize(parent.getWidth() - PhoneField.this.secondField.getX(), (int)PhoneField.this.secondField.getPreferredSize().getHeight());
        }

        @Override
        public Dimension preferredLayoutSize(Container parent) {
            int h = (int)PhoneField.this.secondField.getPreferredSize().getHeight();
            return new Dimension(0, h);
        }
    }
}

