/*
 * Decompiled with CFR 0.152.
 */
package ch.icit.pegasus.client.gui.utils.panels.documentscan;

import ch.icit.pegasus.client.gui.table2.Table2RowPanel;
import ch.icit.pegasus.client.gui.utils.DefaultLayout;
import ch.icit.pegasus.client.gui.utils.PDFViewer;
import ch.icit.pegasus.client.gui.utils.buttons.TextButton;
import ch.icit.pegasus.client.gui.utils.panels.defaults.JPanelWithLoadingAnimation;
import ch.icit.pegasus.client.gui.utils.popup.InnerPopupFactory;
import ch.icit.pegasus.client.gui.utils.tables.ScanDocumentTable;
import ch.icit.pegasus.client.node.impls.Node;
import ch.icit.pegasus.server.core.dtos.ADTO;
import ch.icit.pegasus.server.core.dtos.document.DocumentScanComplete;
import ch.icit.pegasus.server.core.dtos.document.DocumentScanTypeE;
import ch.icit.pegasus.server.core.dtos.system.SystemSettingsComplete;
import com.sun.pdfview.PDFFile;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.io.File;
import java.nio.ByteBuffer;
import org.apache.commons.io.FileUtils;

public abstract class DocumentScanPanel<T extends ADTO>
extends JPanelWithLoadingAnimation {
    protected ScanDocumentTable documentTable;
    protected PDFViewer preview;
    protected SystemSettingsComplete settings;
    protected DocumentScanTypeE type;
    protected Node<T> orderNode;
    protected TextButton chooseFile;

    public DocumentScanPanel(SystemSettingsComplete settings, DocumentScanTypeE type) {
        this(settings, type, null);
    }

    public DocumentScanPanel(SystemSettingsComplete settings, DocumentScanTypeE type, Node<T> orderNode) {
        this.settings = settings;
        this.type = type;
        this.orderNode = orderNode;
        this.documentTable = new ScanDocumentTable(false);
        this.preview = new PDFViewer();
        this.setLayout(new Layout());
        this.documentTable.getFader().setProgress(0.0f);
        this.preview.getFader().setProgress(0.0f);
        this.documentTable.getModel().addTableSelectionListener((sourceTable, panel) -> this.selectRow(panel));
        this.add(this.documentTable);
        this.add(this.preview);
        this.initDataNode(type, orderNode);
    }

    public void setOrderNode(Node<T> orderNode) {
        this.orderNode = orderNode;
        if (this.orderNode != null) {
            this.initDataNode(this.type, orderNode);
        }
    }

    private void selectRow(Table2RowPanel panel) {
        Node selectedDocument = panel.getModel().getNode();
        try {
            File file = ((DocumentScanComplete)selectedDocument.getValue()).getFileData().getLocalFile();
            byte[] bytes = FileUtils.readFileToByteArray((File)file);
            ByteBuffer buffer = ByteBuffer.wrap(bytes);
            this.preview.showPDF(file, new PDFFile(buffer));
        }
        catch (Exception e) {
            InnerPopupFactory.showErrorDialog(e, (Component)this);
        }
        for (Table2RowPanel row : this.documentTable.getRows()) {
            if (row.isSelected() != 3) continue;
        }
    }

    public Node<DocumentScanComplete> getDocument() {
        for (Table2RowPanel row : this.documentTable.getRows()) {
            if (row.isSelected() != 3) continue;
            return row.getModel().getNode();
        }
        return null;
    }

    public abstract void initDataNode(DocumentScanTypeE var1, Node<T> var2);

    public abstract void loadScans();

    protected String getDefaultDocumentScanPath() {
        switch (this.type) {
            case PURCHASE_ORDER: 
            case MOVEMENT: {
                return this.settings.getDefaultPurchaseDocumentScanPath();
            }
            case DELIVERY_SLIP: {
                return this.settings.getDefaultDispatchDocumentScanPath();
            }
        }
        throw new IllegalStateException("Unknown state");
    }

    private class Layout
    extends DefaultLayout {
        private Layout() {
        }

        @Override
        public Dimension preferredLayoutSize(Container parent) {
            return new Dimension(400, 400);
        }

        @Override
        public void layoutContainer(Container parent) {
            DocumentScanPanel.this.layoutAnimation(parent);
            if (DocumentScanPanel.this.chooseFile != null) {
                DocumentScanPanel.this.documentTable.setLocation(0, 0);
                DocumentScanPanel.this.documentTable.setSize(parent.getWidth() / 2, (int)((double)parent.getHeight() - (10.0 + DocumentScanPanel.this.chooseFile.getPreferredSize().getHeight() + 10.0)));
                DocumentScanPanel.this.chooseFile.setLocationSmooth(10, DocumentScanPanel.this.documentTable.getY() + DocumentScanPanel.this.documentTable.getHeight() + 10);
                DocumentScanPanel.this.chooseFile.setSize(DocumentScanPanel.this.chooseFile.getPreferredSize());
            } else {
                DocumentScanPanel.this.documentTable.setLocation(0, 0);
                DocumentScanPanel.this.documentTable.setSize(parent.getWidth() / 2, parent.getHeight());
            }
            DocumentScanPanel.this.preview.setLocation(parent.getWidth() / 2, 0);
            DocumentScanPanel.this.preview.setSize(parent.getWidth() / 2, parent.getHeight());
        }
    }
}

