/*
 * Decompiled with CFR 0.152.
 */
package ch.icit.pegasus.client.gui.utils.popup.inserts;

import ch.icit.pegasus.client.gui.utils.AttributesConverter;
import ch.icit.pegasus.client.gui.utils.DefaultLayout;
import ch.icit.pegasus.client.gui.utils.InnerPopUpListener2;
import ch.icit.pegasus.client.gui.utils.MultiLineTextLabel;
import ch.icit.pegasus.client.gui.utils.ScrollPane;
import ch.icit.pegasus.client.gui.utils.buttons.TextButton;
import ch.icit.pegasus.client.gui.utils.panels.LoadingAnimation;
import ch.icit.pegasus.client.gui.utils.popup.InnerPopUp2;
import ch.icit.pegasus.client.gui.utils.popup.InnerPopupFactory;
import ch.icit.pegasus.client.gui.utils.popup.PopUpInsert;
import ch.icit.pegasus.client.gui.utils.popup.PopupAction;
import ch.icit.pegasus.client.gui.utils.popup.PopupType;
import ch.icit.pegasus.client.gui.utils.popup.inserts.EnterMessagePopupInsert;
import ch.icit.pegasus.client.laf.LafLoader;
import ch.icit.pegasus.client.node.INodeCreator;
import ch.icit.pegasus.client.node.impls.Node;
import ch.icit.pegasus.client.services.ServiceManagerRegistry;
import ch.icit.pegasus.client.services.interfaces.supply.OrderServiceManager;
import ch.icit.pegasus.client.services.interfaces.system.UserServiceManager;
import ch.icit.pegasus.client.util.RemoteLoader;
import ch.icit.pegasus.client.util.async.ThreadSafeExecutable;
import ch.icit.pegasus.client.util.async.ThreadSafeLoader;
import ch.icit.pegasus.client.util.exception.ClientException;
import ch.icit.pegasus.server.core.dtos.masterdata.UserLight;
import ch.icit.pegasus.server.core.dtos.ordering.PurchaseOrderPositionComplete;
import ch.icit.pegasus.server.core.dtos.ordering.PurchaseOrderPositionLight;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.sql.Timestamp;
import java.util.List;
import javax.swing.JComponent;

public class HalalCheckPopUpInsert
extends PopUpInsert
implements RemoteLoader {
    private static final long serialVersionUID = 1L;
    private final PurchaseOrderPositionLight position;
    private final boolean infoOnly;
    private ScrollPane scrollPane;
    private JComponent viewPort;
    private Color backgroundColor;
    protected MultiLineTextLabel label;
    private LoadingAnimation loadingAnimation;
    private TextButton checkHalalOk;
    private TextButton checkHalalNotOk;

    public HalalCheckPopUpInsert(String text, PurchaseOrderPositionLight position, boolean infoOnly) {
        this.position = position;
        this.infoOnly = infoOnly;
        this.initLayout();
        this.initMultiLabelThings(text);
    }

    protected void ensureAnimation(String current) {
        if (this.loadingAnimation == null) {
            this.loadingAnimation = new LoadingAnimation();
            this.loadingAnimation.stateChanged(current);
            this.viewPort.add(this.loadingAnimation);
            this.loadingAnimation.start();
            this.loadingAnimation.fadeIn();
        }
        if (this.label != null) {
            this.label.fadeOut(false);
        }
    }

    protected void hideAnimation() {
        if (this.loadingAnimation != null) {
            this.loadingAnimation.stop();
            this.loadingAnimation.fadeOut(true);
            this.loadingAnimation = null;
        }
        if (this.label != null) {
            this.label.fadeIn();
        }
    }

    private void initLayout() {
        this.setOpaque(false);
        this.setLayout(new InnerLayout());
    }

    private void doSaveHalalSpotCheck() {
        this.checkHalalNotOk.fadeOut(true);
        this.checkHalalOk.fadeOut(true);
        this.ensureAnimation("Save Halal Check");
        this.loadingAnimation.fadeIn();
        this.popup.enableOKButton(false);
        this.saveData();
    }

    private void initMultiLabelThings(String text) {
        this.label = new MultiLineTextLabel();
        this.label.getFader().setPermanent(true);
        this.backgroundColor = AttributesConverter.getColor4String(LafLoader.getLafLoader().getAttribute("innerpopup_extension_background"));
        this.scrollPane = new ScrollPane();
        this.scrollPane.setScrollPaneBackground(this.backgroundColor);
        this.viewPort = new Port();
        this.viewPort.setLayout(new ViewPortLayout());
        if (!this.infoOnly) {
            this.checkHalalOk = new TextButton("Halal Ok");
            this.checkHalalNotOk = new TextButton("Halal Not Ok");
            this.checkHalalOk.addButtonListener((source, x, y) -> {
                this.position.setHalalChecked(Boolean.valueOf(true));
                this.position.setHalalCheckDate(new Timestamp(System.currentTimeMillis()));
                this.position.setHalalCheckUser((UserLight)((UserServiceManager)ServiceManagerRegistry.getService(UserServiceManager.class)).getCurrentUser());
                this.position.setHalalCheckComment("");
                this.position.setHalalCheckStatus(Boolean.valueOf(true));
                this.doSaveHalalSpotCheck();
            });
            this.checkHalalNotOk.addButtonListener((source, x, y) -> {
                this.position.setHalalChecked(Boolean.valueOf(true));
                this.position.setHalalCheckDate(new Timestamp(System.currentTimeMillis()));
                this.position.setHalalCheckUser((UserLight)((UserServiceManager)ServiceManagerRegistry.getService(UserServiceManager.class)).getCurrentUser());
                this.position.setHalalCheckStatus(Boolean.valueOf(false));
                InnerPopUp2 popUp = InnerPopUp2.getInnerPopUp();
                popUp.setAttributes(source, true, true, "Halal deviation comment");
                Node node = INodeCreator.getDefaultImpl().getNode4DTO((Object)this.position.getHalalCheckComment(), false, false);
                popUp.setView(new EnterMessagePopupInsert(node));
                InnerPopUpListener2 listener2 = (source1, xargs) -> {
                    if (xargs == null) {
                        this.position.setHalalCheckComment("");
                    } else {
                        this.position.setHalalCheckComment((String)node.getValue());
                        this.doSaveHalalSpotCheck();
                    }
                };
                popUp.showPopUp(x, y, 400, 400, listener2, source, PopupType.NORMAL);
            });
        }
        this.setText(text);
        this.viewPort.add(this.label);
        if (!this.infoOnly) {
            this.viewPort.add(this.checkHalalNotOk);
            this.viewPort.add(this.checkHalalOk);
        }
        this.scrollPane.setViewportView(this.viewPort);
        this.add(this.scrollPane);
        this.invalidate();
        this.validate();
    }

    private void saveData() {
        ThreadSafeExecutable run = new ThreadSafeExecutable(){

            @Override
            public Node<?> loadData() throws Exception {
                ((OrderServiceManager)ServiceManagerRegistry.getService(OrderServiceManager.class)).saveHalalCheck((PurchaseOrderPositionComplete)HalalCheckPopUpInsert.this.position);
                return null;
            }

            @Override
            public RemoteLoader getInvoker() {
                return new RemoteLoader(){

                    public void remoteObjectLoaded(Node<?> node) {
                        HalalCheckPopUpInsert.this.hideAnimation();
                        HalalCheckPopUpInsert.this.popup.enableOKButton(true);
                        HalalCheckPopUpInsert.this.label.setText("Halal Check saved");
                    }

                    public void errorOccurred(ClientException exception) {
                        HalalCheckPopUpInsert.this.hideAnimation();
                        HalalCheckPopUpInsert.this.popup.enableOKButton(true);
                        HalalCheckPopUpInsert.this.label.setText("Halal Check not saved");
                        InnerPopupFactory.showErrorDialog((Exception)((Object)exception), (Component)HalalCheckPopUpInsert.this);
                    }
                };
            }

            @Override
            public long getID() {
                return 0L;
            }
        };
        ThreadSafeLoader.run(run);
    }

    @Override
    public void kill() {
        if (this.isKilled()) {
            return;
        }
        super.kill();
        if (this.label != null) {
            this.label.kill();
            this.label = null;
        }
        if (this.loadingAnimation != null) {
            this.loadingAnimation.stop();
            this.loadingAnimation.kill();
            this.loadingAnimation = null;
        }
    }

    public void setText(String t) {
        if (this.label != null) {
            this.label.setLabelText(t);
        }
    }

    public String getText() {
        if (this.label != null) {
            return this.label.getText();
        }
        return "";
    }

    @Override
    public Object[] getValues(PopupAction isOK) {
        if (isOK == PopupAction.OK_FOREGROUND) {
            return new Object[1];
        }
        return null;
    }

    @Override
    public boolean isInnerComponent(Component c) {
        return false;
    }

    @Override
    public Dimension getPreferredSize() {
        return this.getLayout().preferredLayoutSize(this);
    }

    @Override
    public boolean tryToGrabFocus() {
        return false;
    }

    @Override
    public List<Component> getFocusComponents() {
        return null;
    }

    @Override
    public boolean isClosableWithEnter() {
        return false;
    }

    private class ViewPortLayout
    extends DefaultLayout {
        private ViewPortLayout() {
        }

        @Override
        public Dimension preferredLayoutSize(Container parent) {
            int w = (int)((double)HalalCheckPopUpInsert.this.scrollPane.getWidth() - HalalCheckPopUpInsert.this.scrollPane.getVerticalScrollBar().getPreferredSize().getWidth());
            int h = (int)HalalCheckPopUpInsert.this.label.getPreferredSize().getHeight();
            if (!HalalCheckPopUpInsert.this.infoOnly && HalalCheckPopUpInsert.this.checkHalalNotOk != null) {
                h += 5;
                h = (int)((double)h + HalalCheckPopUpInsert.this.checkHalalNotOk.getPreferredSize().getHeight());
            }
            if (HalalCheckPopUpInsert.this.loadingAnimation != null && (double)h < HalalCheckPopUpInsert.this.loadingAnimation.getPreferredSize().getHeight()) {
                h = (int)HalalCheckPopUpInsert.this.loadingAnimation.getPreferredSize().getHeight();
            }
            return new Dimension(w, h);
        }

        @Override
        public void layoutContainer(Container parent) {
            HalalCheckPopUpInsert.this.label.setLocation(0, 0);
            HalalCheckPopUpInsert.this.label.setSize(parent.getWidth(), (int)HalalCheckPopUpInsert.this.label.getPreferredSize().getHeight());
            if (HalalCheckPopUpInsert.this.loadingAnimation != null) {
                HalalCheckPopUpInsert.this.loadingAnimation.setSize(HalalCheckPopUpInsert.this.loadingAnimation.getPreferredSize());
                HalalCheckPopUpInsert.this.loadingAnimation.setLocation((parent.getWidth() - HalalCheckPopUpInsert.this.loadingAnimation.getWidth()) / 2, (parent.getHeight() - HalalCheckPopUpInsert.this.loadingAnimation.getHeight()) / 2);
            }
            if (!HalalCheckPopUpInsert.this.infoOnly) {
                if (HalalCheckPopUpInsert.this.checkHalalOk != null && HalalCheckPopUpInsert.this.checkHalalOk.getFader() != null && HalalCheckPopUpInsert.this.checkHalalOk.getFader().isFaded()) {
                    HalalCheckPopUpInsert.this.checkHalalOk.setLocation(5, HalalCheckPopUpInsert.this.label.getY() + HalalCheckPopUpInsert.this.label.getHeight() + 5);
                    HalalCheckPopUpInsert.this.checkHalalOk.setSize(HalalCheckPopUpInsert.this.checkHalalOk.getPreferredSize());
                }
                if (HalalCheckPopUpInsert.this.checkHalalNotOk != null && HalalCheckPopUpInsert.this.checkHalalNotOk.getFader() != null && HalalCheckPopUpInsert.this.checkHalalNotOk.getFader().isFaded()) {
                    HalalCheckPopUpInsert.this.checkHalalNotOk.setLocation((int)((double)parent.getWidth() - (5.0 + HalalCheckPopUpInsert.this.checkHalalNotOk.getPreferredSize().getWidth())), HalalCheckPopUpInsert.this.label.getY() + HalalCheckPopUpInsert.this.label.getHeight() + 5);
                    HalalCheckPopUpInsert.this.checkHalalNotOk.setSize(HalalCheckPopUpInsert.this.checkHalalNotOk.getPreferredSize());
                }
            }
        }
    }

    private class Port
    extends JComponent {
        private static final long serialVersionUID = 1L;

        private Port() {
        }

        @Override
        public void paint(Graphics g) {
            Graphics2D g2 = (Graphics2D)g;
            g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            g2.setColor(HalalCheckPopUpInsert.this.backgroundColor);
            g2.fillRect(0, 0, this.getWidth(), this.getHeight());
            this.paintChildren(g2);
        }
    }

    private class InnerLayout
    extends DefaultLayout {
        private InnerLayout() {
        }

        @Override
        public void layoutContainer(Container parent) {
            if (HalalCheckPopUpInsert.this.loadingAnimation != null) {
                HalalCheckPopUpInsert.this.loadingAnimation.setLocation((int)((double)parent.getWidth() - HalalCheckPopUpInsert.this.loadingAnimation.getPreferredSize().getWidth()) / 2, (int)(((double)parent.getHeight() - HalalCheckPopUpInsert.this.loadingAnimation.getPreferredSize().getHeight()) / 2.0));
                HalalCheckPopUpInsert.this.loadingAnimation.setSize(HalalCheckPopUpInsert.this.loadingAnimation.getPreferredSize());
            }
            if (HalalCheckPopUpInsert.this.scrollPane != null) {
                HalalCheckPopUpInsert.this.scrollPane.setLocation(0, 0);
                HalalCheckPopUpInsert.this.scrollPane.setSize(parent.getSize());
            }
        }

        @Override
        public Dimension preferredLayoutSize(Container parent) {
            Dimension d = new Dimension();
            if (HalalCheckPopUpInsert.this.userPrefHeight != null) {
                d.setSize(d.getWidth(), (double)HalalCheckPopUpInsert.this.userPrefHeight.intValue());
            } else if (HalalCheckPopUpInsert.this.viewPort != null) {
                d.setSize(d.getWidth(), HalalCheckPopUpInsert.this.viewPort.getPreferredSize().getHeight());
            } else {
                d.setSize(d.getWidth(), (double)(HalalCheckPopUpInsert.this.loadingAnimation.getHeight() + 10));
            }
            if (HalalCheckPopUpInsert.this.userPrefWidth != null) {
                d.setSize((double)HalalCheckPopUpInsert.this.userPrefWidth.intValue(), d.getHeight());
            } else if (HalalCheckPopUpInsert.this.viewPort != null) {
                d.setSize(HalalCheckPopUpInsert.this.viewPort.getPreferredSize().getWidth(), d.getHeight());
            } else {
                d.setSize(HalalCheckPopUpInsert.this.loadingAnimation.getPreferredSize().getWidth() + 10.0, d.getHeight());
            }
            return d;
        }
    }
}

