/*
 * Decompiled with CFR 0.152.
 */
package ch.icit.pegasus.client.gui.utils.popup.inserts;

import ch.icit.pegasus.client.gui.utils.AttributesConverter;
import ch.icit.pegasus.client.gui.utils.DefaultLayout;
import ch.icit.pegasus.client.gui.utils.ScrollPane;
import ch.icit.pegasus.client.gui.utils.popup.InnerPopUp2;
import ch.icit.pegasus.client.gui.utils.popup.inserts.PrintPopupInsert;
import ch.icit.pegasus.client.laf.LafLoader;
import java.awt.Color;
import java.awt.Container;
import java.awt.Dimension;
import javax.swing.JPanel;

public abstract class ScrollablePrintPopupInsert
extends PrintPopupInsert {
    private static final long serialVersionUID = 1L;
    private ScrollPane scrollPane;
    private JPanel viewPort = new JPanel();

    public ScrollablePrintPopupInsert() {
        super(false);
        this.scrollPane = new ScrollPane();
        Color c = AttributesConverter.getColor4String(LafLoader.getLafLoader().getAttribute("innerpopup_extension_background"));
        this.scrollPane.setScrollPaneBackground(c);
        this.scrollPane.setHorizontalScrollBarPolicy(31);
        this.scrollPane.setVerticalScrollBarPolicy(20);
        this.viewPort.setBackground(this.scrollPane.getBackground());
        this.scrollPane.setViewportView(this.viewPort);
        this.setLayout(new Layout());
        this.setViewContainer(this.viewPort);
        this.add(this.scrollPane);
    }

    @Override
    public void setEnabled(boolean isEnabled) {
        super.setEnabled(isEnabled);
        if (this.scrollPane != null) {
            this.scrollPane.setEnabled(isEnabled);
        }
    }

    @Override
    public void setInnerPopUp(InnerPopUp2 ip) {
        ip.setRightAlignment(5);
        super.setInnerPopUp(ip);
    }

    @Override
    public void kill() {
        if (this.isKilled()) {
            return;
        }
        super.kill();
        this.scrollPane.kill();
        this.scrollPane = null;
        this.remove(this.viewPort);
        this.viewPort = null;
    }

    private class Layout
    extends DefaultLayout {
        private Layout() {
        }

        @Override
        public void layoutContainer(Container parent) {
            ScrollablePrintPopupInsert.this.scrollPane.setLocation(0, 0);
            ScrollablePrintPopupInsert.this.scrollPane.setSize(parent.getSize());
        }

        @Override
        public Dimension preferredLayoutSize(Container parent) {
            return new Dimension(0, 0);
        }
    }
}

