/*
 * Decompiled with CFR 0.152.
 */
package ch.icit.pegasus.client.gui.utils.searchbox.objectbased;

import ch.icit.pegasus.client.comparators.controller.ComparatorRegistry;
import ch.icit.pegasus.client.converter.Converter;
import ch.icit.pegasus.client.gui.utils.AttributesConverter;
import ch.icit.pegasus.client.gui.utils.DefaultLayout;
import ch.icit.pegasus.client.gui.utils.ScrollPane;
import ch.icit.pegasus.client.gui.utils.buttons.Button;
import ch.icit.pegasus.client.gui.utils.combobox.activators.ActivationAdapter;
import ch.icit.pegasus.client.gui.utils.combobox.iconmapper.IconMapper;
import ch.icit.pegasus.client.gui.utils.combobox.utils.PopupInsertElement;
import ch.icit.pegasus.client.gui.utils.combobox.utils.PopupInsertsSorter;
import ch.icit.pegasus.client.gui.utils.popup.InnerPopUp2;
import ch.icit.pegasus.client.gui.utils.popup.PopUpInsert;
import ch.icit.pegasus.client.gui.utils.popup.PopupAction;
import ch.icit.pegasus.client.gui.utils.skins.Skin1Field;
import ch.icit.pegasus.client.laf.LafListener;
import ch.icit.pegasus.client.laf.LafLoader;
import ch.icit.pegasus.client.util.FlexList;
import ch.icit.pegasus.client.util.FlexListListener;
import ch.icit.pegasus.server.core.i18n.Words;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.event.AWTEventListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.JPanel;

public class DefaultListViewPopupInsertObjectBased
extends PopUpInsert
implements LafListener,
MouseMotionListener,
MouseListener,
FlexListListener {
    private static final long serialVersionUID = 1L;
    private List<PopupInsertElement> elements = new ArrayList<PopupInsertElement>();
    private int defaultEntryHeight = 25;
    private Color okOverBackgroundColor;
    private Color defaultBackgroundColor;
    private Color notOkOverBackgroundColor = new Color(51, 51, 51, 50);
    private Color okColor;
    private Color overOkColor;
    private Color deletedColor = Color.red;
    private Color deactivatedColor = Color.lightGray;
    private Color warningColor = Color.orange;
    private Color halalWarningForeground;
    private Font defaultFont;
    private Converter viewConverter;
    private InnerPopUp2 popup;
    private ScrollPane scrollPane;
    private JPanel viewPort;
    private Component invoker;
    private IconMapper iconMapper;
    private AWTEventListener awtListener;
    private boolean isWithALL;
    private boolean alwaysSelected = false;
    private Comparator<PopupInsertElement> sorter;
    private FlexList listNode;
    private ActivationAdapter activationAdapter;
    private PopupInsertElement currentSelectedItem;

    public DefaultListViewPopupInsertObjectBased(FlexList n, Converter viewConverter, Component invoker, Comparator c) {
        this.viewConverter = viewConverter;
        this.invoker = invoker;
        this.sorter = c;
        this.listNode = n;
        this.listNode.addFlexListener(this);
        this.scrollPane = new ScrollPane();
        this.scrollPane.setBorder(BorderFactory.createEmptyBorder());
        this.viewPort = new JPanel(){

            @Override
            public void paint(Graphics g) {
                Graphics2D g2 = (Graphics2D)g;
                g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
                g2.setColor(DefaultListViewPopupInsertObjectBased.this.popup.getExtensionColor());
                g2.fillRect(0, 0, this.getWidth(), this.getHeight());
                g2.setFont(DefaultListViewPopupInsertObjectBased.this.defaultFont);
                int currentY = 0;
                for (PopupInsertElement p : DefaultListViewPopupInsertObjectBased.this.elements) {
                    Color textColor = DefaultListViewPopupInsertObjectBased.this.okColor;
                    Color background = null;
                    switch (p.isActivated(DefaultListViewPopupInsertObjectBased.this.activationAdapter)) {
                        case DEACTIVATED: 
                        case CAN_NOT_CREATE_TRANSACTION: {
                            textColor = DefaultListViewPopupInsertObjectBased.this.deactivatedColor;
                            if (p.isOver()) {
                                background = DefaultListViewPopupInsertObjectBased.this.notOkOverBackgroundColor;
                                break;
                            }
                            background = DefaultListViewPopupInsertObjectBased.this.defaultBackgroundColor;
                            break;
                        }
                        case FATAL: {
                            textColor = DefaultListViewPopupInsertObjectBased.this.deletedColor;
                            if (p.isOver()) {
                                background = DefaultListViewPopupInsertObjectBased.this.notOkOverBackgroundColor;
                                break;
                            }
                            background = DefaultListViewPopupInsertObjectBased.this.defaultBackgroundColor;
                            break;
                        }
                        case OK: {
                            if (p.isOver()) {
                                textColor = DefaultListViewPopupInsertObjectBased.this.okColor;
                                background = DefaultListViewPopupInsertObjectBased.this.okOverBackgroundColor;
                                break;
                            }
                            textColor = DefaultListViewPopupInsertObjectBased.this.overOkColor;
                            background = DefaultListViewPopupInsertObjectBased.this.defaultBackgroundColor;
                            break;
                        }
                        case ALLERGEN_WARNING: {
                            textColor = DefaultListViewPopupInsertObjectBased.this.warningColor;
                            if (p.isOver()) {
                                background = DefaultListViewPopupInsertObjectBased.this.notOkOverBackgroundColor;
                                break;
                            }
                            background = DefaultListViewPopupInsertObjectBased.this.defaultBackgroundColor;
                            break;
                        }
                        case HALAL_WARNING: {
                            textColor = DefaultListViewPopupInsertObjectBased.this.halalWarningForeground;
                            if (p.isOver()) {
                                background = DefaultListViewPopupInsertObjectBased.this.notOkOverBackgroundColor;
                                break;
                            }
                            background = DefaultListViewPopupInsertObjectBased.this.defaultBackgroundColor;
                            break;
                        }
                    }
                    if (background != null) {
                        g2.setColor(background);
                        g2.fillRect(0, currentY, this.getWidth(), DefaultListViewPopupInsertObjectBased.this.defaultEntryHeight);
                    }
                    int space4Skin = 0;
                    Skin1Field skin = p.getPaintingSkin(DefaultListViewPopupInsertObjectBased.this.iconMapper);
                    if (skin != null) {
                        skin.paint(g2, this.getWidth() - 20, currentY + 3, Button.ButtonState.UP);
                        space4Skin = 20;
                    }
                    g2.setColor(textColor);
                    g2.drawString(p.getDisplayString(this.getWidth() - (10 + space4Skin), this.getFont(), this), 5, currentY + (DefaultListViewPopupInsertObjectBased.this.defaultEntryHeight + g2.getFont().getSize()) / 2);
                    currentY += DefaultListViewPopupInsertObjectBased.this.defaultEntryHeight;
                }
            }
        };
        this.lafAttributeChanged("All attribues changed");
        this.viewPort.setOpaque(false);
        this.viewPort.addMouseMotionListener(this);
        this.viewPort.addMouseListener(this);
        this.setOpaque(false);
        this.scrollPane.setViewportView(this.viewPort);
        this.viewPort.setLayout(new ViewPortLayout());
        this.scrollPane.setBackground(this.defaultBackgroundColor);
        this.scrollPane.setHorizontalScrollBarPolicy(31);
        this.scrollPane.getHorizontalScrollBar().setBackground(this.defaultBackgroundColor);
        this.scrollPane.getVerticalScrollBar().setBackground(this.defaultBackgroundColor);
        this.setList(this.listNode.iterator());
        this.setLayout(new Layout());
        this.add(this.scrollPane);
    }

    public void setAlwaysSelected(boolean b) {
        this.alwaysSelected = b;
    }

    public DefaultListViewPopupInsertObjectBased(FlexList n, Converter viewConverter, Component invoker) {
        this(n, viewConverter, invoker, null);
    }

    public ActivationAdapter getActivationAdapter() {
        return this.activationAdapter;
    }

    public void setActivationAdapter(ActivationAdapter activationAdapter) {
        this.activationAdapter = activationAdapter;
    }

    public boolean isWithALL() {
        return this.isWithALL;
    }

    public void setWithALL(boolean isWithALL) {
        this.isWithALL = isWithALL;
    }

    public void setIconMapper(IconMapper mapper) {
        this.iconMapper = mapper;
    }

    @Override
    public void kill() {
        if (this.isKilled()) {
            return;
        }
        super.kill();
        this.remove(this.scrollPane);
        this.elements.clear();
        this.viewPort = null;
        this.scrollPane = null;
        this.viewPort = null;
    }

    public int getDefaultEntryHeight() {
        return this.defaultEntryHeight;
    }

    public void closeIt(boolean escape) {
        if (escape) {
            this.popup.hidePopUp(new Object[0]);
        } else {
            this.popup.hidePopUp(this.getValues(PopupAction.OK_FOREGROUND));
        }
    }

    public void tryToSelectItemStartsWith(String t) {
        for (PopupInsertElement elemnt : this.elements) {
            if (!elemnt.getText().toLowerCase().startsWith(t.toLowerCase())) continue;
            this.highlightElement(elemnt);
            return;
        }
    }

    public void createSelectionEvent() {
        this.selectItemAndClose();
    }

    public void selectCurrentSelection(Object userObject) {
        for (PopupInsertElement e : this.elements) {
            e.setOver(e.getUserObject() == userObject);
            if (!e.isOver()) continue;
            this.currentSelectedItem = e;
        }
        this.viewPort.repaint(32L);
    }

    protected void checkScollNeedance() {
        int cy = this.elements.indexOf(this.currentSelectedItem);
        int sy = (int)this.scrollPane.getViewport().getViewPosition().getY();
        int sh = (int)this.scrollPane.getViewport().getVisibleRect().getHeight();
        if ((cy *= this.defaultEntryHeight) < sy) {
            this.scrollPane.getVerticalScrollBar().setValue(cy);
        } else if (cy + this.defaultEntryHeight > sy + sh) {
            this.scrollPane.getVerticalScrollBar().setValue(cy);
        }
    }

    private void doSelectLower() {
        if (this.currentSelectedItem == null) {
            if (this.elements.size() > 0) {
                this.elements.get(0).setOver(true);
                this.currentSelectedItem = this.elements.get(0);
            }
        } else {
            int i = this.elements.indexOf(this.currentSelectedItem);
            if (i < this.elements.size() - 1) {
                this.currentSelectedItem.setOver(false);
                this.currentSelectedItem = this.elements.get(++i);
                this.currentSelectedItem.setOver(true);
            }
        }
        this.checkScollNeedance();
        this.viewPort.repaint(32L);
    }

    public void selectLowerItem() {
        this.doSelectLower();
    }

    public void selectUpperItem() {
        this.doSelectUpper();
    }

    private void doSelectUpper() {
        if (this.currentSelectedItem == null) {
            if (this.elements.size() > 0) {
                this.currentSelectedItem = this.elements.get(0);
                this.currentSelectedItem.setOver(true);
            }
        } else {
            int i = this.elements.indexOf(this.currentSelectedItem);
            if (i > 0) {
                this.currentSelectedItem.setOver(false);
                this.currentSelectedItem = this.elements.get(--i);
                this.currentSelectedItem.setOver(true);
            }
        }
        this.checkScollNeedance();
        this.viewPort.repaint(32L);
    }

    public void setList(Iterator<Object> it) {
        while (it.hasNext()) {
            Object n = it.next();
            this.addItem(n);
        }
        if (this.sorter == null) {
            this.sorter = ComparatorRegistry.getComparator(PopupInsertsSorter.class);
        }
        Collections.sort(this.elements, this.sorter);
        this.viewPort.invalidate();
        this.viewPort.validate();
    }

    public void setSorter(Comparator so) {
        this.sorter = so;
    }

    private void addItem(Object n) {
        if (n == null) {
            PopupInsertElement element = new PopupInsertElement(n, Words.ALL);
            this.elements.add(element);
        } else {
            PopupInsertElement element = new PopupInsertElement(n, (String)this.viewConverter.convert(n, null, new Object[0]));
            this.elements.add(element);
        }
    }

    private void removeItem(Object n) {
        Iterator<PopupInsertElement> it = this.elements.iterator();
        while (it.hasNext()) {
            PopupInsertElement e = it.next();
            if (e.getUserObject() != n) continue;
            it.remove();
        }
    }

    @Override
    public Object[] getValues(PopupAction isOK) {
        if (isOK == PopupAction.CANCEL) {
            return null;
        }
        for (PopupInsertElement e : this.elements) {
            if (!e.isOver()) continue;
            Object[] o = new Object[]{e.getUserObject()};
            return o;
        }
        return null;
    }

    @Override
    public boolean isInnerComponent(Component c) {
        return c == this.invoker;
    }

    @Override
    public void setInnerPopUp(InnerPopUp2 ip) {
        this.popup = ip;
    }

    @Override
    public boolean tryToGrabFocus() {
        return false;
    }

    @Override
    public void lafAttributeChanged(String att) {
        this.okColor = AttributesConverter.getColor4String(LafLoader.getLafLoader().getAttribute("combobox.popup.foreground.ok.color"));
        this.deactivatedColor = AttributesConverter.getColor4String(LafLoader.getLafLoader().getAttribute("default_foreground_disabled_color"));
        this.warningColor = AttributesConverter.getColor4String(LafLoader.getLafLoader().getAttribute("combobox.popup.foreground.warning.color"));
        this.deletedColor = AttributesConverter.getColor4String(LafLoader.getLafLoader().getAttribute("combobox.popup.foreground.fatal.color"));
        this.halalWarningForeground = AttributesConverter.getColor4String(LafLoader.getLafLoader().getAttribute("default_halal_waring_string_color"));
        this.overOkColor = AttributesConverter.getColor4String(LafLoader.getLafLoader().getAttribute("combobox.popup.foreground.selected.ok.color"));
        this.notOkOverBackgroundColor = AttributesConverter.getColor4String(LafLoader.getLafLoader().getAttribute("combobox.popup.background.selected.notok.color"));
        this.okOverBackgroundColor = AttributesConverter.getColor4String(LafLoader.getLafLoader().getAttribute("combobox.popup.background.selected.ok.color"));
        this.defaultBackgroundColor = AttributesConverter.getColor4String(LafLoader.getLafLoader().getAttribute("inner_panel_background_color"));
        this.defaultFont = AttributesConverter.getFont4String(LafLoader.getLafLoader().getAttribute("default_font"), LafLoader.getLafLoader().getAttribute("comboBox_popUpList_font_size"), LafLoader.getLafLoader().getAttribute("comboBox_popUpList_font_type"));
    }

    @Override
    public void mouseDragged(MouseEvent e) {
    }

    @Override
    public void mouseMoved(MouseEvent e) {
        this.highlightElement(e.getY());
    }

    private void highlightElement(int y) {
        int a = y / this.defaultEntryHeight;
        int i = 0;
        for (PopupInsertElement e : this.elements) {
            e.setOver(a == i);
            if (e.isOver()) {
                this.currentSelectedItem = e;
            }
            ++i;
        }
        this.viewPort.repaint(32L);
    }

    private void highlightElement(PopupInsertElement element) {
        int count = 0;
        for (PopupInsertElement e : this.elements) {
            if (e == element) {
                this.currentSelectedItem = e;
                e.setOver(true);
                int h = this.defaultEntryHeight * count;
                this.scrollPane.getVerticalScrollBar().setValue(h);
            } else {
                e.setOver(false);
            }
            ++count;
        }
        this.viewPort.repaint(32L);
    }

    private void selectItemAndClose() {
        this.closeIt(false);
    }

    @Override
    public void mouseClicked(MouseEvent e) {
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
    }

    @Override
    public void mousePressed(MouseEvent e) {
    }

    @Override
    public void mouseReleased(MouseEvent e) {
        this.highlightElement(e.getY());
        this.selectItemAndClose();
    }

    @Override
    public List<Component> getFocusComponents() {
        return null;
    }

    @Override
    public boolean isClosableWithEnter() {
        return false;
    }

    @Override
    public void elementAdded(Object o) {
        if (this.isKilled()) {
            return;
        }
        this.addItem(o);
        this.viewPort.revalidate();
        this.repaint(32L);
    }

    @Override
    public void elementRemoved(Object o) {
        this.removeItem(o);
        this.invalidate();
        this.validate();
        this.revalidate();
        this.repaint(32L);
    }

    private class ViewPortLayout
    extends DefaultLayout {
        private ViewPortLayout() {
        }

        @Override
        public void layoutContainer(Container parent) {
        }

        @Override
        public Dimension preferredLayoutSize(Container parent) {
            int h = DefaultListViewPopupInsertObjectBased.this.elements.size() * DefaultListViewPopupInsertObjectBased.this.defaultEntryHeight;
            return new Dimension(0, h);
        }
    }

    private class Layout
    extends DefaultLayout {
        private Layout() {
        }

        @Override
        public void layoutContainer(Container parent) {
            DefaultListViewPopupInsertObjectBased.this.scrollPane.setLocation(0, 0);
            DefaultListViewPopupInsertObjectBased.this.scrollPane.setSize(parent.getWidth(), parent.getHeight());
        }

        @Override
        public Dimension preferredLayoutSize(Container parent) {
            int h = DefaultListViewPopupInsertObjectBased.this.elements.size() * DefaultListViewPopupInsertObjectBased.this.defaultEntryHeight;
            if (h > 100) {
                h = 100;
            }
            return new Dimension(20, h);
        }
    }
}

