/*
 * Decompiled with CFR 0.152.
 */
package ch.icit.pegasus.client.gui.utils.tabbed;

import ch.icit.pegasus.client.gui.utils.DefaultLayout;
import ch.icit.pegasus.client.gui.utils.buttons.Button;
import ch.icit.pegasus.client.gui.utils.buttons.ButtonListener;
import ch.icit.pegasus.client.gui.utils.panels.defaults.JPanelKillable;
import ch.icit.pegasus.client.gui.utils.tabbed.TabButton;
import ch.icit.pegasus.client.gui.utils.tabbed.TabListener;
import java.awt.Container;
import java.awt.Dimension;
import java.util.ArrayList;
import java.util.List;

public class TabbedButtonPanel
extends JPanelKillable
implements ButtonListener {
    private static final long serialVersionUID = -2827662507215518316L;
    private List<TabListener> listeners = new ArrayList<TabListener>();
    private List<Button> buttons = new ArrayList<Button>();
    private boolean usesPrefSize = true;

    public TabbedButtonPanel(boolean pref) {
        this.usesPrefSize = pref;
        this.setLayout(new TabbedButtonPanelLayout());
        this.setOpaque(false);
    }

    @Override
    public void setEnabled(boolean isEnabled) {
        for (Button b : this.buttons) {
            b.setEnabled(isEnabled);
        }
    }

    public void addTabListener(TabListener l) {
        this.listeners.add(l);
    }

    public void removeTabListener(TabListener l) {
        this.listeners.remove(l);
    }

    private void fireEvent(Button selectedButton) {
        for (TabListener l : this.listeners) {
            l.newTabSelected(selectedButton);
        }
    }

    @Override
    public void kill() {
        if (this.isKilled()) {
            return;
        }
        super.kill();
        this.listeners.clear();
        this.listeners = null;
        for (Button b : this.buttons) {
            b.kill();
        }
        this.buttons.clear();
        this.buttons = null;
    }

    public void addTabButton(TabButton b) {
        this.add(b);
        b.addButtonListener(this);
        this.buttons.add(b);
        if (this.buttons.size() == 1) {
            if (b instanceof TabButton) {
                b.setActive(true);
            } else {
                b.setState(Button.ButtonState.UP);
            }
        } else if (b instanceof TabButton) {
            b.setActive(false);
        } else {
            b.setState(Button.ButtonState.DISABLED);
        }
    }

    public void removeTabButton(TabButton b) {
        this.remove(b);
        b.removeButtonListener(this);
        this.buttons.remove(b);
    }

    @Override
    public void buttonPressed(Button source, int x, int y) {
        this.fireEvent(source);
        for (Button b : this.buttons) {
            if (b != source) {
                if (b instanceof TabButton) {
                    ((TabButton)b).setActive(false);
                    continue;
                }
                b.setState(Button.ButtonState.UP);
                continue;
            }
            if (b instanceof TabButton) {
                ((TabButton)b).setActive(true);
                continue;
            }
            b.setState(Button.ButtonState.DISABLED);
        }
    }

    public void clear() {
        for (Button b : this.buttons) {
            b.kill();
        }
        this.buttons.clear();
    }

    public void select(TabButton key) {
        this.buttonPressed(key, 0, 0);
    }

    private class TabbedButtonPanelLayout
    extends DefaultLayout {
        private TabbedButtonPanelLayout() {
        }

        @Override
        public void layoutContainer(Container parent) {
            int w = parent.getWidth();
            int h = parent.getHeight();
            int spacePerButton = w / (TabbedButtonPanel.this.buttons.size() > 0 ? TabbedButtonPanel.this.buttons.size() : 1);
            int currentX = 0;
            for (Button b : TabbedButtonPanel.this.buttons) {
                b.setLocation(currentX, (int)(((double)h - b.getPreferredSize().getHeight()) / 2.0));
                if (TabbedButtonPanel.this.usesPrefSize) {
                    b.setSize(b.getPreferredSize());
                } else {
                    b.setSize(spacePerButton, (int)b.getPreferredSize().getHeight());
                }
                currentX += b.getWidth();
            }
        }

        @Override
        public Dimension preferredLayoutSize(Container parent) {
            int maxWidth = 0;
            int maxHeight = 0;
            for (Button b : TabbedButtonPanel.this.buttons) {
                maxWidth = (int)((double)maxWidth + b.getPreferredSize().getWidth());
            }
            if (TabbedButtonPanel.this.buttons.size() > 0) {
                maxHeight = (int)((Button)TabbedButtonPanel.this.buttons.get(0)).getPreferredSize().getHeight();
            }
            return new Dimension(maxWidth, maxHeight);
        }
    }
}

