/*
 * Decompiled with CFR 0.152.
 */
package ch.icit.pegasus.client.gui.utils.tables;

import ch.icit.pegasus.client.converter.CostCenterConverter;
import ch.icit.pegasus.client.converter.CustomerCodeConverter;
import ch.icit.pegasus.client.converter.DateConverter;
import ch.icit.pegasus.client.converter.FlightCodeConverter;
import ch.icit.pegasus.client.converter.FlightDateConverter;
import ch.icit.pegasus.client.converter.LegListStringConverter;
import ch.icit.pegasus.client.converter.PurchaseOrderConverter;
import ch.icit.pegasus.client.converter.RequisitionOrderInvoiceConverter;
import ch.icit.pegasus.client.converter.StowingListNameConverter;
import ch.icit.pegasus.client.converter.SupplierConverter;
import ch.icit.pegasus.client.converter.TradeGoodsConverter;
import ch.icit.pegasus.client.converter.controller.ConverterRegistry;
import ch.icit.pegasus.client.gui.table.TableColumnInfo;
import ch.icit.pegasus.client.gui.table.renderer.CellViewFlightStateERenderer;
import ch.icit.pegasus.client.gui.table.renderer.CellViewModificationStateERenderer;
import ch.icit.pegasus.client.gui.table2.Table2;
import ch.icit.pegasus.client.gui.table2.Table2Model;
import ch.icit.pegasus.client.gui.table2.Table2RowModel;
import ch.icit.pegasus.client.gui.table2.Table2RowPanel;
import ch.icit.pegasus.client.gui.utils.CheckedListAdder;
import ch.icit.pegasus.client.gui.utils.DefaultLayout;
import ch.icit.pegasus.client.gui.utils.Killable;
import ch.icit.pegasus.client.gui.utils.TextLabel;
import ch.icit.pegasus.client.gui.utils.buttons.Button;
import ch.icit.pegasus.client.gui.utils.buttons.ButtonListener;
import ch.icit.pegasus.client.gui.utils.buttons.DeleteButton;
import ch.icit.pegasus.client.gui.utils.skins.SizedSkin1Field;
import ch.icit.pegasus.client.node.impls.ListNode;
import ch.icit.pegasus.client.node.impls.Node;
import ch.icit.pegasus.server.core.dtos.flightschedule.FlightLight;
import ch.icit.pegasus.server.core.dtos.flightschedule.FlightLight_;
import ch.icit.pegasus.server.core.dtos.masterdata.ModificationStateE;
import ch.icit.pegasus.server.core.dtos.ordering.OrderStateE;
import ch.icit.pegasus.server.core.dtos.ordering.PurchaseOrderComplete;
import ch.icit.pegasus.server.core.dtos.ordering.PurchaseOrderComplete_;
import ch.icit.pegasus.server.core.dtos.ordering.RequisitionOrderComplete_;
import ch.icit.pegasus.server.core.dtos.ordering.RequisitionOrderLight;
import ch.icit.pegasus.server.core.dtos.ordering.RequisitionOrderLight_;
import ch.icit.pegasus.server.core.dtos.tradegoods.TradeGoodsLight;
import ch.icit.pegasus.server.core.dtos.tradegoods.TradeGoodsLight_;
import ch.icit.pegasus.server.core.i18n.Words;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.util.ArrayList;
import java.util.List;

public class FlightSearchTable
extends Table2 {
    private static final long serialVersionUID = 1L;

    public FlightSearchTable() {
        super(false, "", true, false);
        ArrayList<TableColumnInfo> columns = new ArrayList<TableColumnInfo>();
        columns.add(new TableColumnInfo(Words.STATE, null, null, null, "", 108, 108, 108));
        columns.add(new TableColumnInfo(Words.FLIGHT_OUT_IN_BOUND, null, null, null, "", 80, Integer.MAX_VALUE, 80));
        columns.add(new TableColumnInfo(Words.DATE_OUT_IN_BOUND, null, null, null, "", TableColumnInfo.dateTimeColumnWidth * 2 + 10, TableColumnInfo.dateTimeColumnWidth * 2 + 10, TableColumnInfo.dateTimeColumnWidth * 2 + 10));
        columns.add(new TableColumnInfo(Words.LEGS, null, null, null, "", 80, Integer.MAX_VALUE, 80));
        columns.add(new TableColumnInfo(Words.CUSTOMER, null, null, null, "", TableColumnInfo.customerCodeWidth, TableColumnInfo.customerCodeWidth, TableColumnInfo.customerCodeWidth));
        columns.add(new TableColumnInfo(Words.STOWING, null, null, null, "", 100, Integer.MAX_VALUE, 100));
        int tw = 2 * this.getCellPadding() + DeleteButton.getPreferredWidth(SizedSkin1Field.SkinSize.SMALL);
        columns.add(new TableColumnInfo("", null, null, null, "", tw, tw, tw));
        ((TableColumnInfo)columns.get(0)).setxExpand(0.0);
        ((TableColumnInfo)columns.get(1)).setxExpand(0.4);
        ((TableColumnInfo)columns.get(2)).setxExpand(0.0);
        ((TableColumnInfo)columns.get(3)).setxExpand(0.3);
        ((TableColumnInfo)columns.get(4)).setxExpand(0.0);
        ((TableColumnInfo)columns.get(5)).setxExpand(0.3);
        ((TableColumnInfo)columns.get(6)).setxExpand(0.0);
        this.setModel(new Table2Model(columns, model1 -> new TableRowImpl(model1)));
        this.getModel().setNode((Node)new ListNode());
    }

    private class TableRowImpl
    extends Table2RowPanel
    implements ButtonListener {
        private static final long serialVersionUID = 1L;
        private Component state;
        private TextLabel flightNo;
        private TextLabel date;
        private TextLabel legs;
        private TextLabel customer;
        private TextLabel stowing;
        private DataType isFlight;
        private DeleteButton delete;

        public TableRowImpl(Table2RowModel m) {
            super(m);
            this.setUseControlSkin(Table2RowPanel.TableControlsType.TWO);
            if (m.getNode().getValue() instanceof FlightLight) {
                this.isFlight = DataType.Flight;
                FlightLight f = (FlightLight)m.getNode().getValue(FlightLight.class);
                this.state = new CellViewFlightStateERenderer(f);
                this.flightNo = new TextLabel(m.getNode(), ConverterRegistry.getConverter(FlightCodeConverter.class));
                this.date = new TextLabel(m.getNode(), ConverterRegistry.getConverter(FlightDateConverter.class));
                this.legs = new TextLabel(m.getNode().getChildNamed(FlightLight_.legs), ConverterRegistry.getConverter(LegListStringConverter.class));
                this.customer = new TextLabel(m.getNode().getChildNamed(FlightLight_.customer), ConverterRegistry.getConverter(CustomerCodeConverter.class));
                this.stowing = new TextLabel(m.getNode().getChildNamed(FlightLight_.activeStowingList), ConverterRegistry.getConverter(StowingListNameConverter.class));
            } else if (m.getNode().getValue() instanceof TradeGoodsLight) {
                this.isFlight = DataType.TradeGoods;
                TradeGoodsLight f = (TradeGoodsLight)m.getNode().getValue(TradeGoodsLight.class);
                this.state = new CellViewModificationStateERenderer(f.getState());
                this.flightNo = new TextLabel(m.getNode(), ConverterRegistry.getConverter(TradeGoodsConverter.class));
                this.date = new TextLabel(m.getNode().getChildNamed(TradeGoodsLight_.sellDate), ConverterRegistry.getConverter(DateConverter.class));
                this.legs = new TextLabel();
                this.customer = new TextLabel(m.getNode().getChildNamed(TradeGoodsLight_.customer), ConverterRegistry.getConverter(CustomerCodeConverter.class));
                this.stowing = new TextLabel();
            } else if (m.getNode().getValue() instanceof RequisitionOrderLight) {
                this.isFlight = DataType.Requisition;
                RequisitionOrderLight f = (RequisitionOrderLight)m.getNode().getValue(RequisitionOrderLight.class);
                this.state = new CellViewModificationStateERenderer(f.getReceiveState() == OrderStateE.CLOSED ? ModificationStateE.ACCEPTED : ModificationStateE.DRAFT);
                this.flightNo = new TextLabel(m.getNode(), ConverterRegistry.getConverter(RequisitionOrderInvoiceConverter.class));
                this.date = new TextLabel(m.getNode().getChildNamed(RequisitionOrderLight_.lastReceived), ConverterRegistry.getConverter(DateConverter.class));
                this.legs = new TextLabel();
                this.customer = new TextLabel(m.getNode().getChildNamed(RequisitionOrderLight_.requiredBy), ConverterRegistry.getConverter(CostCenterConverter.class));
                this.stowing = new TextLabel(Words.REQUISITION_ORDER);
            } else if (m.getNode().getValue() instanceof PurchaseOrderComplete) {
                this.isFlight = DataType.Purchase;
                PurchaseOrderComplete f = (PurchaseOrderComplete)m.getNode().getValue(PurchaseOrderComplete.class);
                this.state = new CellViewModificationStateERenderer(f.getState() == OrderStateE.CLOSED ? ModificationStateE.ACCEPTED : ModificationStateE.DRAFT);
                this.flightNo = new TextLabel(m.getNode(), ConverterRegistry.getConverter(PurchaseOrderConverter.class));
                this.date = new TextLabel(m.getNode().getChildNamed(PurchaseOrderComplete_.lastReceived), ConverterRegistry.getConverter(DateConverter.class));
                this.legs = new TextLabel(m.getNode().getChildNamed(PurchaseOrderComplete_.supplier), ConverterRegistry.getConverter(SupplierConverter.class));
                this.customer = new TextLabel(m.getNode().getChildNamed(PurchaseOrderComplete_.customer), ConverterRegistry.getConverter(CostCenterConverter.class));
                this.stowing = new TextLabel(Words.PURCHASE_ORDER);
            }
            this.delete = new DeleteButton();
            this.delete.addButtonListener(this);
            this.setLayout(new Layout());
            this.add(this.state);
            this.add(this.flightNo);
            this.add(this.date);
            this.add(this.legs);
            this.add(this.customer);
            this.add(this.stowing);
            this.add(this.delete);
        }

        @Override
        public List<Component> getFocusComponents() {
            ArrayList<Component> a = new ArrayList<Component>();
            CheckedListAdder.addToList(a, this.delete);
            return a;
        }

        @Override
        public Object getObject4Column(int column) {
            switch (column) {
                case 0: {
                    switch (this.isFlight) {
                        case Flight: {
                            return this.model.getNode().getChildNamed(FlightLight_.flightState).getValue();
                        }
                        case Purchase: {
                            return this.model.getNode().getChildNamed(PurchaseOrderComplete_.state).getValue();
                        }
                        case Requisition: {
                            return this.model.getNode().getChildNamed(RequisitionOrderComplete_.receiveState).getValue();
                        }
                        case TradeGoods: {
                            return this.model.getNode().getChildNamed(TradeGoodsLight_.state).getValue();
                        }
                    }
                }
                case 1: {
                    return this.flightNo.getText();
                }
                case 2: {
                    return this.date.getNode().getValue();
                }
                case 3: {
                    return this.legs.getText();
                }
                case 4: {
                    return this.customer.getText();
                }
                case 5: {
                    return this.stowing.getText();
                }
            }
            return null;
        }

        @Override
        public void setEnabled(boolean isEnabled) {
            super.setEnabled(isEnabled);
            this.state.setEnabled(isEnabled);
            this.flightNo.setEnabled(isEnabled);
            this.date.setEnabled(isEnabled);
            this.legs.setEnabled(isEnabled);
            this.customer.setEnabled(isEnabled);
            this.stowing.setEnabled(isEnabled);
            this.delete.setEnabled(isEnabled);
        }

        @Override
        public void kill() {
            if (this.isKilled()) {
                return;
            }
            super.kill();
            if (this.state instanceof Killable) {
                ((Killable)((Object)this.state)).kill();
            }
            this.state = null;
            this.flightNo.kill();
            this.flightNo = null;
            this.date.kill();
            this.date = null;
            this.legs.kill();
            this.legs = null;
            this.customer.kill();
            this.customer = null;
            this.stowing.kill();
            this.stowing = null;
            this.delete.kill();
            this.delete = null;
        }

        @Override
        public void buttonPressed(Button source, int x, int y) {
            if (source == this.delete) {
                this.model.getNode().getParent().removeChild(this.model.getNode(), 0L);
            }
        }

        private class Layout
        extends DefaultLayout {
            private Layout() {
            }

            @Override
            public Dimension preferredLayoutSize(Container parent) {
                return new Dimension(0, TableRowImpl.this.getDefaultRowHeight());
            }

            @Override
            public void layoutContainer(Container parent) {
                int w = TableRowImpl.this.model.getParentModel().getColumnWidth(0);
                int currentX = 0;
                TableRowImpl.this.state.setLocation(currentX + TableRowImpl.this.getCellPadding(), (int)(((double)parent.getHeight() - TableRowImpl.this.state.getPreferredSize().getHeight()) / 2.0));
                TableRowImpl.this.state.setSize(w - 2 * TableRowImpl.this.getCellPadding(), (int)TableRowImpl.this.state.getPreferredSize().getHeight());
                currentX += w;
                w = TableRowImpl.this.model.getParentModel().getColumnWidth(1);
                TableRowImpl.this.flightNo.setLocation(currentX + TableRowImpl.this.getCellPadding(), (int)(((double)parent.getHeight() - TableRowImpl.this.flightNo.getPreferredSize().getHeight()) / 2.0));
                TableRowImpl.this.flightNo.setSize(w - 2 * TableRowImpl.this.getCellPadding(), (int)TableRowImpl.this.flightNo.getPreferredSize().getHeight());
                currentX += w;
                w = TableRowImpl.this.model.getParentModel().getColumnWidth(2);
                TableRowImpl.this.date.setLocation(currentX + TableRowImpl.this.getCellPadding(), (int)(((double)parent.getHeight() - TableRowImpl.this.date.getPreferredSize().getHeight()) / 2.0));
                TableRowImpl.this.date.setSize(w - 2 * TableRowImpl.this.getCellPadding(), (int)TableRowImpl.this.date.getPreferredSize().getHeight());
                currentX += w;
                w = TableRowImpl.this.model.getParentModel().getColumnWidth(3);
                TableRowImpl.this.legs.setLocation(currentX + TableRowImpl.this.getCellPadding(), (int)(((double)parent.getHeight() - TableRowImpl.this.legs.getPreferredSize().getHeight()) / 2.0));
                TableRowImpl.this.legs.setSize(w - 2 * TableRowImpl.this.getCellPadding(), (int)TableRowImpl.this.legs.getPreferredSize().getHeight());
                currentX += w;
                w = TableRowImpl.this.model.getParentModel().getColumnWidth(4);
                TableRowImpl.this.customer.setLocation(currentX + TableRowImpl.this.getCellPadding(), (int)(((double)parent.getHeight() - TableRowImpl.this.customer.getPreferredSize().getHeight()) / 2.0));
                TableRowImpl.this.customer.setSize(w - 2 * TableRowImpl.this.getCellPadding(), (int)TableRowImpl.this.customer.getPreferredSize().getHeight());
                currentX += w;
                w = TableRowImpl.this.model.getParentModel().getColumnWidth(5);
                TableRowImpl.this.stowing.setLocation(currentX + TableRowImpl.this.getCellPadding(), (int)(((double)parent.getHeight() - TableRowImpl.this.stowing.getPreferredSize().getHeight()) / 2.0));
                TableRowImpl.this.stowing.setSize(w - 2 * TableRowImpl.this.getCellPadding(), (int)TableRowImpl.this.stowing.getPreferredSize().getHeight());
                currentX += w;
                w = TableRowImpl.this.model.getParentModel().getColumnWidth(6);
                TableRowImpl.this.setControlsX(currentX);
                TableRowImpl.this.delete.setLocation(currentX + TableRowImpl.this.getCellPadding(), (int)(((double)parent.getHeight() - TableRowImpl.this.delete.getPreferredSize().getHeight()) / 2.0));
                TableRowImpl.this.delete.setSize(TableRowImpl.this.delete.getPreferredSize());
            }
        }
    }

    private static enum DataType {
        Flight,
        TradeGoods,
        Requisition,
        Purchase;

    }
}

