/*
 * Decompiled with CFR 0.152.
 */
package ch.icit.pegasus.client.gui.utils.tables;

import ch.icit.pegasus.client.converter.FlightCategoryConverter;
import ch.icit.pegasus.client.converter.HaulTypeConverter;
import ch.icit.pegasus.client.converter.IndexedColorsConverter;
import ch.icit.pegasus.client.converter.controller.ConverterRegistry;
import ch.icit.pegasus.client.gui.table.TableColumnInfo;
import ch.icit.pegasus.client.gui.table2.Table2;
import ch.icit.pegasus.client.gui.table2.Table2ButtonHandler;
import ch.icit.pegasus.client.gui.table2.Table2Model;
import ch.icit.pegasus.client.gui.table2.Table2RowModel;
import ch.icit.pegasus.client.gui.table2.Table2RowPanel;
import ch.icit.pegasus.client.gui.utils.CheckedListAdder;
import ch.icit.pegasus.client.gui.utils.DefaultLayout;
import ch.icit.pegasus.client.gui.utils.buttons.Button;
import ch.icit.pegasus.client.gui.utils.buttons.ButtonListener;
import ch.icit.pegasus.client.gui.utils.buttons.DeleteButton;
import ch.icit.pegasus.client.gui.utils.combobox.ComboBox;
import ch.icit.pegasus.client.gui.utils.searchbox.SearchTextField2;
import ch.icit.pegasus.client.gui.utils.searchbox.SearchTextField2Factory;
import ch.icit.pegasus.client.gui.utils.skins.SizedSkin1Field;
import ch.icit.pegasus.client.node.INodeCreator;
import ch.icit.pegasus.client.node.impls.Node;
import ch.icit.pegasus.client.node.impls.NodeToolkit;
import ch.icit.pegasus.server.core.dtos.ADTO;
import ch.icit.pegasus.server.core.dtos.masterdata.FlightCategoryComplete;
import ch.icit.pegasus.server.core.dtos.masterdata.HaulTypeComplete;
import ch.icit.pegasus.server.core.dtos.report.KitchenReadyTimeColorDefinitionComplete;
import ch.icit.pegasus.server.core.dtos.report.KitchenReadyTimeColorDefinitionComplete_;
import ch.icit.pegasus.server.core.dtos.supply.CustomerLight;
import ch.icit.pegasus.server.core.i18n.Words;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.util.ArrayList;
import java.util.List;

public class KitchenReadyTimeColorDefinitionEditTable
extends Table2 {
    private static final long serialVersionUID = 1L;

    public KitchenReadyTimeColorDefinitionEditTable() {
        super(true, Words.ADD, true, true, Words.EXCEL_REPORT_COLOR_SETTINGS);
        this.setButtonHandler(new Table2ButtonHandler(){

            @Override
            public void childRemoved() {
                KitchenReadyTimeColorDefinitionEditTable.this.revalidate();
            }

            @Override
            public void addButtonPressed(int x, int y, Button source) {
                KitchenReadyTimeColorDefinitionComplete c = new KitchenReadyTimeColorDefinitionComplete();
                c.setClientOId(Long.valueOf(ADTO.getNextId()));
                Node node = INodeCreator.getDefaultImpl().getNode4DTO((Object)c, true, false);
                KitchenReadyTimeColorDefinitionEditTable.this.getModel().getNode().addChild(node, 0L);
                KitchenReadyTimeColorDefinitionEditTable.this.getParent().revalidate();
            }
        });
        ArrayList<TableColumnInfo> columns = new ArrayList<TableColumnInfo>();
        columns.add(new TableColumnInfo(Words.COLOR, null, null, null, "", 40, 40, 40));
        columns.add(new TableColumnInfo(Words.FLIGHT_CATEGORY, null, null, null, "", 80, 80, 80));
        columns.add(new TableColumnInfo(Words.CUSTOMER, null, null, null, "", 80, 80, 80));
        columns.add(new TableColumnInfo(Words.HAUL_TYPE, null, null, null, "", 80, 80, 80));
        int tw = 2 * this.getCellPadding() + DeleteButton.getPreferredWidth(SizedSkin1Field.SkinSize.MEDIUM);
        columns.add(new TableColumnInfo("", null, null, null, "", tw, tw, tw));
        ((TableColumnInfo)columns.get(0)).setxExpand(0.25);
        ((TableColumnInfo)columns.get(1)).setxExpand(0.25);
        ((TableColumnInfo)columns.get(2)).setxExpand(0.25);
        ((TableColumnInfo)columns.get(3)).setxExpand(0.25);
        ((TableColumnInfo)columns.get(4)).setxExpand(0.0);
        this.setModel(new Table2Model(columns, model1 -> new TableRowImpl(model1)));
    }

    public void setNode(Node<List<KitchenReadyTimeColorDefinitionComplete>> node) {
        this.getModel().setNode(node);
    }

    @Deprecated
    private static enum IndexedColors {
        BLACK1(0),
        WHITE1(1),
        RED1(2),
        BRIGHT_GREEN1(3),
        BLUE1(4),
        YELLOW1(5),
        PINK1(6),
        TURQUOISE1(7),
        BLACK(8),
        WHITE(9),
        RED(10),
        BRIGHT_GREEN(11),
        BLUE(12),
        YELLOW(13),
        PINK(14),
        TURQUOISE(15),
        DARK_RED(16),
        GREEN(17),
        DARK_BLUE(18),
        DARK_YELLOW(19),
        VIOLET(20),
        TEAL(21),
        GREY_25_PERCENT(22),
        GREY_50_PERCENT(23),
        CORNFLOWER_BLUE(24),
        MAROON(25),
        LEMON_CHIFFON(26),
        LIGHT_TURQUOISE1(27),
        ORCHID(28),
        CORAL(29),
        ROYAL_BLUE(30),
        LIGHT_CORNFLOWER_BLUE(31),
        SKY_BLUE(40),
        LIGHT_TURQUOISE(41),
        LIGHT_GREEN(42),
        LIGHT_YELLOW(43),
        PALE_BLUE(44),
        ROSE(45),
        LAVENDER(46),
        TAN(47),
        LIGHT_BLUE(48),
        AQUA(49),
        LIME(50),
        GOLD(51),
        LIGHT_ORANGE(52),
        ORANGE(53),
        BLUE_GREY(54),
        GREY_40_PERCENT(55),
        DARK_TEAL(56),
        SEA_GREEN(57),
        DARK_GREEN(58),
        OLIVE_GREEN(59),
        BROWN(60),
        PLUM(61),
        INDIGO(62),
        GREY_80_PERCENT(63),
        AUTOMATIC(64);

        private static final IndexedColors[] _values;
        public final short index;

        private IndexedColors(int idx) {
            this.index = (short)idx;
        }

        public short getIndex() {
            return this.index;
        }

        static {
            _values = new IndexedColors[65];
            IndexedColors[] indexedColorsArray = IndexedColors.values();
            int n = indexedColorsArray.length;
            for (int i = 0; i < n; ++i) {
                IndexedColors color;
                IndexedColors._values[color.index] = color = indexedColorsArray[i];
            }
        }
    }

    private class TableRowImpl
    extends Table2RowPanel
    implements ButtonListener {
        private static final long serialVersionUID = 1L;
        private ComboBox color;
        private ComboBox category;
        private SearchTextField2<CustomerLight> customer;
        private ComboBox haulType;
        private DeleteButton delete;

        public TableRowImpl(Table2RowModel m) {
            super(m);
            ArrayList<Short> data = new ArrayList<Short>();
            for (IndexedColors colors : IndexedColors.values()) {
                data.add(colors.getIndex());
            }
            Node nodes = INodeCreator.getDefaultImpl().createNodes(data, false);
            this.color = new ComboBox(m.getNode().getChildNamed(KitchenReadyTimeColorDefinitionComplete_.colorIndex), nodes, ConverterRegistry.getConverter(IndexedColorsConverter.class));
            this.category = new ComboBox(m.getNode().getChildNamed(KitchenReadyTimeColorDefinitionComplete_.category), NodeToolkit.getAffixList(FlightCategoryComplete.class), ConverterRegistry.getConverter(FlightCategoryConverter.class));
            this.category.addItem(Words.ALL);
            if (m.getNode() != null && ((KitchenReadyTimeColorDefinitionComplete)m.getNode().getValue()).getCategory() == null) {
                this.category.setSelectedItem(Words.ALL);
            }
            this.customer = SearchTextField2Factory.getCustomerSearchField(true, null);
            this.customer.setNode(m.getNode().getChildNamed(KitchenReadyTimeColorDefinitionComplete_.customer));
            this.haulType = new ComboBox(m.getNode().getChildNamed(KitchenReadyTimeColorDefinitionComplete_.haulType), NodeToolkit.getAffixList(HaulTypeComplete.class), ConverterRegistry.getConverter(HaulTypeConverter.class));
            this.haulType.addItem(Words.ALL);
            if (m.getNode() != null && ((KitchenReadyTimeColorDefinitionComplete)m.getNode().getValue()).getHaulType() == null) {
                this.haulType.setSelectedItem(Words.ALL);
            }
            this.delete = new DeleteButton();
            this.delete.addButtonListener(this);
            this.setLayout(new Layout());
            this.add(this.color);
            this.add(this.category);
            this.add(this.customer);
            this.add(this.haulType);
            this.add(this.delete);
        }

        @Override
        public void buttonPressed(Button source, int x, int y) {
            if (source == this.delete) {
                this.model.getNode().getParent().removeChild(this.model.getNode(), 0L);
            } else {
                this.setEnabled(this.isEnabled());
            }
        }

        @Override
        public void kill() {
            if (this.isKilled()) {
                return;
            }
            super.kill();
            this.color.kill();
            this.category.kill();
            this.customer.kill();
            this.haulType.kill();
            this.delete.kill();
            this.color = null;
            this.category = null;
            this.customer = null;
            this.haulType = null;
            this.delete = null;
        }

        @Override
        public List<Component> getFocusComponents() {
            ArrayList<Component> a = new ArrayList<Component>();
            CheckedListAdder.addToList(a, this.color);
            CheckedListAdder.addToList(a, this.category);
            CheckedListAdder.addToList(a, this.customer);
            CheckedListAdder.addToList(a, this.haulType);
            CheckedListAdder.addToList(a, this.delete);
            return a;
        }

        @Override
        public Object getObject4Column(int column) {
            return null;
        }

        private class Layout
        extends DefaultLayout {
            private Layout() {
            }

            @Override
            public Dimension preferredLayoutSize(Container parent) {
                return new Dimension(0, TableRowImpl.this.getDefaultRowHeight());
            }

            @Override
            public void layoutContainer(Container parent) {
                int currentX = 0;
                int w = TableRowImpl.this.model.getParentModel().getColumnWidth(0);
                TableRowImpl.this.color.setLocation(currentX + TableRowImpl.this.getCellPadding(), (int)(((double)parent.getHeight() - TableRowImpl.this.color.getPreferredSize().getHeight()) / 2.0));
                TableRowImpl.this.color.setSize(w - 2 * TableRowImpl.this.getCellPadding(), (int)TableRowImpl.this.color.getPreferredSize().getHeight());
                currentX += w;
                w = TableRowImpl.this.model.getParentModel().getColumnWidth(1);
                TableRowImpl.this.category.setLocation(currentX + TableRowImpl.this.getCellPadding(), (int)(((double)parent.getHeight() - TableRowImpl.this.category.getPreferredSize().getHeight()) / 2.0));
                TableRowImpl.this.category.setSize(w - 2 * TableRowImpl.this.getCellPadding(), (int)TableRowImpl.this.category.getPreferredSize().getHeight());
                currentX += w;
                w = TableRowImpl.this.model.getParentModel().getColumnWidth(2);
                TableRowImpl.this.customer.setLocation(currentX + TableRowImpl.this.getCellPadding(), (int)(((double)parent.getHeight() - TableRowImpl.this.customer.getPreferredSize().getHeight()) / 2.0));
                TableRowImpl.this.customer.setSize(w - 2 * TableRowImpl.this.getCellPadding(), (int)TableRowImpl.this.customer.getPreferredSize().getHeight());
                currentX += w;
                w = TableRowImpl.this.model.getParentModel().getColumnWidth(2);
                TableRowImpl.this.haulType.setLocation(currentX + TableRowImpl.this.getCellPadding(), (int)(((double)parent.getHeight() - TableRowImpl.this.haulType.getPreferredSize().getHeight()) / 2.0));
                TableRowImpl.this.haulType.setSize(w - 2 * TableRowImpl.this.getCellPadding(), (int)TableRowImpl.this.haulType.getPreferredSize().getHeight());
                currentX += w;
                w = TableRowImpl.this.model.getParentModel().getColumnWidth(2);
                TableRowImpl.this.delete.setLocation(currentX + TableRowImpl.this.getCellPadding(), (int)(((double)parent.getHeight() - TableRowImpl.this.delete.getPreferredSize().getHeight()) / 2.0));
                TableRowImpl.this.delete.setSize(TableRowImpl.this.delete.getPreferredSize());
            }
        }
    }
}

