/*
 * Decompiled with CFR 0.152.
 */
package ch.icit.pegasus.client.gui.utils.tables;

import ch.icit.pegasus.client.converter.IntegerConverter;
import ch.icit.pegasus.client.converter.QuantityConverter2Decimal;
import ch.icit.pegasus.client.converter.StorePositionShortNameConverter;
import ch.icit.pegasus.client.converter.StringConverter;
import ch.icit.pegasus.client.converter.controller.ConverterRegistry;
import ch.icit.pegasus.client.gui.table.TableColumnInfo;
import ch.icit.pegasus.client.gui.table2.PageableTable2;
import ch.icit.pegasus.client.gui.table2.Table2Model;
import ch.icit.pegasus.client.gui.table2.Table2RowModel;
import ch.icit.pegasus.client.gui.table2.Table2RowPanel;
import ch.icit.pegasus.client.gui.utils.DefaultLayout;
import ch.icit.pegasus.client.gui.utils.TextLabel;
import ch.icit.pegasus.client.gui.utils.buttons.EditButton;
import ch.icit.pegasus.client.node.impls.Node;
import ch.icit.pegasus.client.search.SearchAlgorithm;
import ch.icit.pegasus.client.search.controller.SearchAlgorithmRegistry;
import ch.icit.pegasus.client.search.impls.remote.ProductionTransactionSearchAlgorithm;
import ch.icit.pegasus.server.core.dtos.ADTO;
import ch.icit.pegasus.server.core.dtos.inventory.InventoryLight;
import ch.icit.pegasus.server.core.dtos.masterdata.StoreQuantityComplete;
import ch.icit.pegasus.server.core.dtos.store.StorePositionLight;
import ch.icit.pegasus.server.core.general.ASearchConfiguration;
import ch.icit.pegasus.server.core.i18n.Words;
import java.awt.Color;
import java.awt.Container;
import java.awt.Dimension;
import java.util.ArrayList;

public abstract class ProductionInventorySearchTable
extends PageableTable2 {
    private InventoryLight inventory;
    private static final String FILTER_NAME_NUMBER = "Name/Number";
    private String filterName;

    public ProductionInventorySearchTable(String title) {
        super(title, true, false, false);
        ArrayList<TableColumnInfo> headers = new ArrayList<TableColumnInfo>();
        headers.add(new TableColumnInfo("Number", null, null, null, "", TableColumnInfo.numberColumnWidth));
        headers.add(new TableColumnInfo("Name", null, null, null, "", 50, Integer.MAX_VALUE, 50));
        headers.add(new TableColumnInfo("Charge", null, null, null, "", TableColumnInfo.numberColumnWidth));
        headers.add(new TableColumnInfo("Position", null, null, null, "", TableColumnInfo.costCenter));
        headers.add(new TableColumnInfo("Quantity", null, null, null, "", TableColumnInfo.dateTimeColumnWidth));
        ((TableColumnInfo)headers.get(0)).setxExpand(0.0);
        ((TableColumnInfo)headers.get(1)).setxExpand(1.0);
        ((TableColumnInfo)headers.get(2)).setxExpand(0.0);
        ((TableColumnInfo)headers.get(3)).setxExpand(0.0);
        ((TableColumnInfo)headers.get(4)).setxExpand(0.0);
        this.setModel(new Table2Model(headers, model -> this.createRow(model)));
    }

    public void setInventory(InventoryLight inventory) {
        this.inventory = inventory;
    }

    @Override
    public void fillFilterChain() {
        this.filterChain.addSeachField(FILTER_NAME_NUMBER, Words.NAME_OR_NUMBER);
    }

    @Override
    public ASearchConfiguration<? extends ADTO, ? extends Enum<?>> filterValueChanged(String id, Object value) {
        return this.filterChainValueChanged(id, value);
    }

    public abstract ASearchConfiguration<? extends ADTO, ? extends Enum<?>> filterChainValueChanged(String var1, Object var2);

    @Override
    public SearchAlgorithm getSearchAlgorithm() {
        return SearchAlgorithmRegistry.getSearchAlgorithm(ProductionTransactionSearchAlgorithm.class);
    }

    private Table2RowPanel createRow(Table2RowModel m) {
        return new TableRowImpl(m);
    }

    public abstract void editQuantity(EditButton var1, Node var2, int var3, int var4, TableRowImpl var5);

    public abstract Node<Integer> getNumberField(Table2RowModel var1);

    public abstract Node<String> getNameField(Table2RowModel var1);

    public abstract Node<Integer> getChargeField(Table2RowModel var1);

    public abstract Node<StorePositionLight> getPositionField(Table2RowModel var1);

    public abstract Node<StoreQuantityComplete> getQuantityField(Table2RowModel var1);

    public class TableRowImpl
    extends Table2RowPanel {
        private TextLabel number;
        private TextLabel name;
        private TextLabel charge;
        private TextLabel position;
        private TextLabel quantity;
        private EditButton editQty;

        public TableRowImpl(Table2RowModel m) {
            super(m);
            this.number = new TextLabel(ProductionInventorySearchTable.this.getNumberField(m), ConverterRegistry.getConverter(IntegerConverter.class));
            this.name = new TextLabel(ProductionInventorySearchTable.this.getNameField(m), ConverterRegistry.getConverter(StringConverter.class));
            this.charge = new TextLabel(ProductionInventorySearchTable.this.getChargeField(m), ConverterRegistry.getConverter(IntegerConverter.class));
            this.position = new TextLabel(ProductionInventorySearchTable.this.getPositionField(m), ConverterRegistry.getConverter(StorePositionShortNameConverter.class));
            this.quantity = new TextLabel(ProductionInventorySearchTable.this.getQuantityField(m), ConverterRegistry.getConverter(QuantityConverter2Decimal.class));
            this.editQty = new EditButton();
            this.editQty.addButtonListener((source, x, y) -> ProductionInventorySearchTable.this.editQuantity(this.editQty, this.model.getNode(), x, y, this));
            this.setLayout(new RowLayout());
            this.add(this.number);
            this.add(this.name);
            this.add(this.charge);
            this.add(this.position);
            this.add(this.quantity);
            this.add(this.editQty);
        }

        @Override
        public Object getObject4Column(int column) {
            return null;
        }

        public void setLeftUpperCornerPainting(boolean showUpperCorner, Color color) {
            this.quantity.setLeftUpperCornerPainting(showUpperCorner, color);
        }

        private class RowLayout
        extends DefaultLayout {
            private RowLayout() {
            }

            @Override
            public Dimension preferredLayoutSize(Container parent) {
                return new Dimension(0, TableRowImpl.this.getDefaultRowHeight());
            }

            @Override
            public void layoutContainer(Container parent) {
                int currentX = 0;
                int w = TableRowImpl.this.model.getParentModel().getColumnWidth(0);
                TableRowImpl.this.number.setLocation(currentX + TableRowImpl.this.getCellPadding(), (int)(((double)parent.getHeight() - TableRowImpl.this.number.getPreferredSize().getHeight()) / 2.0));
                TableRowImpl.this.number.setSize(w - 2 * TableRowImpl.this.getCellPadding(), (int)TableRowImpl.this.number.getPreferredSize().getHeight());
                currentX += w;
                w = TableRowImpl.this.model.getParentModel().getColumnWidth(1);
                TableRowImpl.this.name.setLocation(currentX + TableRowImpl.this.getCellPadding(), (int)(((double)parent.getHeight() - TableRowImpl.this.name.getPreferredSize().getHeight()) / 2.0));
                TableRowImpl.this.name.setSize(w - 2 * TableRowImpl.this.getCellPadding(), (int)TableRowImpl.this.name.getPreferredSize().getHeight());
                currentX += w;
                w = TableRowImpl.this.model.getParentModel().getColumnWidth(2);
                TableRowImpl.this.charge.setLocation(currentX + TableRowImpl.this.getCellPadding(), (int)(((double)parent.getHeight() - TableRowImpl.this.charge.getPreferredSize().getHeight()) / 2.0));
                TableRowImpl.this.charge.setSize(w - 2 * TableRowImpl.this.getCellPadding(), (int)TableRowImpl.this.charge.getPreferredSize().getHeight());
                currentX += w;
                w = TableRowImpl.this.model.getParentModel().getColumnWidth(3);
                TableRowImpl.this.position.setLocation(currentX + TableRowImpl.this.getCellPadding(), (int)(((double)parent.getHeight() - TableRowImpl.this.position.getPreferredSize().getHeight()) / 2.0));
                TableRowImpl.this.position.setSize(w - 2 * TableRowImpl.this.getCellPadding(), (int)TableRowImpl.this.position.getPreferredSize().getHeight());
                currentX += w;
                w = TableRowImpl.this.model.getParentModel().getColumnWidth(4);
                TableRowImpl.this.quantity.setLocation(currentX + TableRowImpl.this.getCellPadding(), (int)(((double)parent.getHeight() - TableRowImpl.this.quantity.getPreferredSize().getHeight()) / 2.0));
                TableRowImpl.this.quantity.setSize((int)((double)w - ((double)(2 * TableRowImpl.this.getCellPadding() + TableRowImpl.this.getInnerCellPadding()) + TableRowImpl.this.editQty.getPreferredSize().getWidth())), (int)TableRowImpl.this.quantity.getPreferredSize().getHeight());
                TableRowImpl.this.editQty.setLocation(TableRowImpl.this.quantity.getX() + TableRowImpl.this.quantity.getWidth() + TableRowImpl.this.getInnerCellPadding(), (int)(((double)parent.getHeight() - TableRowImpl.this.editQty.getPreferredSize().getHeight()) / 2.0));
                TableRowImpl.this.editQty.setSize(TableRowImpl.this.editQty.getPreferredSize());
            }
        }
    }
}

