/*
 * Decompiled with CFR 0.152.
 */
package ch.icit.pegasus.client.util.logger;

import ch.icit.pegasus.client.Main;
import java.io.PrintStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LoggerOutputProxy {
    static Logger l = LoggerFactory.getLogger(Main.class);

    public static PrintStream createDebugLoggingProxy(PrintStream realPrintStream) {
        return new PrintStream(realPrintStream){

            @Override
            public void print(String string) {
                l.info(string.replace("\n", "").replace("\r", ""));
            }

            @Override
            public void println(String string) {
                l.info(string.replace("\n", "").replace("\r", ""));
            }

            @Override
            public void println(char x) {
            }

            @Override
            public void print(char x) {
            }

            @Override
            public void println(Object x) {
                if (x instanceof String) {
                    this.println((String)x);
                }
            }
        };
    }

    public static PrintStream createErrorLoggingProxy(PrintStream realPrintStream) {
        return new PrintStream(realPrintStream){

            @Override
            public void print(String string) {
                l.error(string.replace("\n", "").replace("\r", ""));
            }

            @Override
            public void println(String string) {
                if (string != null && !string.isEmpty()) {
                    l.error(string);
                }
            }

            @Override
            public void println(char x) {
            }

            @Override
            public void print(char x) {
            }

            @Override
            public void println(Object x) {
                if (x instanceof String) {
                    this.println((String)x);
                }
                if (x instanceof Exception) {
                    if (((Exception)x).getCause() != null) {
                        this.println(((Exception)x).getCause().getClass().getName());
                        this.println(((Exception)x).getCause().getMessage());
                    } else if (((Exception)x).getMessage() != null) {
                        this.println(x.getClass().getName());
                        this.println(((Exception)x).getMessage());
                    } else {
                        this.println(x.getClass().getName());
                    }
                }
            }
        };
    }
}

