/*
 * Decompiled with CFR 0.152.
 */
package ch.icit.pegasus.client.util.toolkits;

import ch.icit.pegasus.client.converter.FormattedDoubleConverter2Decimals;
import ch.icit.pegasus.client.converter.PeriodConverter;
import ch.icit.pegasus.client.converter.PriceConverter2;
import ch.icit.pegasus.client.converter.QuantityConverter2Decimal;
import ch.icit.pegasus.client.converter.controller.ConverterRegistry;
import ch.icit.pegasus.client.node.impls.NodeToolkit;
import ch.icit.pegasus.server.core.dtos.handlingcost.AbsolutePriceCalculationComplete;
import ch.icit.pegasus.server.core.dtos.handlingcost.ArticleDeliverablePriceCalculationComplete;
import ch.icit.pegasus.server.core.dtos.handlingcost.HandlingCostArticleDeliverableComplete;
import ch.icit.pegasus.server.core.dtos.handlingcost.HandlingCostComplete;
import ch.icit.pegasus.server.core.dtos.handlingcost.HandlingCostProductDeliverableComplete;
import ch.icit.pegasus.server.core.dtos.handlingcost.HandlingCostTypeE;
import ch.icit.pegasus.server.core.dtos.handlingcost.HandlingCostVariantComplete;
import ch.icit.pegasus.server.core.dtos.handlingcost.LinearPriceCalculationComplete;
import ch.icit.pegasus.server.core.dtos.handlingcost.PriceCalculationComplete;
import ch.icit.pegasus.server.core.dtos.handlingcost.StepPriceCalculationComplete;
import ch.icit.pegasus.server.core.dtos.handlingcost.StepPriceFunctionComplete;
import ch.icit.pegasus.server.core.dtos.masterdata.CabinClassComplete;
import ch.icit.pegasus.server.core.dtos.masterdata.ModificationStateE;
import ch.icit.pegasus.server.core.dtos.masterdata.QuantityComplete;
import ch.icit.pegasus.server.core.dtos.masterdata.UnitComplete;
import ch.icit.pegasus.server.core.dtos.product.ProductVariantComplete;
import ch.icit.pegasus.server.core.dtos.supply.BasicArticleComplete;
import ch.icit.pegasus.server.core.dtos.supply.BasicArticleLight;
import ch.icit.pegasus.server.core.dtos.supply.PriceComplete;
import ch.icit.pegasus.server.core.dtos.system.SystemSettingsComplete;
import ch.icit.pegasus.server.core.dtos.utils.PriceQuantityCombination;
import ch.icit.pegasus.server.core.dtos.utils.ProductRecipeAmountCalculationToolkit;
import ch.icit.pegasus.server.core.dtos.utils.UnitConversionToolkit;
import ch.icit.pegasus.server.core.dtos.utils.accessor.CurrencyVariantAccessor;
import ch.icit.pegasus.server.core.dtos.utils.accessor.RecipeVariantAccessor;
import ch.icit.pegasus.server.core.i18n.Words;
import ch.icit.pegasus.server.core.services.exception.ClientRemoteException;
import java.sql.Timestamp;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HandlingCostToolkit {
    static Logger log = LoggerFactory.getLogger(HandlingCostToolkit.class);

    public static PriceComplete getHandlingCostsPrice(ProductVariantComplete variant, int count, Timestamp validity, RecipeVariantAccessor recipeAccessor, SystemSettingsComplete settings, CurrencyVariantAccessor currencyAccessor) throws Exception {
        PriceComplete p = new PriceComplete(settings.getCurrency(), Double.valueOf(0.0));
        Map<HandlingCostComplete, PriceComplete> r = HandlingCostToolkit.getHandlingCosts(variant, count, validity, recipeAccessor, settings, currencyAccessor);
        for (PriceComplete price : r.values()) {
            p.setPrice(Double.valueOf(p.getPrice() + price.getPrice()));
        }
        return p;
    }

    public static PriceComplete getHandlingCostPrice(HandlingCostVariantComplete hc) {
        switch (hc.getType()) {
            case ARTICLE: {
                HandlingCostArticleDeliverableComplete hd = (HandlingCostArticleDeliverableComplete)hc.getDeliverable();
                ArticleDeliverablePriceCalculationComplete calc = (ArticleDeliverablePriceCalculationComplete)hd.getArticles().get(0);
                if (calc.getPriceCalculation() instanceof AbsolutePriceCalculationComplete) {
                    return new PriceComplete(((AbsolutePriceCalculationComplete)calc.getPriceCalculation()).getCurrency(), ((AbsolutePriceCalculationComplete)hc.getQuantity()).getPrice());
                }
                if (calc.getPriceCalculation() instanceof LinearPriceCalculationComplete) {
                    return new PriceComplete(((LinearPriceCalculationComplete)calc.getPriceCalculation()).getPrice());
                }
                if (!(calc.getPriceCalculation() instanceof StepPriceCalculationComplete)) break;
                return ((StepPriceFunctionComplete)((StepPriceCalculationComplete)calc.getPriceCalculation()).getSteps().get(0)).getPrice();
            }
            case PAX: 
            case FLIGHT: 
            case PRODUCT: {
                if (hc.getQuantity() instanceof AbsolutePriceCalculationComplete) {
                    return new PriceComplete(((AbsolutePriceCalculationComplete)hc.getQuantity()).getCurrency(), ((AbsolutePriceCalculationComplete)hc.getQuantity()).getPrice());
                }
                if (hc.getQuantity() instanceof LinearPriceCalculationComplete) {
                    return new PriceComplete(((LinearPriceCalculationComplete)hc.getQuantity()).getPrice());
                }
                if (!(hc.getQuantity() instanceof StepPriceCalculationComplete)) break;
                return ((StepPriceFunctionComplete)((StepPriceCalculationComplete)hc.getQuantity()).getSteps().get(0)).getPrice();
            }
        }
        return new PriceComplete();
    }

    public static PriceComplete getHandlingCostPrice(HandlingCostComplete hc) {
        return HandlingCostToolkit.getHandlingCostPrice(hc.getCurrentVariant());
    }

    public static Map<HandlingCostComplete, PriceComplete> getHandlingCosts(ProductVariantComplete variant, int count, Timestamp validity, RecipeVariantAccessor recipeVariantAccessor, SystemSettingsComplete settings, CurrencyVariantAccessor currencyAccessor) throws Exception {
        HashMap<HandlingCostComplete, PriceComplete> ret = new HashMap<HandlingCostComplete, PriceComplete>();
        Map articles = null;
        block6: for (HandlingCostComplete hc : variant.getHandlingCosts()) {
            PriceCalculationComplete pc = null;
            PriceComplete p = null;
            PriceComplete resolvedPrice = (PriceComplete)ret.get(hc);
            switch (hc.getCurrentVariant().getType()) {
                case ARTICLE: {
                    PriceComplete op;
                    if (articles == null) {
                        articles = ProductRecipeAmountCalculationToolkit.getAmount4Product((ProductVariantComplete)variant, (double)count, (ModificationStateE)variant.getState(), (Timestamp)validity, (RecipeVariantAccessor)recipeVariantAccessor, (CurrencyVariantAccessor)currencyAccessor);
                    }
                    HandlingCostArticleDeliverableComplete h = (HandlingCostArticleDeliverableComplete)hc.getCurrentVariant().getDeliverable();
                    for (ArticleDeliverablePriceCalculationComplete adpc : h.getArticles()) {
                        BasicArticleComplete a = adpc.getArticle();
                        pc = adpc.getPriceCalculation();
                        PriceQuantityCombination pqc = (PriceQuantityCombination)articles.get(a);
                        QuantityComplete qq = null;
                        if (pqc == null) {
                            log.trace("No Quantity for Article " + a.getName());
                            continue;
                        }
                        qq = pqc.getQuantity();
                        if (pc instanceof AbsolutePriceCalculationComplete) {
                            AbsolutePriceCalculationComplete apc = (AbsolutePriceCalculationComplete)pc;
                            p = new PriceComplete(apc.getCurrency(), apc.getPrice());
                        } else if (pc instanceof LinearPriceCalculationComplete) {
                            LinearPriceCalculationComplete lpc = (LinearPriceCalculationComplete)pc;
                            op = lpc.getPrice();
                            QuantityComplete q = lpc.getQuantity();
                            double ca = UnitConversionToolkit.convertUnit((UnitComplete)q.getUnit(), (UnitComplete)qq.getUnit(), (double)q.getQuantity(), (BasicArticleLight)a, (Timestamp)validity);
                            double d = op.getPrice() / ca;
                            p = new PriceComplete(op.getCurrency(), Double.valueOf(d * qq.getQuantity()));
                        } else if (pc instanceof StepPriceCalculationComplete) {
                            StepPriceCalculationComplete spc = (StepPriceCalculationComplete)pc;
                            double latestStep = 0.0;
                            StepPriceFunctionComplete latest = null;
                            for (StepPriceFunctionComplete s : spc.getSteps()) {
                                if (latest != null && qq.getQuantity() > latestStep && qq.getQuantity() < s.getUpperLimit().getQuantity()) {
                                    PriceComplete op2 = latest.getPrice();
                                    p = new PriceComplete(op2.getCurrency(), op2.getPrice());
                                }
                                latestStep = s.getUpperLimit().getQuantity();
                                latest = s;
                            }
                            if (p == null) {
                                if (latest != null) {
                                    p = new PriceComplete(latest.getPrice());
                                } else if (!spc.getSteps().isEmpty()) {
                                    StepPriceFunctionComplete lf = (StepPriceFunctionComplete)spc.getSteps().get(spc.getSteps().size() - 1);
                                    PriceComplete op3 = lf.getPrice();
                                    p = new PriceComplete(op3.getCurrency(), op3.getPrice());
                                } else {
                                    p = new PriceComplete(settings.getCurrency(), Double.valueOf(0.0));
                                }
                            }
                        }
                        if (resolvedPrice == null) {
                            resolvedPrice = new PriceComplete(p);
                            ret.put(hc, resolvedPrice);
                            continue;
                        }
                        resolvedPrice.setPrice(Double.valueOf(resolvedPrice.getPrice() + p.getPrice()));
                    }
                    continue block6;
                }
                case FLIGHT: {
                    throw new ClientRemoteException("Product " + variant.getProduct().getNumber() + " - " + variant.getName() + " references a Flight Handling Cost which isn't supported (Handling Cost: " + hc.getNumber() + " - " + hc.getCurrentVariant().getName() + "", null, new String[0]);
                }
                case PAX: {
                    throw new ClientRemoteException("Product " + variant.getProduct().getNumber() + " - " + variant.getName() + " references a PAX Handling Cost which isn't supported (Handling Cost: " + hc.getNumber() + " - " + hc.getCurrentVariant().getName() + "", null, new String[0]);
                }
                case PRODUCT: {
                    PriceComplete op;
                    HandlingCostProductDeliverableComplete h1 = (HandlingCostProductDeliverableComplete)hc.getCurrentVariant().getDeliverable();
                    if (h1.getProduct() != null && !h1.getProduct().equals((Object)variant.getProduct())) {
                        throw new ClientRemoteException("Product " + variant.getProduct().getNumber() + " - " + variant.getName() + " references a Product Handling Cost which doesn't references the given Product (Handling Cost: " + hc.getNumber() + " - " + hc.getCurrentVariant().getName() + "", null, new String[0]);
                    }
                    pc = hc.getCurrentVariant().getQuantity();
                    p = null;
                    if (pc instanceof AbsolutePriceCalculationComplete) {
                        AbsolutePriceCalculationComplete apc = (AbsolutePriceCalculationComplete)pc;
                        p = new PriceComplete(apc.getCurrency(), apc.getPrice());
                    } else if (pc instanceof LinearPriceCalculationComplete) {
                        LinearPriceCalculationComplete lpc = (LinearPriceCalculationComplete)pc;
                        PriceComplete op4 = lpc.getPrice();
                        QuantityComplete q = lpc.getQuantity();
                        double d = op4.getPrice() / q.getQuantity();
                        p = new PriceComplete(op4.getCurrency(), Double.valueOf(d * (double)count));
                    } else if (pc instanceof StepPriceCalculationComplete) {
                        StepPriceCalculationComplete spc = (StepPriceCalculationComplete)pc;
                        double latestStep = 0.0;
                        StepPriceFunctionComplete latest = null;
                        for (StepPriceFunctionComplete s : spc.getSteps()) {
                            if (latest != null && (double)count > latestStep && (double)count < s.getUpperLimit().getQuantity()) {
                                PriceComplete op5 = latest.getPrice();
                                p = new PriceComplete(op5.getCurrency(), op5.getPrice());
                            }
                            latestStep = s.getUpperLimit().getQuantity();
                            latest = s;
                        }
                        if (p == null) {
                            if (latest != null) {
                                p = new PriceComplete(latest.getPrice());
                            } else if (!spc.getSteps().isEmpty()) {
                                StepPriceFunctionComplete lf = (StepPriceFunctionComplete)spc.getSteps().get(spc.getSteps().size() - 1);
                                op = lf.getPrice();
                                p = new PriceComplete(op.getCurrency(), op.getPrice());
                            } else {
                                p = new PriceComplete(settings.getCurrency(), Double.valueOf(0.0));
                            }
                        }
                    }
                    resolvedPrice = (PriceComplete)ret.get(hc);
                    if (resolvedPrice == null) {
                        resolvedPrice = new PriceComplete(p);
                        ret.put(hc, resolvedPrice);
                        break;
                    }
                    resolvedPrice.setPrice(Double.valueOf(resolvedPrice.getPrice() + p.getPrice()));
                }
            }
        }
        return ret;
    }

    public static double getHandlingCostsCount(ProductVariantComplete variant, int count, Timestamp validity, RecipeVariantAccessor recipeVariantAccessor, SystemSettingsComplete settings, CurrencyVariantAccessor currencyAccessor) throws Exception {
        Map articles = ProductRecipeAmountCalculationToolkit.getAmount4Product((ProductVariantComplete)variant, (double)count, (ModificationStateE)variant.getState(), (Timestamp)validity, (RecipeVariantAccessor)recipeVariantAccessor, (CurrencyVariantAccessor)currencyAccessor);
        double handlingCostCount = 0.0;
        block6: for (HandlingCostComplete hc : variant.getHandlingCosts()) {
            PriceCalculationComplete pc = null;
            Object p = null;
            switch (hc.getCurrentVariant().getType()) {
                case ARTICLE: {
                    HandlingCostArticleDeliverableComplete h = (HandlingCostArticleDeliverableComplete)hc.getCurrentVariant().getDeliverable();
                    for (ArticleDeliverablePriceCalculationComplete adpc : h.getArticles()) {
                        BasicArticleComplete a = adpc.getArticle();
                        pc = adpc.getPriceCalculation();
                        PriceQuantityCombination pqc = (PriceQuantityCombination)articles.get(a);
                        QuantityComplete qq = null;
                        if (pqc == null) {
                            log.trace("No Quantity for Article " + a.getName());
                            continue;
                        }
                        qq = pqc.getQuantity();
                        if (pc instanceof AbsolutePriceCalculationComplete) {
                            handlingCostCount += 1.0;
                            continue;
                        }
                        if (pc instanceof LinearPriceCalculationComplete) {
                            LinearPriceCalculationComplete lpc = (LinearPriceCalculationComplete)pc;
                            PriceComplete op = lpc.getPrice();
                            QuantityComplete q = lpc.getQuantity();
                            double ca = UnitConversionToolkit.convertUnit((UnitComplete)q.getUnit(), (UnitComplete)qq.getUnit(), (double)q.getQuantity(), (BasicArticleLight)a, (Timestamp)validity);
                            handlingCostCount += qq.getQuantity() / ca;
                            continue;
                        }
                        if (!(pc instanceof StepPriceCalculationComplete)) continue;
                        handlingCostCount += 1.0;
                    }
                    continue block6;
                }
                case FLIGHT: {
                    throw new ClientRemoteException("Product " + variant.getProduct().getNumber() + " - " + variant.getName() + " references a Flight Handling Cost which isn't supported (Handling Cost: " + hc.getNumber() + " - " + hc.getCurrentVariant().getName() + "", null, new String[0]);
                }
                case PAX: {
                    throw new ClientRemoteException("Product " + variant.getProduct().getNumber() + " - " + variant.getName() + " references a PAX Handling Cost which isn't supported (Handling Cost: " + hc.getNumber() + " - " + hc.getCurrentVariant().getName() + "", null, new String[0]);
                }
                case PRODUCT: {
                    HandlingCostProductDeliverableComplete h1 = (HandlingCostProductDeliverableComplete)hc.getCurrentVariant().getDeliverable();
                    if (h1.getProduct() != null && !h1.getProduct().equals((Object)variant.getProduct())) {
                        throw new ClientRemoteException("Product " + variant.getProduct().getNumber() + " - " + variant.getName() + " references a Product Handling Cost which doesn't references the given Product (Handling Cost: " + hc.getNumber() + " - " + hc.getCurrentVariant().getName() + "", null, new String[0]);
                    }
                    pc = hc.getCurrentVariant().getQuantity();
                    p = null;
                    if (pc instanceof AbsolutePriceCalculationComplete) {
                        handlingCostCount += 1.0;
                        break;
                    }
                    if (pc instanceof LinearPriceCalculationComplete) {
                        LinearPriceCalculationComplete lpc = (LinearPriceCalculationComplete)pc;
                        QuantityComplete q = lpc.getQuantity();
                        handlingCostCount += q.getQuantity().doubleValue();
                        break;
                    }
                    if (!(pc instanceof StepPriceCalculationComplete)) break;
                    handlingCostCount += 1.0;
                }
            }
        }
        return handlingCostCount;
    }

    public static String getHandlingCostInfoString(HandlingCostComplete handlingCost, PriceComplete specialPrice) {
        if (handlingCost == null) {
            return "<b>" + Words.NO_HANDLING_COST_SELECTED + "</b>";
        }
        boolean isSolarCompany = Boolean.TRUE.equals(((SystemSettingsComplete)NodeToolkit.getAffixClass(SystemSettingsComplete.class).getValue()).getCompany().getSolarCompanyType());
        PeriodConverter periodConverter = (PeriodConverter)ConverterRegistry.getConverter(PeriodConverter.class);
        String t = "<b>" + handlingCost.getNumber() + " - " + handlingCost.getCurrentVariant().getName() + "<br/><hr/></b><br/>";
        if (!isSolarCompany) {
            t = t + "<b>Customer</b><ul><li>" + handlingCost.getCustomer().getNumber() + " - " + handlingCost.getCustomer().getName() + "</li></ul><br/>";
            if (handlingCost.getCurrentVariant().getCustomerInvoiceNumber() != null && !handlingCost.getCurrentVariant().getCustomerInvoiceNumber().isEmpty()) {
                t = t + "<b>Customer Invoice No</b><ul><li>" + handlingCost.getCurrentVariant().getCustomerInvoiceNumber() + "</li></ul><br/>";
            }
        }
        t = t + "<b>" + Words.PERIOD + "</b><ul><li>" + periodConverter.convert((Object)handlingCost.getPeriod(), null, new Object[0]) + "</li></ul><br/>";
        if (!isSolarCompany) {
            t = t + "<b>Cost Type</b><ul><li>";
            switch (handlingCost.getCurrentVariant().getType()) {
                case ARTICLE: {
                    t = t + "Article Handling Costs</li>";
                    break;
                }
                case FLIGHT: {
                    t = t + "Flight Handling Costs</li>";
                    break;
                }
                case PAX: {
                    t = t + "Pax related Handling Costs</li>";
                    break;
                }
                case PRODUCT: {
                    t = t + "Product Handling Costs</li>";
                }
            }
        }
        t = t + HandlingCostToolkit.getDeliveryItemText(handlingCost, specialPrice);
        t = t + "</ul>";
        if (handlingCost.getCurrentVariant().getRemark() != null && !handlingCost.getCurrentVariant().getRemark().isEmpty()) {
            t = t + "<b>" + Words.REMARK + "</b><ul><li>" + handlingCost.getCurrentVariant().getRemark() + "</li></ul>";
        }
        return t;
    }

    private static String getDeliveryItemText(HandlingCostComplete handling, PriceComplete specialPrice) {
        Object p;
        String t = "";
        FormattedDoubleConverter2Decimals fdc = (FormattedDoubleConverter2Decimals)ConverterRegistry.getConverter(FormattedDoubleConverter2Decimals.class);
        PriceConverter2 pc = (PriceConverter2)ConverterRegistry.getConverter(PriceConverter2.class);
        QuantityConverter2Decimal qc = (QuantityConverter2Decimal)ConverterRegistry.getConverter(QuantityConverter2Decimal.class);
        if (handling.getCurrentVariant().getDeliverable() instanceof HandlingCostProductDeliverableComplete) {
            p = (HandlingCostProductDeliverableComplete)handling.getCurrentVariant().getDeliverable();
            if (p.getProduct() != null) {
                t = t + "<li>for " + p.getProduct().getNumber() + " - " + p.getProduct().getCurrentVariant().getName() + "</li>";
            }
        } else if (handling.getCurrentVariant().getDeliverable() instanceof HandlingCostArticleDeliverableComplete) {
            p = (HandlingCostArticleDeliverableComplete)handling.getCurrentVariant().getDeliverable();
            if (!p.getArticles().isEmpty()) {
                for (ArticleDeliverablePriceCalculationComplete adpc : p.getArticles()) {
                    t = t + "<li>for " + adpc.getArticle().getNumber() + " - " + adpc.getArticle().getName() + "</li>";
                }
            }
        } else if (handling.getCurrentVariant().getType() == HandlingCostTypeE.PAX) {
            t = t + "<li>Pax: ";
            for (CabinClassComplete ccc : handling.getCurrentVariant().getPaxClasses()) {
                t = t + ccc.getCode() + ", ";
            }
            if (handling.getCurrentVariant().getPaxClasses().size() > 0) {
                t = t.substring(0, t.length() - 2);
            }
            t = t + "</li>";
        }
        if (handling.getCurrentVariant().getQuantity() instanceof AbsolutePriceCalculationComplete) {
            AbsolutePriceCalculationComplete abs = (AbsolutePriceCalculationComplete)handling.getCurrentVariant().getQuantity();
            t = t + "<li>" + Words.ABSOLUT + ": ";
            if (specialPrice != null) {
                t = t + pc.convert(specialPrice, null, new Object[0]) + "</li>";
            } else if (abs != null && abs.getCurrency() != null) {
                t = t + fdc.convert((Number)abs.getPrice(), null, new Object[0]) + " " + abs.getCurrency().getCode() + "</li>";
            }
        } else if (handling.getCurrentVariant().getQuantity() instanceof LinearPriceCalculationComplete) {
            LinearPriceCalculationComplete lpc = (LinearPriceCalculationComplete)handling.getCurrentVariant().getQuantity();
            t = t + "<li>Linear: " + pc.convert(lpc.getPrice(), null, new Object[0]) + " per " + qc.convert((Object)lpc.getQuantity(), null, new Object[0]) + "</li>";
        } else if (handling.getCurrentVariant().getQuantity() instanceof StepPriceCalculationComplete) {
            StepPriceCalculationComplete spc = (StepPriceCalculationComplete)handling.getCurrentVariant().getQuantity();
            t = t + "<li>Steps " + spc.getSteps().size() + " Steps defined</li>";
        }
        return t;
    }
}

