/*
 * Decompiled with CFR 0.152.
 */
package ch.icit.pegasus.client.util.variantaccessor;

import ch.icit.pegasus.client.converter.DateConverter;
import ch.icit.pegasus.client.converter.controller.ConverterRegistry;
import ch.icit.pegasus.client.services.ServiceManagerRegistry;
import ch.icit.pegasus.client.services.interfaces.recipe.RecipeServiceManager;
import ch.icit.pegasus.client.util.exception.ClientServerCallException;
import ch.icit.pegasus.server.core.dtos.recipe.RecipeComplete;
import ch.icit.pegasus.server.core.dtos.recipe.RecipeVariantComplete;
import ch.icit.pegasus.server.core.dtos.recipe.RecipeVariantLight;
import ch.icit.pegasus.server.core.dtos.recipe.RecipeVariantReference;
import ch.icit.pegasus.server.core.dtos.util.XMLWrapper.ListWrapper;
import ch.icit.pegasus.server.core.dtos.utils.accessor.RecipeVariantAccessor;
import java.sql.Timestamp;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class RecipeVariantAccessorImpl
implements RecipeVariantAccessor {
    private Map<RecipeComplete, List<RecipeVariantLight>> variants = new HashMap<RecipeComplete, List<RecipeVariantLight>>();
    private Map<RecipeVariantReference, RecipeVariantComplete> completes = new HashMap<RecipeVariantReference, RecipeVariantComplete>();

    public RecipeVariantComplete loadData(RecipeComplete reference, Timestamp ts) throws ClientServerCallException {
        List v = this.variants.get(reference);
        if (v == null) {
            v = ((RecipeServiceManager)ServiceManagerRegistry.getService(RecipeServiceManager.class)).getRecipeVariants(new ListWrapper(reference.getVariants())).getList();
            this.variants.put(reference, v);
        }
        RecipeVariantLight selected = null;
        for (RecipeVariantLight cv : v) {
            if (ts.getTime() + 1L < cv.getValidityPeriod().getStartDate().getTime() || ts.getTime() + 1L > cv.getValidityPeriod().getEndDate().getTime()) continue;
            selected = cv;
        }
        if (selected == null) {
            throw new IllegalArgumentException("No valid Recipe Variant found for Recipe " + reference.getNumber() + " " + reference.getCurrentVariant().getName() + " at " + ((DateConverter)ConverterRegistry.getConverter(DateConverter.class)).convert((Object)ts, null, new Object[0]));
        }
        RecipeVariantComplete ccv = this.completes.get(selected);
        if (ccv != null) {
            return ccv;
        }
        ccv = this.getComplete(new RecipeVariantReference(selected.getId()));
        this.completes.put((RecipeVariantReference)selected, ccv);
        return ccv;
    }

    public RecipeVariantComplete getComplete(RecipeVariantReference ref) throws ClientServerCallException {
        RecipeVariantComplete c = this.completes.get(ref);
        if (c != null) {
            return c;
        }
        c = (RecipeVariantComplete)((RecipeServiceManager)ServiceManagerRegistry.getService(RecipeServiceManager.class)).getRecipeVariant(ref).getValue();
        this.completes.put(ref, c);
        return c;
    }
}

