/*
 * Decompiled with CFR 0.152.
 */
package ch.icit.pegasus.client.gui.debug;

import ch.icit.pegasus.client.gui.debug.DebugCheckBoxLine;
import ch.icit.pegasus.client.gui.utils.DefaultLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.lang.reflect.Method;
import java.util.List;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class DebugCheckBoxPanel
extends JPanel {
    private static final long serialVersionUID = 1L;
    private Class<?> clazz;
    private List<Method> methods;
    private List<DebugCheckBoxLine> rows;

    public DebugCheckBoxPanel(Class<?> clazz, List<Method> methods) {
        this.clazz = clazz;
        this.methods = methods;
        this.setLayout(new Layout());
        JLabel title = new JLabel(clazz.getSimpleName());
        this.add(title);
        title.setFont(new Font("SansSerif", 1, 15));
        title.setVisible(true);
        for (Method method : methods) {
            DebugCheckBoxLine dcl = new DebugCheckBoxLine(method, clazz);
            this.add(dcl);
            dcl.setVisible(true);
        }
    }

    private class Layout
    extends DefaultLayout {
        private Layout() {
        }

        @Override
        public Dimension preferredLayoutSize(Container parent) {
            Component[] comps = parent.getComponents();
            int x = 0;
            int y = 5;
            for (Component component : comps) {
                component.setSize(component.getPreferredSize());
                component.setLocation(5, y);
                y += component.getPreferredSize().height + 5;
                if (component.getPreferredSize().width <= x) continue;
                x = component.getPreferredSize().width;
            }
            return new Dimension(x + 10, y);
        }

        @Override
        public void layoutContainer(Container parent) {
            Component[] comps = parent.getComponents();
            int y = 5;
            for (Component component : comps) {
                component.setSize(component.getPreferredSize());
                component.setLocation(5, y);
                y += component.getPreferredSize().height + 5;
            }
        }
    }
}

