/*
 * Decompiled with CFR 0.152.
 */
package ch.icit.pegasus.client.gui.modules.aircraft.details;

import ch.icit.pegasus.client.gui.table.DefaultDetailsPanel;
import ch.icit.pegasus.client.gui.table.RowEditor;
import ch.icit.pegasus.client.gui.table2.Table2RowPanel;
import ch.icit.pegasus.client.gui.utils.DefaultLayout;
import ch.icit.pegasus.client.gui.utils.rightdependant.RDProvider;
import ch.icit.pegasus.client.gui.utils.tables.GalleyLoadingTable;
import ch.icit.pegasus.client.node.impls.Node;
import ch.icit.pegasus.client.util.ScreenValidationObject;
import ch.icit.pegasus.server.core.dtos.flightschedule.aircraft.AircraftLight;
import ch.icit.pegasus.server.core.dtos.flightschedule.aircraft.AircraftLight_;
import ch.icit.pegasus.server.core.dtos.flightschedule.scanning.GalleyLoadConfigurationComplete;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;

public class GalleyLoadingDetailsPanel
extends DefaultDetailsPanel<AircraftLight> {
    private static final long serialVersionUID = 1L;
    private GalleyLoadingTable table;

    public GalleyLoadingDetailsPanel(RowEditor<AircraftLight> editor, RDProvider provider) {
        super(editor, provider);
        this.setTitleText("Galley/Truck Loading");
        this.table = new GalleyLoadingTable(provider, AircraftLight_.loadConfigurations);
        this.setCustomLayouter(new Layout());
        this.addToView(this.table);
    }

    @Override
    public void setNode(Node<?> node) {
        this.table.getModel().setNode(node.getChildNamed(AircraftLight_.loadConfigurations));
    }

    @Override
    public void resetParagraph() {
        this.table.getModel().setNode(this.editor.getModel().getNode().getChildNamed(AircraftLight_.loadConfigurations));
    }

    @Override
    public List<Component> getFocusComponents() {
        return this.table.getFocusComponents();
    }

    @Override
    public List<ScreenValidationObject> validateParagraph() {
        ArrayList<ScreenValidationObject> validationObjects = new ArrayList<ScreenValidationObject>();
        HashSet<String> uniqueGalleys = new HashSet<String>();
        for (Table2RowPanel p : this.table.getRows()) {
            p.getModel().getNode().commit();
            GalleyLoadConfigurationComplete group = (GalleyLoadConfigurationComplete)p.getModel().getNode().getValue();
            for (String s : group.getGalleys()) {
                if (uniqueGalleys.contains(s)) {
                    validationObjects.add(new ScreenValidationObject(ScreenValidationObject.ValidationStateE.FATAL, "Galley loading configuration must be unique (" + s + ")"));
                    continue;
                }
                uniqueGalleys.add(s);
            }
        }
        return validationObjects;
    }

    private class Layout
    extends DefaultLayout {
        private Layout() {
        }

        @Override
        public Dimension preferredLayoutSize(Container parent) {
            return new Dimension(0, 250);
        }

        @Override
        public void layoutContainer(Container parent) {
            GalleyLoadingDetailsPanel.this.table.setLocation(0, 0);
            GalleyLoadingDetailsPanel.this.table.setSize(parent.getWidth(), parent.getHeight());
        }
    }
}

