/*
 * Decompiled with CFR 0.152.
 */
package ch.icit.pegasus.client.gui.modules.article.details;

import ch.icit.pegasus.client.converter.ArticleNutritionConverter;
import ch.icit.pegasus.client.converter.ArticleNutritionStateConverter;
import ch.icit.pegasus.client.converter.IntegerPlusPlusConverter;
import ch.icit.pegasus.client.converter.NutritionTypeConverter;
import ch.icit.pegasus.client.converter.controller.ConverterRegistry;
import ch.icit.pegasus.client.gui.modules.article.details.SpecificationDetailsPanel;
import ch.icit.pegasus.client.gui.screentemplates.details.TableDetailsPanel;
import ch.icit.pegasus.client.gui.table.RowEditor;
import ch.icit.pegasus.client.gui.table.TableColumnInfo;
import ch.icit.pegasus.client.gui.table2.SortableTable2RowPanel;
import ch.icit.pegasus.client.gui.table2.Table2;
import ch.icit.pegasus.client.gui.table2.Table2RowModel;
import ch.icit.pegasus.client.gui.table2.Table2RowPanel;
import ch.icit.pegasus.client.gui.utils.CheckedListAdder;
import ch.icit.pegasus.client.gui.utils.DefaultLayout;
import ch.icit.pegasus.client.gui.utils.TextLabel;
import ch.icit.pegasus.client.gui.utils.TitledItem;
import ch.icit.pegasus.client.gui.utils.buttons.Button;
import ch.icit.pegasus.client.gui.utils.combobox.ComboBox;
import ch.icit.pegasus.client.gui.utils.combobox.InputComboBox;
import ch.icit.pegasus.client.gui.utils.combobox.InputComboBox2;
import ch.icit.pegasus.client.gui.utils.rightdependant.RDProvider;
import ch.icit.pegasus.client.gui.utils.textfield.TextField;
import ch.icit.pegasus.client.gui.utils.textfield.TextFieldType;
import ch.icit.pegasus.client.node.INodeCreator;
import ch.icit.pegasus.client.node.impls.Node;
import ch.icit.pegasus.client.node.impls.NodeListener;
import ch.icit.pegasus.client.node.impls.NodeToolkit;
import ch.icit.pegasus.client.node.impls.ViewNode;
import ch.icit.pegasus.client.util.toolkits.ArticleToolkit;
import ch.icit.pegasus.client.util.toolkits.UnitToolkit;
import ch.icit.pegasus.server.core.dtos.ADTO;
import ch.icit.pegasus.server.core.dtos.masterdata.NutritionTypeComplete;
import ch.icit.pegasus.server.core.dtos.masterdata.QuantityComplete;
import ch.icit.pegasus.server.core.dtos.masterdata.QuantityComplete_;
import ch.icit.pegasus.server.core.dtos.masterdata.UnitComplete;
import ch.icit.pegasus.server.core.dtos.supply.ArticleNutritionComplete;
import ch.icit.pegasus.server.core.dtos.supply.ArticleNutritionComplete_;
import ch.icit.pegasus.server.core.dtos.supply.ArticleNutritionStateE;
import ch.icit.pegasus.server.core.dtos.supply.BasicArticleComplete;
import ch.icit.pegasus.server.core.dtos.supply.BasicArticleComplete_;
import ch.icit.pegasus.server.core.dtos.supply.BasicArticleLight;
import ch.icit.pegasus.server.core.dtos.supply.BasicArticleLight_;
import ch.icit.pegasus.server.core.dtos.system.SystemSettingsComplete;
import ch.icit.pegasus.server.core.i18n.Words;
import ch.icit.pegasus.server.dtos.metamodel.DtoField;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;

public class NutritionDetailsPanel
extends TableDetailsPanel<BasicArticleLight>
implements NodeListener {
    private static final long serialVersionUID = 1L;
    private TitledItem<InputComboBox2> referenceAmount;
    private boolean isWritable;
    private SpecificationDetailsPanel specificationDetailsPanel;

    public NutritionDetailsPanel(RowEditor<BasicArticleLight> editor, RDProvider provider, SpecificationDetailsPanel specificationDetailsPanel) {
        super(editor, provider, true, true, false, true);
        this.specificationDetailsPanel = specificationDetailsPanel;
        this.setTitleText(Words.NUTRITION);
        this.isWritable = provider.isWritable(BasicArticleComplete_.nutritions);
        this.referenceAmount = new TitledItem<InputComboBox2>(new InputComboBox2(null, null, InputComboBox.InputComboBoxType.PRICE_AND_UNIT_DOUBLE), Words.BASE_AMOUNT, TitledItem.TitledItemOrientation.NORTH);
        this.addToView(this.referenceAmount);
    }

    @Override
    public void layoutContainer(Container parent) {
        this.referenceAmount.setLocation(this.horizontalBorder, this.verticalBorder);
        this.referenceAmount.setSize(this.referenceAmount.getPreferredSize());
        this.table.setLocation(0, this.referenceAmount.getY() + this.referenceAmount.getHeight() + this.verticalBorder);
        this.table.setSize(parent.getWidth(), parent.getHeight() - this.table.getY());
    }

    @Override
    public Dimension calculateContainerPreferredSize() {
        return new Dimension(0, 200);
    }

    private void updateSelectableUnits() {
        List<Node<UnitComplete>> selectableUnitsForArticle = ArticleToolkit.getSelectableUnitsForArticle((Node<BasicArticleComplete>)this.editor.getModel().getNode());
        ViewNode unitNode = new ViewNode("units");
        for (Node<UnitComplete> unit : selectableUnitsForArticle) {
            unitNode.addChild(unit, 0L);
        }
        this.referenceAmount.getElement().setPossibleUnits((Node)unitNode);
    }

    private Node<NutritionTypeComplete> getFreeContentCharacteristic() {
        Iterator it = NodeToolkit.getAffixList(NutritionTypeComplete.class).getChilds();
        while (it.hasNext()) {
            Node nutritionType = (Node)it.next();
            boolean found = false;
            for (Table2RowPanel rowPanel : this.table.getRows()) {
                NutritionTypeComplete nutritionTypeByRow = (NutritionTypeComplete)rowPanel.getModel().getNode().getChildNamed(ArticleNutritionComplete_.nutritionType).getValue();
                if (!((NutritionTypeComplete)nutritionType.getValue()).equals((Object)nutritionTypeByRow)) continue;
                found = true;
            }
            if (found) continue;
            return nutritionType;
        }
        return null;
    }

    public void validateComboContent() {
        List<Node<NutritionTypeComplete>> list = this.getUsedDeclarations();
        for (Table2RowPanel rowPanel : this.table.getRows()) {
            TableRowImpl rowPanelImpl = (TableRowImpl)rowPanel;
            rowPanelImpl.updateContentCombo(list);
        }
    }

    private List<Node<NutritionTypeComplete>> getUsedDeclarations() {
        ArrayList<Node<NutritionTypeComplete>> list = new ArrayList<Node<NutritionTypeComplete>>();
        if (this.editor.getModel().getNode().getChildNamed(BasicArticleComplete_.nutritions) != null) {
            Iterator it = this.editor.getModel().getNode().getChildNamed(BasicArticleLight_.number).getChilds();
            while (it.hasNext()) {
                Node articleNutrition = (Node)it.next();
                Node nutritionType = articleNutrition.getChildNamed(ArticleNutritionComplete_.nutritionType);
                if (nutritionType.getValue() == null) continue;
                list.add((Node<NutritionTypeComplete>)nutritionType);
            }
        }
        return list;
    }

    @Override
    public List<TableColumnInfo> getColumns(boolean add) {
        int deleteW = TableColumnInfo.getSortableColumnWidth(this.table);
        ArrayList<TableColumnInfo> columns = new ArrayList<TableColumnInfo>();
        columns.add(new TableColumnInfo(Words.NO_NUMBER, null, null, null, "", 65, 65, 65));
        columns.add(new TableColumnInfo(Words.TYPE, null, null, null, "", 100, 100, 100));
        columns.add(new TableColumnInfo(Words.PARENT, null, null, null, "", 150, 150, 150));
        int tw = InputComboBox2.getPreferredWidth(this, 11);
        columns.add(new TableColumnInfo(Words.DAILY_VALUE, null, null, null, "", 60, 60, 60));
        columns.add(new TableColumnInfo(Words.QTY, null, null, null, "", tw, tw, tw));
        columns.add(new TableColumnInfo(Words.STATE, null, null, null, "", 150, 150, 150));
        columns.add(new TableColumnInfo("", null, null, null, "", deleteW, deleteW, deleteW));
        ((TableColumnInfo)columns.get(0)).setxExpand(0.0);
        ((TableColumnInfo)columns.get(1)).setxExpand(1.0);
        ((TableColumnInfo)columns.get(2)).setxExpand(0.0);
        ((TableColumnInfo)columns.get(3)).setxExpand(0.0);
        ((TableColumnInfo)columns.get(4)).setxExpand(0.0);
        ((TableColumnInfo)columns.get(5)).setxExpand(0.0);
        ((TableColumnInfo)columns.get(6)).setxExpand(0.0);
        return columns;
    }

    @Override
    public void configTable(Table2 table) {
        table.setUseWriteAccessRight(true);
        table.setMaxRows(NodeToolkit.getAffixList(NutritionTypeComplete.class).getChildCount(), false);
        table.setProvider(this.provider);
        table.setRequestFocusOnAdd(true);
        table.setComparator((o1, o2) -> {
            Table2RowPanel tr1 = (Table2RowPanel)o1;
            Table2RowPanel tr2 = (Table2RowPanel)o2;
            Node n1 = tr1.getModel().getNode();
            Node n2 = tr2.getModel().getNode();
            Node i1 = n1.getChildNamed(ArticleNutritionComplete_.sequenceNo);
            Node i2 = n2.getChildNamed(ArticleNutritionComplete_.sequenceNo);
            Integer v1 = (Integer)i1.getValue();
            Integer v2 = (Integer)i2.getValue();
            if (v1 == null) {
                return v2 == null ? 0 : -1;
            }
            if (v2 == null) {
                return 1;
            }
            return v1.compareTo(v2);
        });
    }

    @Override
    public void addButtonPressed(int x, int y, Button source) {
        Node<NutritionTypeComplete> nutritionType = this.getFreeContentCharacteristic();
        if (nutritionType != null) {
            ArticleNutritionComplete articleNutrition = new ArticleNutritionComplete();
            articleNutrition.setClientOId(Long.valueOf(ADTO.getNextId()));
            articleNutrition.setNutritionType((NutritionTypeComplete)nutritionType.getValue());
            articleNutrition.setNutritionState(ArticleNutritionStateE.APPROVED);
            articleNutrition.setSequenceNo(Integer.valueOf(this.table.getRowCount()));
            UnitComplete unit = (UnitComplete)this.editor.getModel().getNode().getChildNamed(BasicArticleLight_.baseUnit).getValue();
            articleNutrition.setAmount(new QuantityComplete(Double.valueOf(0.0), unit));
            articleNutrition.setDailyValue(Double.valueOf(0.0));
            Node articleNutritionNode = INodeCreator.getDefaultImpl().getNode4DTO((Object)articleNutrition, true, false);
            try {
                this.table.getModel().getNode().addChild(articleNutritionNode, System.currentTimeMillis());
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            this.validateComboContent();
            this.editor.revalidate();
        } else {
            this.table.enableAddButton(false);
        }
    }

    @Override
    public void childRemoved() {
        this.validateComboContent();
        this.table.writeNumber(ArticleNutritionComplete_.sequenceNo, 0);
        this.editor.revalidate();
    }

    @Override
    public Table2RowPanel generateView(Table2RowModel model, boolean isHeader) {
        TableRowImpl rowPanel = new TableRowImpl(model);
        rowPanel.setUseControlSkin(Table2RowPanel.TableControlsType.THREE);
        return rowPanel;
    }

    @Override
    public void setEnabled(boolean isEnabled) {
        super.setEnabled(isEnabled);
        this.referenceAmount.setEnabled(isEnabled && this.isWritable);
    }

    @Override
    public void setNode(Node<?> node) {
        if (node.getChildNamed(BasicArticleComplete_.nutritionBaseAmountUnit).getValue() == null) {
            SystemSettingsComplete settings = (SystemSettingsComplete)NodeToolkit.getAffixClass(SystemSettingsComplete.class).getValue();
            node.getChildNamed(BasicArticleComplete_.nutritionBaseAmountUnit).setValue((Object)settings.getDefaultNutritionBaseUnit(), 0L);
        }
        if (node.getChildNamed(BasicArticleComplete_.nutritionBaseAmount).getValue() == null) {
            node.getChildNamed(BasicArticleComplete_.nutritionBaseAmount).setValue((Object)100.0, 0L);
        }
        this.referenceAmount.getElement().setNode(node.getChildNamed(BasicArticleComplete_.nutritionBaseAmount), node.getChildNamed(BasicArticleComplete_.nutritionBaseAmountUnit));
        this.table.getModel().setNode(node.getChildNamed(BasicArticleComplete_.nutritions));
        node.getChildNamed(BasicArticleLight_.baseUnit).addNodeListener((NodeListener)this);
        this.updateSelectableUnits();
    }

    @Override
    public void kill() {
        if (this.isKilled()) {
            return;
        }
        super.kill();
        if (this.editor.getModel().getNode() != null) {
            this.editor.getModel().getNode().getChildNamed(BasicArticleLight_.baseUnit).removeNodeListener((NodeListener)this);
        }
    }

    public void valueChanged(Node<?> node) {
        if (node.getName().equals(BasicArticleLight_.baseUnit.getFieldName())) {
            this.referenceAmount.getElement().setPossibleUnits(this.specificationDetailsPanel.getUnitSelectionNode());
        }
    }

    public void childAdded(Node<?> source, Node<?> child) {
    }

    public void childRemoved(Node<?> source, Node<?> child) {
    }

    public void childrenAdded(Node<?> source, Node<?> ... nodes) {
    }

    public boolean isSwingOnly() {
        return false;
    }

    @Override
    public void requestFocusInWindowNow() {
    }

    @Override
    public List<Component> getFocusComponents() {
        ArrayList<Component> focusComponents = new ArrayList<Component>();
        CheckedListAdder.addToList(focusComponents, this.referenceAmount);
        CheckedListAdder.addToList(focusComponents, this.table);
        return focusComponents;
    }

    private Node createParentList(Node<BasicArticleComplete> articleNode, Node<ArticleNutritionComplete> currentNutrition) {
        HashSet<Node> excludes = new HashSet<Node>();
        Node nutrition = currentNutrition;
        while (nutrition != null) {
            if (excludes.contains(nutrition)) {
                nutrition = null;
                continue;
            }
            excludes.add(nutrition);
            nutrition = nutrition.getChildNamed(ArticleNutritionComplete_.parentNutrition);
        }
        ViewNode parents = new ViewNode("Selectable Nutrition");
        Iterator iterator = articleNode.getChildNamed(BasicArticleComplete_.nutritions).getFailSafeChildIterator();
        while (iterator.hasNext()) {
            Node nut = (Node)iterator.next();
            if (excludes.contains(nut)) continue;
            parents.addChild(nut, 0L);
        }
        return parents;
    }

    private class TableRowImpl
    extends SortableTable2RowPanel
    implements NodeListener {
        private TextLabel sequence;
        private ComboBox type;
        private TextField dailyValue;
        private InputComboBox2 qty;
        private ComboBox state;
        private ComboBox parentNutrition;

        public TableRowImpl(Table2RowModel m) {
            super(m);
            this.setLayout(new Layout());
            this.sequence = new TextLabel(m.getNode().getChildNamed(ArticleNutritionComplete_.sequenceNo), ConverterRegistry.getConverter(IntegerPlusPlusConverter.class));
            this.type = new ComboBox(m.getNode().getChildNamed(ArticleNutritionComplete_.nutritionType), NodeToolkit.getAffixClass(NutritionTypeComplete.class), ConverterRegistry.getConverter(NutritionTypeConverter.class));
            this.dailyValue = new TextField(m.getNode().getChildNamed(ArticleNutritionComplete_.dailyValue), TextFieldType.DOUBLE);
            this.qty = new InputComboBox2(m.getNode().getChildNamed(new DtoField[]{ArticleNutritionComplete_.amount, QuantityComplete_.quantity}), m.getNode().getChildNamed(new DtoField[]{ArticleNutritionComplete_.amount, QuantityComplete_.unit}), InputComboBox.InputComboBoxType.PRICE_AND_UNIT_DOUBLE);
            this.state = new ComboBox(m.getNode().getChildNamed(ArticleNutritionComplete_.nutritionState), NodeToolkit.getAffixList(ArticleNutritionStateE.class), ConverterRegistry.getConverter(ArticleNutritionStateConverter.class));
            this.parentNutrition = new ComboBox(m.getNode().getChildNamed(ArticleNutritionComplete_.parentNutrition), NutritionDetailsPanel.this.createParentList((Node<BasicArticleComplete>)NutritionDetailsPanel.this.editor.getModel().getNode(), (Node<ArticleNutritionComplete>)m.getNode()), ConverterRegistry.getConverter(ArticleNutritionConverter.class), true);
            NutritionDetailsPanel.this.editor.getModel().getNode().getChildNamed(BasicArticleLight_.baseUnit).addNodeListener((NodeListener)this);
            this.updateSelectableUnits();
            this.setSortAttributeName(ArticleNutritionComplete_.sequenceNo);
            this.setStartEndOffset(0, 1);
            NutritionDetailsPanel.this.editor.getModel().getNode().getChildNamed(BasicArticleComplete_.nutritions).addNodeListener((NodeListener)this);
            this.add(this.sequence);
            this.add(this.type);
            this.add(this.dailyValue);
            this.add(this.qty);
            this.add(this.state);
            this.add(this.parentNutrition);
        }

        private void updateSelectableUnits() {
            List<Node<UnitComplete>> selectableUnitsForArticle = ArticleToolkit.getSelectableUnitsForArticle((Node<BasicArticleComplete>)NutritionDetailsPanel.this.editor.getModel().getNode());
            ViewNode unitNode = new ViewNode("units");
            for (Node<UnitComplete> unit : selectableUnitsForArticle) {
                unitNode.addChild(unit, 0L);
            }
            this.qty.setPossibleUnits(UnitToolkit.getAllUnits());
        }

        private void updateSelectableParents() {
            if (this.parentNutrition != null) {
                this.parentNutrition.refreshPossibleValues(NutritionDetailsPanel.this.createParentList((Node<BasicArticleComplete>)NutritionDetailsPanel.this.editor.getModel().getNode(), (Node<ArticleNutritionComplete>)this.model.getNode()));
            }
        }

        @Override
        public Object getObject4Column(int column) {
            return this.model.getNode().getChildNamed(ArticleNutritionComplete_.sequenceNo);
        }

        @Override
        public void setEnabled(boolean isEnabled) {
            boolean enable = isEnabled && NutritionDetailsPanel.this.isWritable;
            super.setEnabled(enable);
            this.sequence.setEnabled(enable);
            this.type.setEnabled(enable);
            this.dailyValue.setEnabled(enable);
            this.qty.setEnabled(enable);
            this.state.setEnabled(enable);
            this.parentNutrition.setEnabled(enable);
        }

        @Override
        public void kill() {
            if (this.isKilled()) {
                return;
            }
            super.kill();
            this.sequence.kill();
            this.type.kill();
            this.dailyValue.kill();
            this.qty.kill();
            this.state.kill();
            this.parentNutrition.kill();
            if (NutritionDetailsPanel.this.editor.getModel().getNode() != null) {
                NutritionDetailsPanel.this.editor.getModel().getNode().getChildNamed(BasicArticleLight_.baseUnit).removeNodeListener((NodeListener)this);
            }
            this.sequence = null;
            this.type = null;
            this.dailyValue = null;
            this.qty = null;
            this.state = null;
            this.parentNutrition = null;
        }

        public void updateContentCombo(List<Node<NutritionTypeComplete>> list) {
            List<Node<NutritionTypeComplete>> l = list;
            this.type.updateSelectableValues(l);
        }

        public void valueChanged(Node<?> node) {
            this.updateSelectableUnits();
        }

        public void childAdded(Node<?> source, Node<?> child) {
            this.updateSelectableParents();
        }

        public void childRemoved(Node<?> source, Node<?> child) {
            this.updateSelectableParents();
        }

        public void childrenAdded(Node<?> source, Node<?> ... nodes) {
            this.updateSelectableParents();
        }

        public boolean isSwingOnly() {
            return true;
        }

        private class Layout
        extends DefaultLayout {
            private Layout() {
            }

            @Override
            public Dimension preferredLayoutSize(Container parent) {
                return new Dimension(0, TableRowImpl.this.getDefaultRowHeight());
            }

            @Override
            public void layoutContainer(Container parent) {
                int currentX = 0;
                int w = TableRowImpl.this.getModel().getParentModel().getColumnWidth(0);
                TableRowImpl.this.sequence.setLocation(currentX + TableRowImpl.this.getCellPadding(), (int)(((double)parent.getHeight() - TableRowImpl.this.sequence.getPreferredSize().getHeight()) / 2.0));
                TableRowImpl.this.sequence.setSize(w - 2 * TableRowImpl.this.getCellPadding(), (int)TableRowImpl.this.sequence.getPreferredSize().getHeight());
                currentX += w;
                w = TableRowImpl.this.getModel().getParentModel().getColumnWidth(1);
                TableRowImpl.this.type.setLocation(currentX + TableRowImpl.this.getCellPadding(), (int)(((double)parent.getHeight() - TableRowImpl.this.type.getPreferredSize().getHeight()) / 2.0));
                TableRowImpl.this.type.setSize(w - 2 * TableRowImpl.this.getCellPadding(), (int)TableRowImpl.this.type.getPreferredSize().getHeight());
                currentX += w;
                w = TableRowImpl.this.getModel().getParentModel().getColumnWidth(2);
                TableRowImpl.this.parentNutrition.setLocation(currentX + TableRowImpl.this.getCellPadding(), (int)(((double)parent.getHeight() - TableRowImpl.this.parentNutrition.getPreferredSize().getHeight()) / 2.0));
                TableRowImpl.this.parentNutrition.setSize(w - 2 * TableRowImpl.this.getCellPadding(), (int)TableRowImpl.this.parentNutrition.getPreferredSize().getHeight());
                currentX += w;
                w = TableRowImpl.this.getModel().getParentModel().getColumnWidth(3);
                TableRowImpl.this.dailyValue.setLocation(currentX + TableRowImpl.this.getCellPadding(), (int)(((double)parent.getHeight() - TableRowImpl.this.dailyValue.getPreferredSize().getHeight()) / 2.0));
                TableRowImpl.this.dailyValue.setSize(w - 2 * TableRowImpl.this.getCellPadding(), (int)TableRowImpl.this.dailyValue.getPreferredSize().getHeight());
                currentX += w;
                w = TableRowImpl.this.getModel().getParentModel().getColumnWidth(4);
                TableRowImpl.this.qty.setLocation(currentX + TableRowImpl.this.getCellPadding(), (int)(((double)parent.getHeight() - TableRowImpl.this.qty.getPreferredSize().getHeight()) / 2.0));
                TableRowImpl.this.qty.setSize(w - 2 * TableRowImpl.this.getCellPadding(), (int)TableRowImpl.this.qty.getPreferredSize().getHeight());
                currentX += w;
                w = TableRowImpl.this.getModel().getParentModel().getColumnWidth(5);
                TableRowImpl.this.state.setLocation(currentX + TableRowImpl.this.getCellPadding(), (int)(((double)parent.getHeight() - TableRowImpl.this.state.getPreferredSize().getHeight()) / 2.0));
                TableRowImpl.this.state.setSize(w - 2 * TableRowImpl.this.getCellPadding(), (int)TableRowImpl.this.state.getPreferredSize().getHeight());
                currentX += w;
                w = TableRowImpl.this.getModel().getParentModel().getColumnWidth(6);
                TableRowImpl.this.setControlsX(currentX);
                TableRowImpl.this.layoutSortButtons(currentX, parent.getHeight());
            }
        }
    }
}

