/*
 * Decompiled with CFR 0.152.
 */
package ch.icit.pegasus.client.gui.modules.article.details.utils;

import ch.icit.pegasus.client.converter.FormulaConverter;
import ch.icit.pegasus.client.converter.UnitConverter;
import ch.icit.pegasus.client.converter.controller.ConverterRegistry;
import ch.icit.pegasus.client.gui.modules.article.details.SupplierConditionDetailsPanel;
import ch.icit.pegasus.client.gui.table.TableColumnInfo;
import ch.icit.pegasus.client.gui.table2.Table2;
import ch.icit.pegasus.client.gui.table2.Table2ButtonHandler;
import ch.icit.pegasus.client.gui.table2.Table2Model;
import ch.icit.pegasus.client.gui.table2.Table2RowModel;
import ch.icit.pegasus.client.gui.table2.Table2RowPanel;
import ch.icit.pegasus.client.gui.utils.CheckedListAdder;
import ch.icit.pegasus.client.gui.utils.DefaultLayout;
import ch.icit.pegasus.client.gui.utils.Nodable;
import ch.icit.pegasus.client.gui.utils.Selectable;
import ch.icit.pegasus.client.gui.utils.TextLabel;
import ch.icit.pegasus.client.gui.utils.TitledItem;
import ch.icit.pegasus.client.gui.utils.VerticalSeparator;
import ch.icit.pegasus.client.gui.utils.buttons.Button;
import ch.icit.pegasus.client.gui.utils.buttons.DeleteButton;
import ch.icit.pegasus.client.gui.utils.combobox.ComboBox;
import ch.icit.pegasus.client.gui.utils.focus.Focusable;
import ch.icit.pegasus.client.gui.utils.focus.MutableFocusContainer;
import ch.icit.pegasus.client.gui.utils.focus.MutableFocusContainerListener;
import ch.icit.pegasus.client.gui.utils.focus.VisibleContainer;
import ch.icit.pegasus.client.gui.utils.icons.impl.EditOnAddOnlyIcon;
import ch.icit.pegasus.client.gui.utils.panels.ArticlePackagingTable;
import ch.icit.pegasus.client.gui.utils.panels.DefaultPanel;
import ch.icit.pegasus.client.gui.utils.popup.InnerPopupFactory;
import ch.icit.pegasus.client.gui.utils.rightdependant.RDComboBox;
import ch.icit.pegasus.client.gui.utils.rightdependant.RDDateChooser;
import ch.icit.pegasus.client.gui.utils.rightdependant.RDProvider;
import ch.icit.pegasus.client.gui.utils.skins.SizedSkin1Field;
import ch.icit.pegasus.client.gui.utils.tables.TemporalVariantInserter;
import ch.icit.pegasus.client.node.INodeCreator;
import ch.icit.pegasus.client.node.impls.Node;
import ch.icit.pegasus.client.node.impls.NodeListener;
import ch.icit.pegasus.client.node.impls.NodeToolkit;
import ch.icit.pegasus.client.util.ScreenValidationObject;
import ch.icit.pegasus.server.core.dtos.masterdata.PeriodComplete;
import ch.icit.pegasus.server.core.dtos.masterdata.PeriodComplete_;
import ch.icit.pegasus.server.core.dtos.masterdata.UnitComplete;
import ch.icit.pegasus.server.core.dtos.masterdata.UnitSystemComplete;
import ch.icit.pegasus.server.core.dtos.supply.BasicArticleComplete;
import ch.icit.pegasus.server.core.dtos.supply.BasicArticleComplete_;
import ch.icit.pegasus.server.core.dtos.supply.BasicArticleLight_;
import ch.icit.pegasus.server.core.dtos.supply.PackagingQuantityBaseComplete;
import ch.icit.pegasus.server.core.dtos.supply.PackagingQuantityBaseComplete_;
import ch.icit.pegasus.server.core.dtos.supply.PackagingQuantityComplete;
import ch.icit.pegasus.server.core.dtos.supply.PackagingQuantityComplete_;
import ch.icit.pegasus.server.core.dtos.supply.SupplierConditionBaseComplete_;
import ch.icit.pegasus.server.core.dtos.supply.SupplierConditionCategoryComplete_;
import ch.icit.pegasus.server.core.dtos.supply.SupplierConditionComplete_;
import ch.icit.pegasus.server.core.dtos.system.SelectBaseUnitE;
import ch.icit.pegasus.server.core.dtos.system.SystemSettingsComplete;
import ch.icit.pegasus.server.core.i18n.Words;
import ch.icit.pegasus.server.dtos.metamodel.DtoField;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.sql.Date;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;

public class ArticlePackingVariantsTable
extends DefaultPanel
implements Nodable,
MutableFocusContainer,
Focusable,
NodeListener {
    private final Table2 validityTable;
    private final ArticlePackagingTable packingTable;
    private final VerticalSeparator sep;
    private TextLabel formulaString;
    private Node<BasicArticleComplete> articleNode;
    private final RDProvider provider;
    private final Node storeUnitSelectionNode;
    private Node storeUnitBASESelectionNode;
    private TitledItem<RDComboBox> priceUnitCombo;
    private TitledItem<RDComboBox> mainStoreUnitCombo;
    private TitledItem<RDComboBox> floatStoreUnitCombo;
    private TitledItem<Component> baseUnit;
    private TextLabel baseUnitRestrictionPanel;
    private EditOnAddOnlyIcon editOnAddOnlyIcon;
    private UnitComplete oldUnit;
    private SupplierConditionDetailsPanel supplierConditionPanel;
    private boolean addRow = false;
    private SystemSettingsComplete settings;

    public ArticlePackingVariantsTable(RDProvider provider, Node storeUnitSelectionNode, Node storeUnitBASESelectionNode, SupplierConditionDetailsPanel supplierConditionPanel, boolean addRow) {
        this.provider = provider;
        this.storeUnitSelectionNode = storeUnitSelectionNode;
        this.supplierConditionPanel = supplierConditionPanel;
        this.storeUnitBASESelectionNode = storeUnitBASESelectionNode;
        this.addRow = addRow;
        this.packingTable = new ArticlePackagingTable(provider, BasicArticleComplete_.packingQuantitiesVariants, this);
        if (addRow) {
            this.baseUnit = new TitledItem<ComboBox>(new ComboBox(null, null, ConverterRegistry.getConverter(UnitConverter.class)), Words.BASE_UNIT, TitledItem.TitledItemOrientation.NORTH);
            this.editOnAddOnlyIcon = new EditOnAddOnlyIcon();
        } else {
            this.baseUnit = new TitledItem<TextLabel>(new TextLabel(null, ConverterRegistry.getConverter(UnitConverter.class)), Words.BASE_UNIT, TitledItem.TitledItemOrientation.NORTH);
        }
        this.settings = (SystemSettingsComplete)NodeToolkit.getAffixClass(SystemSettingsComplete.class).getValue();
        if (this.isPackingVariantsAllowed()) {
            this.validityTable = new Table2(true, Words.ADD, false, false);
            this.validityTable.setHasLastLine(false);
            this.validityTable.setButtonHandler(new Table2ButtonHandler(){

                @Override
                public void addButtonPressed(int x, int y, Button source) {
                    new PackingBaseInserter().insertNewVariant(ArticlePackingVariantsTable.this, ArticlePackingVariantsTable.this.validityTable.getModel().getNode());
                    ArticlePackingVariantsTable.this.ensureUnitsAreSelectableForStoreUnit();
                }

                @Override
                public void childRemoved() {
                    ArticlePackingVariantsTable.this.revalidate();
                    ArticlePackingVariantsTable.this.ensureUnitsAreSelectableForStoreUnit();
                }
            });
            int tw = this.validityTable.getCellPadding() * 2 + DeleteButton.getPreferredWidth(SizedSkin1Field.SkinSize.SMALL);
            ArrayList<TableColumnInfo> columns = new ArrayList<TableColumnInfo>();
            columns.add(new TableColumnInfo(Words.START, null, null, null, "", 30, Integer.MAX_VALUE, 30));
            columns.add(new TableColumnInfo(Words.END, null, null, null, "", 30, Integer.MAX_VALUE, 30));
            columns.add(new TableColumnInfo("", null, null, null, "", tw, tw, tw));
            ((TableColumnInfo)columns.get(0)).setxExpand(0.5);
            ((TableColumnInfo)columns.get(1)).setxExpand(0.5);
            ((TableColumnInfo)columns.get(2)).setxExpand(0.0);
            Table2Model tModel = new Table2Model(columns, model -> new TableRowImplBase(model, Table2RowPanel.TableControlsType.ONE));
            this.validityTable.setModel(tModel);
            this.validityTable.getModel().addTableSelectionListener((table, panel) -> {
                if (panel != null) {
                    Node listOfPackaging = panel.getModel().getNode().getChildNamed(PackagingQuantityBaseComplete_.packingQuantities);
                    this.packingTable.setNode((Node<List<PackagingQuantityComplete>>)listOfPackaging);
                    this.formulaString.setNode(listOfPackaging);
                }
            });
        } else {
            this.validityTable = null;
        }
        this.priceUnitCombo = new TitledItem<RDComboBox>(new RDComboBox(provider, ConverterRegistry.getConverter(UnitConverter.class)), Words.PRICE_UNIT, TitledItem.TitledItemOrientation.NORTH);
        this.mainStoreUnitCombo = new TitledItem<RDComboBox>(new RDComboBox(provider, ConverterRegistry.getConverter(UnitConverter.class)), Words.MAIN_STORE_UNIT, TitledItem.TitledItemOrientation.NORTH);
        this.floatStoreUnitCombo = new TitledItem<RDComboBox>(new RDComboBox(provider, ConverterRegistry.getConverter(UnitConverter.class)), Words.FLOAT_STORE_UNIT, TitledItem.TitledItemOrientation.NORTH);
        this.formulaString = new TextLabel(null, ConverterRegistry.getConverter(FormulaConverter.class));
        this.formulaString.setProgress(1.0f);
        this.formulaString.listenToChildAddRemove(true);
        this.setLayout(new Layout());
        if (this.isPackingVariantsAllowed()) {
            this.sep = new VerticalSeparator();
            this.add(this.validityTable);
            this.add(this.sep);
        } else {
            this.sep = null;
        }
        this.add(this.packingTable);
        this.add(this.formulaString);
        this.add(this.priceUnitCombo);
        this.add(this.mainStoreUnitCombo);
        this.add(this.baseUnit);
        this.add(this.floatStoreUnitCombo);
        if (addRow) {
            this.baseUnitRestrictionPanel = new TextLabel();
            if (SelectBaseUnitE.ONLY_MASS_AND_PIECE.equals((Object)this.settings.getSelectBaseUnits())) {
                this.baseUnitRestrictionPanel.setText(Words.BASE_UNIT_RESTRICTION);
            } else if (SelectBaseUnitE.CONFIGURATION.equals((Object)this.settings.getSelectBaseUnits())) {
                this.baseUnitRestrictionPanel.setText(Words.CONFIGURATION_OF_BASE_UNIT);
            } else {
                this.baseUnitRestrictionPanel.setText(Words.NO_BASE_UNIT_RESTRICTION);
            }
            this.add(this.baseUnitRestrictionPanel);
            this.add(this.editOnAddOnlyIcon);
        }
    }

    public Node getStoreUnitSelectionNode() {
        return this.storeUnitSelectionNode;
    }

    private boolean isPackingVariantsAllowed() {
        return Boolean.TRUE.equals(this.settings.getAllowPackingTableVariants());
    }

    private void ensureSupplierConditionPrice(UnitComplete newStoreUnit) {
        ArrayList<ScreenValidationObject> values;
        long currentID = System.currentTimeMillis();
        BasicArticleComplete artC = (BasicArticleComplete)this.articleNode.getValue(BasicArticleComplete.class);
        if (!this.addRow) {
            values = new ArrayList<ScreenValidationObject>();
            values.add(new ScreenValidationObject(ScreenValidationObject.ValidationStateE.MESSAGE, Words.SUPPLIER_ORDER_INTERVAL_AUTO_CHANGED));
            InnerPopupFactory.showMessageDialog(values, Words.STORE_UNIT_CHANGED, Words.CHANGE_OF_STORE_UNIT_EFFECTS_SUPPLIER_CONDITON_ETC, (Component)this);
        }
        if (this.supplierConditionPanel != null) {
            this.supplierConditionPanel.updateCurrent();
        }
        this.oldUnit = newStoreUnit;
        if (!this.addRow) {
            values = new ArrayList();
            values.add(new ScreenValidationObject(ScreenValidationObject.ValidationStateE.MESSAGE, Words.SUPPLIER_PRICE_AUTO_CHANGED));
            values.add(new ScreenValidationObject(ScreenValidationObject.ValidationStateE.MESSAGE, Words.STANDARD_ARTICLE_PRICE_AUTO_CHANGED));
            values.add(new ScreenValidationObject(ScreenValidationObject.ValidationStateE.MESSAGE, Words.PLEASE_REVIEW_SUPPLIERS_ORDER_INTERVAL));
            values.add(new ScreenValidationObject(ScreenValidationObject.ValidationStateE.MESSAGE, Words.PLEASE_REVIEW_STORE_CONDITIONS));
            InnerPopupFactory.showMessageDialog(values, Words.STORE_UNIT_CHANGED, Words.CHANGE_OF_STORE_UNIT_EFFECTS_SUPPLIER_CONDITON_ETC, (Component)this);
        }
    }

    public void ensureUnitsAreSelectableForStoreUnit() {
        Iterator it = this.articleNode.getChildNamed(BasicArticleComplete_.packingQuantitiesVariants).getFailSafeChildIterator();
        HashSet<UnitComplete> units = new HashSet<UnitComplete>();
        while (it.hasNext()) {
            Node n = (Node)it.next();
            Iterator it2 = n.getChildNamed(PackagingQuantityBaseComplete_.packingQuantities).getFailSafeChildIterator();
            while (it2.hasNext()) {
                Node p = (Node)it2.next();
                UnitComplete unit = (UnitComplete)p.getChildNamed(PackagingQuantityComplete_.unit).getValue();
                units.addAll(this.getUnitsForUnitSystem(unit.getUnitSystem()));
            }
        }
        HashMap<Object, Node> childIndex = new HashMap<Object, Node>();
        it = this.storeUnitSelectionNode.getFailSafeChildIterator();
        while (it.hasNext()) {
            Node n = (Node)it.next();
            if (!units.contains(n.getValue())) {
                this.storeUnitSelectionNode.removeChild(n, 0L);
                continue;
            }
            childIndex.put(n.getValue(), n);
        }
        for (UnitComplete unit : units) {
            if (childIndex.containsKey(unit)) continue;
            this.storeUnitSelectionNode.addChild(INodeCreator.getDefaultImpl().getNode4DTO((Object)unit, true, true), 0L);
        }
        if (SelectBaseUnitE.ONLY_MASS_AND_PIECE.equals((Object)this.settings.getSelectBaseUnits())) {
            UnitSystemComplete massUnitSystem = this.settings.getDefaultCustomsPenaltyUnit().getUnitSystem();
            UnitSystemComplete pieceUnitSystem = this.settings.getPieceUnit().getUnitSystem();
            childIndex = new HashMap();
            it = this.storeUnitBASESelectionNode.getFailSafeChildIterator();
            while (it.hasNext()) {
                Node n = (Node)it.next();
                if (!((UnitComplete)n.getValue()).getUnitSystem().equals((Object)massUnitSystem) && !((UnitComplete)n.getValue()).getUnitSystem().equals((Object)pieceUnitSystem)) {
                    this.storeUnitBASESelectionNode.removeChild(n, 0L);
                    continue;
                }
                if (!units.contains(n.getValue())) {
                    this.storeUnitBASESelectionNode.removeChild(n, 0L);
                    continue;
                }
                childIndex.put(n.getValue(), n);
            }
            for (UnitComplete unit : units) {
                if (childIndex.containsKey(unit) || !unit.getUnitSystem().equals((Object)massUnitSystem) && !unit.getUnitSystem().equals((Object)pieceUnitSystem)) continue;
                this.storeUnitBASESelectionNode.addChild(INodeCreator.getDefaultImpl().getNode4DTO((Object)unit, true, true), 0L);
            }
        } else if (SelectBaseUnitE.CONFIGURATION.equals((Object)this.settings.getSelectBaseUnits())) {
            List unitList = this.settings.getUnitListForBaseUnit();
            childIndex = new HashMap();
            it = this.storeUnitBASESelectionNode.getFailSafeChildIterator();
            while (it.hasNext()) {
                Node n = (Node)it.next();
                if (!unitList.contains(n.getValue())) {
                    this.storeUnitBASESelectionNode.removeChild(n, 0L);
                    continue;
                }
                childIndex.put(n.getValue(), n);
            }
            for (UnitComplete unit : unitList) {
                if (childIndex.containsKey(unit)) continue;
                this.storeUnitBASESelectionNode.addChild(INodeCreator.getDefaultImpl().getNode4DTO((Object)unit, true, true), 0L);
            }
        } else {
            this.storeUnitBASESelectionNode = this.storeUnitSelectionNode;
        }
        this.formulaString.updateString();
    }

    public void updateOrderIntervalUnits() {
        if (this.supplierConditionPanel != null) {
            this.supplierConditionPanel.updateOrderIntervalUnits();
        }
    }

    private Set<UnitComplete> getUnitsForUnitSystem(UnitSystemComplete unitSystem) {
        HashSet<UnitComplete> units = new HashSet<UnitComplete>();
        if (unitSystem != null) {
            UnitComplete unit;
            for (unit = unitSystem.getBaseUnit(); unit != null; unit = unit.getSubUnit()) {
                units.add(unit);
            }
            for (unit = unitSystem.getBaseUnit(); unit != null; unit = unit.getSuperUnit()) {
                units.add(unit);
            }
        }
        return units;
    }

    @Override
    public List<Component> getFocusComponents() {
        ArrayList<Component> focusList = new ArrayList<Component>();
        CheckedListAdder.addToList(focusList, this.validityTable);
        CheckedListAdder.addToList(focusList, this.packingTable);
        CheckedListAdder.addToList(focusList, this.priceUnitCombo);
        CheckedListAdder.addToList(focusList, this.mainStoreUnitCombo);
        CheckedListAdder.addToList(focusList, this.floatStoreUnitCombo);
        CheckedListAdder.addToList(focusList, this.baseUnit);
        return focusList;
    }

    @Override
    public void setVisibleContainer(VisibleContainer pane) {
    }

    @Override
    public void requestFocusInWindowNow() {
    }

    @Override
    public Selectable getSelectDelegationComponent() {
        return null;
    }

    @Override
    public void setNode(Node<?> node) {
        if (this.articleNode != null) {
            this.articleNode.removeNodeListener((NodeListener)this);
        }
        this.articleNode = node;
        this.oldUnit = (UnitComplete)this.articleNode.getChildNamed(BasicArticleComplete_.priceUnit).getValue();
        this.articleNode.getChildNamed(BasicArticleComplete_.priceUnit).addNodeListener((NodeListener)this);
        this.articleNode.getChildNamed(BasicArticleComplete_.mainStoreUnit).addNodeListener((NodeListener)this);
        if (this.isPackingVariantsAllowed()) {
            this.validityTable.getModel().setNode(node.getChildNamed(BasicArticleComplete_.packingQuantitiesVariants));
        } else {
            Node listOfPackaging = node.getChildNamed(BasicArticleComplete_.packingQuantitiesVariants).getChildAt(0).getChildNamed(PackagingQuantityBaseComplete_.packingQuantities);
            this.packingTable.setNode((Node<List<PackagingQuantityComplete>>)listOfPackaging);
            this.formulaString.setNode(listOfPackaging);
        }
        this.ensureUnitsAreSelectableForStoreUnit();
        this.priceUnitCombo.getElement().refreshPossibleValues(this.storeUnitSelectionNode);
        this.priceUnitCombo.getElement().setNode(this.articleNode.getChildNamed(BasicArticleComplete_.priceUnit));
        this.mainStoreUnitCombo.getElement().refreshPossibleValues(this.storeUnitSelectionNode);
        this.mainStoreUnitCombo.getElement().setNode(this.articleNode.getChildNamed(BasicArticleComplete_.mainStoreUnit));
        this.floatStoreUnitCombo.getElement().refreshPossibleValues(this.storeUnitSelectionNode);
        this.floatStoreUnitCombo.getElement().setNode(this.articleNode.getChildNamed(BasicArticleComplete_.floatStoreUnit));
        if (this.addRow) {
            ((ComboBox)this.baseUnit.getElement()).refreshPossibleValues(this.storeUnitBASESelectionNode);
            ((ComboBox)this.baseUnit.getElement()).setNode(this.articleNode.getChildNamed(BasicArticleComplete_.baseUnit));
        } else {
            ((TextLabel)this.baseUnit.getElement()).setNode(this.articleNode.getChildNamed(BasicArticleComplete_.baseUnit));
        }
    }

    @Override
    public Node<?> getNode() {
        return this.articleNode;
    }

    @Override
    public void addFocusCycleChangeListener(MutableFocusContainerListener listener) {
    }

    @Override
    public void removeFocusCycleChangeListener(MutableFocusContainerListener listener) {
    }

    public void valueChanged(Node<?> node) {
        if (node.getName().equals(BasicArticleLight_.priceUnit.getFieldName()) && !Boolean.TRUE.equals(this.settings.getUseSeparatePurchaseOrderPriceUnitForSuppliers())) {
            this.ensureSupplierConditionPrice((UnitComplete)node.getValue());
        }
        if (node.getName().equals(BasicArticleLight_.mainStoreUnit.getFieldName()) && !Boolean.TRUE.equals(this.settings.getUseDifferentPurchaseOrderUnits())) {
            this.updateMinOrderAmountUnit((UnitComplete)node.getValue());
        }
    }

    private void updateMinOrderAmountUnit(UnitComplete newStoreUnit) {
        Iterator it1 = this.articleNode.getChildNamed(BasicArticleComplete_.suppliers).getChilds();
        while (it1.hasNext()) {
            Node conditionBase = (Node)it1.next();
            Iterator it = conditionBase.getChildNamed(SupplierConditionBaseComplete_.supplierConditionCategory).getChilds();
            while (it.hasNext()) {
                Node cat = (Node)it.next();
                Iterator it2 = cat.getChildNamed(SupplierConditionCategoryComplete_.conditions).getFailSafeChildIterator();
                while (it2.hasNext()) {
                    Node sup = (Node)it2.next();
                    Node currentUnit = sup.getChildNamed(SupplierConditionComplete_.minOrderAmountUnit);
                    currentUnit.setValue((Object)newStoreUnit, 0L);
                }
            }
        }
    }

    public void childAdded(Node<?> source, Node<?> child) {
    }

    public void childRemoved(Node<?> source, Node<?> child) {
    }

    public void childrenAdded(Node<?> source, Node<?>[] nodes) {
    }

    public boolean isSwingOnly() {
        return false;
    }

    public void invalidateStoreUnit(boolean isValid) {
        if (isValid) {
            this.priceUnitCombo.getElement().setValid();
        } else {
            this.priceUnitCombo.getElement().setInvalid();
        }
    }

    private class PackingBaseInserter
    extends TemporalVariantInserter<PackagingQuantityBaseComplete> {
        private PackingBaseInserter() {
        }

        @Override
        public Node<PackagingQuantityBaseComplete> getLatestData() {
            return ArticlePackingVariantsTable.this.validityTable.getModel().getNode().getChildCount() > 0 ? ArticlePackingVariantsTable.this.validityTable.getModel().getNode().getChildAt(ArticlePackingVariantsTable.this.validityTable.getModel().getNode().getChildCount() - 1) : null;
        }

        @Override
        public PackagingQuantityBaseComplete createNewVariant() {
            return new PackagingQuantityBaseComplete();
        }

        @Override
        public Node<Date> getStartDate(Node<PackagingQuantityBaseComplete> node) {
            return node.getChildNamed(new DtoField[]{PackagingQuantityBaseComplete_.period, PeriodComplete_.startDate});
        }

        @Override
        public Node<Date> getEndDate(Node<PackagingQuantityBaseComplete> node) {
            return node.getChildNamed(new DtoField[]{PackagingQuantityBaseComplete_.period, PeriodComplete_.endDate});
        }

        @Override
        public void setValidityPeriod(PackagingQuantityBaseComplete data, PeriodComplete period) {
            data.setPeriod(period);
        }
    }

    private class TableRowImplBase
    extends Table2RowPanel {
        private RDDateChooser startDate;
        private RDDateChooser endDate;
        private DeleteButton delete;

        public TableRowImplBase(Table2RowModel m, Table2RowPanel.TableControlsType controlSkin) {
            super(m);
            this.setUseControlSkin(controlSkin);
            this.setSelectable(true);
            this.startDate = new RDDateChooser(ArticlePackingVariantsTable.this.provider);
            this.startDate.setOverrideName(PackagingQuantityBaseComplete_.period);
            this.startDate.setNode(m.getNode().getChildNamed(new DtoField[]{PackagingQuantityBaseComplete_.period, PeriodComplete_.startDate}));
            this.endDate = new RDDateChooser(ArticlePackingVariantsTable.this.provider);
            this.endDate.setOverrideName(PackagingQuantityBaseComplete_.period);
            this.endDate.setCheckBoxEnabled();
            this.endDate.setNode(m.getNode().getChildNamed(new DtoField[]{PackagingQuantityBaseComplete_.period, PeriodComplete_.endDate}));
            boolean deletable = ArticlePackingVariantsTable.this.provider.isDeletable(BasicArticleComplete_.packingQuantitiesVariants);
            if (deletable) {
                this.delete = new DeleteButton();
                this.delete.addButtonListener((source, x, y) -> this.model.getParentModel().getNode().removeChild(this.model.getNode(), 0L));
            }
            this.setLayout(new BaseLayout());
            this.add(this.startDate);
            this.add(this.endDate);
            if (this.delete != null) {
                this.add(this.delete);
            }
        }

        @Override
        public Object getObject4Column(int column) {
            return this.model.getNode().getChildNamed(new DtoField[]{PackagingQuantityBaseComplete_.period, PeriodComplete_.startDate}).getValue();
        }

        private class BaseLayout
        extends DefaultLayout {
            private BaseLayout() {
            }

            @Override
            public Dimension preferredLayoutSize(Container parent) {
                return new Dimension(0, TableRowImplBase.this.getDefaultRowHeight());
            }

            @Override
            public void layoutContainer(Container parent) {
                int currentX = 0;
                int w = TableRowImplBase.this.model.getParentModel().getColumnWidth(0);
                TableRowImplBase.this.startDate.setLocation(currentX + TableRowImplBase.this.getCellPadding(), (int)(((double)parent.getHeight() - TableRowImplBase.this.startDate.getPreferredSize().getHeight()) / 2.0));
                TableRowImplBase.this.startDate.setSize(w - 2 * TableRowImplBase.this.getCellPadding(), (int)TableRowImplBase.this.startDate.getPreferredSize().getHeight());
                currentX += w;
                w = TableRowImplBase.this.model.getParentModel().getColumnWidth(1);
                TableRowImplBase.this.endDate.setLocation(currentX + TableRowImplBase.this.getCellPadding(), (int)(((double)parent.getHeight() - TableRowImplBase.this.endDate.getPreferredSize().getHeight()) / 2.0));
                TableRowImplBase.this.endDate.setSize(w - 2 * TableRowImplBase.this.getCellPadding(), (int)TableRowImplBase.this.endDate.getPreferredSize().getHeight());
                currentX += w;
                w = TableRowImplBase.this.model.getParentModel().getColumnWidth(2);
                TableRowImplBase.this.setControlsX(currentX);
                if (TableRowImplBase.this.delete != null) {
                    TableRowImplBase.this.delete.setLocation(currentX + TableRowImplBase.this.getCellPadding(), (int)(((double)parent.getHeight() - TableRowImplBase.this.delete.getPreferredSize().getHeight()) / 2.0));
                    TableRowImplBase.this.delete.setSize(w - 2 * TableRowImplBase.this.getCellPadding(), (int)TableRowImplBase.this.delete.getPreferredSize().getHeight());
                }
            }
        }
    }

    private class Layout
    extends DefaultLayout {
        private Layout() {
        }

        @Override
        public Dimension preferredLayoutSize(Container parent) {
            return new Dimension(0, 350);
        }

        @Override
        public void layoutContainer(Container parent) {
            int tableHeight = (int)((double)parent.getHeight() - (10.0 + ArticlePackingVariantsTable.this.priceUnitCombo.getPreferredSize().getHeight() + 5.0 + ArticlePackingVariantsTable.this.formulaString.getPreferredSize().getHeight()));
            int nx = 0;
            if (ArticlePackingVariantsTable.this.isPackingVariantsAllowed()) {
                ArticlePackingVariantsTable.this.validityTable.setLocation(0, 0);
                ArticlePackingVariantsTable.this.validityTable.setSize(350, tableHeight);
                nx = ArticlePackingVariantsTable.this.validityTable.getX() + ArticlePackingVariantsTable.this.validityTable.getWidth();
                ArticlePackingVariantsTable.this.sep.setLocation(nx, 0);
                ArticlePackingVariantsTable.this.sep.setSize((int)ArticlePackingVariantsTable.this.sep.getPreferredSize().getWidth(), tableHeight);
                nx = ArticlePackingVariantsTable.this.sep.getX() + ArticlePackingVariantsTable.this.sep.getWidth();
            }
            ArticlePackingVariantsTable.this.packingTable.setLocation(nx, 0);
            ArticlePackingVariantsTable.this.packingTable.setSize(parent.getWidth() - ArticlePackingVariantsTable.this.packingTable.getX(), tableHeight);
            ArticlePackingVariantsTable.this.formulaString.setLocation(10, ArticlePackingVariantsTable.this.packingTable.getY() + ArticlePackingVariantsTable.this.packingTable.getHeight() + 5);
            ArticlePackingVariantsTable.this.formulaString.setSize(parent.getWidth() - 20, (int)ArticlePackingVariantsTable.this.formulaString.getPreferredSize().getHeight());
            ArticlePackingVariantsTable.this.priceUnitCombo.setLocation(10, ArticlePackingVariantsTable.this.formulaString.getY() + ArticlePackingVariantsTable.this.formulaString.getHeight() + 5);
            ArticlePackingVariantsTable.this.priceUnitCombo.setSize((int)(ArticlePackingVariantsTable.this.priceUnitCombo.getPreferredSize().getWidth() + 35.0), (int)ArticlePackingVariantsTable.this.priceUnitCombo.getPreferredSize().getHeight());
            ArticlePackingVariantsTable.this.mainStoreUnitCombo.setLocation(ArticlePackingVariantsTable.this.priceUnitCombo.getX() + ArticlePackingVariantsTable.this.priceUnitCombo.getWidth() + 10, ArticlePackingVariantsTable.this.priceUnitCombo.getY());
            ArticlePackingVariantsTable.this.mainStoreUnitCombo.setSize(ArticlePackingVariantsTable.this.mainStoreUnitCombo.getPreferredSize());
            ArticlePackingVariantsTable.this.floatStoreUnitCombo.setLocation(ArticlePackingVariantsTable.this.mainStoreUnitCombo.getX() + ArticlePackingVariantsTable.this.mainStoreUnitCombo.getWidth() + 10, ArticlePackingVariantsTable.this.mainStoreUnitCombo.getY());
            ArticlePackingVariantsTable.this.floatStoreUnitCombo.setSize(ArticlePackingVariantsTable.this.floatStoreUnitCombo.getPreferredSize());
            ArticlePackingVariantsTable.this.baseUnit.setLocation(ArticlePackingVariantsTable.this.floatStoreUnitCombo.getX() + ArticlePackingVariantsTable.this.floatStoreUnitCombo.getWidth() + 10, ArticlePackingVariantsTable.this.floatStoreUnitCombo.getY());
            ArticlePackingVariantsTable.this.baseUnit.setSize(ArticlePackingVariantsTable.this.baseUnit.getPreferredSize());
            if (ArticlePackingVariantsTable.this.editOnAddOnlyIcon != null) {
                ArticlePackingVariantsTable.this.editOnAddOnlyIcon.setLocation(ArticlePackingVariantsTable.this.baseUnit.getX() + ArticlePackingVariantsTable.this.baseUnit.getWidth() + 7, ArticlePackingVariantsTable.this.mainStoreUnitCombo.getY() + 20);
                ArticlePackingVariantsTable.this.editOnAddOnlyIcon.setSize(ArticlePackingVariantsTable.this.editOnAddOnlyIcon.getPreferredSize());
                if (ArticlePackingVariantsTable.this.baseUnitRestrictionPanel != null) {
                    ArticlePackingVariantsTable.this.baseUnitRestrictionPanel.setLocation(ArticlePackingVariantsTable.this.editOnAddOnlyIcon.getX() + ArticlePackingVariantsTable.this.editOnAddOnlyIcon.getWidth() + 10, ArticlePackingVariantsTable.this.editOnAddOnlyIcon.getY());
                    ArticlePackingVariantsTable.this.baseUnitRestrictionPanel.setSize(ArticlePackingVariantsTable.this.baseUnitRestrictionPanel.getPreferredSize());
                }
            }
        }
    }
}

