/*
 * Decompiled with CFR 0.152.
 */
package ch.icit.pegasus.client.gui.modules.articlepricecontract.details;

import ch.icit.pegasus.client.converter.ArticlePriceScaleConverter;
import ch.icit.pegasus.client.converter.BasicArticleConverter;
import ch.icit.pegasus.client.converter.DateConverter;
import ch.icit.pegasus.client.converter.IntegerConverter;
import ch.icit.pegasus.client.converter.TaxZoneConverter;
import ch.icit.pegasus.client.converter.controller.ConverterRegistry;
import ch.icit.pegasus.client.gui.modules.articlepricecontract.details.ActionDetailsPanel;
import ch.icit.pegasus.client.gui.modules.articlepricecontract.details.utils.ArticleEntryConverter;
import ch.icit.pegasus.client.gui.modules.articlepricecontract.details.utils.ScaleEditPopup;
import ch.icit.pegasus.client.gui.screentemplates.details.TableDetailsPanel;
import ch.icit.pegasus.client.gui.table.RowEditor;
import ch.icit.pegasus.client.gui.table.TableColumnInfo;
import ch.icit.pegasus.client.gui.table2.SortableTable2RowPanel;
import ch.icit.pegasus.client.gui.table2.Table2;
import ch.icit.pegasus.client.gui.table2.Table2RowModel;
import ch.icit.pegasus.client.gui.table2.Table2RowPanel;
import ch.icit.pegasus.client.gui.utils.CheckedListAdder;
import ch.icit.pegasus.client.gui.utils.DefaultLayout;
import ch.icit.pegasus.client.gui.utils.InnerPopUpListener2;
import ch.icit.pegasus.client.gui.utils.QuantityRenderer;
import ch.icit.pegasus.client.gui.utils.TextLabel;
import ch.icit.pegasus.client.gui.utils.TitledItem;
import ch.icit.pegasus.client.gui.utils.buttons.ArticleInfoButton;
import ch.icit.pegasus.client.gui.utils.buttons.ArticleProductInfoButton;
import ch.icit.pegasus.client.gui.utils.buttons.Button;
import ch.icit.pegasus.client.gui.utils.buttons.ButtonListener;
import ch.icit.pegasus.client.gui.utils.buttons.CheckBox;
import ch.icit.pegasus.client.gui.utils.buttons.DeleteButton;
import ch.icit.pegasus.client.gui.utils.buttons.EditButton;
import ch.icit.pegasus.client.gui.utils.buttons.TextButton;
import ch.icit.pegasus.client.gui.utils.datechooser.DateChooser;
import ch.icit.pegasus.client.gui.utils.icons.impl.CheckBoxRO;
import ch.icit.pegasus.client.gui.utils.popup.InnerPopUp2;
import ch.icit.pegasus.client.gui.utils.popup.InnerPopupFactory;
import ch.icit.pegasus.client.gui.utils.rightdependant.RDProvider;
import ch.icit.pegasus.client.gui.utils.searchbox.SearchTextField2;
import ch.icit.pegasus.client.gui.utils.searchbox.SearchTextField2Factory;
import ch.icit.pegasus.client.gui.utils.searchbox.SearchTextField2Listener;
import ch.icit.pegasus.client.gui.utils.skins.SizedSkin1Field;
import ch.icit.pegasus.client.node.INodeCreator;
import ch.icit.pegasus.client.node.impls.DTOProxyNode;
import ch.icit.pegasus.client.node.impls.Node;
import ch.icit.pegasus.client.node.impls.NodeListener;
import ch.icit.pegasus.client.node.impls.NodeToolkit;
import ch.icit.pegasus.client.node.impls.ViewNode;
import ch.icit.pegasus.client.search.SearchResultIterator;
import ch.icit.pegasus.client.services.ServiceManagerRegistry;
import ch.icit.pegasus.client.services.interfaces.supply.SupplyServiceManager;
import ch.icit.pegasus.client.util.RemoteLoader;
import ch.icit.pegasus.client.util.ScreenValidationObject;
import ch.icit.pegasus.client.util.async.ThreadSafeExecutable;
import ch.icit.pegasus.client.util.async.ThreadSafeLoader;
import ch.icit.pegasus.client.util.exception.ClientException;
import ch.icit.pegasus.client.util.exception.ClientExceptionCollection;
import ch.icit.pegasus.client.util.exception.ClientGetFromServerException;
import ch.icit.pegasus.client.util.exception.ClientServerCallException;
import ch.icit.pegasus.client.util.loaders.BasicArticleLoader;
import ch.icit.pegasus.client.util.toolkits.ArticlePriceContractToolkit;
import ch.icit.pegasus.client.util.toolkits.ArticleToolkit;
import ch.icit.pegasus.server.core.dtos.ADTO;
import ch.icit.pegasus.server.core.dtos.handlingcost.StepPriceCalculationComplete;
import ch.icit.pegasus.server.core.dtos.handlingcost.StepPriceFunctionComplete;
import ch.icit.pegasus.server.core.dtos.masterdata.PeriodComplete_;
import ch.icit.pegasus.server.core.dtos.masterdata.QuantityComplete;
import ch.icit.pegasus.server.core.dtos.masterdata.TaxZoneComplete;
import ch.icit.pegasus.server.core.dtos.masterdata.UnitComplete;
import ch.icit.pegasus.server.core.dtos.rightmanagement.template.def.ArticlePriceContractAccess;
import ch.icit.pegasus.server.core.dtos.search.BasicArticleSearchConfiguration;
import ch.icit.pegasus.server.core.dtos.supply.ArticlePriceContractComplete;
import ch.icit.pegasus.server.core.dtos.supply.ArticlePriceContractComplete_;
import ch.icit.pegasus.server.core.dtos.supply.ArticlePriceContractEntryComplete;
import ch.icit.pegasus.server.core.dtos.supply.ArticlePriceContractEntryComplete_;
import ch.icit.pegasus.server.core.dtos.supply.ArticlePriceContractLight;
import ch.icit.pegasus.server.core.dtos.supply.ArticlePriceContractStateE;
import ch.icit.pegasus.server.core.dtos.supply.BasicArticleComplete;
import ch.icit.pegasus.server.core.dtos.supply.BasicArticleLight;
import ch.icit.pegasus.server.core.dtos.supply.BasicArticleReference;
import ch.icit.pegasus.server.core.dtos.supply.PriceComplete;
import ch.icit.pegasus.server.core.dtos.supply.SupplierConditionComplete;
import ch.icit.pegasus.server.core.dtos.supply.SupplierLight;
import ch.icit.pegasus.server.core.dtos.supply.SupplierReference;
import ch.icit.pegasus.server.core.dtos.utils.ArticlePriceCalculationToolkit;
import ch.icit.pegasus.server.core.general.ASearchConfiguration;
import ch.icit.pegasus.server.core.i18n.Words;
import ch.icit.pegasus.server.dtos.metamodel.DtoField;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.sql.Date;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import javax.swing.SwingUtilities;

public class ArticleDetailsPanel
extends TableDetailsPanel<ArticlePriceContractLight>
implements SearchTextField2Listener,
NodeListener,
InnerPopUpListener2 {
    private static final long serialVersionUID = 1L;
    private TitledItem<SearchTextField2> articleSearch;
    private TitledItem<CheckBox> contracted;
    private TextButton add;
    private TextButton addAll;
    private TextButton updateArticles;
    private boolean isPriceEditAllowed = true;
    private boolean isScaleEditAllowed = true;
    private boolean isDeletable = true;
    private ActionDetailsPanel actionPanel;
    private SupplierLight currentSupplier;
    private int loadingState = 0;
    private static final int TYPE_LOAD_ARTICLE = 3;
    private static final int TYPE_ARTICLE_LIST = 5;
    private static final int TYPE_UPDATE_ARTICLE = 19;
    private boolean isExported;
    private boolean isUpdateAllowed = true;
    private boolean isAddAllowed = true;
    private boolean isAddAllAllowed = true;

    public ArticleDetailsPanel(RowEditor<ArticlePriceContractLight> editor, RDProvider provider, ActionDetailsPanel aP) {
        super(editor, provider, true, true, false, false);
        this.actionPanel = aP;
        this.setTitleText(Words.ARTICLES);
        this.isPriceEditAllowed = provider.isWritable(ArticlePriceContractAccess.E_PRICE);
        this.isScaleEditAllowed = provider.isWritable(ArticlePriceContractAccess.E_SCALE);
        this.isDeletable = provider.isDeletable(ArticlePriceContractComplete_.articles);
        this.isUpdateAllowed = provider.isWritable(ArticlePriceContractAccess.UPDATE);
        this.isAddAllowed = provider.isAddable(ArticlePriceContractComplete_.articles);
        this.isAddAllAllowed = provider.isWritable(ArticlePriceContractAccess.ADD_ALL);
        this.articleSearch = new TitledItem<SearchTextField2<BasicArticleLight>>(SearchTextField2Factory.getBasicArticleSearchField(false, new DTOProxyNode(null)), Words.SEARCH, TitledItem.TitledItemOrientation.NORTH);
        this.articleSearch.getElement().addSearchTextFieldListener(this);
        this.contracted = new TitledItem<CheckBox>(new CheckBox(), Words.CONTRACTED, TitledItem.TitledItemOrientation.EAST);
        this.add = new TextButton(Words.ADD);
        this.addAll = new TextButton(Words.ADD_ALL);
        this.updateArticles = new TextButton(Words.UPDATE_ARTICLE_PRICES);
        this.add.addButtonListener(this);
        this.addAll.addButtonListener(this);
        this.updateArticles.addButtonListener(this);
        this.add.setEnabled(false);
        this.addToView(this.articleSearch);
        this.addToView(this.contracted);
        this.addToView(this.add);
        this.addToView(this.addAll);
        this.addToView(this.updateArticles);
    }

    @Override
    public List<TableColumnInfo> getColumns(boolean add) {
        ArrayList<TableColumnInfo> columns = new ArrayList<TableColumnInfo>();
        columns.add(new TableColumnInfo(Words.NO_NUMBER, null, null, null, "", TableColumnInfo.numberColumnWidth, TableColumnInfo.numberColumnWidth, TableColumnInfo.numberColumnWidth));
        columns.add(new TableColumnInfo(Words.ARTICLE, null, null, null, "", 40, 40, 40));
        columns.add(new TableColumnInfo(Words.TAX_ZONE, null, null, null, "", 80, 80, 80));
        int tw = DateChooser.getPreferredWidth(this, false) + 10;
        columns.add(new TableColumnInfo(Words.ARTICLE_UPDATED, null, null, null, "", tw, tw, tw));
        columns.add(new TableColumnInfo(Words.SCALE, null, null, null, "", tw += EditButton.getPreferredWidth(SizedSkin1Field.SkinSize.SMALL) + 10, tw, tw));
        tw = QuantityRenderer.getPreferredSize(this) + 30 + EditButton.getPreferredWidth(SizedSkin1Field.SkinSize.SMALL);
        columns.add(new TableColumnInfo(Words.PRICE, null, null, null, "", tw, tw, tw));
        tw = CheckBox.getPreferredWidth() + 2 * this.table.getCellPadding();
        columns.add(new TableColumnInfo(Words.BONDED, null, null, null, "", tw, tw, tw));
        columns.add(new TableColumnInfo(Words.CAN_BE_ORDERED, null, null, null, "", tw, tw, tw));
        tw = 3 * this.table.getCellPadding() + 3 * DeleteButton.getPreferredWidth(SizedSkin1Field.SkinSize.SMALL) + this.table.getInnerCellPadding();
        columns.add(new TableColumnInfo("", null, null, null, "", tw, tw, tw));
        ((TableColumnInfo)columns.get(0)).setxExpand(0.0);
        ((TableColumnInfo)columns.get(1)).setxExpand(1.0);
        ((TableColumnInfo)columns.get(2)).setxExpand(0.0);
        ((TableColumnInfo)columns.get(3)).setxExpand(0.0);
        ((TableColumnInfo)columns.get(4)).setxExpand(0.0);
        ((TableColumnInfo)columns.get(5)).setxExpand(0.0);
        ((TableColumnInfo)columns.get(6)).setxExpand(0.0);
        ((TableColumnInfo)columns.get(7)).setxExpand(0.0);
        ((TableColumnInfo)columns.get(8)).setxExpand(0.0);
        return columns;
    }

    @Override
    public void configTable(Table2 table) {
        table.setScrollDownOnAdd(false);
        table.setRequestFocusOnAdd(true);
        table.setSortedColumn(0);
    }

    @Override
    public void addButtonPressed(int x, int y, Button source) {
        this.editor.revalidate();
        this.table.writeNumber(ArticlePriceContractEntryComplete_.positionNumber, 1);
    }

    @Override
    public void childRemoved() {
        this.table.writeNumber(ArticlePriceContractEntryComplete_.positionNumber, 1);
        this.editor.revalidate();
    }

    @Override
    public Table2RowPanel generateView(Table2RowModel model, boolean isHeader) {
        TableRowImpl p = new TableRowImpl(model);
        p.setUseControlSkin(Table2RowPanel.TableControlsType.ONE);
        return p;
    }

    @Override
    public void setEnabled(boolean isEnabled) {
        super.setEnabled(isEnabled);
        boolean isAccepted = this.editor.getModel().getNode().getChildNamed(ArticlePriceContractComplete_.state).getValue() == ArticlePriceContractStateE.ACCPTED;
        this.articleSearch.setEnabled(isEnabled && !this.isExported && this.isAddAllowed && !isAccepted);
        this.contracted.setEnabled(isEnabled && !this.isExported && this.isAddAllowed && !isAccepted);
        this.add.setEnabled(isEnabled && this.articleSearch.getElement().isItemSelected() && !this.isExported && this.isAddAllowed && !isAccepted);
        this.addAll.setEnabled(isEnabled && !this.isExported && this.isAddAllAllowed && !isAccepted);
        this.updateArticles.setEnabled(isEnabled && this.isUpdateAllowed && !isAccepted);
        if (isEnabled) {
            this.table.setLocked(!isAccepted);
        } else {
            this.table.setEnabled(isEnabled);
        }
    }

    @Override
    public void kill() {
        if (this.isKilled()) {
            return;
        }
        super.kill();
        if (this.editor.getModel().getNode().getChildNamed(ArticlePriceContractComplete_.exported) != null) {
            this.editor.getModel().getNode().getChildNamed(ArticlePriceContractComplete_.exported).removeNodeListener((NodeListener)this);
        }
        this.articleSearch.kill();
        this.contracted.kill();
        this.add.kill();
        this.addAll.kill();
        this.updateArticles.kill();
        this.articleSearch = null;
        this.contracted = null;
        this.add = null;
        this.addAll = null;
        this.updateArticles = null;
    }

    @Override
    public List<Component> getFocusComponents() {
        ArrayList<Component> focusList = new ArrayList<Component>();
        CheckedListAdder.addToList(focusList, this.articleSearch);
        CheckedListAdder.addToList(focusList, this.contracted);
        CheckedListAdder.addToList(focusList, this.add);
        CheckedListAdder.addToList(focusList, this.addAll);
        CheckedListAdder.addToList(focusList, this.updateArticles);
        return focusList;
    }

    @Override
    public void setNode(Node<?> node) {
        super.setNode(node);
        node.getChildNamed(ArticlePriceContractComplete_.exported).addNodeListener((NodeListener)this);
        Object exportedValue = node.getChildNamed(ArticlePriceContractComplete_.exported).getValue();
        if (exportedValue == null) {
            exportedValue = false;
        }
        this.isExported = (Boolean)exportedValue;
        this.isDeletable = this.provider.isDeletable(ArticlePriceContractComplete_.articles);
        this.isDeletable = this.isDeletable && node.getChildNamed(ArticlePriceContractComplete_.state).getValue() != ArticlePriceContractStateE.ACCPTED;
        this.table.getModel().setNode(node.getChildNamed(ArticlePriceContractComplete_.articles));
        Object[] o = new Object[4];
        o[0] = node.getChildNamed(ArticlePriceContractComplete_.supplier).getValue();
        this.currentSupplier = (SupplierLight)o[0];
        o[3] = this.contracted.getElement().isChecked();
        this.articleSearch.getElement().setAdditionalSearchField(o);
    }

    @Override
    public void buttonPressed(Button source, int x, int y) {
        super.buttonPressed(source, x, y);
        if (source == this.add) {
            BasicArticleLight l = (BasicArticleLight)this.articleSearch.getElement().getNode().getValue(BasicArticleLight.class);
            this.editor.showCommittingAnimation(Words.ADD_ARTICLE);
            this.editor.setEnabled(false);
            this.loadingState = 3;
            new BasicArticleLoader((BasicArticleReference)l, this, this.articleSearch.getElement().getNode(), this);
        } else if (source == this.addAll) {
            this.editor.showCommittingAnimation(Words.ADD_ALL_ARTICLES);
            this.editor.setEnabled(false);
            final BasicArticleSearchConfiguration articleSearch = new BasicArticleSearchConfiguration();
            articleSearch.setSupplier((SupplierReference)this.currentSupplier);
            if (this.contracted.getElement().isChecked()) {
                articleSearch.setContracted(Boolean.valueOf(this.contracted.getElement().isChecked()));
            }
            articleSearch.setInUse(Boolean.valueOf(true));
            this.loadingState = 5;
            this.table.setFadebleAdd(false);
            ThreadSafeExecutable run = new ThreadSafeExecutable(this){

                @Override
                public Node<?> loadData() throws Exception {
                    SearchResultIterator articleSearchResult = new SearchResultIterator((ASearchConfiguration)articleSearch);
                    ViewNode rt = new ViewNode("");
                    rt.setValue((Object)articleSearchResult, 0L);
                    ArrayList<ClientGetFromServerException> errors = new ArrayList<ClientGetFromServerException>();
                    for (BasicArticleLight articleLight : articleSearchResult) {
                        if (articleLight == null) continue;
                        try {
                            BasicArticleComplete articleComplete = (BasicArticleComplete)((SupplyServiceManager)ServiceManagerRegistry.getService(SupplyServiceManager.class)).getBasicArticle((BasicArticleReference)articleLight).getValue();
                            Node articleNode = INodeCreator.getDefaultImpl().getNode4DTO((Object)articleComplete, false, false);
                            ArticleDetailsPanel.this.ensureArticleAdd(articleNode, false);
                        }
                        catch (ClientGetFromServerException e) {
                            errors.add(e);
                        }
                    }
                    ArticleDetailsPanel.this.table.writeNumber(ArticlePriceContractEntryComplete_.positionNumber, 1);
                    if (!errors.isEmpty()) {
                        throw new ClientExceptionCollection("", errors);
                    }
                    return rt;
                }

                @Override
                public RemoteLoader getInvoker() {
                    return ArticleDetailsPanel.this;
                }

                @Override
                public long getID() {
                    return 0L;
                }
            };
            ThreadSafeLoader.run(run);
        } else if (source == this.updateArticles) {
            InnerPopUp2 popUp = InnerPopUp2.getInnerPopUp();
            popUp.setAttributes(source, true, true, Words.EXPORT_CONTRACT);
            InnerPopupFactory.showDesicionPopup(Words.OVERRIDE, Words.WRITE_CURRENT_SALES_PRICE_INTO_ARTICLE, this, this, 400, 150);
            this.setEnabled(false);
        }
    }

    @Override
    public void requestFocusInWindowNow() {
        this.articleSearch.getElement().requestFocusInWindowNow();
    }

    @Override
    public void switchState(Button.ButtonState newState) {
    }

    @Override
    public void layoutContainer(Container parent) {
        this.layoutTitle(parent);
        this.articleSearch.setLocation(this.horizontalBorder, this.getTitleHeight());
        this.articleSearch.setSize(250, (int)this.articleSearch.getPreferredSize().getHeight());
        this.contracted.setLocation(this.articleSearch.getX() + this.articleSearch.getWidth() + this.inner_horizontalBorder - 7, (int)((double)(this.articleSearch.getY() + this.articleSearch.getHeight()) - (this.contracted.getElement().getPreferredSize().getHeight() + 3.0)));
        this.contracted.setSize(this.contracted.getPreferredSize());
        this.add.setLocation(this.contracted.getX() + this.contracted.getWidth() + this.inner_horizontalBorder, (int)((double)(this.articleSearch.getY() + this.articleSearch.getHeight()) - (this.add.getPreferredSize().getHeight() + 1.0)));
        this.add.setSize(this.add.getPreferredSize());
        this.addAll.setLocation(this.add.getX() + this.add.getWidth() + this.inner_horizontalBorder, this.add.getY());
        this.addAll.setSize(this.addAll.getPreferredSize());
        this.updateArticles.setLocation(this.addAll.getX() + this.addAll.getWidth() + 50, this.addAll.getY());
        this.updateArticles.setSize(this.updateArticles.getPreferredSize());
        this.table.setLocation(0, this.articleSearch.getY() + this.articleSearch.getHeight() + this.verticalBorder);
        this.table.setSize(parent.getWidth(), parent.getHeight() - (this.table.getY() + 1));
    }

    @Override
    public Dimension calculateContainerPreferredSize() {
        return new Dimension(0, 500);
    }

    @Override
    public void newValueSelected(SearchTextField2 source, Node<?> n) {
        this.add.setEnabled(this.articleSearch.getElement().isItemSelected());
        this.add.requestFocusInWindowNow();
    }

    @Override
    public void errorOccurred(ClientException exception) {
        super.errorOccurred(exception);
        this.editor.hideCommittingAnimation();
        this.editor.setEnabled(true);
    }

    private void ensureArticleAdd(Node node, boolean isSwing) {
        BasicArticleComplete articleComplete = (BasicArticleComplete)node.getValue(BasicArticleComplete.class);
        Date date = (Date)this.editor.getModel().getNode().getChildNamed(new DtoField[]{ArticlePriceContractComplete_.contractPeriod, PeriodComplete_.startDate}).getValue();
        Boolean useTaxZone = (Boolean)this.editor.getModel().getNode().getChildNamed(ArticlePriceContractComplete_.useTaxZone).getValue();
        TaxZoneComplete taxZone = (TaxZoneComplete)this.editor.getModel().getNode().getChildNamed(ArticlePriceContractComplete_.taxZone).getValue();
        if (Boolean.TRUE.equals(useTaxZone)) {
            SupplierConditionComplete supplierCondition = ArticleToolkit.getSupplierConditionForContract(articleComplete, (SupplierReference)this.currentSupplier, useTaxZone, taxZone, new Timestamp(date.getTime()));
            this.processCondition(supplierCondition, node, isSwing, articleComplete, taxZone);
        } else {
            List allTaxes = (List)NodeToolkit.getAffixList(TaxZoneComplete.class).getValue();
            for (TaxZoneComplete tax : allTaxes) {
                SupplierConditionComplete supplierCondition = ArticleToolkit.getSupplierConditionForContract(articleComplete, (SupplierReference)this.currentSupplier, true, tax, new Timestamp(date.getTime()));
                this.processCondition(supplierCondition, node, isSwing, articleComplete, tax);
            }
            SupplierConditionComplete supplierCondition = ArticleToolkit.getSupplierConditionForContract(articleComplete, (SupplierReference)this.currentSupplier, true, null, new Timestamp(date.getTime()));
            this.processCondition(supplierCondition, node, isSwing, articleComplete, null);
        }
    }

    private void processCondition(SupplierConditionComplete supplierCondition, Node node, boolean isSwing, final BasicArticleComplete articleComplete, TaxZoneComplete taxZone) {
        if (supplierCondition == null) {
            return;
        }
        if (supplierCondition.getStepPrice() == null) {
            supplierCondition.setStepPrice(new StepPriceCalculationComplete());
        }
        if (supplierCondition.getStepPrice().getSteps().size() == 0) {
            StepPriceFunctionComplete stepPriceFunction = new StepPriceFunctionComplete();
            stepPriceFunction.setSequenceNumber(Integer.valueOf(0));
            stepPriceFunction.setUpperLimit(new QuantityComplete(Double.valueOf(0.0), articleComplete.getPriceUnit()));
            PriceComplete brutto = ArticlePriceCalculationToolkit.getNettoPrice((BasicArticleLight)articleComplete, (Timestamp)new Timestamp(System.currentTimeMillis()), null, (boolean)false);
            stepPriceFunction.setPrice(new PriceComplete(brutto.getCurrency(), Double.valueOf(0.0)));
            supplierCondition.getStepPrice().getSteps().add(stepPriceFunction);
            this.editor.showCommittingAnimation(Words.UPDATE_ARTICLES);
            if (isSwing) {
                ThreadSafeExecutable run = new ThreadSafeExecutable(this){

                    @Override
                    public Node<?> loadData() throws Exception {
                        BasicArticleComplete articleCompleteLoaded = (BasicArticleComplete)((SupplyServiceManager)ServiceManagerRegistry.getService(SupplyServiceManager.class)).updateBasicArticle(articleComplete).getValue();
                        Node dataNode = INodeCreator.getDefaultImpl().getNode4DTO((Object)articleCompleteLoaded, false, false);
                        dataNode.removeExistingValues();
                        dataNode.setValue((Object)articleCompleteLoaded, 0L);
                        return dataNode;
                    }

                    @Override
                    public RemoteLoader getInvoker() {
                        return ArticleDetailsPanel.this;
                    }

                    @Override
                    public long getID() {
                        return 0L;
                    }
                };
                ThreadSafeLoader.run(run);
            } else {
                try {
                    BasicArticleComplete articleLoaded = (BasicArticleComplete)((SupplyServiceManager)ServiceManagerRegistry.getService(SupplyServiceManager.class)).updateBasicArticle(articleComplete).getValue();
                    node.removeExistingValues();
                    node.setValue((Object)articleLoaded, System.currentTimeMillis());
                    this.ensureArticleAdd(node, false);
                }
                catch (ClientServerCallException e) {
                    InnerPopupFactory.showErrorDialog((Exception)((Object)e), (Component)this);
                }
            }
        } else {
            int i = this.table.getModel().getNode().getChildCount();
            Collections.sort(supplierCondition.getStepPrice().getSteps(), (o1, o2) -> o1.getSequenceNumber().compareTo(o2.getSequenceNumber()));
            int lastStep = 0;
            for (StepPriceFunctionComplete s : supplierCondition.getStepPrice().getSteps()) {
                boolean alreadyAdded = false;
                Integer max = 0;
                Iterator it2 = this.table.getModel().getNode().getFailSafeChildIterator();
                while (it2.hasNext() && !alreadyAdded) {
                    Node on = (Node)it2.next();
                    BasicArticleReference art = (BasicArticleReference)on.getChildNamed(ArticlePriceContractEntryComplete_.article).getValue();
                    TaxZoneComplete tax = (TaxZoneComplete)on.getChildNamed(ArticlePriceContractEntryComplete_.taxZone).getValue();
                    boolean found = false;
                    if (art.equals((Object)articleComplete)) {
                        if (tax == null) {
                            if (taxZone == null) {
                                found = true;
                            }
                        } else if (tax.equals((Object)taxZone)) {
                            found = true;
                        }
                    }
                    if (!found) continue;
                    Integer min = (Integer)on.getChildNamed(ArticlePriceContractEntryComplete_.minScale).getValue();
                    max = (Integer)on.getChildNamed(ArticlePriceContractEntryComplete_.maxScale).getValue();
                    UnitComplete su = (UnitComplete)on.getChildNamed(ArticlePriceContractEntryComplete_.scaleUnit).getValue();
                    if (min != lastStep || max.intValue() != s.getUpperLimit().getQuantity().intValue() || !su.equals((Object)s.getUpperLimit().getUnit())) continue;
                    alreadyAdded = true;
                }
                if (!alreadyAdded) {
                    ArticlePriceContractEntryComplete entry = new ArticlePriceContractEntryComplete();
                    entry.setClientOId(Long.valueOf(ADTO.getNextId()));
                    entry.setArticle((BasicArticleLight)articleComplete);
                    entry.setCanBeOrdered(Boolean.valueOf(true));
                    entry.setMinScale(Integer.valueOf(lastStep));
                    entry.setMaxScale(Integer.valueOf(s.getUpperLimit().getQuantity().intValue()));
                    entry.setScaleUnit(s.getUpperLimit().getUnit());
                    entry.setPrice(s.getPrice());
                    entry.setPriceUnit(articleComplete.getPriceUnit());
                    entry.setPositionNumber(Integer.valueOf(++i));
                    entry.setTaxZone(taxZone);
                    max = s.getUpperLimit().getQuantity().intValue();
                    this.table.getModel().getNode().addChild(INodeCreator.getDefaultImpl().getNode4DTO((Object)entry, true, false), System.currentTimeMillis());
                }
                lastStep = max;
            }
            this.revalidate();
        }
    }

    @Override
    public void remoteObjectLoaded(Node<?> node) {
        if (this.loadingState == 5) {
            this.table.setFadebleAdd(true);
            this.editor.hideCommittingAnimation();
            this.editor.setEnabled(true);
        } else if (this.loadingState == 19) {
            this.editor.hideCommittingAnimation();
            this.editor.setEnabled(true);
        } else {
            this.editor.hideCommittingAnimation();
            this.editor.setEnabled(true);
            this.articleSearch.getElement().requestFocusInWindowNow();
            this.ensureArticleAdd(node, true);
        }
    }

    public void valueChanged(Node<?> node) {
        Object b = node.getValue();
        if (b == null) {
            b = false;
        }
        this.isExported = (Boolean)b;
        this.validateRows();
        this.setEnabled(this.isEnabled());
    }

    private void validateRows() {
        for (Table2RowPanel p : this.table.getRows()) {
            TableRowImpl l = (TableRowImpl)p;
            l.validateControlsState(this.isExported);
        }
    }

    public void childAdded(Node<?> source, Node<?> child) {
    }

    public void childRemoved(Node<?> source, Node<?> child) {
    }

    public void childrenAdded(Node<?> source, Node<?> ... nodes) {
    }

    @Override
    public void popUpClosed(InnerPopUp2 source, Object ... xargs) {
        if (xargs == null) {
            this.editor.setEnabled(true);
            return;
        }
        this.loadingState = 19;
        this.editor.showCommittingAnimation(Words.UPDATE_ARTICLES);
        this.editor.setEnabled(false);
        ThreadSafeExecutable run = new ThreadSafeExecutable(this){

            @Override
            public Node<?> loadData() throws Exception {
                Node node = ArticleDetailsPanel.this.editor.getModel().getNode();
                node.commit(ArticlePriceContractComplete.class);
                ArticlePriceContractComplete contractComplete = (ArticlePriceContractComplete)node.getValue(ArticlePriceContractComplete.class);
                contractComplete = (ArticlePriceContractComplete)((SupplyServiceManager)ServiceManagerRegistry.getService(SupplyServiceManager.class)).updateArticlePrice(contractComplete).getValue();
                node.removeExistingValues();
                node.setValue((Object)contractComplete, 0L);
                node.updateNode();
                List<ScreenValidationObject> t = ArticlePriceContractToolkit.updateArticleSupplierPrices((Node<ArticlePriceContractComplete>)node);
                if (t != null && !t.isEmpty()) {
                    SwingUtilities.invokeLater(() -> InnerPopupFactory.showWarningDialog(t, null, (Component)ArticleDetailsPanel.this.updateArticles));
                }
                return null;
            }

            @Override
            public RemoteLoader getInvoker() {
                return ArticleDetailsPanel.this;
            }

            @Override
            public long getID() {
                return 0L;
            }
        };
        ThreadSafeLoader.run(run);
    }

    public boolean isSwingOnly() {
        return true;
    }

    private class TableRowImpl
    extends SortableTable2RowPanel
    implements ButtonListener,
    InnerPopUpListener2 {
        private static final long serialVersionUID = 1L;
        private TextLabel sequence;
        private TextLabel taxZone;
        private TextLabel article;
        private TextLabel lastUpdate;
        private TextLabel price;
        private TextLabel scale;
        private EditButton editScale;
        private EditButton editPrice;
        private ArticleProductInfoButton infoButton;
        private CheckBox bonded;
        private CheckBoxRO canBeOrdered;

        public TableRowImpl(Table2RowModel m) {
            super(m, ArticleDetailsPanel.this.isDeletable, ArticleDetailsPanel.this.isDeletable);
            this.setSortAttributeName(ArticlePriceContractEntryComplete_.positionNumber);
            this.setStartEndOffset(1, 0);
            this.sequence = new TextLabel(m.getNode().getChildNamed(ArticlePriceContractEntryComplete_.positionNumber), ConverterRegistry.getConverter(IntegerConverter.class));
            this.taxZone = new TextLabel(m.getNode().getChildNamed(ArticlePriceContractEntryComplete_.taxZone), ConverterRegistry.getConverter(TaxZoneConverter.class));
            this.article = new TextLabel(m.getNode().getChildNamed(ArticlePriceContractEntryComplete_.article), ConverterRegistry.getConverter(BasicArticleConverter.class));
            this.lastUpdate = new TextLabel(m.getNode().getChildNamed(ArticlePriceContractEntryComplete_.lastUpdate), ConverterRegistry.getConverter(DateConverter.class));
            this.price = new TextLabel(m.getNode(), ConverterRegistry.getConverter(ArticleEntryConverter.class));
            this.scale = new TextLabel(m.getNode(), ConverterRegistry.getConverter(ArticlePriceScaleConverter.class));
            this.bonded = new CheckBox((Node<Boolean>)m.getNode().getChildNamed(ArticlePriceContractEntryComplete_.bonded));
            this.canBeOrdered = new CheckBoxRO((Node<Boolean>)m.getNode().getChildNamed(ArticlePriceContractEntryComplete_.canBeOrdered));
            this.infoButton = new ArticleInfoButton((Node<BasicArticleReference>)m.getNode().getChildNamed(ArticlePriceContractEntryComplete_.article), (Node<Date>)INodeCreator.getDefaultImpl().getNode4DTO((Object)new Date(System.currentTimeMillis()), false, false), ArticleToolkit.getAllArticleContractTypes());
            this.editScale = new EditButton();
            this.editScale.addButtonListener(this);
            this.editPrice = new EditButton();
            this.editPrice.addButtonListener(this);
            this.editScale.setVisible(!ArticleDetailsPanel.this.isExported);
            this.editPrice.setVisible(!ArticleDetailsPanel.this.isExported);
            this.setLayout(new Layout());
            this.add(this.article);
            this.add(this.taxZone);
            this.add(this.sequence);
            this.add(this.lastUpdate);
            this.add(this.price);
            this.add(this.scale);
            this.add(this.infoButton);
            this.add(this.bonded);
            this.add(this.canBeOrdered);
            this.add(this.editScale);
            this.add(this.editPrice);
        }

        @Override
        public void kill() {
            if (this.isKilled()) {
                return;
            }
            super.kill();
            this.article.kill();
            this.sequence.kill();
            this.lastUpdate.kill();
            this.price.kill();
            this.editScale.kill();
            this.editPrice.kill();
            this.scale.kill();
            this.infoButton.kill();
            this.bonded.kill();
            this.canBeOrdered.kill();
            this.taxZone.kill();
            this.article = null;
            this.sequence = null;
            this.lastUpdate = null;
            this.price = null;
            this.scale = null;
            this.editScale = null;
            this.editPrice = null;
            this.infoButton = null;
            this.bonded = null;
            this.canBeOrdered = null;
            this.taxZone = null;
        }

        @Override
        public List<Component> getFocusComponents() {
            ArrayList<Component> focusList = new ArrayList<Component>();
            if (this.editScale.isVisible()) {
                CheckedListAdder.addToList(focusList, this.editScale);
            }
            if (this.editPrice.isVisible()) {
                CheckedListAdder.addToList(focusList, this.editPrice);
            }
            return focusList;
        }

        @Override
        public void setEnabled(boolean isEnabled) {
            boolean isAccepted = ArticleDetailsPanel.this.editor.getModel().getNode().getChildNamed(ArticlePriceContractComplete_.state).getValue() == ArticlePriceContractStateE.ACCPTED;
            super.setEnabled(isEnabled && !isAccepted);
            this.article.setEnabled(isEnabled && !isAccepted);
            this.taxZone.setEnabled(isEnabled && !isAccepted);
            this.sequence.setEnabled(isEnabled && !isAccepted);
            this.lastUpdate.setEnabled(isEnabled && !isAccepted);
            this.price.setEnabled(isEnabled && !isAccepted);
            this.scale.setEnabled(isEnabled && !isAccepted);
            this.editScale.setEnabled(isEnabled && ArticleDetailsPanel.this.isScaleEditAllowed && !isAccepted);
            this.editPrice.setEnabled(isEnabled && ArticleDetailsPanel.this.isPriceEditAllowed && !isAccepted);
            this.infoButton.setEnabled(isEnabled);
            this.bonded.setEnabled(isEnabled);
            this.canBeOrdered.setEnabled(isEnabled);
        }

        @Override
        public void buttonPressed(Button source, int x, int y) {
            if (source == this.editScale) {
                InnerPopUp2 popUp = InnerPopUp2.getInnerPopUp();
                popUp.setAttributes(source, true, true, Words.EDIT_SCALE);
                popUp.hideCancelButton();
                popUp.setView(new ScaleEditPopup((Node<Integer>)this.model.getNode().getChildNamed(ArticlePriceContractEntryComplete_.minScale), this.model.getNode().getChildNamed(ArticlePriceContractEntryComplete_.maxScale), (Node<UnitComplete>)this.model.getNode().getChildNamed(ArticlePriceContractEntryComplete_.scaleUnit)));
                popUp.showPopUp(x, y, -1, -1, this, source);
            } else if (source == this.editPrice) {
                InnerPopupFactory.showPriceEditPopup((Node<PriceComplete>)this.price.getNode().getChildNamed(ArticlePriceContractEntryComplete_.price), x, y, source, this);
            } else {
                super.buttonPressed(source, x, y);
            }
        }

        @Override
        public void popUpClosed(InnerPopUp2 source, Object ... xargs) {
            this.model.getNode().commitThis();
            this.scale.updateString();
            this.price.updateString();
        }

        public void validateControlsState(boolean isExported) {
            this.editPrice.setVisible(!isExported);
            this.editScale.setVisible(!isExported);
        }

        private class Layout
        extends DefaultLayout {
            private Layout() {
            }

            @Override
            public Dimension preferredLayoutSize(Container parent) {
                return new Dimension(0, TableRowImpl.this.getDefaultRowHeight());
            }

            @Override
            public void layoutContainer(Container parent) {
                int currentX = 0;
                int w = TableRowImpl.this.model.getParentModel().getColumnWidth(0);
                TableRowImpl.this.sequence.setLocation(currentX + TableRowImpl.this.getCellPadding(), (int)(((double)parent.getHeight() - TableRowImpl.this.sequence.getPreferredSize().getHeight()) / 2.0));
                TableRowImpl.this.sequence.setSize(TableRowImpl.this.sequence.getPreferredSize());
                currentX += w;
                w = TableRowImpl.this.model.getParentModel().getColumnWidth(1);
                TableRowImpl.this.article.setLocation(currentX + TableRowImpl.this.getCellPadding(), (int)(((double)parent.getHeight() - TableRowImpl.this.article.getPreferredSize().getHeight()) / 2.0));
                TableRowImpl.this.article.setSize((int)((double)w - ((double)(2 * TableRowImpl.this.getCellPadding() + 5) + TableRowImpl.this.infoButton.getPreferredSize().getWidth())), (int)TableRowImpl.this.article.getPreferredSize().getHeight());
                TableRowImpl.this.infoButton.setLocation(TableRowImpl.this.article.getX() + TableRowImpl.this.article.getWidth() + 5, (int)(((double)parent.getHeight() - TableRowImpl.this.infoButton.getPreferredSize().getHeight()) / 2.0));
                TableRowImpl.this.infoButton.setSize(TableRowImpl.this.infoButton.getPreferredSize());
                currentX += w;
                w = TableRowImpl.this.model.getParentModel().getColumnWidth(2);
                TableRowImpl.this.taxZone.setLocation(currentX + TableRowImpl.this.getCellPadding(), (int)(((double)parent.getHeight() - TableRowImpl.this.taxZone.getPreferredSize().getHeight()) / 2.0));
                TableRowImpl.this.taxZone.setSize(w - 2 * TableRowImpl.this.getCellPadding(), (int)TableRowImpl.this.taxZone.getPreferredSize().getHeight());
                currentX += w;
                w = TableRowImpl.this.model.getParentModel().getColumnWidth(3);
                TableRowImpl.this.lastUpdate.setLocation(currentX + TableRowImpl.this.getCellPadding(), (int)(((double)parent.getHeight() - TableRowImpl.this.lastUpdate.getPreferredSize().getHeight()) / 2.0));
                TableRowImpl.this.lastUpdate.setSize(w - 2 * TableRowImpl.this.getCellPadding(), (int)TableRowImpl.this.lastUpdate.getPreferredSize().getHeight());
                currentX += w;
                w = TableRowImpl.this.model.getParentModel().getColumnWidth(4);
                TableRowImpl.this.scale.setLocation(currentX + TableRowImpl.this.getCellPadding(), (int)(((double)parent.getHeight() - TableRowImpl.this.scale.getPreferredSize().getHeight()) / 2.0));
                TableRowImpl.this.scale.setSize((int)((double)w - ((double)(2 * TableRowImpl.this.getCellPadding() + TableRowImpl.this.getInnerCellPadding()) + TableRowImpl.this.editScale.getPreferredSize().getWidth())), (int)TableRowImpl.this.scale.getPreferredSize().getHeight());
                TableRowImpl.this.editScale.setLocation(TableRowImpl.this.scale.getX() + TableRowImpl.this.scale.getWidth() + TableRowImpl.this.getInnerCellPadding(), (int)(((double)parent.getHeight() - TableRowImpl.this.editScale.getPreferredSize().getHeight()) / 2.0));
                TableRowImpl.this.editScale.setSize(TableRowImpl.this.editScale.getPreferredSize());
                currentX += w;
                w = TableRowImpl.this.model.getParentModel().getColumnWidth(5);
                TableRowImpl.this.price.setLocation(currentX + TableRowImpl.this.getCellPadding(), (int)(((double)parent.getHeight() - TableRowImpl.this.price.getPreferredSize().getHeight()) / 2.0));
                TableRowImpl.this.price.setSize((int)((double)w - ((double)(2 * TableRowImpl.this.getCellPadding() + TableRowImpl.this.getInnerCellPadding()) + TableRowImpl.this.editPrice.getPreferredSize().getWidth())), (int)TableRowImpl.this.price.getPreferredSize().getHeight());
                TableRowImpl.this.editPrice.setLocation(TableRowImpl.this.price.getX() + TableRowImpl.this.price.getWidth() + TableRowImpl.this.getInnerCellPadding(), (int)(((double)parent.getHeight() - TableRowImpl.this.editPrice.getPreferredSize().getHeight()) / 2.0));
                TableRowImpl.this.editPrice.setSize(TableRowImpl.this.editPrice.getPreferredSize());
                currentX += w;
                w = TableRowImpl.this.model.getParentModel().getColumnWidth(6);
                TableRowImpl.this.bonded.setLocation(currentX + TableRowImpl.this.getCellPadding(), (int)(((double)parent.getHeight() - TableRowImpl.this.bonded.getPreferredSize().getHeight()) / 2.0));
                TableRowImpl.this.bonded.setSize(TableRowImpl.this.bonded.getPreferredSize());
                currentX += w;
                w = TableRowImpl.this.model.getParentModel().getColumnWidth(7);
                TableRowImpl.this.canBeOrdered.setLocation(currentX + TableRowImpl.this.getCellPadding(), (int)(((double)parent.getHeight() - TableRowImpl.this.canBeOrdered.getPreferredSize().getHeight()) / 2.0));
                TableRowImpl.this.canBeOrdered.setSize(TableRowImpl.this.canBeOrdered.getPreferredSize());
                currentX += w;
                w = TableRowImpl.this.model.getParentModel().getColumnWidth(8);
                TableRowImpl.this.setControlsX(currentX);
                TableRowImpl.this.layoutSortButtons(currentX, parent.getHeight());
            }
        }
    }
}

