/*
 * Decompiled with CFR 0.152.
 */
package ch.icit.pegasus.client.gui.modules.changenotificationmanager.details;

import ch.icit.pegasus.client.converter.ChangeNotificationTypeEConverter;
import ch.icit.pegasus.client.converter.controller.ConverterRegistry;
import ch.icit.pegasus.client.gui.table.DefaultDetailsPanel;
import ch.icit.pegasus.client.gui.table.RowEditor;
import ch.icit.pegasus.client.gui.utils.CheckedListAdder;
import ch.icit.pegasus.client.gui.utils.DefaultLayout;
import ch.icit.pegasus.client.gui.utils.TextLabel;
import ch.icit.pegasus.client.gui.utils.TitledItem;
import ch.icit.pegasus.client.gui.utils.rightdependant.RDProvider;
import ch.icit.pegasus.client.gui.utils.rightdependant.RDTextField;
import ch.icit.pegasus.client.node.impls.Node;
import ch.icit.pegasus.client.util.ScreenValidationObject;
import ch.icit.pegasus.server.core.dtos.changenotification.ChangeNotificationComplete_;
import ch.icit.pegasus.server.core.dtos.changenotification.ChangeNotificationLight;
import ch.icit.pegasus.server.core.dtos.changenotification.ChangeNotificationTypeE;
import ch.icit.pegasus.server.core.i18n.Words;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.util.ArrayList;
import java.util.List;

public class ChangeNotificationManualAddPanel
extends DefaultDetailsPanel<ChangeNotificationLight> {
    private static final long serialVersionUID = 1L;
    private TitledItem<TextLabel> type;
    private TitledItem<RDTextField> remark;

    public ChangeNotificationManualAddPanel(RowEditor<ChangeNotificationLight> editor, RDProvider provider) {
        super(editor, provider);
        this.setTitleText(Words.MANUAL_CHANGE_NOTIFICATION);
        this.setCustomLayouter(new Layout());
        this.type = new TitledItem<TextLabel>(new TextLabel(null, ConverterRegistry.getConverter(ChangeNotificationTypeEConverter.class)), Words.TYPE, TitledItem.TitledItemOrientation.NORTH);
        this.type.getElement().setReadOnlyTextField(true);
        this.remark = new TitledItem<RDTextField>(new RDTextField(provider), Words.REMARK, TitledItem.TitledItemOrientation.NORTH);
        this.remark.setIgnorePrefHeight(true);
        this.addToView(this.type);
        this.addToView(this.remark);
    }

    @Override
    public void setNode(Node<?> node) {
        super.setNode(node);
        this.type.getElement().setNode(node.getChildNamed(ChangeNotificationComplete_.type));
        this.type.getElement().getNode().setValue((Object)ChangeNotificationTypeE.MANUAL, 0L);
        this.remark.getElement().setNode(node.getChildNamed(ChangeNotificationComplete_.remark));
    }

    @Override
    public void setEnabled(boolean isEnabled) {
        boolean isAddRow = this.editor.getModel().isAddRow();
        super.setEnabled(isEnabled && isAddRow);
        this.type.setEnabled(isEnabled);
        this.remark.setEnabled(isEnabled && isAddRow);
    }

    @Override
    public List<ScreenValidationObject> validateParagraph() {
        ArrayList<ScreenValidationObject> validationObjects = new ArrayList<ScreenValidationObject>();
        RDTextField element = this.remark.getElement();
        String value = (String)element.getNode().getValue();
        if (value.length() > 100) {
            ScreenValidationObject warning = new ScreenValidationObject(ScreenValidationObject.ValidationStateE.WARNING, "Maximum remark length is 100 characters");
            validationObjects.add(warning);
        }
        return validationObjects;
    }

    @Override
    public boolean grabsFocus() {
        return !this.editor.getModel().isAddRow();
    }

    @Override
    public List<Component> getFocusComponents() {
        ArrayList<Component> focusList = new ArrayList<Component>();
        CheckedListAdder.addToList(focusList, this.type);
        CheckedListAdder.addToList(focusList, this.remark);
        return focusList;
    }

    @Override
    public void kill() {
        if (this.isKilled()) {
            return;
        }
        super.kill();
        this.type.kill();
        this.remark.kill();
        this.type = null;
        this.remark = null;
    }

    @Override
    public void requestFocusInWindowNow() {
        this.remark.requestFocusInWindowNow();
    }

    private class Layout
    extends DefaultLayout {
        private Layout() {
        }

        @Override
        public void layoutContainer(Container parent) {
            int w = parent.getWidth() - 2 * ChangeNotificationManualAddPanel.this.horizontalBorder;
            ChangeNotificationManualAddPanel.this.type.setLocation(ChangeNotificationManualAddPanel.this.horizontalBorder, ChangeNotificationManualAddPanel.this.verticalBorder);
            ChangeNotificationManualAddPanel.this.type.setSize((w -= ChangeNotificationManualAddPanel.this.inner_horizontalBorder / 2) + ChangeNotificationManualAddPanel.this.inner_horizontalBorder / 2, (int)ChangeNotificationManualAddPanel.this.type.getPreferredSize().getHeight());
            ChangeNotificationManualAddPanel.this.remark.setLocation(ChangeNotificationManualAddPanel.this.horizontalBorder, ChangeNotificationManualAddPanel.this.type.getY() + ChangeNotificationManualAddPanel.this.type.getHeight() + ChangeNotificationManualAddPanel.this.inner_verticalBorder);
            ChangeNotificationManualAddPanel.this.remark.setSize(parent.getWidth() - ChangeNotificationManualAddPanel.this.remark.getX() * 2, (int)ChangeNotificationManualAddPanel.this.remark.getPreferredSize().getHeight());
        }

        @Override
        public Dimension preferredLayoutSize(Container parent) {
            int currentY = ChangeNotificationManualAddPanel.this.verticalBorder;
            currentY += ChangeNotificationManualAddPanel.this.type.getHeight() + ChangeNotificationManualAddPanel.this.verticalBorder;
            return new Dimension(260, currentY += ChangeNotificationManualAddPanel.this.remark.getHeight() + ChangeNotificationManualAddPanel.this.verticalBorder);
        }
    }
}

