/*
 * Decompiled with CFR 0.152.
 */
package ch.icit.pegasus.client.gui.modules.chargetracking;

import ch.icit.pegasus.client.converter.CustomsDocumentTypeConverter;
import ch.icit.pegasus.client.converter.IntegerConverter;
import ch.icit.pegasus.client.converter.SingleArticleCategoryConverter;
import ch.icit.pegasus.client.converter.StringConverter;
import ch.icit.pegasus.client.converter.controller.ConverterRegistry;
import ch.icit.pegasus.client.gui.modules.Module;
import ch.icit.pegasus.client.gui.modules.chargetracking.ChargeTrackingModuleDataHandler;
import ch.icit.pegasus.client.gui.modules.chargetracking.details.ChargeDetailsPanel;
import ch.icit.pegasus.client.gui.modules.chargetracking.details.SideTableDetailsPanel;
import ch.icit.pegasus.client.gui.screentemplates.overview.ScreenTableView;
import ch.icit.pegasus.client.gui.screentemplates.overview.data.IDataHandler;
import ch.icit.pegasus.client.gui.table.MessageProvidedRowEditor;
import ch.icit.pegasus.client.gui.table.RowEditor;
import ch.icit.pegasus.client.gui.table.RowEditorFactory;
import ch.icit.pegasus.client.gui.table.RowModel;
import ch.icit.pegasus.client.gui.table.RowPanel;
import ch.icit.pegasus.client.gui.table.Table;
import ch.icit.pegasus.client.gui.table.TableColumnInfo;
import ch.icit.pegasus.client.gui.utils.TableLayoutConstraint;
import ch.icit.pegasus.client.gui.utils.buttons.TextButton;
import ch.icit.pegasus.client.gui.utils.combobox.ComboBox;
import ch.icit.pegasus.client.gui.utils.combobox.ComboBoxFactory;
import ch.icit.pegasus.client.gui.utils.combobox.minicombobox.MiniComboBox;
import ch.icit.pegasus.client.gui.utils.combobox.minicombobox.MiniComboBoxConfiguration;
import ch.icit.pegasus.client.gui.utils.filterchain.FilterChainConfiguration;
import ch.icit.pegasus.client.gui.utils.rightdependant.RDProvider;
import ch.icit.pegasus.client.gui.utils.searchbox.ConfigurableSearchTextField;
import ch.icit.pegasus.client.gui.utils.searchbox.SearchTextField2;
import ch.icit.pegasus.client.node.impls.Node;
import ch.icit.pegasus.client.node.impls.NodeToolkit;
import ch.icit.pegasus.client.search.SearchAlgorithm;
import ch.icit.pegasus.client.search.controller.SearchAlgorithmRegistry;
import ch.icit.pegasus.client.search.impls.remote.BasicArticleSearchAlgorithm;
import ch.icit.pegasus.server.core.dtos.masterdata.ArticleCategoryComplete;
import ch.icit.pegasus.server.core.dtos.masterdata.ArticleCategoryComplete_;
import ch.icit.pegasus.server.core.dtos.masterdata.ArticleCategoryLight;
import ch.icit.pegasus.server.core.dtos.masterdata.ArticleCategoryReference;
import ch.icit.pegasus.server.core.dtos.masterdata.CustomsDocumentTypeComplete;
import ch.icit.pegasus.server.core.dtos.rightmanagement.definition.SubModuleDefinitionComplete;
import ch.icit.pegasus.server.core.dtos.rightmanagement.template.AccessDefinitionComplete;
import ch.icit.pegasus.server.core.dtos.rightmanagement.template.def.ChargeTrackingAccess;
import ch.icit.pegasus.server.core.dtos.search.ABasicArticleSearchConfiguration;
import ch.icit.pegasus.server.core.dtos.search.BasicArticleSearchConfiguration;
import ch.icit.pegasus.server.core.dtos.search.BasicArticleSearchTypeE;
import ch.icit.pegasus.server.core.dtos.store.ArticleChargeLight;
import ch.icit.pegasus.server.core.dtos.store.StoreLight;
import ch.icit.pegasus.server.core.dtos.store.StoreReference;
import ch.icit.pegasus.server.core.dtos.supply.BasicArticleLight;
import ch.icit.pegasus.server.core.dtos.supply.BasicArticleLight_;
import ch.icit.pegasus.server.core.dtos.supply.CustomerLight;
import ch.icit.pegasus.server.core.dtos.supply.CustomerReference;
import ch.icit.pegasus.server.core.dtos.supply.SupplierLight;
import ch.icit.pegasus.server.core.dtos.supply.SupplierReference;
import ch.icit.pegasus.server.core.general.ASearchConfiguration;
import ch.icit.pegasus.server.core.i18n.Words;
import ch.icit.pegasus.server.core.search.SortDirection;
import java.awt.Component;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.ArrayList;
import java.util.List;

public class ChargeTrackingModule
extends ScreenTableView<BasicArticleLight, ABasicArticleSearchConfiguration.BASIC_ARTICLE_COLUMN>
implements ItemListener,
Module {
    private static final long serialVersionUID = 1L;
    private ComboBox firstCategory;
    private ComboBox secondCategory;
    private static final String FILTER1 = "code & name";
    private static final String FILTER2 = "main category";
    private static final String FILTER3 = "sub category";
    private static final String FILTER4 = "supplier";
    private static final String FILTER5 = "store";
    private static final String FILTER6 = "customer";
    private static final String FILTER7 = "inuse";
    private static final String FILTER14 = "charge";
    private static final String FILTER15 = "customs_document_type";
    private static final String inuseonly = Words.USE_ONLY;
    private static final String notuseonly = Words.NOT_USE_ONLY;
    private String searchCriteria1 = null;
    private BasicArticleSearchTypeE filterCriteria1;
    private ArticleCategoryLight filterCriteria2;
    private ArticleCategoryLight filterCriteria3;
    private SupplierLight filterCriteria4;
    private StoreReference filterCriteria5;
    private CustomerLight filterCriteria6;
    private String filterCriteria7;
    private ArticleChargeLight filterCriteria14;
    private CustomsDocumentTypeComplete filterCriteria15;
    private boolean combosFilled = false;
    private ComboBox customsDocumentTypes;

    public ChargeTrackingModule() {
        super(BasicArticleLight.class);
        this.isSynchronSearch = false;
    }

    @Override
    public void kill() {
        if (this.isKilled()) {
            return;
        }
        super.kill();
        this.firstCategory.kill();
        this.secondCategory.kill();
        this.customsDocumentTypes.kill();
        this.firstCategory = null;
        this.secondCategory = null;
        this.customsDocumentTypes = null;
    }

    @Override
    public AccessDefinitionComplete getInvoker() {
        return ChargeTrackingAccess.MODULE_CHARGE_TRACKING;
    }

    @Override
    protected void createFilterChain(long id) {
        MiniComboBoxConfiguration mcbc = new MiniComboBoxConfiguration(BasicArticleSearchTypeE.ALL);
        MiniComboBox mcomboBox = new MiniComboBox();
        mcomboBox.setVisible(true);
        mcomboBox.addItem(BasicArticleSearchTypeE.ALL, mcbc.getPicture(BasicArticleSearchTypeE.ALL));
        mcomboBox.addItem(BasicArticleSearchTypeE.ARTICLE_NAME, mcbc.getPicture(BasicArticleSearchTypeE.ARTICLE_NAME));
        mcomboBox.addItem(BasicArticleSearchTypeE.ARTICLE_NUMBER, mcbc.getPicture(BasicArticleSearchTypeE.ARTICLE_NUMBER));
        mcomboBox.addItem(BasicArticleSearchTypeE.SUPPLIER_NUMBER, mcbc.getPicture(BasicArticleSearchTypeE.SUPPLIER_NUMBER));
        mcomboBox.addItem(BasicArticleSearchTypeE.CUSTOMS_DOCUMENT_ID, mcbc.getPicture(BasicArticleSearchTypeE.CUSTOMS_DOCUMENT_ID));
        mcomboBox.setSelectedItem(BasicArticleSearchTypeE.ALL);
        this.filterChain.addConfigurableSearchField(FILTER1, Words.NUMBER_NAME_CUSDOCID, "", mcomboBox);
        this.filterChain.setSearchTextField2Width(140);
        this.filterChain.setDefaultComboWidth(100);
        this.firstCategory = new ComboBox();
        this.firstCategory.setViewConverter(ConverterRegistry.getConverter(SingleArticleCategoryConverter.class));
        this.secondCategory = new ComboBox();
        this.secondCategory.setViewConverter(ConverterRegistry.getConverter(SingleArticleCategoryConverter.class));
        this.filterChain.addSelectionComboBox(this.firstCategory, 120, FILTER2, Words.MAIN_CATEGORY, Words.ALL, false);
        this.filterChain.addSelectionComboBox(this.secondCategory, 120, FILTER3, Words.SUB_CATEGORY, Words.ALL);
        this.filterChain.addSupplierSearchField(FILTER4);
        this.filterChain.addStoreSearchField(FILTER5);
        this.filterChain.addCustomerSearchField(FILTER6);
        this.customsDocumentTypes = new ComboBox(null, null, ConverterRegistry.getConverter(CustomsDocumentTypeConverter.class));
        this.filterChain.addSelectionComboBox(this.customsDocumentTypes, 120, FILTER15, Words.CUSTOMS_DOCUMENT_TYPE, Words.ALL, true);
        SearchTextField2<ArticleChargeLight> a = this.filterChain.addChargeSearchField(FILTER14);
        ComboBox b = ComboBoxFactory.getInUseComboBox(true);
        this.filterChain.addSelectionComboBox(b, FILTER7, Words.SHOW, Words.ALL);
        this.filterChain.addResetButton();
    }

    private void fillComboBoxes(Node n) {
        if (this.combosFilled) {
            return;
        }
        this.combosFilled = true;
        this.customsDocumentTypes.refreshPossibleValues(NodeToolkit.getAffixList(CustomsDocumentTypeComplete.class));
        this.customsDocumentTypes.addItem(Words.ALL);
        this.customsDocumentTypes.setSelectedItem(Words.ALL);
        Node cats = NodeToolkit.getAffixList(ArticleCategoryComplete.class);
        this.firstCategory.refreshPossibleValues(cats);
        this.firstCategory.addItem(Words.ALL);
        this.firstCategory.setSelectedItem(Words.ALL);
        this.firstCategory.addItemListener(this);
        this.itemStateChanged(new ItemEvent(this.firstCategory, (int)System.currentTimeMillis(), null, 1));
        this.secondCategory.setSelectedItem(Words.ALL);
    }

    @Override
    public ASearchConfiguration<BasicArticleLight, ABasicArticleSearchConfiguration.BASIC_ARTICLE_COLUMN> getModuleSearchParameters(Object name, Object value, boolean isReset, boolean getEmptyConfig, Component source) {
        Object o;
        if (isReset) {
            this.searchCriteria1 = null;
            this.filterCriteria1 = null;
            this.filterCriteria2 = null;
            this.filterCriteria3 = null;
            this.filterCriteria4 = null;
            this.filterCriteria5 = null;
            this.filterCriteria6 = null;
            this.filterCriteria7 = null;
            this.filterCriteria14 = null;
            this.filterCriteria15 = null;
        } else if (name == FILTER1) {
            ConfigurableSearchTextField textfield = (ConfigurableSearchTextField)source;
            this.filterCriteria1 = (BasicArticleSearchTypeE)textfield.getSearchType();
            this.searchCriteria1 = (String)value;
        } else if (name == FILTER2) {
            o = this.firstCategory.getSelectedItem();
            if (!(o instanceof String)) {
                this.filterCriteria2 = (ArticleCategoryLight)((Node)o).getValue();
            }
        } else if (name == FILTER3) {
            o = this.secondCategory.getSelectedItem();
            this.filterCriteria3 = o instanceof Node ? (ArticleCategoryLight)((Node)o).getValue() : null;
            Object o2 = this.firstCategory.getSelectedItem();
            this.filterCriteria2 = o2 instanceof Node ? (ArticleCategoryLight)((Node)o2).getValue() : null;
        } else if (name == FILTER4) {
            o = value;
            this.filterCriteria4 = !(o instanceof String) ? (SupplierLight)o : null;
        } else if (name == FILTER5) {
            o = value;
            this.filterCriteria5 = o instanceof StoreReference ? (StoreLight)o : null;
        } else if (name == FILTER6) {
            o = value;
            this.filterCriteria6 = o instanceof CustomerLight ? (CustomerLight)o : (o instanceof Node ? (CustomerLight)((Node)o).getValue() : null);
        } else if (name == FILTER7) {
            this.filterCriteria7 = value.equals(Words.ALL) ? null : (String)value;
        } else if (name == FILTER14) {
            o = value;
            this.filterCriteria14 = o instanceof ArticleChargeLight ? (ArticleChargeLight)o : null;
        } else if (name == FILTER15) {
            this.filterCriteria15 = value instanceof CustomsDocumentTypeComplete ? (CustomsDocumentTypeComplete)value : (value instanceof Node ? (CustomsDocumentTypeComplete)((Node)value).getValue() : null);
        }
        o = new BasicArticleSearchConfiguration();
        o.setNumResults(this.numberOfShownResults);
        String v = this.searchCriteria1;
        if (v != null) {
            try {
                Integer a = Integer.valueOf(v.trim());
                o.setNumber(a);
                o.setName(v);
                o.setSupplierArticleNumber(v);
                o.setCustomsDocumentId(v);
            }
            catch (NumberFormatException e) {
                o.setNumber(null);
                o.setName(v);
                o.setSupplierArticleNumber(v);
                o.setCustomsDocumentId(v);
            }
        }
        if (this.filterCriteria1 == null) {
            o.setSearchType(BasicArticleSearchTypeE.ALL);
        } else {
            o.setSearchType(this.filterCriteria1);
        }
        o.setStore(this.filterCriteria5);
        o.setAttribute3Category((ArticleCategoryReference)this.filterCriteria2);
        o.setTemperatureCategory((ArticleCategoryReference)this.filterCriteria3);
        o.setSupplier((SupplierReference)this.filterCriteria4);
        o.setCustomer((CustomerReference)this.filterCriteria6);
        o.setStorePosition(null);
        o.setCharge(this.filterCriteria14);
        o.setCustomsDocumentType(this.filterCriteria15);
        if (this.filterCriteria7 == null) {
            o.setInUse(null);
        } else if (this.filterCriteria7.equals(inuseonly)) {
            o.setInUse(Boolean.valueOf(true));
        } else if (this.filterCriteria7.equals(notuseonly)) {
            o.setInUse(Boolean.valueOf(false));
        }
        if (this.currentColumnAttribute != null) {
            o.setSortColumn(this.currentColumnAttribute);
        }
        if (this.isAsc) {
            o.setSortDirection(SortDirection.ASCENDING);
        } else {
            o.setSortDirection(SortDirection.DESCENDING);
        }
        if (source == this.pagination) {
            o.setPageNumber(this.pagination.getCurrentPage() - 1);
        } else {
            o.setPageNumber(0);
        }
        if (o.getPageNumber() < 0) {
            o.setPageNumber(0);
        }
        return o;
    }

    @Override
    public void itemStateChanged(ItemEvent e) {
        if (e.getStateChange() == 1) {
            Object o = this.firstCategory.getSelectedItem();
            this.secondCategory.removeAllItems();
            if (o instanceof String) {
                this.secondCategory.addItem(Words.ALL);
            } else if (o instanceof Node) {
                Node n = (Node)o;
                this.secondCategory.refreshPossibleValues(n.getChildNamed(ArticleCategoryComplete_.subCategories));
                this.secondCategory.addItem(Words.ALL);
                this.secondCategory.setSelectedItem(Words.ALL);
            }
        }
    }

    @Override
    public void remoteObjectLoaded(Node node) {
        this.fillComboBoxes(null);
        super.remoteObjectLoaded(node);
    }

    @Override
    public SearchAlgorithm<BasicArticleLight> getSearchAlgorithm() {
        return SearchAlgorithmRegistry.getSearchAlgorithm(BasicArticleSearchAlgorithm.class);
    }

    @Override
    public FilterChainConfiguration getDefaultConfiguration() {
        FilterChainConfiguration c = new FilterChainConfiguration();
        c.addProperty("sortedColumn", ABasicArticleSearchConfiguration.BASIC_ARTICLE_COLUMN.NUMBER.toString() + "<>" + true);
        return c;
    }

    public ChargeTrackingModuleDataHandler getDataHandler() {
        return (ChargeTrackingModuleDataHandler)this.getTable().getModel().getDataHandler();
    }

    public boolean isChargeBased() {
        return true;
    }

    @Override
    public boolean isSmartScreenAllowed(SubModuleDefinitionComplete screen, RowModel<BasicArticleLight> model) {
        return false;
    }

    @Override
    protected Table.SmartIconConfiguration getPossibleSmartIcons() {
        return Table.SmartIconConfiguration.TWO;
    }

    @Override
    protected RowEditorFactory<BasicArticleLight> getRowEditorFactory() {
        return model -> {
            MessageProvidedRowEditor<BasicArticleLight> rowEditor = new MessageProvidedRowEditor<BasicArticleLight>(model, "");
            RDProvider p = this.createProvider(model.isAddRow());
            ChargeDetailsPanel chargePanel = new ChargeDetailsPanel((RowEditor<BasicArticleLight>)rowEditor, p);
            SideTableDetailsPanel tablePanel = new SideTableDetailsPanel(rowEditor, p, chargePanel);
            rowEditor.add(tablePanel, (Object)new TableLayoutConstraint(0, 0, 1.0, 1.0));
            rowEditor.add(chargePanel, (Object)new TableLayoutConstraint(1, 0, 1.0, 1.0));
            rowEditor.addToFocusQueue(tablePanel);
            rowEditor.addToFocusQueue(chargePanel);
            rowEditor.allInstalled();
            rowEditor.setCancelButtonText(TextButton.BUTTON_TYPES.CLOSE);
            rowEditor.hideCloseButton();
            rowEditor.setVisibleContainer(this.getTable());
            return rowEditor;
        };
    }

    @Override
    protected RowPanel<BasicArticleLight> getNewAddRow() {
        return null;
    }

    @Override
    protected IDataHandler getModuleDataHandler() {
        return new ChargeTrackingModuleDataHandler(this.loadingId, this);
    }

    @Override
    protected List<TableColumnInfo> getTableColumnInfo() {
        ArrayList<TableColumnInfo> infos = new ArrayList<TableColumnInfo>();
        infos.add(new TableColumnInfo(Words.NO_NUMBER, "", IntegerConverter.class, null, BasicArticleLight_.number, 120, 120, 120));
        infos.add(new TableColumnInfo(Words.NAME, "", StringConverter.class, null, BasicArticleLight_.name, 120, Integer.MAX_VALUE, 120));
        return infos;
    }
}

