/*
 * Decompiled with CFR 0.152.
 */
package ch.icit.pegasus.client.gui.modules.dataexchange.inserts;

import ch.icit.pegasus.client.MainFrame;
import ch.icit.pegasus.client.gui.modules.dataexchange.DataExchangeModule;
import ch.icit.pegasus.client.gui.modules.masterdata.panels.DefaultDataInsert;
import ch.icit.pegasus.client.gui.utils.DefaultLayout;
import ch.icit.pegasus.client.gui.utils.TitledItem;
import ch.icit.pegasus.client.gui.utils.buttons.Button;
import ch.icit.pegasus.client.gui.utils.buttons.ButtonListener;
import ch.icit.pegasus.client.gui.utils.buttons.CheckBox;
import ch.icit.pegasus.client.gui.utils.buttons.RadioButton;
import ch.icit.pegasus.client.gui.utils.buttons.RadioButtonBox;
import ch.icit.pegasus.client.gui.utils.buttons.TablePanelAddSaveButton;
import ch.icit.pegasus.client.gui.utils.datechooser.TitledPeriodEditor;
import ch.icit.pegasus.client.gui.utils.panels.LoadingAnimation;
import ch.icit.pegasus.client.gui.utils.popup.InnerPopupFactory;
import ch.icit.pegasus.client.gui.utils.tables.SkypexMappingTable;
import ch.icit.pegasus.client.io.FileTransferListener;
import ch.icit.pegasus.client.io.FileTransferUtil;
import ch.icit.pegasus.client.node.INodeCreator;
import ch.icit.pegasus.client.node.impls.Node;
import ch.icit.pegasus.client.services.ServiceManagerRegistry;
import ch.icit.pegasus.client.services.StaticEnumServiceManager;
import ch.icit.pegasus.client.services.interfaces.masterdata.MasterDataServiceManager;
import ch.icit.pegasus.client.services.interfaces.report.SkypexReportServiceManager;
import ch.icit.pegasus.client.services.interfaces.system.SystemSettingsServiceManager;
import ch.icit.pegasus.client.util.RemoteLoader;
import ch.icit.pegasus.client.util.ScreenValidationObject;
import ch.icit.pegasus.client.util.async.ThreadSafeExecutable;
import ch.icit.pegasus.client.util.async.ThreadSafeLoader;
import ch.icit.pegasus.client.util.exception.ClientException;
import ch.icit.pegasus.server.core.dtos.ADTO;
import ch.icit.pegasus.server.core.dtos.dataexchange.SkypexSettingsComplete;
import ch.icit.pegasus.server.core.dtos.dataexchange.SkypexSettingsComplete_;
import ch.icit.pegasus.server.core.dtos.file.PegasusFileComplete;
import ch.icit.pegasus.server.core.dtos.masterdata.PeriodComplete;
import ch.icit.pegasus.server.core.dtos.masterdata.PeriodComplete_;
import ch.icit.pegasus.server.core.dtos.masterdata.UnitComplete;
import ch.icit.pegasus.server.core.dtos.report.ReportingOutputFormatE;
import ch.icit.pegasus.server.core.i18n.Words;
import ch.icit.pegasus.server.dtos.metamodel.DtoField;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.io.File;
import java.sql.Date;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.JFileChooser;
import javax.swing.SwingUtilities;
import org.apache.commons.io.FilenameUtils;

public class SkypexInsert
extends DefaultDataInsert
implements ButtonListener {
    private static final long serialVersionUID = 1L;
    private TitledItem<CheckBox> article;
    private TitledItem<CheckBox> purchase;
    private TitledItem<CheckBox> invoice;
    private TitledItem<CheckBox> supplier;
    private TitledItem<CheckBox> contracts;
    private TitledItem<CheckBox> acceptations;
    private TitledPeriodEditor period;
    private RadioButtonBox outputFormat;
    private TitledItem<RadioButton> csvOutput;
    private TitledItem<RadioButton> xlsxOutput;
    private TitledItem<SkypexMappingTable> unitMapper;
    private TablePanelAddSaveButton printButton;
    private final DataExchangeModule module;
    protected Node<SkypexSettingsComplete> settings;
    protected SkypexSettingsComplete skypeSettings;

    public SkypexInsert(DataExchangeModule module) {
        super(module);
        this.module = module;
        SkypexSettingsComplete e = new SkypexSettingsComplete();
        e.setPeriod(new PeriodComplete(new Date(System.currentTimeMillis()), new Date(System.currentTimeMillis())));
        this.settings = INodeCreator.getDefaultImpl().getNode4DTO((Object)e, false, false);
    }

    @Override
    public void insertElements() {
        this.article = new TitledItem<CheckBox>(new CheckBox((Node<Boolean>)this.settings.getChildNamed(SkypexSettingsComplete_.includeArticle)), Words.ARTICLE, TitledItem.TitledItemOrientation.EAST);
        this.purchase = new TitledItem<CheckBox>(new CheckBox((Node<Boolean>)this.settings.getChildNamed(SkypexSettingsComplete_.includePurchase)), Words.PURCHASE_ORDER, TitledItem.TitledItemOrientation.EAST);
        this.invoice = new TitledItem<CheckBox>(new CheckBox((Node<Boolean>)this.settings.getChildNamed(SkypexSettingsComplete_.includeInvoice)), Words.INVOICE, TitledItem.TitledItemOrientation.EAST);
        this.supplier = new TitledItem<CheckBox>(new CheckBox((Node<Boolean>)this.settings.getChildNamed(SkypexSettingsComplete_.includeSupplier)), Words.SUPPLIER, TitledItem.TitledItemOrientation.EAST);
        this.contracts = new TitledItem<CheckBox>(new CheckBox((Node<Boolean>)this.settings.getChildNamed(SkypexSettingsComplete_.includeContracts)), Words.CONTRACTS, TitledItem.TitledItemOrientation.EAST);
        this.acceptations = new TitledItem<CheckBox>(new CheckBox((Node<Boolean>)this.settings.getChildNamed(SkypexSettingsComplete_.includeAcceptations)), Words.ACCEPTATIONS, TitledItem.TitledItemOrientation.EAST);
        this.unitMapper = new TitledItem<SkypexMappingTable>(new SkypexMappingTable(), Words.UNIT_MAPPING, TitledItem.TitledItemOrientation.NORTH);
        this.unitMapper.setIgnorePrefHeight(true);
        this.unitMapper.getElement().getModel().setNode(this.settings.getChildNamed(SkypexSettingsComplete_.mapping));
        this.period = new TitledPeriodEditor((Node<Date>)this.settings.getChildNamed(new DtoField[]{SkypexSettingsComplete_.period, PeriodComplete_.startDate}), (Node<Date>)this.settings.getChildNamed(new DtoField[]{SkypexSettingsComplete_.period, PeriodComplete_.endDate}), true, null);
        this.csvOutput = new TitledItem<RadioButton>(new RadioButton(), ".csv (without column header)", TitledItem.TitledItemOrientation.EAST);
        this.xlsxOutput = new TitledItem<RadioButton>(new RadioButton(), ".xlsx (with column header)", TitledItem.TitledItemOrientation.EAST);
        this.csvOutput.getElement().setChecked(true);
        this.outputFormat = new RadioButtonBox();
        this.outputFormat.setBorder(0);
        this.outputFormat.addBox(this.csvOutput, this.csvOutput.getElement());
        this.outputFormat.addBox(this.xlsxOutput, this.xlsxOutput.getElement());
        this.printButton = new TablePanelAddSaveButton();
        this.printButton.setText("Start");
        this.printButton.addButtonListener(this);
        this.setLayout(new Layout());
        this.add(this.article);
        this.add(this.purchase);
        this.add(this.invoice);
        this.add(this.supplier);
        this.add(this.contracts);
        this.add(this.acceptations);
        this.add(this.period);
        this.add(this.printButton);
        this.add(this.unitMapper);
        this.add(this.outputFormat);
    }

    private void ensureAnimation() {
        if (this.animation == null) {
            this.animation = new LoadingAnimation();
            this.animation.stateChanged("Create Skypex Data");
            this.add((Component)this.animation, 0);
        }
        this.animation.start();
        this.animation.fadeIn();
        this.revalidate();
    }

    @Override
    public void loadData() {
        super.loadData();
        ThreadSafeExecutable run = new ThreadSafeExecutable(this){

            @Override
            public Node<?> loadData() throws Exception {
                StaticEnumServiceManager.getAllTimeDurations();
                ((MasterDataServiceManager)ServiceManagerRegistry.getService(MasterDataServiceManager.class)).getAllCached(UnitComplete.class, false);
                SkypexInsert.this.skypeSettings = (SkypexSettingsComplete)((SkypexReportServiceManager)ServiceManagerRegistry.getService(SkypexReportServiceManager.class)).getSettings().getValue();
                if (SkypexInsert.this.skypeSettings == null) {
                    SkypexSettingsComplete s = new SkypexSettingsComplete();
                    s.setClientOId(Long.valueOf(ADTO.getNextId()));
                    SkypexInsert.this.skypeSettings = s;
                }
                SkypexInsert.this.settings = INodeCreator.getDefaultImpl().getNode4DTO((Object)SkypexInsert.this.skypeSettings, false, false);
                ((SystemSettingsServiceManager)ServiceManagerRegistry.getService(SystemSettingsServiceManager.class)).getSettings();
                return null;
            }

            @Override
            public RemoteLoader getInvoker() {
                return SkypexInsert.this;
            }

            @Override
            public long getID() {
                return 0L;
            }
        };
        ThreadSafeLoader.run(run);
    }

    private void hideAnimation() {
        if (this.animation != null) {
            this.animation.fadeOut(true);
            this.animation = null;
        }
        this.revalidate();
    }

    @Override
    public void setEnabled(boolean isEnabled) {
        super.setEnabled(isEnabled);
        if (this.isInserted) {
            this.article.setEnabled(isEnabled);
            this.purchase.setEnabled(isEnabled);
            this.invoice.setEnabled(isEnabled);
            this.supplier.setEnabled(isEnabled);
            this.contracts.setEnabled(isEnabled);
            this.acceptations.setEnabled(isEnabled);
            this.period.setEnabled(isEnabled);
            this.printButton.setEnabled(isEnabled);
            this.unitMapper.setEnabled(isEnabled);
            this.outputFormat.setEnabled(isEnabled);
        }
    }

    @Override
    public void kill() {
        if (this.isKilled()) {
            return;
        }
        super.kill();
        if (this.isInserted) {
            this.article.kill();
            this.purchase.kill();
            this.invoice.kill();
            this.supplier.kill();
            this.contracts.kill();
            this.acceptations.kill();
            this.period.kill();
            this.printButton.kill();
            this.unitMapper.kill();
            this.outputFormat.kill();
        }
        this.article = null;
        this.purchase = null;
        this.invoice = null;
        this.supplier = null;
        this.acceptations = null;
        this.period = null;
        this.printButton = null;
        this.unitMapper = null;
        this.outputFormat = null;
        this.csvOutput = null;
        this.xlsxOutput = null;
    }

    @Override
    public Node getNode() {
        return null;
    }

    @Override
    public List<ScreenValidationObject> validateInsert() {
        return null;
    }

    @Override
    public String getInsertName() {
        return "Skypex";
    }

    @Override
    public void buttonPressed(Button source, int x, int y) {
        List<ScreenValidationObject> a = this.period.validateContent();
        if (a != null && !a.isEmpty()) {
            InnerPopupFactory.showErrorDialog(a, "Unable to start Analysis", (Component)this);
            return;
        }
        this.ensureAnimation();
        this.module.started();
        this.setEnabled(false);
        ThreadSafeExecutable run = new ThreadSafeExecutable(this){

            @Override
            public Node<?> loadData() throws Exception {
                SkypexInsert.this.settings.commit(SkypexSettingsComplete.class);
                SkypexSettingsComplete sypexSettings = (SkypexSettingsComplete)SkypexInsert.this.settings.getValue();
                if (((RadioButton)SkypexInsert.this.csvOutput.getElement()).isChecked()) {
                    sypexSettings.setFormat(ReportingOutputFormatE.CSV);
                } else {
                    sypexSettings.setFormat(ReportingOutputFormatE.XLSX);
                }
                SkypexInsert.this.skypeSettings = (SkypexSettingsComplete)((SystemSettingsServiceManager)ServiceManagerRegistry.getService(SystemSettingsServiceManager.class)).updateSettings((ADTO)sypexSettings).getValue();
                Node n = new Node();
                HashMap<String, File> files = new HashMap<String, File>();
                ArrayList warnings = new ArrayList();
                Map file = ((SkypexReportServiceManager)ServiceManagerRegistry.getService(SkypexReportServiceManager.class)).createSkypexData(sypexSettings, warnings);
                for (String f : file.keySet()) {
                    PegasusFileComplete frc = (PegasusFileComplete)file.get(f);
                    File rfile = FileTransferUtil.download((PegasusFileComplete)frc, (FileTransferListener[])new FileTransferListener[0]);
                    files.put(f, rfile);
                }
                n.setValue(files, 0L);
                if (!warnings.isEmpty()) {
                    SwingUtilities.invokeLater(() -> InnerPopupFactory.showWarningDialog((List<ScreenValidationObject>)ScreenValidationObject.createList((List)warnings), "Waring", "Following warings occured while createing Skypex export", (Component)SkypexInsert.this));
                }
                return n;
            }

            @Override
            public RemoteLoader getInvoker() {
                return new RemoteLoader(){

                    public void remoteObjectLoaded(Node<?> node) {
                        HashMap files = (HashMap)node.getValue();
                        File folder = SkypexInsert.this.showSaveDialog(null);
                        String t = this.ensureFile(folder, files);
                        while (t != null) {
                            InnerPopupFactory.showErrorDialog("File Error " + t, (Component)SkypexInsert.this.printButton);
                            folder = SkypexInsert.this.showSaveDialog(null);
                            t = this.ensureFile(folder, files);
                        }
                        if (folder != null) {
                            for (String f : files.keySet()) {
                                SkypexInsert.this.saveFileTo((File)files.get(f), folder, f);
                            }
                        }
                        SkypexInsert.this.hideAnimation();
                        SkypexInsert.this.module.ended();
                        SkypexInsert.this.setEnabled(true);
                        if (folder != null) {
                            InnerPopupFactory.showMessageDialog("Successfully Exported", SkypexInsert.this.printButton);
                        } else {
                            InnerPopupFactory.showErrorDialog("Error while Export", (Component)SkypexInsert.this.printButton);
                        }
                    }

                    private String ensureFile(File folder, Map<String, File> files) {
                        if (folder == null) {
                            return null;
                        }
                        if (!folder.isDirectory()) {
                            return "Please select a Directory";
                        }
                        for (String f : files.keySet()) {
                            File nf = files.get(f);
                            nf = new File(folder.getPath() + File.separator + f + ".excel");
                            if (!nf.exists()) continue;
                            return "File " + nf.getName() + " already exists";
                        }
                        return null;
                    }

                    public void errorOccurred(ClientException exception) {
                        InnerPopupFactory.showErrorDialog((Exception)exception, "Unable to create Skypex Export", (Component)SkypexInsert.this.printButton);
                        SkypexInsert.this.hideAnimation();
                        SkypexInsert.this.setEnabled(true);
                        SkypexInsert.this.module.ended();
                    }
                };
            }

            @Override
            public long getID() {
                return 0L;
            }
        };
        ThreadSafeLoader.run(run);
    }

    private File showSaveDialog(File file) {
        MainFrame.isTempRelease = true;
        JFileChooser fc = new JFileChooser();
        fc.setFileSelectionMode(1);
        if (MainFrame.getDefaultPath() != null) {
            fc.setCurrentDirectory(new File(MainFrame.getDefaultPath()));
        }
        int returnVal = fc.showOpenDialog(this);
        fc.setVisible(false);
        File selectedFile = null;
        if (returnVal == 0) {
            MainFrame.setDefaultPath(fc.getCurrentDirectory().getAbsolutePath());
            String name = fc.getSelectedFile().getName();
            selectedFile = new File(MainFrame.getDefaultPath() + File.separator + name);
        } else {
            selectedFile = null;
            this.setEnabled(true);
        }
        MainFrame.isTempRelease = false;
        return selectedFile;
    }

    private void saveFileTo(File file, File path, String fileName) {
        if (path.isDirectory()) {
            file.renameTo(new File(path.getPath() + File.separator + fileName + "." + FilenameUtils.getExtension((String)file.getName())));
        }
        this.setEnabled(true);
    }

    private class Layout
    extends DefaultLayout {
        private Layout() {
        }

        @Override
        public Dimension preferredLayoutSize(Container parent) {
            return new Dimension();
        }

        @Override
        public void layoutContainer(Container parent) {
            int border = 10;
            if (SkypexInsert.this.animation != null) {
                SkypexInsert.this.animation.setLocation((int)((double)parent.getWidth() - SkypexInsert.this.animation.getPreferredSize().getWidth()) / 2, (int)((double)parent.getHeight() - SkypexInsert.this.animation.getPreferredSize().getHeight()) / 2);
                SkypexInsert.this.animation.setSize(SkypexInsert.this.animation.getPreferredSize());
            }
            if (SkypexInsert.this.isInserted) {
                SkypexInsert.this.article.setLocation(border, border);
                SkypexInsert.this.article.setSize(parent.getWidth() / 2 - 2 * border, (int)SkypexInsert.this.article.getPreferredSize().getHeight());
                SkypexInsert.this.purchase.setLocation(border, SkypexInsert.this.article.getY() + SkypexInsert.this.article.getHeight() + border / 2);
                SkypexInsert.this.purchase.setSize(parent.getWidth() / 2 - 2 * border, (int)SkypexInsert.this.purchase.getPreferredSize().getHeight());
                SkypexInsert.this.invoice.setLocation(border, SkypexInsert.this.purchase.getY() + SkypexInsert.this.purchase.getHeight() + border / 2);
                SkypexInsert.this.invoice.setSize(parent.getWidth() / 2 - 2 * border, (int)SkypexInsert.this.invoice.getPreferredSize().getHeight());
                SkypexInsert.this.supplier.setLocation(border, SkypexInsert.this.invoice.getY() + SkypexInsert.this.invoice.getHeight() + border / 2);
                SkypexInsert.this.supplier.setSize(parent.getWidth() / 2 - 2 * border, (int)SkypexInsert.this.supplier.getPreferredSize().getHeight());
                SkypexInsert.this.contracts.setLocation(border, SkypexInsert.this.supplier.getY() + SkypexInsert.this.supplier.getHeight() + border / 2);
                SkypexInsert.this.contracts.setSize(parent.getWidth() / 2 - 2 * border, (int)SkypexInsert.this.contracts.getPreferredSize().getHeight());
                SkypexInsert.this.acceptations.setLocation(border, SkypexInsert.this.contracts.getY() + SkypexInsert.this.contracts.getHeight() + border / 2);
                SkypexInsert.this.acceptations.setSize(parent.getWidth() / 2 - 2 * border, (int)SkypexInsert.this.acceptations.getPreferredSize().getHeight());
                SkypexInsert.this.period.setLocation(SkypexInsert.this.article.getX() + SkypexInsert.this.article.getWidth() + 2 * border, SkypexInsert.this.article.getY());
                SkypexInsert.this.period.setSize(parent.getWidth() / 2 - 2 * border, (int)SkypexInsert.this.period.getPreferredSize().getHeight());
                SkypexInsert.this.outputFormat.setLocation(SkypexInsert.this.period.getX(), SkypexInsert.this.period.getY() + SkypexInsert.this.period.getHeight() + border);
                SkypexInsert.this.outputFormat.setSize(parent.getWidth() / 2 - 2 * border, (int)SkypexInsert.this.outputFormat.getPreferredSize().getHeight());
                SkypexInsert.this.printButton.setLocation((int)((double)parent.getWidth() - ((double)border + SkypexInsert.this.printButton.getPreferredSize().getWidth())), (int)((double)parent.getHeight() - ((double)border + SkypexInsert.this.printButton.getPreferredSize().getHeight())));
                SkypexInsert.this.printButton.setSize(SkypexInsert.this.printButton.getPreferredSize());
                SkypexInsert.this.unitMapper.setLocation(SkypexInsert.this.period.getX(), SkypexInsert.this.outputFormat.getY() + SkypexInsert.this.outputFormat.getHeight() + border);
                SkypexInsert.this.unitMapper.setSize(SkypexInsert.this.outputFormat.getWidth(), 300);
            }
        }
    }
}

