/*
 * Decompiled with CFR 0.152.
 */
package ch.icit.pegasus.client.gui.modules.dataexchange.inserts.edelweiss;

import ch.icit.pegasus.client.converter.EdelweissTransactionExchangeLastUpdateConverter;
import ch.icit.pegasus.client.converter.controller.ConverterRegistry;
import ch.icit.pegasus.client.gui.modules.dataexchange.DataExchangeModule;
import ch.icit.pegasus.client.gui.modules.masterdata.panels.DefaultDataInsert;
import ch.icit.pegasus.client.gui.utils.DefaultLayout;
import ch.icit.pegasus.client.gui.utils.TextLabel;
import ch.icit.pegasus.client.gui.utils.TitledItem;
import ch.icit.pegasus.client.gui.utils.buttons.Button;
import ch.icit.pegasus.client.gui.utils.buttons.ButtonListener;
import ch.icit.pegasus.client.gui.utils.buttons.CheckBox;
import ch.icit.pegasus.client.gui.utils.buttons.TablePanelAddSaveButton;
import ch.icit.pegasus.client.gui.utils.panels.BorderedInletPanel;
import ch.icit.pegasus.client.gui.utils.panels.FTPDataExchangeSettingsPanel;
import ch.icit.pegasus.client.gui.utils.panels.LoadingAnimation;
import ch.icit.pegasus.client.gui.utils.popup.InnerPopupFactory;
import ch.icit.pegasus.client.gui.utils.searchbox.SearchTextField2;
import ch.icit.pegasus.client.gui.utils.searchbox.SearchTextField2Factory;
import ch.icit.pegasus.client.gui.utils.tables.EdelweissTransactionExportSheetListTable;
import ch.icit.pegasus.client.node.INodeCreator;
import ch.icit.pegasus.client.node.impls.Node;
import ch.icit.pegasus.client.node.impls.ViewNode;
import ch.icit.pegasus.client.services.ServiceManagerRegistry;
import ch.icit.pegasus.client.services.StaticEnumServiceManager;
import ch.icit.pegasus.client.services.interfaces.TimerServiceServiceManager;
import ch.icit.pegasus.client.services.interfaces.supply.EdelweissTransactionExchangeServiceManager;
import ch.icit.pegasus.client.services.interfaces.system.SystemSettingsServiceManager;
import ch.icit.pegasus.client.util.RemoteLoader;
import ch.icit.pegasus.client.util.ScreenValidationObject;
import ch.icit.pegasus.client.util.async.ThreadSafeExecutable;
import ch.icit.pegasus.client.util.async.ThreadSafeLoader;
import ch.icit.pegasus.client.util.exception.ClientException;
import ch.icit.pegasus.server.core.dtos.ADTO;
import ch.icit.pegasus.server.core.dtos.dataexchange.DataTransferProtocolE;
import ch.icit.pegasus.server.core.dtos.dataexchange.SFTPDataExchangeSettingsComplete;
import ch.icit.pegasus.server.core.dtos.dataexchange.TimerServiceSettingsComplete;
import ch.icit.pegasus.server.core.dtos.dataexchange.edelweiss.EdelweissTransactionExchangeSettingsComplete;
import ch.icit.pegasus.server.core.dtos.dataexchange.edelweiss.EdelweissTransactionExchangeSettingsComplete_;
import ch.icit.pegasus.server.core.dtos.edelweiss.stocklevel.EdelweissTransactionExportComplete;
import ch.icit.pegasus.server.core.dtos.supply.CustomerLight;
import ch.icit.pegasus.server.core.dtos.util.DailyTimeComplete;
import ch.icit.pegasus.server.core.dtos.util.EncryptedStringComplete;
import ch.icit.pegasus.server.core.dtos.util.TimerServiceConfigComplete;
import ch.icit.pegasus.server.core.i18n.Words;
import ch.icit.pegasus.server.core.timerService.ServiceTypesForTimerService;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.util.ArrayList;
import java.util.List;

public class EdelweissTransactionExchangeInsert
extends DefaultDataInsert
implements ButtonListener {
    private static final long serialVersionUID = 1L;
    private BorderedInletPanel sendPanel;
    private BorderedInletPanel configPanel;
    private TitledItem<CheckBox> active;
    private FTPDataExchangeSettingsPanel ftpPanel;
    private TextLabel lastUpdates;
    private TitledItem<SearchTextField2<CustomerLight>> customer;
    private TitledItem<CheckBox> appendData;
    private Node<List<EdelweissTransactionExportComplete>> stockLevelData;
    private EdelweissTransactionExportSheetListTable history;
    private TablePanelAddSaveButton sendButton;
    private TablePanelAddSaveButton saveButton;
    private final DataExchangeModule module;
    private Node<EdelweissTransactionExchangeSettingsComplete> settings;

    public EdelweissTransactionExchangeInsert(DataExchangeModule module) {
        super(module);
        this.module = module;
    }

    @Override
    public void insertElements() {
        this.configPanel = new BorderedInletPanel(true);
        this.configPanel.setTitleText(Words.CONFIG);
        this.configPanel.setHasBackground(true);
        this.active = new TitledItem<CheckBox>(new CheckBox((Node<Boolean>)this.settings.getChildNamed(EdelweissTransactionExchangeSettingsComplete_.active)), Words.ACTIVE, TitledItem.TitledItemOrientation.EAST);
        this.active.getElement().addButtonListener(this);
        this.ftpPanel = new FTPDataExchangeSettingsPanel();
        this.ftpPanel.setNode(this.settings.getChildNamed(EdelweissTransactionExchangeSettingsComplete_.sendDataExchangeSettings));
        this.lastUpdates = new TextLabel(this.settings, ConverterRegistry.getConverter(EdelweissTransactionExchangeLastUpdateConverter.class));
        this.customer = new TitledItem<SearchTextField2<CustomerLight>>(SearchTextField2Factory.getCustomerSearchField(true, this.settings.getChildNamed(EdelweissTransactionExchangeSettingsComplete_.customer)), Words.CUSTOMER, TitledItem.TitledItemOrientation.NORTH);
        this.appendData = new TitledItem<CheckBox>(new CheckBox((Node<Boolean>)this.settings.getChildNamed(EdelweissTransactionExchangeSettingsComplete_.append)), "Append Data", TitledItem.TitledItemOrientation.EAST);
        this.history = new EdelweissTransactionExportSheetListTable();
        this.history.setNode(this.stockLevelData);
        this.sendPanel = new BorderedInletPanel(true);
        this.sendPanel.setTitleText(Words.EXCHANGE_HISTORY);
        this.sendPanel.setHasBackground(true);
        this.sendButton = new TablePanelAddSaveButton();
        this.sendButton.setText(Words.SEND);
        this.sendButton.addButtonListener(this);
        this.saveButton = new TablePanelAddSaveButton();
        this.saveButton.setText(Words.SAVE);
        this.saveButton.addButtonListener(this);
        this.setLayout(new Layout());
        this.sendPanel.setLayout(new SendLayout());
        this.configPanel.setLayout(new ConfigLayout());
        this.configPanel.add(this.ftpPanel);
        this.configPanel.add(this.active);
        this.configPanel.add(this.lastUpdates);
        this.configPanel.add(this.saveButton);
        this.configPanel.add(this.customer);
        this.configPanel.add(this.appendData);
        this.sendPanel.add(this.history);
        this.sendPanel.add(this.sendButton);
        this.add(this.configPanel);
        this.add(this.sendPanel);
    }

    private void ensureAnimation(String text) {
        if (this.animation == null) {
            this.animation = new LoadingAnimation();
            this.animation.stateChanged(text);
            this.add((Component)this.animation, 0);
        }
        this.animation.start();
        this.animation.fadeIn();
        this.revalidate();
    }

    @Override
    public void loadData() {
        super.loadData();
        ThreadSafeExecutable run = new ThreadSafeExecutable(this){

            @Override
            public Node<?> loadData() throws Exception {
                StaticEnumServiceManager.getAllTimeDurations();
                ((SystemSettingsServiceManager)ServiceManagerRegistry.getService(SystemSettingsServiceManager.class)).getSettings();
                EdelweissTransactionExchangeSettingsComplete esc = null;
                try {
                    esc = (EdelweissTransactionExchangeSettingsComplete)((EdelweissTransactionExchangeServiceManager)ServiceManagerRegistry.getService(EdelweissTransactionExchangeServiceManager.class)).getSettings().getValue();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                if (esc == null) {
                    EdelweissTransactionExchangeSettingsComplete s = new EdelweissTransactionExchangeSettingsComplete();
                    s.setClientOId(Long.valueOf(ADTO.getNextId()));
                    esc = s;
                }
                if (esc.getSendDataExchangeSettings() == null) {
                    SFTPDataExchangeSettingsComplete c = new SFTPDataExchangeSettingsComplete();
                    c.setClientOId(Long.valueOf(ADTO.getNextId()));
                    esc.setSendDataExchangeSettings(c);
                }
                if (esc.getSendDataExchangeSettings().getLoginPwd() == null) {
                    esc.getSendDataExchangeSettings().setLoginPwd(new EncryptedStringComplete());
                }
                esc.setSendTimerServiceSettings(EdelweissTransactionExchangeInsert.this.createTimerService());
                EdelweissTransactionExchangeInsert.this.settings = INodeCreator.getDefaultImpl().getNode4DTO((Object)esc, false, false);
                EdelweissTransactionExchangeInsert.this.stockLevelData = (Node)new ViewNode("data");
                return null;
            }

            @Override
            public RemoteLoader getInvoker() {
                return EdelweissTransactionExchangeInsert.this;
            }

            @Override
            public long getID() {
                return 0L;
            }
        };
        ThreadSafeLoader.run(run);
    }

    private TimerServiceSettingsComplete createTimerService() {
        TimerServiceSettingsComplete s = new TimerServiceSettingsComplete();
        s.setClientOId(Long.valueOf(ADTO.getNextId()));
        s.setTimerServiceConfig((TimerServiceConfigComplete)new DailyTimeComplete(Integer.valueOf(1), Integer.valueOf(45), Integer.valueOf(0)));
        return s;
    }

    private void hideAnimation() {
        if (this.animation != null) {
            this.animation.fadeOut(true);
            this.animation = null;
        }
        this.revalidate();
    }

    @Override
    public void setEnabled(boolean isEnabled) {
        super.setEnabled(isEnabled);
        if (this.isInserted) {
            this.active.setEnabled(isEnabled);
            boolean b = isEnabled && this.active.getElement().isChecked();
            this.sendButton.setEnabled(b);
            this.ftpPanel.setEnabled(b);
            this.appendData.setEnabled(b);
            this.customer.setEnabled(b);
            this.lastUpdates.setEnabled(b);
            this.history.setEnabled(isEnabled);
            this.saveButton.setEnabled(isEnabled);
        }
    }

    @Override
    public void kill() {
        if (this.isKilled()) {
            return;
        }
        super.kill();
        if (this.isInserted) {
            this.sendPanel.kill();
            this.configPanel.kill();
            this.sendButton.kill();
            this.ftpPanel.kill();
            this.history.kill();
            this.lastUpdates.kill();
            this.saveButton.kill();
            this.active.kill();
            this.customer.kill();
            this.appendData.kill();
        }
        this.sendPanel = null;
        this.configPanel = null;
        this.ftpPanel = null;
        this.sendButton = null;
        this.history = null;
        this.lastUpdates = null;
        this.saveButton = null;
        this.active = null;
        this.customer = null;
        this.appendData = null;
    }

    @Override
    public Node getNode() {
        return null;
    }

    @Override
    public List<ScreenValidationObject> validateInsert() {
        return null;
    }

    @Override
    public String getInsertName() {
        return "EDW Transaction Exchange";
    }

    @Override
    public void buttonPressed(Button source, int x, int y) {
        if (source == this.sendButton || source == this.saveButton) {
            this.settings.commit();
            this.setEnabled(false);
            if (source == this.sendButton) {
                this.ensureAnimation(Words.EXCHANGE_DATA_WITH_EDELWEISS);
                this.processFiles(false);
            } else if (source == this.saveButton) {
                List<ScreenValidationObject> a = this.validateESpecsConfig();
                if (a.isEmpty()) {
                    this.ensureAnimation(Words.SAVE_DATA);
                    this.saveConfig();
                } else {
                    InnerPopupFactory.showErrorDialog(a, Words.UNABLE_TO_SAVE, (Component)this);
                    this.setEnabled(true);
                    return;
                }
            }
            this.module.started();
        } else {
            this.setEnabled(this.isEnabled());
        }
    }

    private List<ScreenValidationObject> validateESpecsConfig() {
        ArrayList<ScreenValidationObject> a = new ArrayList<ScreenValidationObject>();
        return a;
    }

    private void saveConfig() {
        ThreadSafeExecutable run = new ThreadSafeExecutable(){

            @Override
            public Node<?> loadData() throws Exception {
                EdelweissTransactionExchangeInsert.this.settings.commit(EdelweissTransactionExchangeSettingsComplete.class);
                EdelweissTransactionExchangeSettingsComplete value = (EdelweissTransactionExchangeSettingsComplete)EdelweissTransactionExchangeInsert.this.settings.getValue();
                value.getSendDataExchangeSettings().setDataExchangeProtocol(DataTransferProtocolE.SFTP);
                value.setSendTimerServiceSettings(EdelweissTransactionExchangeInsert.this.createTimerService());
                TimerServiceSettingsComplete sendTS = (TimerServiceSettingsComplete)((SystemSettingsServiceManager)ServiceManagerRegistry.getService(SystemSettingsServiceManager.class)).setTimerServiceData(value.getSendTimerServiceSettings()).getValue();
                value.setSendTimerServiceSettings(sendTS);
                value = (EdelweissTransactionExchangeSettingsComplete)((SystemSettingsServiceManager)ServiceManagerRegistry.getService(SystemSettingsServiceManager.class)).updateSettings((ADTO)value).getValue();
                ((TimerServiceServiceManager)ServiceManagerRegistry.getService(TimerServiceServiceManager.class)).manageAllTimerServiceWithInterval(ServiceTypesForTimerService.EDW_TRANSACTION_EXCHANGE, value.getActive().booleanValue(), sendTS, -1L);
                EdelweissTransactionExchangeInsert.this.settings = INodeCreator.getDefaultImpl().getNode4DTO((Object)value, false, false);
                EdelweissTransactionExchangeInsert.this.lastUpdates.setNode(EdelweissTransactionExchangeInsert.this.settings);
                EdelweissTransactionExchangeInsert.this.history.setNode(EdelweissTransactionExchangeInsert.this.stockLevelData);
                return null;
            }

            @Override
            public RemoteLoader getInvoker() {
                return new RemoteLoader(){

                    public void remoteObjectLoaded(Node<?> node) {
                        EdelweissTransactionExchangeInsert.this.hideAnimation();
                        EdelweissTransactionExchangeInsert.this.module.ended();
                        EdelweissTransactionExchangeInsert.this.setEnabled(true);
                    }

                    public void errorOccurred(ClientException exception) {
                        InnerPopupFactory.showErrorDialog((Exception)exception, (Component)EdelweissTransactionExchangeInsert.this);
                    }
                };
            }

            @Override
            public long getID() {
                return 0L;
            }
        };
        ThreadSafeLoader.run(run);
    }

    private void processFiles(boolean read) {
        ThreadSafeExecutable run = new ThreadSafeExecutable(this){

            @Override
            public Node<?> loadData() throws Exception {
                ((EdelweissTransactionExchangeServiceManager)ServiceManagerRegistry.getService(EdelweissTransactionExchangeServiceManager.class)).sendTransactions();
                EdelweissTransactionExchangeInsert.this.lastUpdates.setNode(EdelweissTransactionExchangeInsert.this.settings);
                return EdelweissTransactionExchangeInsert.this.stockLevelData;
            }

            @Override
            public RemoteLoader getInvoker() {
                return new RemoteLoader(){

                    public void remoteObjectLoaded(Node<?> node) {
                        InnerPopupFactory.showMessageDialog(Words.SUCCESSFULLY_EXPORTED, EdelweissTransactionExchangeInsert.this.sendButton);
                        EdelweissTransactionExchangeInsert.this.hideAnimation();
                        EdelweissTransactionExchangeInsert.this.setEnabled(true);
                        EdelweissTransactionExchangeInsert.this.module.ended();
                    }

                    public void errorOccurred(ClientException exception) {
                        InnerPopupFactory.showErrorDialog((Exception)exception, "Export failed", (Component)EdelweissTransactionExchangeInsert.this.sendButton);
                        EdelweissTransactionExchangeInsert.this.hideAnimation();
                        EdelweissTransactionExchangeInsert.this.setEnabled(true);
                        EdelweissTransactionExchangeInsert.this.module.ended();
                    }
                };
            }

            @Override
            public long getID() {
                return 0L;
            }
        };
        ThreadSafeLoader.run(run);
    }

    private class ConfigLayout
    extends DefaultLayout {
        private ConfigLayout() {
        }

        @Override
        public void layoutContainer(Container parent) {
            EdelweissTransactionExchangeInsert.this.configPanel.layoutTitle(parent);
            int border = 10;
            EdelweissTransactionExchangeInsert.this.active.setLocation(border, border + EdelweissTransactionExchangeInsert.this.configPanel.getTitleHeight());
            EdelweissTransactionExchangeInsert.this.active.setSize(EdelweissTransactionExchangeInsert.this.active.getPreferredSize());
            EdelweissTransactionExchangeInsert.this.ftpPanel.setLocation(border, EdelweissTransactionExchangeInsert.this.active.getY() + EdelweissTransactionExchangeInsert.this.active.getHeight() + border);
            EdelweissTransactionExchangeInsert.this.ftpPanel.setSize(450, (int)EdelweissTransactionExchangeInsert.this.ftpPanel.getPreferredSize().getHeight());
            EdelweissTransactionExchangeInsert.this.lastUpdates.setLocation(border, EdelweissTransactionExchangeInsert.this.ftpPanel.getY() + EdelweissTransactionExchangeInsert.this.ftpPanel.getHeight());
            EdelweissTransactionExchangeInsert.this.lastUpdates.setSize(parent.getWidth() - 2 * border, (int)EdelweissTransactionExchangeInsert.this.lastUpdates.getPreferredSize().getHeight());
            EdelweissTransactionExchangeInsert.this.customer.setLocation(border, EdelweissTransactionExchangeInsert.this.lastUpdates.getY() + EdelweissTransactionExchangeInsert.this.lastUpdates.getHeight() + 5);
            EdelweissTransactionExchangeInsert.this.customer.setSize(parent.getWidth() - 2 * border, (int)EdelweissTransactionExchangeInsert.this.customer.getPreferredSize().getHeight());
            EdelweissTransactionExchangeInsert.this.appendData.setLocation(border, EdelweissTransactionExchangeInsert.this.customer.getY() + EdelweissTransactionExchangeInsert.this.customer.getHeight() + 5);
            EdelweissTransactionExchangeInsert.this.appendData.setSize(EdelweissTransactionExchangeInsert.this.appendData.getPreferredSize());
            EdelweissTransactionExchangeInsert.this.saveButton.setLocation((int)((double)parent.getWidth() - EdelweissTransactionExchangeInsert.this.saveButton.getPreferredSize().getWidth()) / 2, (int)((double)parent.getHeight() - ((double)border + EdelweissTransactionExchangeInsert.this.saveButton.getPreferredSize().getHeight())));
            EdelweissTransactionExchangeInsert.this.saveButton.setSize(EdelweissTransactionExchangeInsert.this.saveButton.getPreferredSize());
        }

        @Override
        public Dimension preferredLayoutSize(Container parent) {
            return new Dimension();
        }
    }

    private class SendLayout
    extends DefaultLayout {
        private SendLayout() {
        }

        @Override
        public void layoutContainer(Container parent) {
            EdelweissTransactionExchangeInsert.this.sendPanel.layoutTitle(parent);
            int border = 10;
            EdelweissTransactionExchangeInsert.this.history.setLocation(0, EdelweissTransactionExchangeInsert.this.sendPanel.getTitleHeight());
            EdelweissTransactionExchangeInsert.this.history.setSize(parent.getWidth(), EdelweissTransactionExchangeInsert.this.sendPanel.getHeight() - (border + EdelweissTransactionExchangeInsert.this.sendPanel.getTitleHeight() + 100));
            EdelweissTransactionExchangeInsert.this.sendButton.setLocation((int)((double)parent.getWidth() - EdelweissTransactionExchangeInsert.this.sendButton.getPreferredSize().getWidth()) / 2, (int)((double)parent.getHeight() - (EdelweissTransactionExchangeInsert.this.sendButton.getPreferredSize().getHeight() + (double)border)));
            EdelweissTransactionExchangeInsert.this.sendButton.setSize(EdelweissTransactionExchangeInsert.this.sendButton.getPreferredSize());
        }

        @Override
        public Dimension preferredLayoutSize(Container arg0) {
            return new Dimension();
        }
    }

    private class Layout
    extends DefaultLayout {
        private Layout() {
        }

        @Override
        public Dimension preferredLayoutSize(Container parent) {
            return new Dimension();
        }

        @Override
        public void layoutContainer(Container parent) {
            int border = 10;
            if (EdelweissTransactionExchangeInsert.this.animation != null) {
                EdelweissTransactionExchangeInsert.this.animation.setLocation((int)((double)parent.getWidth() - EdelweissTransactionExchangeInsert.this.animation.getPreferredSize().getWidth()) / 2, (int)((double)parent.getHeight() - EdelweissTransactionExchangeInsert.this.animation.getPreferredSize().getHeight()) / 2);
                EdelweissTransactionExchangeInsert.this.animation.setSize(EdelweissTransactionExchangeInsert.this.animation.getPreferredSize());
            }
            if (EdelweissTransactionExchangeInsert.this.isInserted) {
                EdelweissTransactionExchangeInsert.this.configPanel.setLocation(border, border);
                EdelweissTransactionExchangeInsert.this.configPanel.setSize((parent.getWidth() - 3 * border) / 2, parent.getHeight() - 2 * border);
                EdelweissTransactionExchangeInsert.this.sendPanel.setLocation(EdelweissTransactionExchangeInsert.this.configPanel.getX() + EdelweissTransactionExchangeInsert.this.configPanel.getWidth() + border, border);
                EdelweissTransactionExchangeInsert.this.sendPanel.setSize(EdelweissTransactionExchangeInsert.this.configPanel.getWidth(), parent.getHeight() - 2 * border);
            }
        }
    }
}

