/*
 * Decompiled with CFR 0.152.
 */
package ch.icit.pegasus.client.gui.modules.internalconsumption;

import ch.icit.pegasus.client.converter.CostCenterConverter;
import ch.icit.pegasus.client.converter.CustomerCodeConverter;
import ch.icit.pegasus.client.converter.DateConverter;
import ch.icit.pegasus.client.converter.DateTimeConverter;
import ch.icit.pegasus.client.converter.DefaultObject2ObjectConverter;
import ch.icit.pegasus.client.converter.IntegerConverter;
import ch.icit.pegasus.client.converter.StringConverter;
import ch.icit.pegasus.client.converter.UserConverter;
import ch.icit.pegasus.client.converter.controller.ConverterRegistry;
import ch.icit.pegasus.client.gui.modules.internalconsumption.InternalConsumptionModuleDataHandler;
import ch.icit.pegasus.client.gui.modules.internalconsumption.details.ArticleCheckoutDetailsPanel;
import ch.icit.pegasus.client.gui.modules.internalconsumption.details.ComponentSearchDetailsPanel;
import ch.icit.pegasus.client.gui.modules.internalconsumption.details.ImportDetailsPanel;
import ch.icit.pegasus.client.gui.modules.internalconsumption.details.MovementDetailsPanel;
import ch.icit.pegasus.client.gui.modules.internalconsumption.details.SpecificationDetailsPanel;
import ch.icit.pegasus.client.gui.modules.internalconsumption.details.TransactionDetailsPanel;
import ch.icit.pegasus.client.gui.screentemplates.overview.ScreenTableView;
import ch.icit.pegasus.client.gui.screentemplates.overview.data.IDataHandler;
import ch.icit.pegasus.client.gui.table.MessageProvidedRowEditor;
import ch.icit.pegasus.client.gui.table.RowEditor;
import ch.icit.pegasus.client.gui.table.RowEditorFactory;
import ch.icit.pegasus.client.gui.table.RowModel;
import ch.icit.pegasus.client.gui.table.Table;
import ch.icit.pegasus.client.gui.table.TableColumnInfo;
import ch.icit.pegasus.client.gui.utils.TableLayoutConstraint;
import ch.icit.pegasus.client.gui.utils.combobox.ComboBox;
import ch.icit.pegasus.client.gui.utils.combobox.ComboBoxFactory;
import ch.icit.pegasus.client.gui.utils.datechooser.TitledPeriodEditor;
import ch.icit.pegasus.client.gui.utils.filterchain.FilterChainConfiguration;
import ch.icit.pegasus.client.gui.utils.rightdependant.RDProvider;
import ch.icit.pegasus.client.node.impls.Node;
import ch.icit.pegasus.client.node.impls.NodeToolkit;
import ch.icit.pegasus.client.search.SearchAlgorithm;
import ch.icit.pegasus.client.search.controller.SearchAlgorithmRegistry;
import ch.icit.pegasus.client.search.impls.remote.InternalConsumptionSearchAlgorithm;
import ch.icit.pegasus.server.core.dtos.cantine.InternalConsumptionLight;
import ch.icit.pegasus.server.core.dtos.cantine.InternalConsumptionLight_;
import ch.icit.pegasus.server.core.dtos.cantine.InternalConsumptionStateE;
import ch.icit.pegasus.server.core.dtos.company.InternalCostCenterComplete;
import ch.icit.pegasus.server.core.dtos.masterdata.PeriodComplete;
import ch.icit.pegasus.server.core.dtos.rightmanagement.definition.SubModuleDefinitionComplete;
import ch.icit.pegasus.server.core.dtos.rightmanagement.template.AccessDefinitionComplete;
import ch.icit.pegasus.server.core.dtos.rightmanagement.template.def.InternalConsumptionAccess;
import ch.icit.pegasus.server.core.dtos.search.InternalConsumptionSearchConfiguration;
import ch.icit.pegasus.server.core.dtos.supply.CustomerLight;
import ch.icit.pegasus.server.core.dtos.system.SystemSettingsComplete;
import ch.icit.pegasus.server.core.dtos.utils.CompanyUtil;
import ch.icit.pegasus.server.core.general.ASearchConfiguration;
import ch.icit.pegasus.server.core.i18n.Words;
import ch.icit.pegasus.server.core.search.SortDirection;
import java.awt.Component;
import java.sql.Date;
import java.util.ArrayList;
import java.util.List;

public class InternalConsumptionModule
extends ScreenTableView<InternalConsumptionLight, InternalConsumptionSearchConfiguration.INTERNAL_CONSUMPTION_COLUMN> {
    private static final long serialVersionUID = 1L;
    private static final String FILTER_CUSTOMER = "customer_filter";
    private static final String FILTER_NAME_OR_NUMBER = "name_or_number_filter";
    private static final String FILTER_PERIOD = "period";
    private static final String FILTER_STATE = "state";
    private static final String FILTER_DEPARTMENT = "department";
    private String searchCriteria1 = null;
    private CustomerLight searchCriteria2 = null;
    private PeriodComplete searchCriteria3 = null;
    private InternalConsumptionStateE searchCriteria4 = null;
    private InternalCostCenterComplete searchCriteria5 = null;
    private TitledPeriodEditor period;
    private ComboBox departments;

    public InternalConsumptionModule() {
        super(InternalConsumptionLight.class);
        this.isSynchronSearch = false;
    }

    @Override
    public FilterChainConfiguration getDefaultConfiguration() {
        FilterChainConfiguration c = new FilterChainConfiguration();
        c.addProperty("sortedColumn", InternalConsumptionSearchConfiguration.INTERNAL_CONSUMPTION_COLUMN.NUMBER.toString() + "<>" + true);
        return c;
    }

    @Override
    protected void createFilterChain(long id) {
        SystemSettingsComplete settings = (SystemSettingsComplete)NodeToolkit.getAffixClass(SystemSettingsComplete.class).getValue();
        this.filterChain.addSearchField(FILTER_NAME_OR_NUMBER, Words.NAME_OR_NUMBER, "");
        if (!CompanyUtil.isNoPro((SystemSettingsComplete)settings)) {
            this.filterChain.addCustomerSearchField(FILTER_CUSTOMER);
            ComboBox stateCombo = ComboBoxFactory.getInternalConsumptionState(true);
            this.filterChain.addSelectionComboBox(stateCombo, 100, FILTER_STATE, Words.STATE, Words.ALL);
            this.departments = new ComboBox(null, null, ConverterRegistry.getConverter(CostCenterConverter.class));
            this.filterChain.addSelectionComboBox(this.departments, 150, FILTER_DEPARTMENT, Words.COSTCENTER, Words.ALL);
        }
        this.period = this.filterChain.addPeriodSelection(FILTER_PERIOD, new Date(System.currentTimeMillis()), new Date(System.currentTimeMillis()), "", true);
        this.period.setCheckBoxEnabled();
        this.filterChain.addResetButton();
    }

    @Override
    public ASearchConfiguration<InternalConsumptionLight, InternalConsumptionSearchConfiguration.INTERNAL_CONSUMPTION_COLUMN> getModuleSearchParameters(Object name, Object value, boolean isReset, boolean getEmptyConfig, Component source) {
        if (isReset) {
            this.searchCriteria1 = null;
            this.searchCriteria2 = null;
            this.period.setCheckBoxChecked(false);
            this.searchCriteria4 = null;
            this.searchCriteria5 = null;
        } else if (name == FILTER_NAME_OR_NUMBER) {
            this.searchCriteria1 = (String)value;
        } else if (name == FILTER_CUSTOMER) {
            this.searchCriteria2 = value instanceof CustomerLight ? (CustomerLight)value : null;
        } else if (name == FILTER_PERIOD) {
            if (value instanceof PeriodComplete) {
                this.searchCriteria3 = (PeriodComplete)value;
            } else if (value instanceof TitledPeriodEditor) {
                this.searchCriteria3 = ((TitledPeriodEditor)value).getPeriod();
            }
        } else if (name == FILTER_STATE) {
            this.searchCriteria4 = value instanceof InternalConsumptionStateE ? (InternalConsumptionStateE)value : null;
        } else if (name == FILTER_DEPARTMENT) {
            this.searchCriteria5 = value instanceof InternalCostCenterComplete ? (InternalCostCenterComplete)value : null;
        }
        InternalConsumptionSearchConfiguration c = new InternalConsumptionSearchConfiguration();
        c.setNumResults(this.numberOfShownResults);
        c.setCustomer(this.searchCriteria2);
        c.setPeriod(this.searchCriteria3);
        c.setState(this.searchCriteria4);
        try {
            int no = Integer.valueOf(this.searchCriteria1);
            c.setNumber(Integer.valueOf(no));
        }
        catch (NumberFormatException e) {
            c.setName(this.searchCriteria1);
        }
        if (this.currentColumnAttribute != null) {
            c.setSortColumn(this.currentColumnAttribute);
        }
        if (this.isAsc) {
            c.setSortDirection(SortDirection.ASCENDING);
        } else {
            c.setSortDirection(SortDirection.DESCENDING);
        }
        if (source == this.pagination) {
            c.setPageNumber(this.pagination.getCurrentPage() - 1);
        } else {
            c.setPageNumber(0);
        }
        if (c.getPageNumber() < 0) {
            c.setPageNumber(0);
        }
        return c;
    }

    @Override
    public void remoteObjectLoaded(Node<?> node) {
        super.remoteObjectLoaded(node);
        if (this.departments != null) {
            Node cats = NodeToolkit.getAffixList(InternalCostCenterComplete.class);
            this.departments.refreshPossibleValues(cats);
            this.departments.addItem(Words.ALL);
            this.departments.setSelectedItem(Words.ALL);
        }
    }

    @Override
    public SearchAlgorithm<InternalConsumptionLight> getSearchAlgorithm() {
        return SearchAlgorithmRegistry.getSearchAlgorithm(InternalConsumptionSearchAlgorithm.class);
    }

    @Override
    public void redo() {
    }

    @Override
    public void undo() {
    }

    @Override
    public boolean isSmartScreenAllowed(SubModuleDefinitionComplete screen, RowModel<InternalConsumptionLight> model) {
        return model != null && model.getDTO(InternalConsumptionLight.class) != null;
    }

    @Override
    protected Table.SmartIconConfiguration getPossibleSmartIcons() {
        return Table.SmartIconConfiguration.ONE;
    }

    @Override
    protected RowEditorFactory<InternalConsumptionLight> getRowEditorFactory() {
        return model -> {
            MessageProvidedRowEditor<InternalConsumptionLight> rowEditor = new MessageProvidedRowEditor<InternalConsumptionLight>(model, Words.ALL_POSITIONS_WITHOUT_STORE_WILL_BE_REMOVED);
            RDProvider p = this.createProvider(model.isAddRow());
            SpecificationDetailsPanel spec = new SpecificationDetailsPanel((RowEditor<InternalConsumptionLight>)rowEditor, p);
            rowEditor.add(spec, (Object)new TableLayoutConstraint(0, 0, 1.0, 0.0));
            rowEditor.addToFocusQueue(spec);
            int currentRow = 1;
            SystemSettingsComplete settings = (SystemSettingsComplete)NodeToolkit.getAffixClass(SystemSettingsComplete.class).getValue();
            boolean isNoPro = CompanyUtil.isNoPro((SystemSettingsComplete)settings);
            if (model.isAddRow()) {
                if (!isNoPro) {
                    ImportDetailsPanel c3 = new ImportDetailsPanel((RowEditor<InternalConsumptionLight>)rowEditor, p);
                    rowEditor.add(c3, (Object)new TableLayoutConstraint(0, currentRow++, 1.0, 0.0));
                    rowEditor.addToFocusQueue(c3);
                }
                ComponentSearchDetailsPanel c1 = new ComponentSearchDetailsPanel((RowEditor<InternalConsumptionLight>)rowEditor, p);
                ArticleCheckoutDetailsPanel c2 = !isNoPro ? new ArticleCheckoutDetailsPanel((RowEditor<InternalConsumptionLight>)rowEditor, p) : null;
                MovementDetailsPanel m1 = new MovementDetailsPanel((RowEditor<InternalConsumptionLight>)rowEditor, p);
                if (isNoPro) {
                    rowEditor.add(c1, (Object)new TableLayoutConstraint(0, currentRow++, 1.0, 0.0));
                    rowEditor.add(m1, (Object)new TableLayoutConstraint(0, currentRow++, 1.0, 0.0));
                    rowEditor.addToFocusQueue(c1);
                    rowEditor.addToFocusQueue(m1);
                } else {
                    rowEditor.add(c1, (Object)new TableLayoutConstraint(0, currentRow++, 1.0, 0.0));
                    rowEditor.add(c2, (Object)new TableLayoutConstraint(0, currentRow++, 1.0, 0.0));
                    rowEditor.add(m1, (Object)new TableLayoutConstraint(0, currentRow++, 1.0, 0.0));
                    rowEditor.addToFocusQueue(c1);
                    rowEditor.addToFocusQueue(c2);
                    rowEditor.addToFocusQueue(m1);
                }
            } else if (!isNoPro) {
                ComponentSearchDetailsPanel c2 = new ComponentSearchDetailsPanel((RowEditor<InternalConsumptionLight>)rowEditor, p);
                TransactionDetailsPanel c1 = new TransactionDetailsPanel((RowEditor<InternalConsumptionLight>)rowEditor, p);
                rowEditor.add(c2, (Object)new TableLayoutConstraint(0, currentRow++, 1.0, 0.0));
                rowEditor.add(c1, (Object)new TableLayoutConstraint(0, currentRow++, 1.0, 0.0));
                rowEditor.addToFocusQueue(c2);
                rowEditor.addToFocusQueue(c1);
                MovementDetailsPanel m1 = new MovementDetailsPanel((RowEditor<InternalConsumptionLight>)rowEditor, p);
                rowEditor.add(m1, (Object)new TableLayoutConstraint(0, currentRow++, 1.0, 0.0));
                rowEditor.addToFocusQueue(m1);
            } else {
                MovementDetailsPanel m1 = new MovementDetailsPanel((RowEditor<InternalConsumptionLight>)rowEditor, p);
                rowEditor.add(m1, (Object)new TableLayoutConstraint(0, currentRow++, 1.0, 0.0));
                rowEditor.addToFocusQueue(m1);
            }
            rowEditor.allInstalled();
            rowEditor.setVisibleContainer(this.getTable());
            return rowEditor;
        };
    }

    @Override
    protected IDataHandler getModuleDataHandler() {
        return new InternalConsumptionModuleDataHandler(this.loadingId, this);
    }

    @Override
    protected List<TableColumnInfo> getTableColumnInfo() {
        ArrayList<TableColumnInfo> columns = new ArrayList<TableColumnInfo>();
        SystemSettingsComplete settings = (SystemSettingsComplete)NodeToolkit.getAffixClass(SystemSettingsComplete.class).getValue();
        columns.add(new TableColumnInfo(Words.NO_NUMBER, "", (Class)IntegerConverter.class, (Enum<?>)InternalConsumptionSearchConfiguration.INTERNAL_CONSUMPTION_COLUMN.NUMBER, InternalConsumptionLight_.number, TableColumnInfo.numberColumnWithExpandWidth, TableColumnInfo.numberColumnWithExpandWidth, TableColumnInfo.numberColumnWithExpandWidth));
        columns.add(new TableColumnInfo(Words.STATE, "", (Class)DefaultObject2ObjectConverter.class, (Enum<?>)InternalConsumptionSearchConfiguration.INTERNAL_CONSUMPTION_COLUMN.STATE, InternalConsumptionLight_.transactionState, TableColumnInfo.state3, TableColumnInfo.state3, TableColumnInfo.state3));
        columns.add(new TableColumnInfo(Words.DESCRIPTION, "", (Class)StringConverter.class, (Enum<?>)InternalConsumptionSearchConfiguration.INTERNAL_CONSUMPTION_COLUMN.NAME, InternalConsumptionLight_.description, 120, Integer.MAX_VALUE, 120));
        if (!CompanyUtil.isNoPro((SystemSettingsComplete)settings)) {
            columns.add(new TableColumnInfo(Words.CUSTOMER, "", (Class)CustomerCodeConverter.class, (Enum<?>)InternalConsumptionSearchConfiguration.INTERNAL_CONSUMPTION_COLUMN.CUSTOMER, InternalConsumptionLight_.customer, TableColumnInfo.customerCodeWidth, TableColumnInfo.customerCodeWidth, TableColumnInfo.customerCodeWidth));
            columns.add(new TableColumnInfo(Words.DEPARTMENT, "", CostCenterConverter.class, null, InternalConsumptionLight_.department, TableColumnInfo.customerCodeWidth, TableColumnInfo.customerCodeWidth, TableColumnInfo.customerCodeWidth));
        }
        columns.add(new TableColumnInfo(Words.CONSUMPTION_DATE, "", (Class)DateConverter.class, (Enum<?>)InternalConsumptionSearchConfiguration.INTERNAL_CONSUMPTION_COLUMN.CONSUMPTION_DATE, InternalConsumptionLight_.consumptionDate, TableColumnInfo.dateColumnWidth, TableColumnInfo.dateColumnWidth, TableColumnInfo.dateColumnWidth));
        columns.add(new TableColumnInfo(Words.CREATION_DATE, "", (Class)DateTimeConverter.class, (Enum<?>)InternalConsumptionSearchConfiguration.INTERNAL_CONSUMPTION_COLUMN.CREATION_DATE, InternalConsumptionLight_.creationDate, TableColumnInfo.dateTimeColumnWidth, TableColumnInfo.dateTimeColumnWidth, TableColumnInfo.dateTimeColumnWidth));
        columns.add(new TableColumnInfo(Words.CREATION_USER, "", (Class)UserConverter.class, (Enum<?>)InternalConsumptionSearchConfiguration.INTERNAL_CONSUMPTION_COLUMN.USER, InternalConsumptionLight_.consumptionUser, 120, 120, 120));
        return columns;
    }

    @Override
    public AccessDefinitionComplete getInvoker() {
        return InternalConsumptionAccess.MODULE_INTERNAL_CONSUMPTION;
    }
}

