/*
 * Decompiled with CFR 0.152.
 */
package ch.icit.pegasus.client.gui.modules.inventory.details.utils;

import ch.icit.pegasus.client.converter.PerUnitViewConverter;
import ch.icit.pegasus.client.converter.PriceConverter2;
import ch.icit.pegasus.client.converter.UnitConverter;
import ch.icit.pegasus.client.converter.controller.ConverterRegistry;
import ch.icit.pegasus.client.gui.utils.CheckedListAdder;
import ch.icit.pegasus.client.gui.utils.DefaultLayout;
import ch.icit.pegasus.client.gui.utils.TextLabel;
import ch.icit.pegasus.client.gui.utils.TitledItem;
import ch.icit.pegasus.client.gui.utils.buttons.CheckBox;
import ch.icit.pegasus.client.gui.utils.combobox.ComboBox;
import ch.icit.pegasus.client.gui.utils.combobox.InputComboBox;
import ch.icit.pegasus.client.gui.utils.panels.LoadingAnimation;
import ch.icit.pegasus.client.gui.utils.popup.PopUpInsert;
import ch.icit.pegasus.client.gui.utils.popup.PopupAction;
import ch.icit.pegasus.client.node.impls.Node;
import ch.icit.pegasus.client.util.RemoteLoader;
import ch.icit.pegasus.client.util.loaders.BasicArticleLoader;
import ch.icit.pegasus.client.util.toolkits.nodebased.UnitConversionToolkitNodeBased;
import ch.icit.pegasus.server.core.dtos.masterdata.UnitComplete;
import ch.icit.pegasus.server.core.dtos.store.ArticleChargeComplete;
import ch.icit.pegasus.server.core.dtos.store.ArticleChargeLight;
import ch.icit.pegasus.server.core.dtos.supply.BasicArticleComplete;
import ch.icit.pegasus.server.core.dtos.supply.BasicArticleLight;
import ch.icit.pegasus.server.core.dtos.supply.BasicArticleReference;
import ch.icit.pegasus.server.core.dtos.supply.PriceComplete;
import ch.icit.pegasus.server.core.dtos.supply.PriceComplete_;
import ch.icit.pegasus.server.core.i18n.Words;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.util.List;

public class ChangeArticleChargePriceAndUnit
extends PopUpInsert
implements RemoteLoader {
    private static final long serialVersionUID = 1L;
    private final Node<ArticleChargeLight> charge;
    private TitledItem<TextLabel> oldPrice;
    private TextLabel oldPriceUnit;
    private TitledItem<InputComboBox> newPrice;
    private ComboBox newPriceUnit;
    private TitledItem<CheckBox> changePurchaseOrderPrice;
    private Node articleNode;
    private LoadingAnimation animation;
    private boolean isAnimating = false;

    public ChangeArticleChargePriceAndUnit(Node<ArticleChargeLight> charge, Node<PriceComplete> newPrice, Node<PriceComplete> oldPrice, Node<Boolean> changeOrder, Node<UnitComplete> oldPriceUnit, Node<UnitComplete> newPriceUnit, Node<BasicArticleLight> artNode) {
        this.charge = charge;
        this.articleNode = artNode;
        this.oldPrice = new TitledItem<TextLabel>(new TextLabel(oldPrice, ConverterRegistry.getConverter(PriceConverter2.class)), Words.OLD_PRICE, TitledItem.TitledItemOrientation.NORTH);
        this.oldPriceUnit = new TextLabel(oldPriceUnit, ConverterRegistry.getConverter(PerUnitViewConverter.class));
        this.newPrice = new TitledItem<InputComboBox>(new InputComboBox(newPrice.getChildNamed(PriceComplete_.price), newPrice.getChildNamed(PriceComplete_.currency), InputComboBox.InputComboBoxType.PRICE_AND_UNIT_DOUBLE), Words.NEW_PRICE, TitledItem.TitledItemOrientation.NORTH);
        this.newPriceUnit = new ComboBox(newPriceUnit, null, ConverterRegistry.getConverter(UnitConverter.class));
        this.changePurchaseOrderPrice = new TitledItem<CheckBox>(new CheckBox(changeOrder), Words.CHANGE_ORDER_PRICE, TitledItem.TitledItemOrientation.EAST);
        this.setLayout(new Layout());
        this.add(this.oldPrice);
        this.add(this.oldPriceUnit);
        this.add(this.newPrice);
        this.add(this.newPriceUnit);
        this.add(this.changePurchaseOrderPrice);
        if (artNode.getValue(BasicArticleComplete.class) != null) {
            this.remoteObjectLoaded(this.articleNode);
        } else {
            new BasicArticleLoader((BasicArticleReference)((BasicArticleLight)this.articleNode.getValue(BasicArticleLight.class)), this, this.articleNode, this);
            this.ensureAnimation();
        }
    }

    private void ensureAnimation() {
        this.isAnimating = true;
        if (this.animation == null) {
            this.animation = new LoadingAnimation();
            this.animation.stateChanged(Words.LOAD_ARTICLE);
            this.add(this.animation);
            this.animation.fadeIn();
            this.animation.start();
        }
    }

    private void killAnimation() {
        this.isAnimating = false;
        if (this.animation != null) {
            this.animation.kill();
        }
        this.animation = null;
    }

    @Override
    public List<Component> getFocusComponents() {
        List<Component> focusList = this.newPrice.getFocusComponents();
        CheckedListAdder.addToList(focusList, this.newPriceUnit);
        CheckedListAdder.addToList(focusList, this.changePurchaseOrderPrice);
        return focusList;
    }

    @Override
    public Object[] getValues(PopupAction isOK) {
        if (isOK == PopupAction.CANCEL) {
            return null;
        }
        Object[] o = new Object[]{this.newPrice.getElement().getValueNode()};
        return o;
    }

    @Override
    public void kill() {
        if (this.isKilled()) {
            return;
        }
        super.kill();
        this.oldPrice.kill();
        this.newPrice.kill();
        this.oldPriceUnit.kill();
        this.newPriceUnit.kill();
        this.changePurchaseOrderPrice.kill();
        this.oldPrice = null;
        this.oldPriceUnit = null;
        this.newPrice = null;
        this.newPriceUnit = null;
        this.changePurchaseOrderPrice = null;
    }

    @Override
    public boolean isClosableWithEnter() {
        return true;
    }

    @Override
    public boolean isInnerComponent(Component c) {
        if (this.newPriceUnit != null && this.newPriceUnit.getCurrentPopUp() != null) {
            for (Component currentC = c; currentC != null; currentC = currentC.getParent()) {
                if (!currentC.equals(this.newPriceUnit.getCurrentPopUp())) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean tryToGrabFocus() {
        return true;
    }

    @Override
    public void remoteObjectLoaded(Node<?> node) {
        this.killAnimation();
        BasicArticleComplete artC = (BasicArticleComplete)this.articleNode.getValue(BasicArticleComplete.class);
        ArticleChargeComplete charge = (ArticleChargeComplete)this.charge.getValue(ArticleChargeComplete.class);
        this.newPriceUnit.refreshPossibleValues((Node)UnitConversionToolkitNodeBased.getUnitList(charge, artC, true, null));
        this.invalidate();
        this.validate();
    }

    private class Layout
    extends DefaultLayout {
        private Layout() {
        }

        @Override
        public void layoutContainer(Container parent) {
            if (ChangeArticleChargePriceAndUnit.this.isAnimating) {
                ChangeArticleChargePriceAndUnit.this.animation.setLocation((int)((double)parent.getWidth() - ChangeArticleChargePriceAndUnit.this.animation.getPreferredSize().getWidth()) / 2, (int)((double)parent.getHeight() - ChangeArticleChargePriceAndUnit.this.animation.getPreferredSize().getHeight()) / 2);
                ChangeArticleChargePriceAndUnit.this.animation.setSize(ChangeArticleChargePriceAndUnit.this.animation.getPreferredSize());
            } else {
                ChangeArticleChargePriceAndUnit.this.oldPrice.setLocation(0, 0);
                ChangeArticleChargePriceAndUnit.this.oldPrice.setSize((int)ChangeArticleChargePriceAndUnit.this.oldPrice.getPreferredSize().getWidth(), (int)ChangeArticleChargePriceAndUnit.this.oldPrice.getPreferredSize().getHeight());
                ChangeArticleChargePriceAndUnit.this.oldPriceUnit.setLocation(ChangeArticleChargePriceAndUnit.this.oldPrice.getX() + ChangeArticleChargePriceAndUnit.this.oldPrice.getWidth(), (int)((double)(ChangeArticleChargePriceAndUnit.this.oldPrice.getY() + ChangeArticleChargePriceAndUnit.this.oldPrice.getHeight()) - ChangeArticleChargePriceAndUnit.this.oldPriceUnit.getPreferredSize().getHeight()));
                ChangeArticleChargePriceAndUnit.this.oldPriceUnit.setSize(ChangeArticleChargePriceAndUnit.this.oldPriceUnit.getPreferredSize());
                ChangeArticleChargePriceAndUnit.this.newPrice.setLocation(0, ChangeArticleChargePriceAndUnit.this.oldPrice.getY() + ChangeArticleChargePriceAndUnit.this.oldPrice.getHeight() + 10);
                ChangeArticleChargePriceAndUnit.this.newPrice.setSize((int)ChangeArticleChargePriceAndUnit.this.newPrice.getPreferredSize().getWidth(), (int)ChangeArticleChargePriceAndUnit.this.newPrice.getPreferredSize().getHeight());
                ChangeArticleChargePriceAndUnit.this.newPriceUnit.setLocation(ChangeArticleChargePriceAndUnit.this.newPrice.getX() + ChangeArticleChargePriceAndUnit.this.newPrice.getWidth() + 5, (int)((double)(ChangeArticleChargePriceAndUnit.this.newPrice.getY() + ChangeArticleChargePriceAndUnit.this.newPrice.getHeight()) - ChangeArticleChargePriceAndUnit.this.newPriceUnit.getPreferredSize().getHeight()));
                ChangeArticleChargePriceAndUnit.this.newPriceUnit.setSize(ChangeArticleChargePriceAndUnit.this.newPriceUnit.getPreferredSize());
                ChangeArticleChargePriceAndUnit.this.changePurchaseOrderPrice.setLocation(0, ChangeArticleChargePriceAndUnit.this.newPrice.getY() + ChangeArticleChargePriceAndUnit.this.newPrice.getHeight() + 10);
                ChangeArticleChargePriceAndUnit.this.changePurchaseOrderPrice.setSize(ChangeArticleChargePriceAndUnit.this.changePurchaseOrderPrice.getPreferredSize());
            }
        }

        @Override
        public Dimension preferredLayoutSize(Container parent) {
            int h = (int)ChangeArticleChargePriceAndUnit.this.oldPrice.getPreferredSize().getHeight();
            h += 10;
            h = (int)((double)h + ChangeArticleChargePriceAndUnit.this.newPrice.getPreferredSize().getHeight());
            h += 10;
            h = (int)((double)h + ChangeArticleChargePriceAndUnit.this.changePurchaseOrderPrice.getPreferredSize().getHeight());
            return new Dimension(0, h += 10);
        }
    }
}

