/*
 * Decompiled with CFR 0.152.
 */
package ch.icit.pegasus.client.gui.modules.inventorytransition.details;

import ch.icit.pegasus.client.converter.IntegerConverter;
import ch.icit.pegasus.client.converter.controller.ConverterRegistry;
import ch.icit.pegasus.client.gui.table.DefaultDetailsPanel;
import ch.icit.pegasus.client.gui.table.RowEditor;
import ch.icit.pegasus.client.gui.utils.CheckedListAdder;
import ch.icit.pegasus.client.gui.utils.DefaultLayout;
import ch.icit.pegasus.client.gui.utils.LocationUtil;
import ch.icit.pegasus.client.gui.utils.TextLabel;
import ch.icit.pegasus.client.gui.utils.TitledItem;
import ch.icit.pegasus.client.gui.utils.rightdependant.RDDateChooser;
import ch.icit.pegasus.client.gui.utils.rightdependant.RDMultiLocationComboBox;
import ch.icit.pegasus.client.gui.utils.rightdependant.RDProvider;
import ch.icit.pegasus.client.gui.utils.rightdependant.RDTextArea;
import ch.icit.pegasus.client.gui.utils.rightdependant.RDTextField;
import ch.icit.pegasus.client.node.impls.Node;
import ch.icit.pegasus.client.util.ScreenValidationObject;
import ch.icit.pegasus.client.util.exception.ClientServerCallException;
import ch.icit.pegasus.server.core.dtos.ILocalizedDTO;
import ch.icit.pegasus.server.core.dtos.inventory.InventoryTransitionComplete;
import ch.icit.pegasus.server.core.dtos.inventory.InventoryTransitionComplete_;
import ch.icit.pegasus.server.core.dtos.inventory.InventoryTransitionLight;
import ch.icit.pegasus.server.core.i18n.Words;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.util.ArrayList;
import java.util.List;

public class SpecificationDetailsPanel
extends DefaultDetailsPanel<InventoryTransitionLight> {
    private static final long serialVersionUID = 1L;
    private TitledItem<TextLabel> number;
    private TitledItem<RDTextField> name;
    private TitledItem<RDMultiLocationComboBox> locations;
    private TitledItem<RDDateChooser> date;
    private TitledItem<RDTextArea> description;

    public SpecificationDetailsPanel(RowEditor<InventoryTransitionLight> editor, RDProvider provider) {
        super(editor, provider);
        this.setTitleText(Words.SPECIFICATION);
        this.number = new TitledItem<TextLabel>(new TextLabel(null, ConverterRegistry.getConverter(IntegerConverter.class)), Words.NUMBER, TitledItem.TitledItemOrientation.NORTH);
        this.number.getElement().setReadOnlyTextField(true);
        this.name = new TitledItem<RDTextField>(new RDTextField(provider), Words.NAME, TitledItem.TitledItemOrientation.NORTH);
        this.date = new TitledItem<RDDateChooser>(new RDDateChooser(provider), Words.DATE, TitledItem.TitledItemOrientation.NORTH);
        this.description = new TitledItem<RDTextArea>(new RDTextArea(provider), Words.DESCRIPTION, TitledItem.TitledItemOrientation.NORTH);
        this.description.setIgnorePrefHeight(true);
        if (Boolean.TRUE.equals(this.viewSettings.getShowLocation())) {
            this.locations = new TitledItem<RDMultiLocationComboBox>(new RDMultiLocationComboBox(provider), Words.LOCATIONS, TitledItem.TitledItemOrientation.NORTH);
        }
        this.setCustomLayouter(new Layout());
        this.addToView(this.number);
        this.addToView(this.name);
        this.addToView(this.date);
        this.addToView(this.description);
        if (Boolean.TRUE.equals(this.viewSettings.getShowLocation())) {
            this.addToView(this.locations);
        }
    }

    @Override
    public void requestFocusInWindowNow() {
        this.name.requestFocusInWindowNow();
    }

    @Override
    public void validateRemote(List<ScreenValidationObject> callBack) throws ClientServerCallException {
    }

    @Override
    public void setNode(Node<?> node) {
        if (this.editor.getModel().isAddRow()) {
            InventoryTransitionComplete dto = (InventoryTransitionComplete)node.getValue();
            LocationUtil.ensureCurrentLocation((ILocalizedDTO)dto);
        }
        this.number.getElement().setNode(node.getChildNamed(InventoryTransitionComplete_.number));
        this.name.getElement().setNode(node.getChildNamed(InventoryTransitionComplete_.name));
        this.date.getElement().setNode(node.getChildNamed(InventoryTransitionComplete_.date));
        this.description.getElement().setNode(node.getChildNamed(InventoryTransitionComplete_.description));
        if (Boolean.TRUE.equals(this.viewSettings.getShowLocation())) {
            this.locations.getElement().setNode(node.getChildNamed(InventoryTransitionComplete_.eligibleLocations));
        }
    }

    @Override
    public void remoteObjectLoaded(Node<?> node) {
    }

    @Override
    public List<Component> getFocusComponents() {
        ArrayList<Component> focusList = new ArrayList<Component>();
        CheckedListAdder.addToList(focusList, this.name);
        CheckedListAdder.addToList(focusList, this.date);
        CheckedListAdder.addToList(focusList, this.description);
        CheckedListAdder.addToList(focusList, this.locations);
        return focusList;
    }

    @Override
    public List<ScreenValidationObject> validateParagraph() {
        List loc;
        ArrayList<ScreenValidationObject> validationObjects = new ArrayList<ScreenValidationObject>();
        String n = (String)this.editor.getModel().getNode().getChildNamed(InventoryTransitionComplete_.name).getValue();
        if (n == null || n.isEmpty()) {
            validationObjects.add(new ScreenValidationObject(ScreenValidationObject.ValidationStateE.FATAL, Words.ENSURE_NAME_IS_SET));
        }
        if (this.editor.getModel().getNode().getChildNamed(InventoryTransitionComplete_.date).getValue() == null) {
            validationObjects.add(new ScreenValidationObject(ScreenValidationObject.ValidationStateE.FATAL, Words.ENSURE_DATE_IS_SET));
        }
        if (Boolean.TRUE.equals(this.viewSettings.getShowLocation()) && (loc = (List)this.editor.getModel().getNode().getChildNamed(InventoryTransitionComplete_.eligibleLocations).getValue()).isEmpty()) {
            validationObjects.add(new ScreenValidationObject(ScreenValidationObject.ValidationStateE.FATAL, Words.ENSURE_LOCATION_IS_SET));
        }
        return validationObjects;
    }

    @Override
    public void setEnabled(boolean isEnabled) {
        super.setEnabled(isEnabled);
        this.number.setEnabled(isEnabled);
        this.name.setEnabled(isEnabled);
        this.date.setEnabled(isEnabled);
        this.description.setEnabled(isEnabled);
        if (Boolean.TRUE.equals(this.viewSettings.getShowLocation())) {
            this.locations.setEnabled(isEnabled);
        }
    }

    @Override
    public void kill() {
        if (this.isKilled()) {
            return;
        }
        super.kill();
        this.number.kill();
        this.name.kill();
        this.date.kill();
        this.description.kill();
        if (Boolean.TRUE.equals(this.viewSettings.getShowLocation())) {
            this.locations.kill();
        }
        this.number = null;
        this.name = null;
        this.date = null;
        this.description = null;
        this.locations = null;
    }

    private class Layout
    extends DefaultLayout {
        private Layout() {
        }

        @Override
        public void layoutContainer(Container parent) {
            int w = parent.getWidth();
            int w4tl = (w - (2 * SpecificationDetailsPanel.this.horizontalBorder + 3 * (SpecificationDetailsPanel.this.horizontalBorder * 2))) / 4;
            SpecificationDetailsPanel.this.number.setLocation(SpecificationDetailsPanel.this.horizontalBorder, SpecificationDetailsPanel.this.verticalBorder);
            SpecificationDetailsPanel.this.number.setSize(w4tl, (int)SpecificationDetailsPanel.this.number.getPreferredSize().getHeight());
            SpecificationDetailsPanel.this.name.setLocation(SpecificationDetailsPanel.this.number.getX() + SpecificationDetailsPanel.this.number.getWidth() + SpecificationDetailsPanel.this.inner_horizontalBorder, SpecificationDetailsPanel.this.verticalBorder);
            SpecificationDetailsPanel.this.name.setSize(w - (SpecificationDetailsPanel.this.name.getX() + SpecificationDetailsPanel.this.horizontalBorder), (int)SpecificationDetailsPanel.this.name.getPreferredSize().getHeight());
            SpecificationDetailsPanel.this.date.setLocation(SpecificationDetailsPanel.this.horizontalBorder, SpecificationDetailsPanel.this.name.getY() + SpecificationDetailsPanel.this.name.getHeight() + SpecificationDetailsPanel.this.inner_verticalBorder);
            SpecificationDetailsPanel.this.date.setSize(SpecificationDetailsPanel.this.date.getPreferredSize());
            int cy = SpecificationDetailsPanel.this.date.getY() + SpecificationDetailsPanel.this.date.getHeight();
            if (Boolean.TRUE.equals(SpecificationDetailsPanel.this.viewSettings.getShowLocation())) {
                SpecificationDetailsPanel.this.locations.setLocation(SpecificationDetailsPanel.this.horizontalBorder, SpecificationDetailsPanel.this.date.getY() + SpecificationDetailsPanel.this.date.getHeight() + SpecificationDetailsPanel.this.inner_verticalBorder);
                SpecificationDetailsPanel.this.locations.setSize(w - 2 * SpecificationDetailsPanel.this.horizontalBorder, (int)SpecificationDetailsPanel.this.locations.getPreferredSize().getHeight());
                cy = SpecificationDetailsPanel.this.locations.getY() + SpecificationDetailsPanel.this.locations.getHeight();
            }
            SpecificationDetailsPanel.this.description.setLocation(SpecificationDetailsPanel.this.horizontalBorder, cy + SpecificationDetailsPanel.this.inner_verticalBorder);
            SpecificationDetailsPanel.this.description.setSize(w - 2 * SpecificationDetailsPanel.this.horizontalBorder, 150);
        }

        @Override
        public Dimension preferredLayoutSize(Container parent) {
            int h = SpecificationDetailsPanel.this.verticalBorder;
            h = (int)((double)h + SpecificationDetailsPanel.this.name.getPreferredSize().getHeight());
            h += SpecificationDetailsPanel.this.inner_verticalBorder;
            h = (int)((double)h + SpecificationDetailsPanel.this.date.getPreferredSize().getHeight());
            h += SpecificationDetailsPanel.this.inner_verticalBorder;
            if (Boolean.TRUE.equals(SpecificationDetailsPanel.this.viewSettings.getShowLocation())) {
                h = (int)((double)h + SpecificationDetailsPanel.this.locations.getPreferredSize().getHeight());
                h += SpecificationDetailsPanel.this.inner_verticalBorder;
            }
            h += 150;
            return new Dimension(0, h += SpecificationDetailsPanel.this.verticalBorder);
        }
    }
}

