/*
 * Decompiled with CFR 0.152.
 */
package ch.icit.pegasus.client.gui.modules.masterdata.panels;

import ch.icit.pegasus.client.converter.Converter;
import ch.icit.pegasus.client.converter.StringConverter;
import ch.icit.pegasus.client.converter.controller.ConverterRegistry;
import ch.icit.pegasus.client.gui.modules.masterdata.MasterDataModule;
import ch.icit.pegasus.client.gui.modules.masterdata.panels.DetailsPanel;
import ch.icit.pegasus.client.gui.modules.masterdata.panels.MasterDataInsert;
import ch.icit.pegasus.client.gui.utils.AttributesConverter;
import ch.icit.pegasus.client.gui.utils.CheckedListAdder;
import ch.icit.pegasus.client.gui.utils.DefaultLayout;
import ch.icit.pegasus.client.gui.utils.TitledItem;
import ch.icit.pegasus.client.gui.utils.buttons.CheckBox;
import ch.icit.pegasus.client.gui.utils.focus.VisibleContainer;
import ch.icit.pegasus.client.gui.utils.textfield.TextField;
import ch.icit.pegasus.client.laf.LafLoader;
import ch.icit.pegasus.client.node.impls.Node;
import ch.icit.pegasus.client.util.ScreenValidationObject;
import ch.icit.pegasus.server.core.dtos.ADTO;
import ch.icit.pegasus.server.core.dtos.masterdata.CustomsDocumentTypeComplete;
import ch.icit.pegasus.server.core.dtos.masterdata.CustomsDocumentTypeComplete_;
import ch.icit.pegasus.server.core.i18n.Words;
import ch.icit.pegasus.server.dtos.metamodel.DtoField;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;

public class DocumentTypePanel
extends MasterDataInsert<CustomsDocumentTypeComplete> {
    private static final long serialVersionUID = 1L;

    public DocumentTypePanel(MasterDataModule p) {
        super(p);
    }

    @Override
    public DetailsPanel getDetails() {
        return new CustomsDocumentTypeConfigPanel();
    }

    @Override
    public CustomsDocumentTypeComplete getNewObject() {
        CustomsDocumentTypeComplete a = new CustomsDocumentTypeComplete();
        a.setClientOId(Long.valueOf(ADTO.getNextId()));
        return a;
    }

    @Override
    public Class<? extends CustomsDocumentTypeComplete> getMasterDataClass() {
        return CustomsDocumentTypeComplete.class;
    }

    @Override
    public String getInsertName() {
        return "Document Types";
    }

    @Override
    public List<ScreenValidationObject> validateInsert() {
        ArrayList<ScreenValidationObject> a = new ArrayList<ScreenValidationObject>();
        Iterator it = this.masterDataTable.getModel().getNode().getChilds();
        HashSet<String> codes = new HashSet<String>();
        boolean codeSet = true;
        boolean descriptionSet = true;
        while (it.hasNext()) {
            Node n = (Node)it.next();
            if (n.getChildNamed(CustomsDocumentTypeComplete_.description).getValue() == null) {
                descriptionSet = false;
            }
            if (n.getChildNamed(CustomsDocumentTypeComplete_.name).getValue() == null) {
                codeSet = false;
                continue;
            }
            if (codes.contains(n.getChildNamed(CustomsDocumentTypeComplete_.name).getValue())) {
                a.add(new ScreenValidationObject(ScreenValidationObject.ValidationStateE.FATAL, "Name " + n.getChildNamed(CustomsDocumentTypeComplete_.name).getValue() + " is not unique."));
                continue;
            }
            codes.add((String)n.getChildNamed(CustomsDocumentTypeComplete_.name).getValue());
        }
        if (!codeSet) {
            a.add(new ScreenValidationObject(ScreenValidationObject.ValidationStateE.FATAL, "Ensure all Codes are set"));
        }
        if (!descriptionSet) {
            a.add(new ScreenValidationObject(ScreenValidationObject.ValidationStateE.FATAL, "Ensure all Descriptions are set"));
        }
        return a;
    }

    private class CustomsDocumentTypeConfigPanel
    extends DetailsPanel {
        private static final long serialVersionUID = 1L;
        private TitledItem<TextField> code;
        private TitledItem<TextField> description;
        private TitledItem<CheckBox> customsRelevant;
        private TitledItem<CheckBox> showInMobilePurchaseReceive;
        private TitledItem<CheckBox> mobilePurchaseReceiveDefault;

        public CustomsDocumentTypeConfigPanel() {
            this.setBackground(AttributesConverter.getColor4String(LafLoader.getLafLoader().getAttribute("inner_panel_background_color")));
            this.code = new TitledItem<TextField>(new TextField(null), Words.NAME, TitledItem.TitledItemOrientation.NORTH);
            this.description = new TitledItem<TextField>(new TextField(null), Words.DESCRIPTION, TitledItem.TitledItemOrientation.NORTH);
            this.customsRelevant = new TitledItem<CheckBox>(new CheckBox(), Words.CUSTOMS_RELEVANT, TitledItem.TitledItemOrientation.NORTH);
            this.showInMobilePurchaseReceive = new TitledItem<CheckBox>(new CheckBox(), "Use for Mobile Purchase Receive", TitledItem.TitledItemOrientation.NORTH);
            this.mobilePurchaseReceiveDefault = new TitledItem<CheckBox>(new CheckBox(), "Mobile Purchase Receive Default", TitledItem.TitledItemOrientation.NORTH);
            this.setLayout(new AALayout());
            this.add(this.code);
            this.add(this.description);
            this.add(this.customsRelevant);
            this.add(this.showInMobilePurchaseReceive);
            this.add(this.mobilePurchaseReceiveDefault);
        }

        @Override
        public List<Component> getFocusComponents() {
            List<Component> a = this.code.getFocusComponents();
            a.addAll(this.description.getFocusComponents());
            a.addAll(this.showInMobilePurchaseReceive.getFocusComponents());
            CheckedListAdder.addToList(a, this.mobilePurchaseReceiveDefault);
            return a;
        }

        @Override
        public void requestFocusInWindowNow() {
            this.code.requestFocusInWindowNow();
        }

        @Override
        public void setVisibleContainer(VisibleContainer pane) {
            this.code.setVisibleContainer(pane);
            this.description.setVisibleContainer(pane);
            this.customsRelevant.setVisibleContainer(pane);
            this.showInMobilePurchaseReceive.setVisibleContainer(pane);
            this.mobilePurchaseReceiveDefault.setVisibleContainer(pane);
        }

        @Override
        public void kill() {
            if (this.isKilled()) {
                return;
            }
            super.kill();
            this.code.kill();
            this.description.kill();
            this.customsRelevant.kill();
            this.showInMobilePurchaseReceive.kill();
            this.mobilePurchaseReceiveDefault.kill();
            this.code = null;
            this.description = null;
            this.customsRelevant = null;
            this.showInMobilePurchaseReceive = null;
            this.mobilePurchaseReceiveDefault = null;
        }

        @Override
        public void setEnabled(boolean isEnabled) {
            boolean b = isEnabled;
            b = this.isNodeSet() ? isEnabled : false;
            super.setEnabled(b);
            this.code.setEnabled(b);
            this.description.setEnabled(b);
            this.customsRelevant.setEnabled(b);
            this.showInMobilePurchaseReceive.setEnabled(b);
            this.mobilePurchaseReceiveDefault.setEnabled(b);
        }

        public Converter getConverter() {
            return ConverterRegistry.getConverter(StringConverter.class);
        }

        @Override
        public void setNode(Node<?> node) {
            super.setNode(node);
            this.code.getElement().setNode(node.getChildNamed(CustomsDocumentTypeComplete_.name));
            this.description.getElement().setNode(node.getChildNamed(CustomsDocumentTypeComplete_.description));
            this.customsRelevant.getElement().setNode(node.getChildNamed(CustomsDocumentTypeComplete_.customsRelevant));
            this.showInMobilePurchaseReceive.getElement().setNode(node.getChildNamed(CustomsDocumentTypeComplete_.showInMobilePurchaseReceive));
            this.mobilePurchaseReceiveDefault.getElement().setNode(node.getChildNamed(CustomsDocumentTypeComplete_.mobilePurchaseReceiveDefault));
            this.setEnabled(true);
            DocumentTypePanel.this.setEnabled(true);
        }

        @Override
        public DtoField getAttributeName() {
            return CustomsDocumentTypeComplete_.name;
        }

        private class AALayout
        extends DefaultLayout {
            private AALayout() {
            }

            @Override
            public void layoutContainer(Container parent) {
                CustomsDocumentTypeConfigPanel.this.code.setLocation(DocumentTypePanel.this.masterDataTable.getCellPadding(), DocumentTypePanel.this.masterDataTable.getCellPadding());
                CustomsDocumentTypeConfigPanel.this.code.setSize(200, (int)CustomsDocumentTypeConfigPanel.this.code.getPreferredSize().getHeight());
                CustomsDocumentTypeConfigPanel.this.description.setLocation(DocumentTypePanel.this.masterDataTable.getCellPadding(), CustomsDocumentTypeConfigPanel.this.code.getY() + CustomsDocumentTypeConfigPanel.this.code.getHeight() + DocumentTypePanel.this.masterDataTable.getCellPadding());
                CustomsDocumentTypeConfigPanel.this.description.setSize(200, (int)CustomsDocumentTypeConfigPanel.this.description.getPreferredSize().getHeight());
                CustomsDocumentTypeConfigPanel.this.customsRelevant.setLocation(DocumentTypePanel.this.masterDataTable.getCellPadding(), CustomsDocumentTypeConfigPanel.this.description.getY() + CustomsDocumentTypeConfigPanel.this.description.getHeight() + DocumentTypePanel.this.masterDataTable.getCellPadding());
                CustomsDocumentTypeConfigPanel.this.customsRelevant.setSize(200, (int)CustomsDocumentTypeConfigPanel.this.customsRelevant.getPreferredSize().getHeight());
                CustomsDocumentTypeConfigPanel.this.showInMobilePurchaseReceive.setLocation(DocumentTypePanel.this.masterDataTable.getCellPadding(), CustomsDocumentTypeConfigPanel.this.customsRelevant.getY() + CustomsDocumentTypeConfigPanel.this.customsRelevant.getHeight() + DocumentTypePanel.this.masterDataTable.getCellPadding());
                CustomsDocumentTypeConfigPanel.this.showInMobilePurchaseReceive.setSize(200, (int)CustomsDocumentTypeConfigPanel.this.showInMobilePurchaseReceive.getPreferredSize().getHeight());
                CustomsDocumentTypeConfigPanel.this.mobilePurchaseReceiveDefault.setLocation(DocumentTypePanel.this.masterDataTable.getCellPadding(), CustomsDocumentTypeConfigPanel.this.showInMobilePurchaseReceive.getY() + CustomsDocumentTypeConfigPanel.this.showInMobilePurchaseReceive.getHeight() + DocumentTypePanel.this.masterDataTable.getCellPadding());
                CustomsDocumentTypeConfigPanel.this.mobilePurchaseReceiveDefault.setSize(200, (int)CustomsDocumentTypeConfigPanel.this.mobilePurchaseReceiveDefault.getPreferredSize().getHeight());
            }

            @Override
            public Dimension preferredLayoutSize(Container parent) {
                return new Dimension();
            }
        }
    }
}

