/*
 * Decompiled with CFR 0.152.
 */
package ch.icit.pegasus.client.gui.modules.masterdata.panels;

import ch.icit.pegasus.client.gui.modules.masterdata.AbstractDataInsertModule;
import ch.icit.pegasus.client.gui.modules.masterdata.panels.DefaultDataInsert;
import ch.icit.pegasus.client.gui.utils.CheckedListAdder;
import ch.icit.pegasus.client.gui.utils.DefaultLayout;
import ch.icit.pegasus.client.gui.utils.InnerPopUpListener2;
import ch.icit.pegasus.client.gui.utils.TitledItem;
import ch.icit.pegasus.client.gui.utils.buttons.Button;
import ch.icit.pegasus.client.gui.utils.buttons.ButtonListener;
import ch.icit.pegasus.client.gui.utils.focus.VisibleContainer;
import ch.icit.pegasus.client.gui.utils.panels.ScrollableBackground;
import ch.icit.pegasus.client.gui.utils.popup.InnerPopUp2;
import ch.icit.pegasus.client.gui.utils.tables.KitchenReadyTimeColorDefinitionEditTable;
import ch.icit.pegasus.client.gui.utils.textfield.DateTimeTextField;
import ch.icit.pegasus.client.gui.utils.textfield.TextField;
import ch.icit.pegasus.client.gui.utils.textfield.TextFieldType;
import ch.icit.pegasus.client.node.impls.Node;
import ch.icit.pegasus.client.services.ServiceManagerRegistry;
import ch.icit.pegasus.client.services.interfaces.masterdata.MasterDataServiceManager;
import ch.icit.pegasus.client.services.interfaces.system.SystemSettingsServiceManager;
import ch.icit.pegasus.client.util.RemoteLoader;
import ch.icit.pegasus.client.util.ScreenValidationObject;
import ch.icit.pegasus.client.util.async.ThreadSafeExecutable;
import ch.icit.pegasus.client.util.async.ThreadSafeLoader;
import ch.icit.pegasus.server.core.dtos.ADTO;
import ch.icit.pegasus.server.core.dtos.masterdata.FlightCategoryComplete;
import ch.icit.pegasus.server.core.dtos.masterdata.HaulTypeComplete;
import ch.icit.pegasus.server.core.dtos.report.KitchenReadyTimeColorDefinitionComplete;
import ch.icit.pegasus.server.core.dtos.report.KitchenReadyTimeSettingsComplete;
import ch.icit.pegasus.server.core.dtos.report.KitchenReadyTimeSettingsComplete_;
import ch.icit.pegasus.server.core.dtos.system.SystemSettingsComplete;
import ch.icit.pegasus.server.core.dtos.system.SystemSettingsComplete_;
import ch.icit.pegasus.server.core.i18n.Words;
import ch.icit.pegasus.server.dtos.metamodel.DtoField;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.sql.Time;
import java.util.ArrayList;
import java.util.List;

public class SettingsKitchenReadyTimeConfig
extends DefaultDataInsert
implements ButtonListener,
InnerPopUpListener2 {
    private static final long serialVersionUID = 1L;
    private ScrollableBackground scrollPane;
    private Node<SystemSettingsComplete> node;
    private TitledItem<TextField> kitchenReadyTime;
    private TitledItem<TextField> startDayShift;
    private TitledItem<DateTimeTextField> startNightShift;
    private KitchenReadyTimeColorDefinitionEditTable table;

    public SettingsKitchenReadyTimeConfig(AbstractDataInsertModule parent) {
        super(parent);
        this.setLayout(new Layout2());
    }

    @Override
    public void insertElements() {
        this.scrollPane = new ScrollableBackground(false);
        this.kitchenReadyTime = new TitledItem<TextField>(new TextField(null, TextFieldType.INT), Words.KITCHEN_READY_TIME + " [h]", TitledItem.TitledItemOrientation.NORTH);
        this.startDayShift = new TitledItem<DateTimeTextField>(new DateTimeTextField(TextFieldType.DAYTIME), "Start day shift", TitledItem.TitledItemOrientation.NORTH);
        this.startNightShift = new TitledItem<DateTimeTextField>(new DateTimeTextField(TextFieldType.DAYTIME), "Start night shift", TitledItem.TitledItemOrientation.NORTH);
        this.table = new KitchenReadyTimeColorDefinitionEditTable();
        this.scrollPane.getViewPort().setLayout(new Layout());
        this.scrollPane.getViewPort().add(this.kitchenReadyTime);
        this.scrollPane.getViewPort().add(this.startDayShift);
        this.scrollPane.getViewPort().add(this.startNightShift);
        this.scrollPane.getViewPort().add(this.table);
        this.add(this.scrollPane);
        this.isInserted = true;
    }

    @Override
    public String getInsertName() {
        return Words.SETTINGS;
    }

    @Override
    public Node getNode() {
        return this.node;
    }

    @Override
    public void kill() {
        if (this.isKilled()) {
            return;
        }
        super.kill();
        if (this.isInserted) {
            this.kitchenReadyTime.kill();
            this.startDayShift.kill();
            this.startNightShift.kill();
            this.table.kill();
        }
        this.kitchenReadyTime = null;
        this.startDayShift = null;
        this.startNightShift = null;
        this.table = null;
    }

    @Override
    public void setEnabled(boolean isEnabled) {
        super.setEnabled(isEnabled);
        this.kitchenReadyTime.setEnabled(isEnabled);
        this.startDayShift.setEnabled(isEnabled);
        this.startNightShift.setEnabled(isEnabled);
        this.kitchenReadyTime.setEnabled(isEnabled);
    }

    @Override
    public List<ScreenValidationObject> validateInsert() {
        ArrayList<ScreenValidationObject> validationObjects = new ArrayList<ScreenValidationObject>();
        return validationObjects;
    }

    @Override
    public List<Component> getFocusComponents() {
        if (this.isInserted) {
            ArrayList<Component> focusList = new ArrayList<Component>();
            CheckedListAdder.addToList(focusList, this.kitchenReadyTime);
            CheckedListAdder.addToList(focusList, this.startDayShift);
            CheckedListAdder.addToList(focusList, this.startNightShift);
            CheckedListAdder.addToList(focusList, this.kitchenReadyTime);
            return focusList;
        }
        return null;
    }

    @Override
    public void setVisibleContainer(VisibleContainer pane) {
    }

    @Override
    public void requestFocusInWindowNow() {
        if (this.isInserted) {
            this.kitchenReadyTime.requestFocusInWindowNow();
        }
    }

    @Override
    public void saveIt() {
        super.saveIt();
        ThreadSafeExecutable run = new ThreadSafeExecutable(this){

            @Override
            public Node<?> loadData() throws Exception {
                SettingsKitchenReadyTimeConfig.this.node.commitThis(SystemSettingsComplete.class);
                SystemSettingsComplete s = (SystemSettingsComplete)SettingsKitchenReadyTimeConfig.this.node.getValue(SystemSettingsComplete.class);
                s = (SystemSettingsComplete)((SystemSettingsServiceManager)ServiceManagerRegistry.getService(SystemSettingsServiceManager.class)).updateSystemSettings(s).getValue();
                SettingsKitchenReadyTimeConfig.this.node.removeExistingValues();
                SettingsKitchenReadyTimeConfig.this.node.setValue((Object)s, 0L);
                SettingsKitchenReadyTimeConfig.this.node.updateNode();
                return null;
            }

            @Override
            public RemoteLoader getInvoker() {
                return SettingsKitchenReadyTimeConfig.this;
            }

            @Override
            public long getID() {
                return 0L;
            }
        };
        ThreadSafeLoader.run(run);
    }

    @Override
    public void loadData() {
        super.loadData();
        ThreadSafeExecutable run = new ThreadSafeExecutable(this){

            @Override
            public Node<?> loadData() throws Exception {
                SettingsKitchenReadyTimeConfig.this.changeLoadingState("Load 1/1 Modules");
                ((MasterDataServiceManager)ServiceManagerRegistry.getService(MasterDataServiceManager.class)).getAllCached(FlightCategoryComplete.class);
                ((MasterDataServiceManager)ServiceManagerRegistry.getService(MasterDataServiceManager.class)).getAllCached(HaulTypeComplete.class);
                return ((SystemSettingsServiceManager)ServiceManagerRegistry.getService(SystemSettingsServiceManager.class)).getSettingsUnCached();
            }

            @Override
            public RemoteLoader getInvoker() {
                return SettingsKitchenReadyTimeConfig.this;
            }

            @Override
            public long getID() {
                return 0L;
            }
        };
        ThreadSafeLoader.run(run);
    }

    @Override
    public void remoteObjectLoaded(Node<?> node) {
        super.remoteObjectLoaded(node);
        if (this.currentState == DefaultDataInsert.LoadingState.LOAD) {
            this.setNode(node);
        }
    }

    private void setNode(Node<SystemSettingsComplete> node) {
        this.node = node;
        if (!this.isInserted) {
            return;
        }
        SystemSettingsComplete systemSettings = (SystemSettingsComplete)node.getValue();
        if (systemSettings.getKitchenReadyTimeSettings() == null) {
            KitchenReadyTimeSettingsComplete settings = new KitchenReadyTimeSettingsComplete();
            settings.setClientOId(Long.valueOf(ADTO.getNextId()));
            systemSettings.setKitchenReadyTimeSettings(settings);
            node.updateNode();
        }
        if (node.getChildNamed(new DtoField[]{SystemSettingsComplete_.kitchenReadyTimeSettings, KitchenReadyTimeSettingsComplete_.startDayShift}).getValue() == null) {
            node.getChildNamed(new DtoField[]{SystemSettingsComplete_.kitchenReadyTimeSettings, KitchenReadyTimeSettingsComplete_.startDayShift}).setValue((Object)new Time(System.currentTimeMillis()), 0L);
        }
        if (node.getChildNamed(new DtoField[]{SystemSettingsComplete_.kitchenReadyTimeSettings, KitchenReadyTimeSettingsComplete_.startNightShift}).getValue() == null) {
            node.getChildNamed(new DtoField[]{SystemSettingsComplete_.kitchenReadyTimeSettings, KitchenReadyTimeSettingsComplete_.startNightShift}).setValue((Object)new Time(System.currentTimeMillis()), 0L);
        }
        this.kitchenReadyTime.getElement().setNode(node.getChildNamed(new DtoField[]{SystemSettingsComplete_.kitchenReadyTimeSettings, KitchenReadyTimeSettingsComplete_.kitchenReadyTime}));
        this.startDayShift.getElement().setNode(node.getChildNamed(new DtoField[]{SystemSettingsComplete_.kitchenReadyTimeSettings, KitchenReadyTimeSettingsComplete_.startDayShift}));
        this.startNightShift.getElement().setNode(node.getChildNamed(new DtoField[]{SystemSettingsComplete_.kitchenReadyTimeSettings, KitchenReadyTimeSettingsComplete_.startNightShift}));
        Node childNamed = node.getChildNamed(new DtoField[]{SystemSettingsComplete_.kitchenReadyTimeSettings, KitchenReadyTimeSettingsComplete_.colorDefinitions});
        this.table.setNode((Node<List<KitchenReadyTimeColorDefinitionComplete>>)childNamed);
        this.setEnabled(true);
    }

    @Override
    public void buttonPressed(Button source, int x, int y) {
    }

    @Override
    public void popUpClosed(InnerPopUp2 source, Object ... xargs) {
    }

    private class Layout2
    extends DefaultLayout {
        private Layout2() {
        }

        @Override
        public Dimension preferredLayoutSize(Container parent) {
            return new Dimension(0, 0);
        }

        @Override
        public void layoutContainer(Container parent) {
            SettingsKitchenReadyTimeConfig.this.layoutAnimation(parent);
            if (SettingsKitchenReadyTimeConfig.this.isInserted) {
                SettingsKitchenReadyTimeConfig.this.scrollPane.setLocation(1, 1);
                SettingsKitchenReadyTimeConfig.this.scrollPane.setSize(parent.getWidth() - 2, parent.getHeight() - 2);
            }
        }
    }

    private class Layout
    extends DefaultLayout {
        private Layout() {
        }

        @Override
        public Dimension preferredLayoutSize(Container parent) {
            int border;
            int h = border = 10;
            if (SettingsKitchenReadyTimeConfig.this.isInserted) {
                h = (int)((double)h + (SettingsKitchenReadyTimeConfig.this.kitchenReadyTime.getPreferredSize().getHeight() + (double)border));
                h = (int)((double)h + (SettingsKitchenReadyTimeConfig.this.startDayShift.getPreferredSize().getHeight() + (double)border));
                h = (int)((double)h + (SettingsKitchenReadyTimeConfig.this.startNightShift.getPreferredSize().getHeight() + (double)border));
                h = (int)((double)h + (SettingsKitchenReadyTimeConfig.this.table.getPreferredSize().getHeight() + (double)border));
            }
            return new Dimension(0, h);
        }

        @Override
        public void layoutContainer(Container parent) {
            int w = parent.getWidth() - 40;
            int h = parent.getHeight() - 40;
            int border = 10;
            if (SettingsKitchenReadyTimeConfig.this.isInserted) {
                h -= border;
                SettingsKitchenReadyTimeConfig.this.kitchenReadyTime.setLocation(border, border * 2);
                SettingsKitchenReadyTimeConfig.this.kitchenReadyTime.setSize(SettingsKitchenReadyTimeConfig.this.kitchenReadyTime.getPreferredSize());
                h -= SettingsKitchenReadyTimeConfig.this.kitchenReadyTime.getHeight();
                h -= border * 2;
                SettingsKitchenReadyTimeConfig.this.startDayShift.setLocation(SettingsKitchenReadyTimeConfig.this.kitchenReadyTime.getX(), SettingsKitchenReadyTimeConfig.this.kitchenReadyTime.getY() + SettingsKitchenReadyTimeConfig.this.kitchenReadyTime.getHeight() + border);
                SettingsKitchenReadyTimeConfig.this.startDayShift.setSize(SettingsKitchenReadyTimeConfig.this.startDayShift.getPreferredSize());
                h -= SettingsKitchenReadyTimeConfig.this.startDayShift.getHeight();
                h -= border;
                SettingsKitchenReadyTimeConfig.this.startNightShift.setLocation(SettingsKitchenReadyTimeConfig.this.startDayShift.getX(), SettingsKitchenReadyTimeConfig.this.startDayShift.getY() + SettingsKitchenReadyTimeConfig.this.startDayShift.getHeight() + border);
                SettingsKitchenReadyTimeConfig.this.startNightShift.setSize(SettingsKitchenReadyTimeConfig.this.startNightShift.getPreferredSize());
                h -= SettingsKitchenReadyTimeConfig.this.startNightShift.getHeight();
                SettingsKitchenReadyTimeConfig.this.table.setLocation(SettingsKitchenReadyTimeConfig.this.startNightShift.getX(), SettingsKitchenReadyTimeConfig.this.startNightShift.getY() + SettingsKitchenReadyTimeConfig.this.startNightShift.getHeight() + 2 * border);
                SettingsKitchenReadyTimeConfig.this.table.setSize(w, h -= border);
            }
        }
    }
}

