/*
 * Decompiled with CFR 0.152.
 */
package ch.icit.pegasus.client.gui.modules.movement.product.positionbased.details;

import ch.icit.pegasus.client.converter.ProductChargeConverter;
import ch.icit.pegasus.client.converter.ProductViewConverter;
import ch.icit.pegasus.client.converter.QuantityConverter2Decimal;
import ch.icit.pegasus.client.converter.StorePositionConverter;
import ch.icit.pegasus.client.converter.StorePositionShortNameConverter;
import ch.icit.pegasus.client.converter.StoreViewConverter;
import ch.icit.pegasus.client.converter.controller.ConverterRegistry;
import ch.icit.pegasus.client.gui.screentemplates.details.TableDetailsPanel;
import ch.icit.pegasus.client.gui.table.RowEditor;
import ch.icit.pegasus.client.gui.table.TableColumnInfo;
import ch.icit.pegasus.client.gui.table2.Table2;
import ch.icit.pegasus.client.gui.table2.Table2RowModel;
import ch.icit.pegasus.client.gui.table2.Table2RowPanel;
import ch.icit.pegasus.client.gui.table2.defaults.DefaultTable2RowPanel;
import ch.icit.pegasus.client.gui.table2.defaults.DefaultTable2RowPanelLayout;
import ch.icit.pegasus.client.gui.utils.TextLabel;
import ch.icit.pegasus.client.gui.utils.buttons.Button;
import ch.icit.pegasus.client.gui.utils.buttons.DeleteButton;
import ch.icit.pegasus.client.gui.utils.combobox.ComboBox;
import ch.icit.pegasus.client.gui.utils.combobox.InputComboBox;
import ch.icit.pegasus.client.gui.utils.combobox.InputComboBox2;
import ch.icit.pegasus.client.gui.utils.popup.InnerPopupFactory;
import ch.icit.pegasus.client.gui.utils.rightdependant.RDProvider;
import ch.icit.pegasus.client.gui.utils.searchbox.SearchTextField2;
import ch.icit.pegasus.client.gui.utils.searchbox.SearchTextField2Factory;
import ch.icit.pegasus.client.gui.utils.searchbox.StorePositionSearchBox;
import ch.icit.pegasus.client.gui.utils.skins.SizedSkin1Field;
import ch.icit.pegasus.client.node.INodeCreator;
import ch.icit.pegasus.client.node.impls.DTOProxyNode;
import ch.icit.pegasus.client.node.impls.Node;
import ch.icit.pegasus.client.node.impls.NodeToolkit;
import ch.icit.pegasus.client.services.ServiceManagerRegistry;
import ch.icit.pegasus.client.services.interfaces.weeklyplan.WeeklyPlanServiceManager;
import ch.icit.pegasus.client.util.RemoteLoader;
import ch.icit.pegasus.client.util.async.ThreadSafeExecutable;
import ch.icit.pegasus.client.util.async.ThreadSafeLoader;
import ch.icit.pegasus.client.util.exception.ClientException;
import ch.icit.pegasus.client.util.toolkits.nodebased.UnitConversionToolkitNodeBased;
import ch.icit.pegasus.server.core.dtos.ADTO;
import ch.icit.pegasus.server.core.dtos.masterdata.QuantityComplete;
import ch.icit.pegasus.server.core.dtos.masterdata.StoreQuantityComplete;
import ch.icit.pegasus.server.core.dtos.masterdata.StoreQuantityComplete_;
import ch.icit.pegasus.server.core.dtos.masterdata.UnitComplete;
import ch.icit.pegasus.server.core.dtos.product.ProductComplete;
import ch.icit.pegasus.server.core.dtos.product.ProductReference;
import ch.icit.pegasus.server.core.dtos.production_new.charges.ProductChargeBatchComplete;
import ch.icit.pegasus.server.core.dtos.production_new.store.product.ProductStockMovementGroupComplete_;
import ch.icit.pegasus.server.core.dtos.production_new.store.product.ProductStockMovementGroupLight;
import ch.icit.pegasus.server.core.dtos.production_new.transactions.ProductConsumeTransactionComplete_;
import ch.icit.pegasus.server.core.dtos.production_new.transactions.ProductMoveTransactionComplete;
import ch.icit.pegasus.server.core.dtos.production_new.transactions.ProductMoveTransactionComplete_;
import ch.icit.pegasus.server.core.dtos.production_new.transactions.ProductProduceTransactionComplete_;
import ch.icit.pegasus.server.core.dtos.store.StorePositionLight;
import ch.icit.pegasus.server.core.dtos.store.StoreReference;
import ch.icit.pegasus.server.core.dtos.system.SystemSettingsComplete;
import ch.icit.pegasus.server.core.dtos.util.XMLWrapper.ListWrapper;
import ch.icit.pegasus.server.core.dtos.utils.UnitConversionToolkit;
import ch.icit.pegasus.server.core.i18n.Words;
import ch.icit.pegasus.server.dtos.metamodel.DtoField;
import java.awt.Component;
import java.util.ArrayList;
import java.util.List;

public class ComponentDetailsPanel
extends TableDetailsPanel<ProductStockMovementGroupLight> {
    private static final long serialVersionUID = 1L;

    public ComponentDetailsPanel(RowEditor<ProductStockMovementGroupLight> editor, RDProvider provider) {
        super(editor, provider, editor.getModel().isAddRow());
        this.setTitleText(Words.PRODUCTS);
    }

    @Override
    public List<TableColumnInfo> getColumns(boolean add) {
        ArrayList<TableColumnInfo> columns = new ArrayList<TableColumnInfo>();
        if (add) {
            columns.add(new TableColumnInfo(Words.PRODUCT, null, null, null, "", 40));
            columns.add(new TableColumnInfo(Words.STORE, null, null, null, "", 30));
            columns.add(new TableColumnInfo(Words.POSITION, null, null, null, "", 30));
            columns.add(new TableColumnInfo(Words.STOCK, null, null, null, "", 2 * this.getTable().getCellPadding() + InputComboBox2.getPreferredWidth(this, 7)));
            columns.add(new TableColumnInfo(Words.AMOUNT, null, null, null, "", 2 * this.getTable().getCellPadding() + InputComboBox2.getPreferredWidth(this, 7)));
            columns.add(new TableColumnInfo(Words.STORE, null, null, null, "", 30));
            columns.add(new TableColumnInfo("", null, null, null, "", 2 * this.getTable().getCellPadding() + DeleteButton.getPreferredWidth(SizedSkin1Field.SkinSize.SMALL)));
            ((TableColumnInfo)columns.get(0)).setxExpand(0.4);
            ((TableColumnInfo)columns.get(1)).setxExpand(0.15);
            ((TableColumnInfo)columns.get(2)).setxExpand(0.15);
            ((TableColumnInfo)columns.get(3)).setxExpand(0.0);
            ((TableColumnInfo)columns.get(4)).setxExpand(0.0);
            ((TableColumnInfo)columns.get(5)).setxExpand(0.3);
            ((TableColumnInfo)columns.get(6)).setxExpand(0.0);
        } else {
            columns.add(new TableColumnInfo(Words.PRODUCT, null, null, null, "", 40));
            columns.add(new TableColumnInfo(Words.ORIGIN, null, null, null, "", 30));
            columns.add(new TableColumnInfo(Words.DESTINATION, null, null, null, "", 30));
            columns.add(new TableColumnInfo(Words.CHARGE, null, null, null, "", 2 * this.getTable().getCellPadding() + InputComboBox2.getPreferredWidth(this, 7)));
            columns.add(new TableColumnInfo(Words.AMOUNT, null, null, null, "", 2 * this.getTable().getCellPadding() + InputComboBox2.getPreferredWidth(this, 7)));
            ((TableColumnInfo)columns.get(0)).setxExpand(0.6);
            ((TableColumnInfo)columns.get(1)).setxExpand(0.2);
            ((TableColumnInfo)columns.get(2)).setxExpand(0.2);
            ((TableColumnInfo)columns.get(3)).setxExpand(0.0);
            ((TableColumnInfo)columns.get(4)).setxExpand(0.0);
        }
        return columns;
    }

    @Override
    public void configTable(Table2 table) {
        table.setRequestFocusOnAdd(true);
    }

    @Override
    public void addButtonPressed(int x, int y, Button source) {
        ProductMoveTransactionComplete c = new ProductMoveTransactionComplete();
        c.setClientOId(Long.valueOf(ADTO.getNextId()));
        c.setQuantity(new StoreQuantityComplete(Long.valueOf(0L), ((SystemSettingsComplete)NodeToolkit.getAffixClass(SystemSettingsComplete.class).getValue()).getPieceUnit()));
        this.table.getModel().getNode().addChild(INodeCreator.getDefaultImpl().getNode4DTO((Object)c, true, false), 0L);
    }

    @Override
    public void childRemoved() {
        this.editor.revalidate();
    }

    @Override
    public Table2RowPanel generateView(final Table2RowModel model, boolean isHeader) {
        DefaultTable2RowPanel row = new DefaultTable2RowPanel(model);
        if (this.editor.getModel().isAddRow()) {
            Node csn = model.getNode().getChildNamed(new String[]{"currentStock"});
            if (csn == null) {
                UnitComplete pieceUnit = ((SystemSettingsComplete)NodeToolkit.getAffixClass(SystemSettingsComplete.class).getValue()).getPieceUnit();
                csn = INodeCreator.getDefaultImpl().getNode4DTO((Object)new QuantityComplete(Double.valueOf(0.0), pieceUnit), false, false);
                csn.setName("currentStock");
                model.getNode().addChild(csn, 0L);
            }
            final Node currentStockNode = csn;
            final ComboBox storeCombo = new ComboBox((Node)new DTOProxyNode(), null, ConverterRegistry.getConverter(StoreViewConverter.class));
            final ComboBox positionCombo = new ComboBox(model.getNode().getChildNamed(ProductConsumeTransactionComplete_.originStore), null, ConverterRegistry.getConverter(StorePositionConverter.class));
            final TextLabel currentStock = new TextLabel(currentStockNode, ConverterRegistry.getConverter(QuantityConverter2Decimal.class));
            InputComboBox2 qtyComponent = new InputComboBox2(model.getNode().getChildNamed(new DtoField[]{ProductMoveTransactionComplete_.quantity, StoreQuantityComplete_.amount}), model.getNode().getChildNamed(new DtoField[]{ProductMoveTransactionComplete_.quantity, StoreQuantityComplete_.unit}), InputComboBox.InputComboBoxType.PRICE_LONG);
            SearchTextField2<ProductComplete> productSearchField = SearchTextField2Factory.getProductSearchField(true, model.getNode().getChildNamed(ProductMoveTransactionComplete_.product));
            productSearchField.addSearchTextFieldListener((source, n) -> {
                ThreadSafeExecutable run = new ThreadSafeExecutable(){

                    @Override
                    public Node<?> loadData() throws Exception {
                        ListWrapper stock = ((WeeklyPlanServiceManager)ServiceManagerRegistry.getService(WeeklyPlanServiceManager.class)).getStockForProduct(new ProductReference(((ProductComplete)n.getValue(ProductComplete.class)).getId()));
                        return INodeCreator.getDefaultImpl().createNodes(stock.getList(), false, false);
                    }

                    @Override
                    public RemoteLoader getInvoker() {
                        return new RemoteLoader(){

                            public void remoteObjectLoaded(Node<?> node) {
                                storeCombo.refreshPossibleValues(node);
                            }

                            public void errorOccurred(ClientException exception) {
                                InnerPopupFactory.showErrorDialog((Exception)exception, (Component)ComponentDetailsPanel.this);
                            }
                        };
                    }

                    @Override
                    public long getID() {
                        return 0L;
                    }
                };
                ThreadSafeLoader.run(run);
                ProductComplete product = (ProductComplete)n.getValue();
                if (product != null) {
                    UnitComplete unit = product.getCurrentVariant().getLabelUnit();
                    if (unit == null) {
                        unit = ((SystemSettingsComplete)NodeToolkit.getAffixClass(SystemSettingsComplete.class).getValue()).getPieceUnit();
                    }
                    model.getNode().getChildNamed(new DtoField[]{ProductProduceTransactionComplete_.quantity, StoreQuantityComplete_.unit}).setValue((Object)unit, 0L);
                    qtyComponent.setSelectedUnit(unit);
                    List units = UnitConversionToolkit.getAllUnits((UnitComplete)unit);
                    qtyComponent.setPossibleUnits((Node)UnitConversionToolkitNodeBased.getUnitList(units));
                    qtyComponent.getUnitNode().setValue((Object)unit, 0L);
                }
            });
            row.addLayoutComponent(productSearchField, DefaultTable2RowPanelLayout.LayoutType.FILL);
            storeCombo.addItemListener(e -> {
                if (e.getStateChange() == 1) {
                    ThreadSafeExecutable run = new ThreadSafeExecutable(){

                        @Override
                        public Node<?> loadData() throws Exception {
                            ProductReference product = (ProductReference)model.getNode().getChildNamed(ProductMoveTransactionComplete_.product).getValue();
                            StoreReference store = (StoreReference)storeCombo.getNode().getValue();
                            ListWrapper stock = ((WeeklyPlanServiceManager)ServiceManagerRegistry.getService(WeeklyPlanServiceManager.class)).getStockForProductAndStore(new ProductReference(product.getId()), new StoreReference(store.getId()));
                            return INodeCreator.getDefaultImpl().createNodes(stock.getList(), false, false);
                        }

                        @Override
                        public RemoteLoader getInvoker() {
                            return new RemoteLoader(){

                                public void remoteObjectLoaded(Node<?> node) {
                                    positionCombo.refreshPossibleValues(node);
                                }

                                public void errorOccurred(ClientException exception) {
                                    InnerPopupFactory.showErrorDialog((Exception)exception, (Component)ComponentDetailsPanel.this);
                                }
                            };
                        }

                        @Override
                        public long getID() {
                            return 0L;
                        }
                    };
                    ThreadSafeLoader.run(run);
                }
            });
            row.addLayoutComponent(storeCombo, DefaultTable2RowPanelLayout.LayoutType.FILL);
            positionCombo.addItemListener(e -> {
                if (e.getStateChange() == 1) {
                    ThreadSafeExecutable run = new ThreadSafeExecutable(){

                        @Override
                        public Node<?> loadData() throws Exception {
                            ProductReference product = (ProductReference)model.getNode().getChildNamed(ProductMoveTransactionComplete_.product).getValue();
                            StorePositionLight storePosition = (StorePositionLight)positionCombo.getNode().getValue();
                            ListWrapper stock = ((WeeklyPlanServiceManager)ServiceManagerRegistry.getService(WeeklyPlanServiceManager.class)).getProductBatchesForPosition(new ProductReference(product.getId()), storePosition);
                            QuantityComplete sum = new QuantityComplete(Double.valueOf(0.0), ((SystemSettingsComplete)NodeToolkit.getAffixClass(SystemSettingsComplete.class).getValue()).getPieceUnit());
                            for (ProductChargeBatchComplete productChargeComplete : stock.getList()) {
                                sum.setQuantity(Double.valueOf(sum.getQuantity() + (double)productChargeComplete.getQuantity().getAmount().longValue()));
                            }
                            currentStockNode.setValue((Object)sum, 0L);
                            return INodeCreator.getDefaultImpl().createNodes(stock.getList(), false, false);
                        }

                        @Override
                        public RemoteLoader getInvoker() {
                            return new RemoteLoader(){

                                public void remoteObjectLoaded(Node<?> node) {
                                    currentStock.updateString();
                                }

                                public void errorOccurred(ClientException exception) {
                                    InnerPopupFactory.showErrorDialog((Exception)exception, (Component)ComponentDetailsPanel.this);
                                }
                            };
                        }

                        @Override
                        public long getID() {
                            return 0L;
                        }
                    };
                    ThreadSafeLoader.run(run);
                }
            });
            row.addLayoutComponent(positionCombo, DefaultTable2RowPanelLayout.LayoutType.FILL);
            row.addLayoutComponent(currentStock, DefaultTable2RowPanelLayout.LayoutType.FILL);
            row.addLayoutComponent(qtyComponent, DefaultTable2RowPanelLayout.LayoutType.FIX);
            row.addLayoutComponent(new StorePositionSearchBox((Node<StorePositionLight>)model.getNode().getChildNamed(ProductMoveTransactionComplete_.targetStore)), DefaultTable2RowPanelLayout.LayoutType.FILL);
            row.addLayoutComponent(new DeleteButton((source, x, y) -> model.getNode().getParent().removeChild(model.getNode(), 0L)), DefaultTable2RowPanelLayout.LayoutType.FIX);
            row.setUseControlSkin(Table2RowPanel.TableControlsType.ONE);
        } else {
            row.addLayoutComponent(new TextLabel(model.getNode().getChildNamed(ProductMoveTransactionComplete_.product), ConverterRegistry.getConverter(ProductViewConverter.class)), DefaultTable2RowPanelLayout.LayoutType.FILL);
            row.addLayoutComponent(new TextLabel(model.getNode().getChildNamed(ProductMoveTransactionComplete_.originStore), ConverterRegistry.getConverter(StorePositionShortNameConverter.class)), DefaultTable2RowPanelLayout.LayoutType.FILL);
            row.addLayoutComponent(new TextLabel(model.getNode().getChildNamed(ProductMoveTransactionComplete_.targetStore), ConverterRegistry.getConverter(StorePositionShortNameConverter.class)), DefaultTable2RowPanelLayout.LayoutType.FILL);
            row.addLayoutComponent(new TextLabel(model.getNode().getChildNamed(ProductMoveTransactionComplete_.productCharge), ConverterRegistry.getConverter(ProductChargeConverter.class)), DefaultTable2RowPanelLayout.LayoutType.FILL);
            row.addLayoutComponent(new TextLabel(model.getNode().getChildNamed(ProductMoveTransactionComplete_.quantity), ConverterRegistry.getConverter(QuantityConverter2Decimal.class)), DefaultTable2RowPanelLayout.LayoutType.FILL);
            row.setUseControlSkin(Table2RowPanel.TableControlsType.NONE);
        }
        return row;
    }

    @Override
    public void setNode(Node node) {
        super.setNode(node);
        this.table.getModel().setNode(node.getChildNamed(ProductStockMovementGroupComplete_.stockMovements));
    }
}

