/*
 * Decompiled with CFR 0.152.
 */
package ch.icit.pegasus.client.gui.modules.productcatalog.details;

import ch.icit.pegasus.client.gui.modules.productcatalog.details.SettingsDetailsPanel;
import ch.icit.pegasus.client.gui.modules.productcatalog.details.SettingsDetailsPanel2;
import ch.icit.pegasus.client.gui.modules.productcatalog.details.utils.CatBreadCrumbMainPanel;
import ch.icit.pegasus.client.gui.screentemplates.details.StateDependantDetailsPanel;
import ch.icit.pegasus.client.gui.table.RowEditor;
import ch.icit.pegasus.client.gui.utils.CheckedListAdder;
import ch.icit.pegasus.client.gui.utils.DefaultLayout;
import ch.icit.pegasus.client.gui.utils.TextLabel;
import ch.icit.pegasus.client.gui.utils.buttons.Button;
import ch.icit.pegasus.client.gui.utils.buttons.ButtonListener;
import ch.icit.pegasus.client.gui.utils.buttons.TextButton;
import ch.icit.pegasus.client.gui.utils.focus.MutableFocusContainerListener;
import ch.icit.pegasus.client.gui.utils.popup.InnerPopupFactory;
import ch.icit.pegasus.client.gui.utils.rightdependant.RDProvider;
import ch.icit.pegasus.client.node.INodeCreator;
import ch.icit.pegasus.client.node.impls.ListNode;
import ch.icit.pegasus.client.node.impls.Node;
import ch.icit.pegasus.client.services.ServiceManagerRegistry;
import ch.icit.pegasus.client.services.interfaces.mealplan.MealPlanServiceManager;
import ch.icit.pegasus.client.services.interfaces.search.SearchServiceManager;
import ch.icit.pegasus.client.util.RemoteLoader;
import ch.icit.pegasus.client.util.ScreenValidationObject;
import ch.icit.pegasus.client.util.async.ThreadSafeExecutable;
import ch.icit.pegasus.client.util.async.ThreadSafeLoader;
import ch.icit.pegasus.client.util.toolkits.ProductCatalogToolkit;
import ch.icit.pegasus.client.util.variantaccessor.CateringServiceVariantAccessorImpl;
import ch.icit.pegasus.server.core.dtos.masterdata.ModificationStateE;
import ch.icit.pegasus.server.core.dtos.mealplan.CateringServicePartChoiceComplete;
import ch.icit.pegasus.server.core.dtos.mealplan.CateringServicePartComplete;
import ch.icit.pegasus.server.core.dtos.mealplan.CateringServiceRotationComplete;
import ch.icit.pegasus.server.core.dtos.mealplan.CateringServiceScheduleComplete;
import ch.icit.pegasus.server.core.dtos.mealplan.CateringServiceScheduleVariantComplete;
import ch.icit.pegasus.server.core.dtos.mealplan.MealPlanReference;
import ch.icit.pegasus.server.core.dtos.product.CatalogEntryComplete_;
import ch.icit.pegasus.server.core.dtos.product.ProductCatalogComplete_;
import ch.icit.pegasus.server.core.dtos.product.ProductCatalogLight;
import ch.icit.pegasus.server.core.dtos.product.ProductCatalogLight_;
import ch.icit.pegasus.server.core.dtos.product.ProductCatalogProductGroupComplete;
import ch.icit.pegasus.server.core.dtos.product.ProductCatalogProductGroupComplete_;
import ch.icit.pegasus.server.core.dtos.product.ProductCatalogTypeE;
import ch.icit.pegasus.server.core.dtos.product.ProductComplete;
import ch.icit.pegasus.server.core.dtos.product.ProductVariantLight;
import ch.icit.pegasus.server.core.dtos.search.ADtoSearchConfiguration;
import ch.icit.pegasus.server.core.dtos.search.ProductSearchConfiguration;
import ch.icit.pegasus.server.core.dtos.util.SearchResult;
import ch.icit.pegasus.server.core.i18n.Phrase;
import ch.icit.pegasus.server.core.i18n.Words;
import ch.icit.pegasus.server.core.util.MealCycleToolkit;
import ch.icit.pegasus.server.dtos.metamodel.DtoField;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;

public class ProductsDetailsPanel
extends StateDependantDetailsPanel<ProductCatalogLight>
implements ButtonListener {
    private static final long serialVersionUID = 1L;
    private CatBreadCrumbMainPanel panel;
    private TextButton updateCatalog;
    private TextLabel infoLabel;
    private final SettingsDetailsPanel settingsDetailsPanel;
    private final SettingsDetailsPanel2 settingsDetailsPanel2;
    private final boolean isAddable;

    public ProductsDetailsPanel(RowEditor<ProductCatalogLight> editor, RDProvider provider, SettingsDetailsPanel settingsDetailsPanel, SettingsDetailsPanel2 settingsDetailsPanel2) {
        super(editor, provider);
        this.settingsDetailsPanel = settingsDetailsPanel;
        this.settingsDetailsPanel2 = settingsDetailsPanel2;
        this.isAddable = provider.isAddable(ProductCatalogComplete_.groups);
        this.setTitleText(Words.PRODUCTS);
        this.panel = new CatBreadCrumbMainPanel(null, provider);
        this.updateCatalog = new TextButton(Words.CREATE_CATALOG);
        this.updateCatalog.addButtonListener(this);
        this.infoLabel = new TextLabel();
        this.setCustomLayouter(new Layout());
        if (editor.getModel().isAddRow()) {
            this.setNode(editor.getModel().getNode());
            this.isNodeInit = false;
        }
        this.addToView(this.updateCatalog);
        this.addToView(this.panel);
        this.addToView(this.infoLabel);
    }

    @Override
    public DtoField<ModificationStateE> getStateChildName() {
        return ProductCatalogComplete_.state;
    }

    @Override
    public List<ScreenValidationObject> validateParagraph() {
        ArrayList<ScreenValidationObject> validationObjects = new ArrayList<ScreenValidationObject>();
        if (this.panel.isAddable(ProductCatalogComplete_.groups.getFieldName())) {
            Iterator it = this.editor.getModel().getNode().getChildNamed(ProductCatalogComplete_.groups).getChilds();
            while (it.hasNext()) {
                Node n = (Node)it.next();
                Iterator it2 = n.getChildNamed(ProductCatalogProductGroupComplete_.entries).getChilds();
                while (it2.hasNext()) {
                    Node nn = (Node)it2.next();
                    if (nn.getChildNamed(CatalogEntryComplete_.product).getValue() != null) continue;
                    validationObjects.add(new ScreenValidationObject(ScreenValidationObject.ValidationStateE.FATAL, Phrase.getPhrase((String)Phrase.FOUND_AN_EMPTY_PRODUCT_IN_GROUP, (Object[])new Object[]{n.getChildNamed(CatalogEntryComplete_.sequenceNumber).getValue()})));
                }
            }
        }
        return validationObjects;
    }

    @Override
    public void setNode(Node<?> node) {
        super.setNode(node);
        this.panel.setNode(this.editor.getModel().getNode());
    }

    @Override
    public List<Component> getFocusComponents() {
        ArrayList<Component> focusList = new ArrayList<Component>();
        CheckedListAdder.addToList(focusList, this.updateCatalog);
        CheckedListAdder.addToList(focusList, this.panel);
        return focusList;
    }

    @Override
    public void kill() {
        if (this.isKilled()) {
            return;
        }
        super.kill();
        this.panel.kill();
        this.panel = null;
        this.updateCatalog.kill();
        this.updateCatalog = null;
        this.infoLabel.kill();
        this.infoLabel = null;
    }

    @Override
    public void setEnabled(boolean isEnabled) {
        super.setEnabled(isEnabled);
        boolean isDraft = this.isStateDraft();
        boolean enabled = isDraft && isEnabled;
        this.panel.setEnabled(enabled);
        this.updateCatalog.setEnabled(enabled & this.isAddable);
        this.infoLabel.setEnabled(enabled);
    }

    @Override
    public void buttonPressed(Button source, int x, int y) {
        if (source == this.updateCatalog) {
            if (!this.settingsDetailsPanel.validateUpdateInfo()) {
                return;
            }
            ProductSearchConfiguration conf = this.settingsDetailsPanel2.getSearchConf();
            conf.setCustomer(this.settingsDetailsPanel.getCustomer());
            conf.setNumResults(Integer.MAX_VALUE);
            conf.setMealPlan((MealPlanReference)this.editor.getModel().getNode().getChildNamed(ProductCatalogComplete_.mealPlan).getValue());
            this.doSearch(conf);
        }
    }

    private void doSearch(final ProductSearchConfiguration conf) {
        this.editor.setEnabled(false);
        this.editor.showCommittingAnimation(Words.CREATE_CATALOG);
        final ProductCatalogTypeE catalogType = (ProductCatalogTypeE)this.editor.getModel().getNode().getChildNamed(ProductCatalogLight_.catalogType).getValue();
        ThreadSafeExecutable run = new ThreadSafeExecutable(this){

            @Override
            public Node<?> loadData() throws Exception {
                ArrayList<ProductComplete> ps = null;
                boolean cycleSelected = false;
                String c = "";
                List counts = MealCycleToolkit.getIntegerForString((String)c);
                if (conf.getMealPlan() != null) {
                    cycleSelected = true;
                    CateringServiceVariantAccessorImpl accessor = new CateringServiceVariantAccessorImpl();
                    HashSet products = new HashSet();
                    List cateringSchedules = ((MealPlanServiceManager)ServiceManagerRegistry.getService(MealPlanServiceManager.class)).getServiceSchedules(new MealPlanReference(conf.getMealPlan().getId())).getList();
                    for (CateringServiceScheduleComplete cs : cateringSchedules) {
                        CateringServiceScheduleVariantComplete v = (CateringServiceScheduleVariantComplete)accessor.loadData(cs, new Timestamp(conf.getPeriod().getStartDate().getTime()));
                        for (CateringServiceRotationComplete r : v.getRotations()) {
                            if (!counts.isEmpty() && !counts.contains(r.getNumber())) continue;
                            for (CateringServicePartComplete parts : r.getParts()) {
                                for (CateringServicePartChoiceComplete choice : parts.getChoices()) {
                                    if (choice.getProduct().getIsDeleted().booleanValue()) continue;
                                    products.add(choice.getProduct());
                                }
                            }
                        }
                    }
                    ps = new ArrayList();
                    ps.addAll(products);
                } else {
                    SearchResult s = ((SearchServiceManager)ServiceManagerRegistry.getService(SearchServiceManager.class)).search((ADtoSearchConfiguration)conf);
                    ps = new ArrayList<ProductComplete>();
                    for (ProductComplete p : s.getResults()) {
                        if (p.getIsDeleted().booleanValue()) continue;
                        ps.add(p);
                    }
                }
                ListNode n = new ListNode();
                if (counts == null) {
                    return null;
                }
                ArrayList<ProductVariantLight> variants = new ArrayList<ProductVariantLight>();
                Iterator it = ps.iterator();
                while (it.hasNext()) {
                    ProductComplete g = (ProductComplete)it.next();
                    String t = g.getCurrentVariant().getProductCycle();
                    List counts2 = MealCycleToolkit.getIntegerForString((String)t);
                    boolean takeProduct = true;
                    switch (catalogType) {
                        case ALACARTE: {
                            if (Boolean.TRUE.equals(g.getCurrentVariant().getAlaCarteProduct())) break;
                            takeProduct = false;
                            break;
                        }
                        case SPML: {
                            if (Boolean.TRUE.equals(g.getCurrentVariant().getSpmlProduct())) break;
                            takeProduct = false;
                            break;
                        }
                        case STANDARD: {
                            if (Boolean.TRUE.equals(g.getCurrentVariant().getStandardProduct())) break;
                            takeProduct = false;
                            break;
                        }
                    }
                    if (!cycleSelected && !MealCycleToolkit.isInserted((List)counts, (List)counts2)) {
                        takeProduct = false;
                    }
                    if (!takeProduct) {
                        it.remove();
                        continue;
                    }
                    variants.add(g.getCurrentVariant());
                }
                ArrayList<ScreenValidationObject> warnings = new ArrayList<ScreenValidationObject>();
                List<ProductCatalogProductGroupComplete> groups = ProductCatalogToolkit.createProductCatalogGroups(variants, (ProductCatalogTypeE)ProductsDetailsPanel.this.editor.getModel().getNode().getChildNamed(ProductCatalogLight_.catalogType).getValue(), warnings);
                if (!warnings.isEmpty()) {
                    InnerPopupFactory.showWarningDialog(warnings, Words.CATALOG_GENERATED, (Component)ProductsDetailsPanel.this);
                }
                n.setValue(groups, 0L);
                return n;
            }

            @Override
            public RemoteLoader getInvoker() {
                return ProductsDetailsPanel.this;
            }

            @Override
            public long getID() {
                return 0L;
            }
        };
        ThreadSafeLoader.run(run);
    }

    private int getProductCount(List<ProductCatalogProductGroupComplete> list) {
        int count = 0;
        for (ProductCatalogProductGroupComplete e : list) {
            count += e.getEntries().size();
        }
        return count;
    }

    @Override
    public void remoteObjectLoaded(Node<?> node) {
        Node groups = this.editor.getModel().getNode().getChildNamed(ProductCatalogComplete_.groups);
        groups.removeExistingValues();
        long currentID = System.currentTimeMillis();
        List list = (List)node.getValue();
        String t = list.size() + Phrase.getPhrase((String)Phrase.GROUPS_CREATE_WITH_COUNT_OF_PRODUCTS, (Object[])new Object[]{this.getProductCount(list)});
        this.infoLabel.setText(t);
        for (ProductCatalogProductGroupComplete e : list) {
            Node entry = INodeCreator.getDefaultImpl().getNode4DTO((Object)e, true, false);
            groups.addChild(entry, currentID);
        }
        groups.setValue((Object)list, currentID);
        groups.updateNode();
        this.editor.setEnabled(true);
        this.editor.hideCommittingAnimation();
    }

    @Override
    public void requestFocusInWindowNow() {
    }

    @Override
    public void addFocusCycleChangeListener(MutableFocusContainerListener listener) {
        super.addFocusCycleChangeListener(listener);
        this.panel.addFocusCycleChangeListener(listener);
    }

    private class Layout
    extends DefaultLayout {
        private Layout() {
        }

        @Override
        public void layoutContainer(Container parent) {
            ProductsDetailsPanel.this.updateCatalog.setLocation(ProductsDetailsPanel.this.horizontalBorder, ProductsDetailsPanel.this.verticalBorder);
            ProductsDetailsPanel.this.updateCatalog.setSize(ProductsDetailsPanel.this.updateCatalog.getPreferredSize());
            ProductsDetailsPanel.this.infoLabel.setLocation(ProductsDetailsPanel.this.updateCatalog.getX() + ProductsDetailsPanel.this.updateCatalog.getWidth() + ProductsDetailsPanel.this.horizontalBorder, (int)((double)ProductsDetailsPanel.this.updateCatalog.getY() + ((double)ProductsDetailsPanel.this.updateCatalog.getHeight() - ProductsDetailsPanel.this.infoLabel.getPreferredSize().getHeight()) / 2.0));
            ProductsDetailsPanel.this.infoLabel.setSize(parent.getWidth() - (ProductsDetailsPanel.this.infoLabel.getX() + ProductsDetailsPanel.this.horizontalBorder), (int)ProductsDetailsPanel.this.infoLabel.getPreferredSize().getHeight());
            ProductsDetailsPanel.this.panel.setLocation(0, ProductsDetailsPanel.this.updateCatalog.getY() + ProductsDetailsPanel.this.updateCatalog.getHeight() + ProductsDetailsPanel.this.inner_verticalBorder);
            ProductsDetailsPanel.this.panel.setSize(parent.getWidth(), parent.getHeight() - ProductsDetailsPanel.this.panel.getY());
        }

        @Override
        public Dimension preferredLayoutSize(Container parent) {
            return new Dimension(0, 400);
        }
    }
}

