/*
 * Decompiled with CFR 0.152.
 */
package ch.icit.pegasus.client.gui.modules.productcatalog.details.utils;

import ch.icit.pegasus.client.comparators.controller.ComparatorRegistry;
import ch.icit.pegasus.client.converter.AMenuTypeListConverter;
import ch.icit.pegasus.client.converter.BoundDirectionConverter;
import ch.icit.pegasus.client.converter.CabinClassListConverter;
import ch.icit.pegasus.client.converter.Converter;
import ch.icit.pegasus.client.converter.HaulTypeListConverter;
import ch.icit.pegasus.client.converter.IntegerConverter;
import ch.icit.pegasus.client.converter.MealTypeConverter;
import ch.icit.pegasus.client.converter.ServiceTypeListConverter;
import ch.icit.pegasus.client.converter.controller.ConverterRegistry;
import ch.icit.pegasus.client.gui.breadcrumb.BreadCrumbComponentTable;
import ch.icit.pegasus.client.gui.breadcrumb.BreadCrumbPanel;
import ch.icit.pegasus.client.gui.modules.productcatalog.details.utils.GroupComparator;
import ch.icit.pegasus.client.gui.screentemplates.overview.data.IDataHandler;
import ch.icit.pegasus.client.gui.submodules.tool.product.spec.utils.GroupLoader;
import ch.icit.pegasus.client.gui.table.TableColumnInfo;
import ch.icit.pegasus.client.gui.table2.SortableTable2RowPanel;
import ch.icit.pegasus.client.gui.table2.Table2RowModel;
import ch.icit.pegasus.client.gui.table2.Table2RowPanel;
import ch.icit.pegasus.client.gui.utils.CheckedListAdder;
import ch.icit.pegasus.client.gui.utils.DefaultLayout;
import ch.icit.pegasus.client.gui.utils.TextLabel;
import ch.icit.pegasus.client.gui.utils.buttons.ArticleProductInfoButton;
import ch.icit.pegasus.client.gui.utils.buttons.CheckBox;
import ch.icit.pegasus.client.gui.utils.buttons.ProductInfoButton;
import ch.icit.pegasus.client.gui.utils.rightdependant.RDProvider;
import ch.icit.pegasus.client.gui.utils.rightdependant.RDSearchTextField2;
import ch.icit.pegasus.client.gui.utils.searchbox.SearchTextField2;
import ch.icit.pegasus.client.gui.utils.searchbox.SearchTextField2Listener;
import ch.icit.pegasus.client.node.INodeCreator;
import ch.icit.pegasus.client.node.impls.Node;
import ch.icit.pegasus.client.util.exception.ClientServerCallException;
import ch.icit.pegasus.client.util.toolkits.ProductToolkit;
import ch.icit.pegasus.server.core.dtos.ADTO;
import ch.icit.pegasus.server.core.dtos.masterdata.AMenuTypeComplete;
import ch.icit.pegasus.server.core.dtos.masterdata.ModificationStateE;
import ch.icit.pegasus.server.core.dtos.masterdata.SpecialMenuTypeComplete;
import ch.icit.pegasus.server.core.dtos.product.CatalogEntryComplete;
import ch.icit.pegasus.server.core.dtos.product.CatalogEntryComplete_;
import ch.icit.pegasus.server.core.dtos.product.ProductCatalogLight_;
import ch.icit.pegasus.server.core.dtos.product.ProductComplete;
import ch.icit.pegasus.server.core.dtos.product.ProductComplete_;
import ch.icit.pegasus.server.core.dtos.product.ProductVariantLight_;
import ch.icit.pegasus.server.core.i18n.Words;
import ch.icit.pegasus.server.core.i18n.WordsToolkit;
import ch.icit.pegasus.server.dtos.metamodel.DtoField;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.util.ArrayList;
import java.util.List;

public class CatBreadCrumbProductTable
extends BreadCrumbComponentTable {
    private static final long serialVersionUID = 1L;
    private boolean isDeletable;
    private boolean isOrderable;

    public CatBreadCrumbProductTable(IDataHandler dataHandler, BreadCrumbPanel master, GroupLoader loader, String buttonText, RDProvider provider) {
        super(dataHandler, master, loader, buttonText, provider, null);
        this.isDeletable = provider.isWritable("entries");
        this.isOrderable = provider.isWritable("entries");
        if (this.table.getAddButton() != null) {
            this.table.getAddButton().setText(Words.ADD);
        } else {
            this.table.setButtonText(Words.ADD);
        }
        this.setUseWriteAcessRight(true);
        this.table.setUseWriteAccessRight(true);
        this.table.setComparator(ComparatorRegistry.getComparator(GroupComparator.class));
        this.disableTitle();
    }

    @Override
    public void addButtonPressed(int x, int y) {
        CatalogEntryComplete nEntry = new CatalogEntryComplete();
        nEntry.setClientOId(Long.valueOf(ADTO.getNextId()));
        nEntry.setSequenceNumber(Integer.valueOf(this.table.getRowCount() + 1));
        Node n = INodeCreator.getDefaultImpl().getNode4DTO((Object)nEntry, true, false);
        this.table.getModel().getNode().addChild(n, System.currentTimeMillis());
        this.table.updateOrder();
        this.table.revalidate();
    }

    @Override
    public void childRemoved() {
        this.table.writeNumber("sequenceNumber", 1);
        this.table.updateOrder();
        this.table.validate();
    }

    public ArrayList<TableColumnInfo> getColumns(Node node) {
        TableColumnInfo c1 = new TableColumnInfo(0.0, 0.0, Words.NO_NUMBER, "", null, null, null, 40, 40, 40);
        TableColumnInfo c2 = new TableColumnInfo(1.0, 0.0, Words.NAME, "", null, null, null, 25, 25, 25);
        int cw = 75;
        TableColumnInfo c3 = new TableColumnInfo(0.0, 0.0, Words.CABIN_CLASS_SHORT, "", null, null, null, cw, cw, cw);
        TableColumnInfo c4 = new TableColumnInfo(0.0, 0.0, Words.SERVICE_TYPE, "", null, null, null, cw, cw, cw);
        TableColumnInfo c5 = new TableColumnInfo(0.0, 0.0, Words.MENU_TYPE, "", null, null, null, cw, cw, cw);
        TableColumnInfo c6 = new TableColumnInfo(0.0, 0.0, Words.MEAL_TYPE, "", null, null, null, cw, cw, cw);
        TableColumnInfo c61 = new TableColumnInfo(0.0, 0.0, Words.HAUL_TYPE, "", null, null, null, cw, cw, cw);
        TableColumnInfo c62 = new TableColumnInfo(0.0, 0.0, Words.DIRECTION, "", null, null, null, cw, cw, cw);
        int iw = CheckBox.getPreferredWidth() + 2 * this.table.getCellPadding();
        TableColumnInfo c7 = new TableColumnInfo(0.0, 0.0, Words.ADD, "", null, null, null, iw, iw, iw);
        TableColumnInfo c8 = new TableColumnInfo(0.0, 0.0, WordsToolkit.toUpperCase((String)Words.CYCLE), "", null, null, null, cw, cw, cw);
        int tw = TableColumnInfo.getSortableColumnWidth(this.table);
        TableColumnInfo c9 = new TableColumnInfo(0.0, 0.0, "", "", null, null, null, tw, tw, tw);
        ArrayList<TableColumnInfo> a = new ArrayList<TableColumnInfo>();
        a.add(c1);
        a.add(c2);
        a.add(c3);
        a.add(c4);
        a.add(c5);
        a.add(c6);
        a.add(c61);
        a.add(c62);
        a.add(c7);
        a.add(c8);
        a.add(c9);
        return a;
    }

    @Override
    public Table2RowPanel getComponentTableRow(Table2RowModel model, boolean isHeader) {
        TableRowImpl p = new TableRowImpl(model);
        p.setUseControlSkin(Table2RowPanel.TableControlsType.THREE);
        return p;
    }

    @Override
    public Converter getTotalConverter() {
        return null;
    }

    @Override
    public void setTotalCostAlgorithm() {
    }

    @Override
    public int getSortingIndex() {
        return 0;
    }

    public Converter getTitleConverter() {
        return null;
    }

    private class TableRowImpl
    extends SortableTable2RowPanel
    implements SearchTextField2Listener {
        private static final long serialVersionUID = 1L;
        private TextLabel no;
        private RDSearchTextField2<ProductComplete> product;
        private ArticleProductInfoButton infoButton;
        private TextLabel cabinClass;
        private TextLabel serviceType;
        private TextLabel menuType;
        private TextLabel mealType;
        private TextLabel haulType;
        private TextLabel direction;
        private TextLabel cycle;
        private CheckBox isAdditional;

        public TableRowImpl(Table2RowModel m) {
            super(m, CatBreadCrumbProductTable.this.isOrderable, CatBreadCrumbProductTable.this.isDeletable);
            this.setSortAttributeName("sequenceNumber");
            this.setStartEndOffset(1, 0);
            this.no = new TextLabel(m.getNode().getChildNamed(new String[]{"sequenceNumber"}), ConverterRegistry.getConverter(IntegerConverter.class));
            this.cabinClass = new TextLabel(m.getNode().getChildNamed(new DtoField[]{CatalogEntryComplete_.product, ProductComplete_.currentVariant, ProductVariantLight_.cabinClasses}), ConverterRegistry.getConverter(CabinClassListConverter.class));
            this.serviceType = new TextLabel(m.getNode().getChildNamed(new DtoField[]{CatalogEntryComplete_.product, ProductComplete_.currentVariant, ProductVariantLight_.serviceTypes}), ConverterRegistry.getConverter(ServiceTypeListConverter.class));
            this.menuType = new TextLabel(m.getNode().getChildNamed(new DtoField[]{CatalogEntryComplete_.product, ProductComplete_.currentVariant, ProductVariantLight_.menuTypes}), ConverterRegistry.getConverter(AMenuTypeListConverter.class));
            this.mealType = new TextLabel(m.getNode().getChildNamed(new DtoField[]{CatalogEntryComplete_.product, ProductComplete_.currentVariant, ProductVariantLight_.mealType}), ConverterRegistry.getConverter(MealTypeConverter.class));
            this.haulType = new TextLabel(m.getNode().getChildNamed(new DtoField[]{CatalogEntryComplete_.product, ProductComplete_.currentVariant, ProductVariantLight_.haulTypes}), ConverterRegistry.getConverter(HaulTypeListConverter.class));
            this.direction = new TextLabel(m.getNode().getChildNamed(new DtoField[]{CatalogEntryComplete_.product, ProductComplete_.currentVariant, ProductVariantLight_.boundDirection}), ConverterRegistry.getConverter(BoundDirectionConverter.class));
            this.cycle = new TextLabel(m.getNode().getChildNamed(new DtoField[]{CatalogEntryComplete_.product, ProductComplete_.currentVariant, ProductVariantLight_.productCycle}));
            this.isAdditional = new CheckBox(this.isAdditional((Node<List<AMenuTypeComplete>>)m.getNode().getChildNamed(new DtoField[]{CatalogEntryComplete_.product, ProductComplete_.currentVariant, ProductVariantLight_.menuTypes})));
            this.product = new RDSearchTextField2(CatBreadCrumbProductTable.this.provider, RDSearchTextField2.SearchTypes.PRODUCT);
            this.product.setOverrideName("entries");
            this.product.setNode(m.getNode().getChildNamed(new String[]{"product"}));
            if (this.product.getEditor() != null) {
                Object[] additionalSearchFields = new Object[4];
                additionalSearchFields[2] = CatBreadCrumbProductTable.this.master.getNode().getChildNamed(ProductCatalogLight_.customer);
                additionalSearchFields[3] = CatBreadCrumbProductTable.this.master.getNode().getChildNamed(ProductCatalogLight_.catalogType);
                ((SearchTextField2)this.product.getEditor()).setAdditionalSearchField(additionalSearchFields);
                ((SearchTextField2)this.product.getEditor()).addSearchTextFieldListener(this);
            }
            this.infoButton = new ProductInfoButton(m.getNode().getChildNamed(new String[]{"product"}), null, ProductToolkit.getAllTypes());
            this.setLayout(new InnerLayout());
            this.add(this.no);
            this.add(this.product);
            this.add(this.infoButton);
            this.add(this.cabinClass);
            this.add(this.serviceType);
            this.add(this.menuType);
            this.add(this.mealType);
            this.add(this.haulType);
            this.add(this.direction);
            this.add(this.cycle);
            this.add(this.isAdditional);
        }

        private boolean isAdditional(Node<List<AMenuTypeComplete>> childs) {
            if (childs != null) {
                for (AMenuTypeComplete aMenuTypeComplete : (List)childs.getValue()) {
                    if (!(aMenuTypeComplete instanceof SpecialMenuTypeComplete) || !Boolean.TRUE.equals(((SpecialMenuTypeComplete)aMenuTypeComplete).getAdditional())) continue;
                    return true;
                }
            }
            return false;
        }

        @Override
        public Object getObject4Column(int column) {
            switch (column) {
                case 0: {
                    return this.model.getNode().getChildNamed(CatalogEntryComplete_.sequenceNumber).getValue();
                }
                case 1: {
                    return this.model.getNode().getChildNamed(new DtoField[]{CatalogEntryComplete_.product, ProductComplete_.number}).getValue();
                }
                case 2: {
                    return this.cabinClass.getText();
                }
                case 3: {
                    return this.serviceType.getText();
                }
                case 4: {
                    return this.menuType.getText();
                }
                case 5: {
                    return this.mealType.getText();
                }
                case 6: {
                    return this.haulType.getText();
                }
                case 7: {
                    return this.direction.getText();
                }
                case 8: {
                    return this.isAdditional.isChecked();
                }
                case 9: {
                    return this.cycle.getText();
                }
            }
            return super.getObject4Column(column);
        }

        public void setNode(Node<CatalogEntryComplete> node) {
            this.no.setNode(this.model.getNode().getChildNamed(new String[]{"sequenceNumber"}));
            this.cabinClass.setNode(this.model.getNode().getChildNamed(new DtoField[]{CatalogEntryComplete_.product, ProductComplete_.currentVariant, ProductVariantLight_.cabinClasses}));
            this.serviceType.setNode(this.model.getNode().getChildNamed(new DtoField[]{CatalogEntryComplete_.product, ProductComplete_.currentVariant, ProductVariantLight_.serviceTypes}));
            this.menuType.setNode(this.model.getNode().getChildNamed(new DtoField[]{CatalogEntryComplete_.product, ProductComplete_.currentVariant, ProductVariantLight_.menuTypes}));
            this.mealType.setNode(this.model.getNode().getChildNamed(new DtoField[]{CatalogEntryComplete_.product, ProductComplete_.currentVariant, ProductVariantLight_.mealType}));
            this.haulType.setNode(this.model.getNode().getChildNamed(new DtoField[]{CatalogEntryComplete_.product, ProductComplete_.currentVariant, ProductVariantLight_.haulTypes}));
            this.direction.setNode(this.model.getNode().getChildNamed(new DtoField[]{CatalogEntryComplete_.product, ProductComplete_.currentVariant, ProductVariantLight_.boundDirection}));
            this.cycle.setNode(this.model.getNode().getChildNamed(new DtoField[]{CatalogEntryComplete_.product, ProductComplete_.currentVariant, ProductVariantLight_.productCycle}));
            this.isAdditional.setChecked(this.isAdditional((Node<List<AMenuTypeComplete>>)this.model.getNode().getChildNamed(new DtoField[]{CatalogEntryComplete_.product, ProductComplete_.currentVariant, ProductVariantLight_.menuTypes})));
        }

        @Override
        public void setEnabled(boolean isEnabled) {
            boolean isDraft = CatBreadCrumbProductTable.this.master.getNode().getChildNamed(ProductCatalogLight_.state).getValue() == ModificationStateE.DRAFT;
            boolean b = isEnabled && isDraft;
            super.setEnabled(b);
            this.no.setEnabled(b);
            this.product.setEnabled(b);
            this.infoButton.setEnabled(isEnabled);
            this.cabinClass.setEnabled(b);
            this.serviceType.setEnabled(b);
            this.menuType.setEnabled(b);
            this.mealType.setEnabled(b);
            this.haulType.setEnabled(b);
            this.direction.setEnabled(b);
            this.cycle.setEnabled(b);
            this.isAdditional.setEnabled(false);
        }

        @Override
        public List<Component> getFocusComponents() {
            ArrayList<Component> a = new ArrayList<Component>();
            CheckedListAdder.addToList(a, this.product);
            a.addAll(super.getFocusComponents());
            return a;
        }

        @Override
        public void requestFocusInWindowNow() {
            if (this.product != null) {
                this.product.requestFocusInWindowNow();
            }
        }

        @Override
        public void kill() {
            if (this.isKilled()) {
                return;
            }
            super.kill();
            this.no.kill();
            this.product.kill();
            this.infoButton.kill();
            this.cabinClass.kill();
            this.serviceType.kill();
            this.menuType.kill();
            this.mealType.kill();
            this.haulType.kill();
            this.direction.kill();
            this.cycle.kill();
            this.isAdditional.kill();
            this.infoButton = null;
            this.no = null;
            this.product = null;
            this.cabinClass = null;
            this.serviceType = null;
            this.menuType = null;
            this.mealType = null;
            this.haulType = null;
            this.direction = null;
            this.cycle = null;
            this.isAdditional = null;
        }

        @Override
        public void newValueSelected(SearchTextField2 source, Node<?> n) throws ClientServerCallException {
            this.setNode((Node<CatalogEntryComplete>)this.model.getNode());
        }

        private class InnerLayout
        extends DefaultLayout {
            private InnerLayout() {
            }

            @Override
            public void layoutContainer(Container parent) {
                int currentX = 0;
                int w = TableRowImpl.this.model.getParentModel().getColumnWidth(0);
                TableRowImpl.this.no.setLocation(TableRowImpl.this.getCellPadding(), (int)(((double)parent.getHeight() - TableRowImpl.this.no.getPreferredSize().getHeight()) / 2.0));
                TableRowImpl.this.no.setSize(TableRowImpl.this.no.getPreferredSize());
                currentX += w;
                w = TableRowImpl.this.model.getParentModel().getColumnWidth(1);
                TableRowImpl.this.product.setLocation(currentX + TableRowImpl.this.getCellPadding(), (int)(((double)parent.getHeight() - TableRowImpl.this.product.getPreferredSize().getHeight()) / 2.0));
                TableRowImpl.this.product.setSize((int)((double)w - ((double)(2 * TableRowImpl.this.getCellPadding() + 5) + TableRowImpl.this.infoButton.getPreferredSize().getWidth())), (int)TableRowImpl.this.product.getPreferredSize().getHeight());
                TableRowImpl.this.infoButton.setLocation(TableRowImpl.this.product.getX() + TableRowImpl.this.product.getWidth() + 5, (int)(((double)parent.getHeight() - TableRowImpl.this.infoButton.getPreferredSize().getHeight()) / 2.0));
                TableRowImpl.this.infoButton.setSize(TableRowImpl.this.infoButton.getPreferredSize());
                currentX += w;
                w = TableRowImpl.this.model.getParentModel().getColumnWidth(2);
                TableRowImpl.this.cabinClass.setLocation(currentX + TableRowImpl.this.getCellPadding(), (int)(((double)parent.getHeight() - TableRowImpl.this.cabinClass.getPreferredSize().getHeight()) / 2.0));
                TableRowImpl.this.cabinClass.setSize(w - 2 * TableRowImpl.this.getCellPadding(), (int)TableRowImpl.this.cabinClass.getPreferredSize().getHeight());
                currentX += w;
                w = TableRowImpl.this.model.getParentModel().getColumnWidth(3);
                TableRowImpl.this.serviceType.setLocation(currentX + TableRowImpl.this.getCellPadding(), (int)(((double)parent.getHeight() - TableRowImpl.this.serviceType.getPreferredSize().getHeight()) / 2.0));
                TableRowImpl.this.serviceType.setSize(w - 2 * TableRowImpl.this.getCellPadding(), (int)TableRowImpl.this.serviceType.getPreferredSize().getHeight());
                currentX += w;
                w = TableRowImpl.this.model.getParentModel().getColumnWidth(4);
                TableRowImpl.this.menuType.setLocation(currentX + TableRowImpl.this.getCellPadding(), (int)(((double)parent.getHeight() - TableRowImpl.this.menuType.getPreferredSize().getHeight()) / 2.0));
                TableRowImpl.this.menuType.setSize(w - 2 * TableRowImpl.this.getCellPadding(), (int)TableRowImpl.this.menuType.getPreferredSize().getHeight());
                currentX += w;
                w = TableRowImpl.this.model.getParentModel().getColumnWidth(5);
                TableRowImpl.this.mealType.setLocation(currentX + TableRowImpl.this.getCellPadding(), (int)(((double)parent.getHeight() - TableRowImpl.this.mealType.getPreferredSize().getHeight()) / 2.0));
                TableRowImpl.this.mealType.setSize(w - 2 * TableRowImpl.this.getCellPadding(), (int)TableRowImpl.this.mealType.getPreferredSize().getHeight());
                currentX += w;
                w = TableRowImpl.this.model.getParentModel().getColumnWidth(6);
                TableRowImpl.this.haulType.setLocation(currentX + TableRowImpl.this.getCellPadding(), (int)(((double)parent.getHeight() - TableRowImpl.this.haulType.getPreferredSize().getHeight()) / 2.0));
                TableRowImpl.this.haulType.setSize(w - 2 * TableRowImpl.this.getCellPadding(), (int)TableRowImpl.this.haulType.getPreferredSize().getHeight());
                currentX += w;
                w = TableRowImpl.this.model.getParentModel().getColumnWidth(7);
                TableRowImpl.this.direction.setLocation(currentX + TableRowImpl.this.getCellPadding(), (int)(((double)parent.getHeight() - TableRowImpl.this.direction.getPreferredSize().getHeight()) / 2.0));
                TableRowImpl.this.direction.setSize(w - 2 * TableRowImpl.this.getCellPadding(), (int)TableRowImpl.this.direction.getPreferredSize().getHeight());
                currentX += w;
                w = TableRowImpl.this.model.getParentModel().getColumnWidth(8);
                TableRowImpl.this.isAdditional.setLocation(currentX + TableRowImpl.this.getCellPadding(), (int)(((double)parent.getHeight() - TableRowImpl.this.isAdditional.getPreferredSize().getHeight()) / 2.0));
                TableRowImpl.this.isAdditional.setSize(w - 2 * TableRowImpl.this.getCellPadding(), (int)TableRowImpl.this.isAdditional.getPreferredSize().getHeight());
                currentX += w;
                w = TableRowImpl.this.model.getParentModel().getColumnWidth(9);
                TableRowImpl.this.cycle.setSize(w - 2 * TableRowImpl.this.getCellPadding(), (int)TableRowImpl.this.cycle.getPreferredSize().getHeight());
                TableRowImpl.this.cycle.setLocation(currentX + TableRowImpl.this.getCellPadding(), (int)(((double)parent.getHeight() - TableRowImpl.this.cycle.getPreferredSize().getHeight()) / 2.0));
                TableRowImpl.this.setControlsX(currentX += w);
                TableRowImpl.this.layoutSortButtons(currentX, parent.getHeight());
            }

            @Override
            public Dimension preferredLayoutSize(Container parent) {
                return new Dimension(0, TableRowImpl.this.getDefaultRowHeight());
            }
        }
    }
}

