/*
 * Decompiled with CFR 0.152.
 */
package ch.icit.pegasus.client.gui.modules.purchaseorder.manualcreator.details.utils;

import ch.icit.pegasus.client.converter.Converter;
import ch.icit.pegasus.client.gui.breadcrumb.BreadCrumbNavigator;
import ch.icit.pegasus.client.gui.breadcrumb.BreadCrumbPanel;
import ch.icit.pegasus.client.gui.breadcrumb.BreadCrumbTable;
import ch.icit.pegasus.client.gui.modules.purchaseorder.manualcreator.details.ArticleDetailsPanel;
import ch.icit.pegasus.client.gui.modules.purchaseorder.manualcreator.details.utils.CreateOrderInformationPopup;
import ch.icit.pegasus.client.gui.modules.purchaseorder.manualcreator.details.utils.OrderBreadCrumbComponentTable;
import ch.icit.pegasus.client.gui.modules.purchaseorder.manualcreator.details.utils.OrderBreadCrumbGroupTable;
import ch.icit.pegasus.client.gui.screentemplates.overview.data.IDataHandler;
import ch.icit.pegasus.client.gui.screentemplates.splitscreen.SplitScreenView;
import ch.icit.pegasus.client.gui.submodules.tool.product.spec.utils.GroupLoader;
import ch.icit.pegasus.client.gui.table.commiter.FileCommitter;
import ch.icit.pegasus.client.gui.utils.InnerPopUpListener2;
import ch.icit.pegasus.client.gui.utils.buttons.Button;
import ch.icit.pegasus.client.gui.utils.buttons.InfoButton;
import ch.icit.pegasus.client.gui.utils.buttons.TablePanelAddSaveButton;
import ch.icit.pegasus.client.gui.utils.buttons.TextButton;
import ch.icit.pegasus.client.gui.utils.file.FileChooserUtil;
import ch.icit.pegasus.client.gui.utils.panels.LoadingAnimation;
import ch.icit.pegasus.client.gui.utils.popup.InnerPopUp2;
import ch.icit.pegasus.client.gui.utils.popup.InnerPopupFactory;
import ch.icit.pegasus.client.gui.utils.print.PrintPopupToolkit;
import ch.icit.pegasus.client.io.FileTransferListener;
import ch.icit.pegasus.client.io.FileTransferState;
import ch.icit.pegasus.client.io.FileTransferUtil;
import ch.icit.pegasus.client.node.impls.Node;
import ch.icit.pegasus.client.node.impls.NodeToolkit;
import ch.icit.pegasus.client.search.SearchResultIterator;
import ch.icit.pegasus.client.services.ServiceManagerRegistry;
import ch.icit.pegasus.client.services.interfaces.report.OrderReportServiceManager;
import ch.icit.pegasus.client.services.interfaces.supply.OrderServiceManager;
import ch.icit.pegasus.client.services.interfaces.supply.SupplyServiceManager;
import ch.icit.pegasus.client.util.RemoteLoader;
import ch.icit.pegasus.client.util.ScreenValidationObject;
import ch.icit.pegasus.client.util.async.ThreadSafeExecutable;
import ch.icit.pegasus.client.util.async.ThreadSafeLoader;
import ch.icit.pegasus.client.util.exception.ClientException;
import ch.icit.pegasus.client.util.exception.ClientServerCallException;
import ch.icit.pegasus.client.util.toolkits.ArticleToolkit;
import ch.icit.pegasus.server.core.dtos.company.CostCenterComplete;
import ch.icit.pegasus.server.core.dtos.file.PegasusFileComplete;
import ch.icit.pegasus.server.core.dtos.masterdata.QuantityComplete;
import ch.icit.pegasus.server.core.dtos.ordering.PurchaseOrderComplete;
import ch.icit.pegasus.server.core.dtos.ordering.PurchaseOrderComplete_;
import ch.icit.pegasus.server.core.dtos.ordering.PurchaseOrderPositionComplete;
import ch.icit.pegasus.server.core.dtos.ordering.PurchaseOrderPreviewComplete_;
import ch.icit.pegasus.server.core.dtos.search.BasicArticleSearchConfiguration;
import ch.icit.pegasus.server.core.dtos.search.CustomerSearchConfiguration;
import ch.icit.pegasus.server.core.dtos.supply.BasicArticleComplete;
import ch.icit.pegasus.server.core.dtos.supply.BasicArticleLight;
import ch.icit.pegasus.server.core.dtos.supply.BasicArticleReference;
import ch.icit.pegasus.server.core.dtos.supply.CustomerLight;
import ch.icit.pegasus.server.core.dtos.system.SystemSettingsComplete;
import ch.icit.pegasus.server.core.dtos.util.XMLWrapper.ListWrapper;
import ch.icit.pegasus.server.core.general.ASearchConfiguration;
import ch.icit.pegasus.server.core.i18n.Words;
import ch.icit.pegasus.server.core.services.exception.ServiceException;
import ch.icit.pegasus.server.core.util.Triple;
import ch.icit.pegasus.server.core.util.Tuple;
import ch.icit.pegasus.server.dtos.metamodel.DtoField;
import ch.icit.utils.ExcelRow;
import ch.icit.utils.ExcelToolkit;
import ch.icit.utils.ExcelToolkitException;
import ch.icit.utils.NumberUtils;
import java.awt.Component;
import java.awt.Container;
import java.io.File;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class OrderBreadCrumpPanel
extends BreadCrumbPanel
implements RemoteLoader {
    private static final long serialVersionUID = 1L;
    private final boolean isSolarCompany;
    private ArticleDetailsPanel ap;
    private OrderBreadCrumbGroupTable groups;
    private Container creator;
    private static final int STATE_POSVAL = 5;
    private static final int STATE_SEND = 7;
    private static final int STATE_INTERVALVALIDATION = 11;
    private int currentState;
    private boolean hasError;
    private boolean workOnPreviewBase;
    private BreadCrumbTable breadCrumbTable;
    private boolean orderFixed = false;

    public OrderBreadCrumpPanel(IDataHandler dataHandler, ArticleDetailsPanel ap, Container c, boolean workOnPreviewBase, boolean orderFixed) {
        super(dataHandler, 2, null);
        this.creator = c;
        this.workOnPreviewBase = workOnPreviewBase;
        this.orderFixed = orderFixed;
        this.isSolarCompany = Boolean.TRUE.equals(((SystemSettingsComplete)NodeToolkit.getAffixClass(SystemSettingsComplete.class).getValue()).getCompany().getSolarCompanyType());
        if (!this.workOnPreviewBase) {
            this.button = new TablePanelAddSaveButton(TextButton.BUTTON_TYPES.ADD);
            this.button.setText(Words.CREATE_ORDERS);
            this.button.addButtonListener(this);
            if (!this.isSolarCompany) {
                this.button2 = new TablePanelAddSaveButton(TextButton.BUTTON_TYPES.ADD);
                this.button2.setText(Words.IMPORT_ARTICLES);
                this.button2.addButtonListener(this);
                this.button2Info = new InfoButton();
                String text = "<b>Import Articles from Excel</b><br/><ul>";
                text = text + "<li>Column A = Article Number from CATIT</li>";
                text = text + "<li>Column B = Customer Code (optional)</li>";
                text = text + "<li>Column C = Order Amount</li>";
                text = text + "<li>Column D = Order Unit</li>";
                text = text + "<li>Column E = Department (optional)</li>";
                text = text + "</ul>";
                this.button2Info.installStringViewer(text);
                this.add(this.button2);
                this.add(this.button2Info);
            }
            this.button3 = new TablePanelAddSaveButton(TextButton.BUTTON_TYPES.ADD);
            this.button3.setText(Words.PREVIEW);
            this.button3.addButtonListener(this);
            this.add(this.button);
            this.add(this.button3);
        }
        this.ap = ap;
    }

    @Override
    public Converter getTotalConverter() {
        return null;
    }

    @Override
    public GroupLoader getGroupLoader() {
        return null;
    }

    @Override
    public BreadCrumbNavigator getNavigatorComponent() {
        return null;
    }

    @Override
    public BreadCrumbTable getGroupTable(Node node) {
        OrderBreadCrumbGroupTable p;
        this.groups = p = new OrderBreadCrumbGroupTable(this.dataHandler, (BreadCrumbPanel)this, null, this.workOnPreviewBase, this.orderFixed);
        p.getTable().getModel().setNode(node);
        return p;
    }

    @Override
    public BreadCrumbTable getComponentTable(Node node, int depth) {
        OrderBreadCrumbComponentTable o = new OrderBreadCrumbComponentTable(this.dataHandler, (BreadCrumbPanel)this, this.ap, this.workOnPreviewBase, this.orderFixed);
        o.setNode(node);
        return o;
    }

    @Override
    public void setNode(Node node) {
        this.node = node;
        if (this.breadCrumbTable == null) {
            this.breadCrumbTable = this.addGroupTable(node);
        } else {
            this.breadCrumbTable.setNode(node);
        }
        this.breadCrumbTable.selectFirstEntry();
    }

    @Override
    public Node getNode() {
        return this.node;
    }

    @Override
    public InnerPopUp2 getAddGroupPopup(Button source, int x, int y, BreadCrumbTable t) {
        return null;
    }

    @Override
    public void setTotalCostAlgorithm() {
    }

    @Override
    public void processPopUpClose(Object ... xargs) {
    }

    @Override
    public DtoField<?> getSelectionChildName() {
        if (this.workOnPreviewBase) {
            return PurchaseOrderPreviewComplete_.positionPreviews;
        }
        return PurchaseOrderComplete_.orderPositions;
    }

    private void loadArticlesFromExcelStrat2(File file) throws ClientServerCallException {
        FileCommitter c = new FileCommitter(file);
        c.commit(null);
        PegasusFileComplete pf = c.getRemoteRef();
        Timestamp validity = new Timestamp(System.currentTimeMillis());
        Map articles = ((OrderServiceManager)ServiceManagerRegistry.getService(OrderServiceManager.class)).getArticles(pf).getMap();
        for (Map.Entry a : articles.entrySet()) {
            this.ap.insertArticle((BasicArticleComplete)((Tuple)a.getKey()).getS(), (CostCenterComplete)((Tuple)a.getKey()).getT(), ArticleToolkit.getCheapestSupplierConditionByMinAmount((BasicArticleComplete)((Tuple)a.getKey()).getS(), false, null, validity), ((QuantityComplete)((Triple)a.getValue()).getS()).getQuantity(), ((QuantityComplete)((Triple)a.getValue()).getS()).getUnit(), (QuantityComplete)((Triple)a.getValue()).getT(), (QuantityComplete)((Triple)a.getValue()).getU(), true);
        }
    }

    private void loadArticlesFromExcelStrat1(File file) throws ServiceException, ExcelToolkitException {
        int toOrderAmountInStoreUnit = 17;
        int toCalcAmountInStoreUnit = 15;
        int toStockAmountInStoreUnit = 16;
        Timestamp validity = new Timestamp(System.currentTimeMillis());
        HashMap<Integer, BasicArticleComplete> articleCache = new HashMap<Integer, BasicArticleComplete>();
        HashMap<String, CustomerLight> customerCache = new HashMap<String, CustomerLight>();
        List rows = ExcelToolkit.readRows((File)file, (int)1);
        BasicArticleSearchConfiguration aSearch = new BasicArticleSearchConfiguration();
        CustomerSearchConfiguration cSearch = new CustomerSearchConfiguration();
        boolean skipt = true;
        for (ExcelRow r : rows) {
            SearchResultIterator sri;
            if (skipt) {
                skipt = false;
                continue;
            }
            Integer articleNo = NumberUtils.getIntegerValue((Object)r.getCellValue(0));
            String customerCode = (String)r.getCellValue(1);
            Double orderAmount = NumberUtils.getDoubleValue((Object)r.getCellValue(toOrderAmountInStoreUnit));
            Double calcAmount = NumberUtils.getDoubleValue((Object)r.getCellValue(toCalcAmountInStoreUnit));
            Double onStockAmount = NumberUtils.getDoubleValue((Object)r.getCellValue(toStockAmountInStoreUnit));
            if (orderAmount == null || !(orderAmount > 0.0)) continue;
            BasicArticleComplete lart = (BasicArticleComplete)articleCache.get(articleNo);
            CustomerLight lcust = (CustomerLight)customerCache.get(customerCode);
            if (lart == null) {
                aSearch.setNumber(articleNo);
                sri = new SearchResultIterator((ASearchConfiguration)aSearch);
                for (BasicArticleLight a : sri) {
                    BasicArticleComplete ac = (BasicArticleComplete)((SupplyServiceManager)ServiceManagerRegistry.getService(SupplyServiceManager.class)).getBasicArticle(new BasicArticleReference(a.getId())).getValue();
                    articleCache.put(articleNo, ac);
                    lart = ac;
                }
            }
            if (lcust == null) {
                cSearch.setCode(customerCode);
                sri = new SearchResultIterator((ASearchConfiguration)cSearch);
                Iterator iterator = sri.iterator();
                while (iterator.hasNext()) {
                    CustomerLight c;
                    lcust = c = (CustomerLight)iterator.next();
                    customerCache.put(customerCode, lcust);
                }
            }
            if (lart == null) continue;
            this.ap.insertArticle(lart, ArticleToolkit.getCheapestSupplierConditionByMinAmount(lart, false, null, validity), orderAmount, lart.getMainStoreUnit(), new QuantityComplete(calcAmount, lart.getMainStoreUnit()), new QuantityComplete(onStockAmount, lart.getMainStoreUnit()), true);
        }
    }

    private LoadingAnimation showAnimation(boolean show) {
        if (this.creator instanceof SplitScreenView) {
            return ((SplitScreenView)this.creator).showAnimation(false);
        }
        return null;
    }

    private LoadingAnimation showAnimation(boolean show, String text) {
        if (this.creator instanceof SplitScreenView) {
            return ((SplitScreenView)this.creator).showAnimation(show, text);
        }
        return null;
    }

    @Override
    public void buttonPressed(Button source, int x, int y) {
        this.hasError = false;
        if (this.workOnPreviewBase) {
            return;
        }
        if (source == this.button) {
            LoadingAnimation anim = this.showAnimation(true, this.dataHandler.getRemoteValidationText());
            if (this.validateSupplierConfiguration()) {
                this.dataHandler.doRemoteValidation(this.groups.getTable().getModel().getNode(), new RemoteLoader(){

                    public void remoteObjectLoaded(Node<?> node) {
                        OrderBreadCrumpPanel.this.showAnimation(false);
                        if (node.getValue() instanceof List) {
                            List l = (List)node.getValue();
                            OrderBreadCrumpPanel.this.currentState = 11;
                            InnerPopupFactory.showMessageDialog((List<ScreenValidationObject>)l, Words.SUPPLIER_PURCHASE_PRICE_LOADED, (InnerPopUpListener2)OrderBreadCrumpPanel.this, (Component)OrderBreadCrumpPanel.this);
                        }
                    }

                    public void errorOccurred(ClientException exception) {
                        InnerPopupFactory.showErrorDialog((Exception)exception, (Component)OrderBreadCrumpPanel.this);
                        OrderBreadCrumpPanel.this.showAnimation(false);
                    }
                }, anim, true);
            } else {
                this.showAnimation(false);
            }
        } else if (source == this.button2) {
            this.showAnimation(true, Words.IMPORT_ARTICLES);
            ThreadSafeExecutable run = new ThreadSafeExecutable(){

                @Override
                public Node<?> loadData() throws Exception {
                    File file = FileChooserUtil.loadFile();
                    OrderBreadCrumpPanel.this.loadArticlesFromExcelStrat2(file);
                    return null;
                }

                @Override
                public RemoteLoader getInvoker() {
                    return new RemoteLoader(){

                        public void remoteObjectLoaded(Node<?> node) {
                            OrderBreadCrumpPanel.this.showAnimation(false);
                        }

                        public void errorOccurred(ClientException exception) {
                            InnerPopupFactory.showErrorDialog((Exception)exception, (Component)OrderBreadCrumpPanel.this.creator);
                            OrderBreadCrumpPanel.this.showAnimation(false);
                        }
                    };
                }

                @Override
                public long getID() {
                    return 0L;
                }
            };
            ThreadSafeLoader.run(run);
        } else if (source == this.button3) {
            this.showAnimation(true, Words.CREATE_PREVIEW);
            ThreadSafeExecutable run = new ThreadSafeExecutable(){

                @Override
                public Node<?> loadData() throws Exception {
                    ArrayList<PurchaseOrderComplete> orders = new ArrayList<PurchaseOrderComplete>();
                    Iterator it = OrderBreadCrumpPanel.this.groups.getTable().getModel().getNode().getFailSafeChildIterator();
                    while (it.hasNext()) {
                        Node n = (Node)it.next();
                        n.commit();
                        PurchaseOrderComplete o = (PurchaseOrderComplete)n.getValue(PurchaseOrderComplete.class);
                        int count = 0;
                        for (PurchaseOrderPositionComplete purchaseOrderPositionComplete : o.getOrderPositions()) {
                            purchaseOrderPositionComplete.setSequenceNumber(Integer.valueOf(count++));
                            purchaseOrderPositionComplete.setOrder(o);
                        }
                        orders.add(o);
                    }
                    PegasusFileComplete file = (PegasusFileComplete)((OrderReportServiceManager)ServiceManagerRegistry.getService(OrderReportServiceManager.class)).createPurchaseOrderPreview(new ListWrapper(orders)).getValue();
                    FileTransferUtil.download((PegasusFileComplete)file, (FileTransferListener[])new FileTransferListener[]{new FileTransferListener(){

                        public void statusChanged(File file, FileTransferState state) {
                        }

                        public void exceptionOccurred(Exception exception) {
                            InnerPopupFactory.showErrorDialog(exception, (Component)OrderBreadCrumpPanel.this);
                        }
                    }});
                    PrintPopupToolkit.previewFile(file);
                    return null;
                }

                @Override
                public RemoteLoader getInvoker() {
                    return new RemoteLoader(){

                        public void remoteObjectLoaded(Node<?> node) {
                            OrderBreadCrumpPanel.this.showAnimation(false);
                        }

                        public void errorOccurred(ClientException exception) {
                            InnerPopupFactory.showErrorDialog((Exception)exception, (Component)OrderBreadCrumpPanel.this.creator);
                            OrderBreadCrumpPanel.this.showAnimation(false);
                        }
                    };
                }

                @Override
                public long getID() {
                    return 0L;
                }
            };
            ThreadSafeLoader.run(run);
        }
    }

    public boolean validateSupplierConfiguration() {
        List<ScreenValidationObject> validationObjects = this.groups.validateComponents();
        if (!validationObjects.isEmpty()) {
            if (!this.workOnPreviewBase) {
                this.showAnimation(false);
                InnerPopupFactory.showErrorDialog(validationObjects, "Review Orders", (Component)this);
            }
            return false;
        }
        return true;
    }

    private void continueWithCreation() {
        List<ScreenValidationObject> t = this.groups.validateOrderIntervalAndDeliveryTime();
        this.currentState = 5;
        if (t.isEmpty()) {
            this.popUpClosed(null, new Object());
        } else {
            boolean isError;
            this.showAnimation(false);
            this.hasError = isError = ScreenValidationObject.isFatal(t);
            if (!isError) {
                InnerPopupFactory.showWarningDialog(t, "Warning", "Review Order", "", this, this);
            } else {
                InnerPopupFactory.showErrorDialog(ScreenValidationObject.filter(t, (ScreenValidationObject.ValidationStateE)ScreenValidationObject.ValidationStateE.FATAL), "Unable to send Order", (Component)this);
            }
        }
    }

    @Override
    public void popUpClosed(InnerPopUp2 source, Object ... xargs) {
        if (xargs == null) {
            return;
        }
        if (this.hasError) {
            this.showAnimation(false);
            return;
        }
        if (this.currentState == 11) {
            LoadingAnimation anim = this.showAnimation(true, this.dataHandler.getRemoteValidationText());
            if (anim != null) {
                anim.stateChanged("Validate Orders");
            }
            this.continueWithCreation();
            return;
        }
        if (this.currentState == 5) {
            this.currentState = 7;
            this.showAnimation(false);
            InnerPopUp2 popUp = InnerPopUp2.getInnerPopUp();
            popUp.setAttributes(source, true, true, "Print Configuration");
            popUp.setView(new CreateOrderInformationPopup());
            popUp.hideCancelButton();
            popUp.showPopUpWithinScreenMiddle(200, 100, this, this);
            return;
        }
        boolean send = (Boolean)xargs[0];
        boolean printRec = (Boolean)xargs[1];
        boolean printOrder = (Boolean)xargs[2];
        LoadingAnimation anim = this.showAnimation(true, Words.CREATE_ORDERS);
        this.ap.createOrders(this.button, this.groups.getTable().getModel().getNode(), this, anim, send, printRec, printOrder);
    }

    @Override
    public void remoteObjectLoaded(Node<?> node) {
        if (this.creator instanceof SplitScreenView) {
            ((SplitScreenView)this.creator).resetView();
        }
        this.showAnimation(false);
        if (node.getValue() instanceof List) {
            List valList = (List)node.getValue();
            InnerPopUp2 p = InnerPopupFactory.showWarningDialog(valList, "Order creation Summary:", (Component)this);
            p.setPopupTitle("Order Summary");
            p.hideCancelButton();
            p.setOkButtonText(Words.CLOSE);
        }
    }

    @Override
    public void errorOccurred(ClientException exception) {
        this.showAnimation(false);
        super.errorOccurred(exception);
    }
}

