/*
 * Decompiled with CFR 0.152.
 */
package ch.icit.pegasus.client.gui.modules.quality.measurement.ccp0102.details;

import ch.icit.pegasus.client.converter.BooleanConverter;
import ch.icit.pegasus.client.converter.CustomerConverter;
import ch.icit.pegasus.client.converter.DateTimeConverter;
import ch.icit.pegasus.client.converter.FormattedDoubleConverter1Decimals;
import ch.icit.pegasus.client.converter.RecipeVariantConverter;
import ch.icit.pegasus.client.converter.UserConverter;
import ch.icit.pegasus.client.converter.controller.ConverterRegistry;
import ch.icit.pegasus.client.gui.screentemplates.details.TableDetailsPanel;
import ch.icit.pegasus.client.gui.table.RowEditor;
import ch.icit.pegasus.client.gui.table.TableColumnInfo;
import ch.icit.pegasus.client.gui.table2.Table2;
import ch.icit.pegasus.client.gui.table2.Table2RowModel;
import ch.icit.pegasus.client.gui.table2.Table2RowPanel;
import ch.icit.pegasus.client.gui.table2.defaults.DefaultTable2RowPanel;
import ch.icit.pegasus.client.gui.table2.defaults.DefaultTable2RowPanelLayout;
import ch.icit.pegasus.client.gui.utils.TextLabel;
import ch.icit.pegasus.client.gui.utils.buttons.Button;
import ch.icit.pegasus.client.gui.utils.buttons.InfoButton;
import ch.icit.pegasus.client.gui.utils.icons.impl.CheckBoxRO;
import ch.icit.pegasus.client.gui.utils.rightdependant.RDProvider;
import ch.icit.pegasus.client.node.impls.Node;
import ch.icit.pegasus.server.core.dtos.masterdata.UserReference;
import ch.icit.pegasus.server.core.dtos.quality.ccp0102.CCP0102BatchComplete;
import ch.icit.pegasus.server.core.dtos.quality.ccp0102.CCP0102BatchMeasurementComplete;
import ch.icit.pegasus.server.core.dtos.quality.ccp0102.CCP0102BatchMeasurementTypeE;
import ch.icit.pegasus.server.core.dtos.quality.ccp0102.CCP0102EntryComplete;
import ch.icit.pegasus.server.core.dtos.quality.ccp0102.CCP0102EntryComplete_;
import ch.icit.pegasus.server.core.dtos.quality.ccp0102.CCP0102MeasurementComplete_;
import ch.icit.pegasus.server.core.dtos.quality.ccp0102.CCP0102MeasurementLight;
import ch.icit.pegasus.server.core.dtos.recipe.RecipeComplete_;
import ch.icit.pegasus.server.core.i18n.Words;
import ch.icit.pegasus.server.core.util.StringUtil;
import ch.icit.pegasus.server.dtos.metamodel.DtoField;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.List;

public class MeasurementDetailsPanel
extends TableDetailsPanel<CCP0102MeasurementLight> {
    public MeasurementDetailsPanel(RowEditor<CCP0102MeasurementLight> editor, RDProvider provider) {
        super(editor, provider, false);
    }

    @Override
    public List<TableColumnInfo> getColumns(boolean add) {
        ArrayList<TableColumnInfo> columns = new ArrayList<TableColumnInfo>();
        columns.add(new TableColumnInfo(Words.RECIPE, null, null, null, "", 40));
        columns.add(new TableColumnInfo(Words.CUSTOMER, null, null, null, "", 40));
        columns.add(new TableColumnInfo(Words.PRODUCED, null, null, null, "", 75));
        columns.add(new TableColumnInfo(Words.BATCHES, null, null, null, "", 60));
        columns.add(new TableColumnInfo(Words.COMPLETE, null, null, null, "", 60));
        columns.add(new TableColumnInfo("Details", null, null, null, "", 60));
        ((TableColumnInfo)columns.get(0)).setxExpand(0.75);
        ((TableColumnInfo)columns.get(1)).setxExpand(0.25);
        ((TableColumnInfo)columns.get(2)).setxExpand(0.0);
        ((TableColumnInfo)columns.get(3)).setxExpand(0.0);
        ((TableColumnInfo)columns.get(4)).setxExpand(0.0);
        ((TableColumnInfo)columns.get(5)).setxExpand(0.0);
        return columns;
    }

    @Override
    public void configTable(Table2 table) {
        table.setRequestFocusOnAdd(true);
    }

    @Override
    public void addButtonPressed(int x, int y, Button source) {
    }

    @Override
    public void childRemoved() {
    }

    @Override
    public void setNode(Node<?> node) {
        super.setNode(node);
        this.table.getModel().setNode(node.getChildNamed(CCP0102MeasurementComplete_.entries));
    }

    @Override
    public Table2RowPanel generateView(Table2RowModel model, boolean isHeader) {
        DefaultTable2RowPanel row = new DefaultTable2RowPanel(model);
        row.addLayoutComponent(new TextLabel(model.getNode().getChildNamed(new DtoField[]{CCP0102EntryComplete_.recipe, RecipeComplete_.currentVariant}), ConverterRegistry.getConverter(RecipeVariantConverter.class)), DefaultTable2RowPanelLayout.LayoutType.FILL);
        CCP0102EntryComplete entry = (CCP0102EntryComplete)model.getNode().getValue(CCP0102EntryComplete.class);
        row.addLayoutComponent(new TextLabel(model.getNode().getChildNamed(CCP0102EntryComplete_.customer), ConverterRegistry.getConverter(CustomerConverter.class)), DefaultTable2RowPanelLayout.LayoutType.FILL);
        row.addLayoutComponent(new TextLabel(model.getNode().getChildNamed(CCP0102EntryComplete_.produced), ConverterRegistry.getConverter(BooleanConverter.class)), DefaultTable2RowPanelLayout.LayoutType.FILL);
        row.addLayoutComponent(new TextLabel(entry.getBatches().size() + ""), DefaultTable2RowPanelLayout.LayoutType.FILL);
        row.addLayoutComponent(new CheckBoxRO((Node<Boolean>)model.getNode().getChildNamed(CCP0102EntryComplete_.complete)), DefaultTable2RowPanelLayout.LayoutType.FIX);
        InfoButton infoButton = new InfoButton();
        infoButton.installStringViewer(this.createHeatingText(entry));
        row.addLayoutComponent(infoButton, DefaultTable2RowPanelLayout.LayoutType.FIX);
        return row;
    }

    private Timestamp getMeasureTime(CCP0102BatchMeasurementComplete measurement) {
        if (measurement.getMeasureTimeStart() != null) {
            return measurement.getMeasureTimeStart();
        }
        return measurement.getMeasureTimeEnd();
    }

    private Double getMeasureTemperature(CCP0102BatchMeasurementComplete measurement) {
        if (measurement.getTemperatureStart() != null) {
            return measurement.getTemperatureStart();
        }
        return measurement.getTemperatureEnd();
    }

    private double getMeasurementDuration(CCP0102BatchMeasurementComplete measurement) {
        Timestamp startTime = measurement.getMeasureTimeStart();
        Timestamp endTime = measurement.getMeasureTimeEnd();
        if (startTime != null && endTime != null) {
            return (endTime.getTime() - startTime.getTime()) / 1000L;
        }
        return 0.0;
    }

    private String createHeatingText(CCP0102EntryComplete entry) {
        String text = "<html>";
        text = text + "<b>Heating/Chilling Process</b><br/>";
        UserConverter userConverter = (UserConverter)ConverterRegistry.getConverter(UserConverter.class);
        DateTimeConverter dateConverter = (DateTimeConverter)ConverterRegistry.getConverter(DateTimeConverter.class);
        FormattedDoubleConverter1Decimals numberConverter = (FormattedDoubleConverter1Decimals)ConverterRegistry.getConverter(FormattedDoubleConverter1Decimals.class);
        for (CCP0102BatchComplete batch : entry.getBatches()) {
            text = text + "<b>Batch</b><br/>";
            for (CCP0102BatchMeasurementComplete measurement : batch.getMeasurements()) {
                text = text + "<ul>";
                if (measurement.getBatchMeasurementType() == CCP0102BatchMeasurementTypeE.Heating) {
                    text = text + "<li>Heating Time: " + dateConverter.convert((Object)this.getMeasureTime(measurement), null, new Object[0]) + "</li>";
                    text = text + "<li>Heating Duration: " + this.getMeasurementDuration(measurement) + " sec</li>";
                    text = text + "<li>Heating Core Temperature: " + numberConverter.convert((Number)this.getMeasureTemperature(measurement), null, new Object[0]) + " " + Words.DEGREE + "C</li>";
                    text = text + "<li>Heating User: " + userConverter.convert((UserReference)measurement.getUser(), null, new Object[0]) + "</li>";
                    text = text + "<li>Heating Comment: " + this.createString(measurement.getCommentText()) + "</li>";
                } else if (measurement.getBatchMeasurementType() == CCP0102BatchMeasurementTypeE.FastChillBegin) {
                    text = text + "<li>Fast Chill Begin Time: " + dateConverter.convert((Object)this.getMeasureTime(measurement), null, new Object[0]) + "</li>";
                    text = text + "<li>Fast Chill Begin Temperature: " + this.getMeasureTemperature(measurement) + " " + Words.DEGREE + "C</li>";
                    text = text + "<li>Fast Chill User: " + userConverter.convert((UserReference)measurement.getUser(), null, new Object[0]) + "</li>";
                    text = text + "<li>Fast Chill Begin Comment: " + this.createString(measurement.getCommentText()) + "</li>";
                } else if (measurement.getBatchMeasurementType() == CCP0102BatchMeasurementTypeE.FastChillEnd) {
                    text = text + "<li>Fast Chill End Time: " + dateConverter.convert((Object)this.getMeasureTime(measurement), null, new Object[0]) + "</li>";
                    text = text + "<li>Fast Chill End Temperature: " + this.getMeasureTemperature(measurement) + " " + Words.DEGREE + "C</li>";
                    text = text + "<li>Fast Chill End: " + userConverter.convert((UserReference)measurement.getUser(), null, new Object[0]) + "</li>";
                    text = text + "<li>Fast Chill End Comment: " + this.createString(measurement.getCommentText()) + "</li>";
                }
                text = text + "</ul>";
            }
            text = text + "<br/>";
        }
        text = text + "</html>";
        return text;
    }

    private String createString(String t) {
        if (StringUtil.isBlank((String)t)) {
            return "-";
        }
        return t;
    }
}

