/*
 * Decompiled with CFR 0.152.
 */
package ch.icit.pegasus.client.gui.modules.radar.view;

import ch.icit.pegasus.client.converter.DateConverter;
import ch.icit.pegasus.client.converter.controller.ConverterRegistry;
import ch.icit.pegasus.client.gui.modules.radar.view.RadarContentPane;
import ch.icit.pegasus.client.gui.modules.radar.view.RadarFlightWidget;
import ch.icit.pegasus.client.gui.utils.AttributesConverter;
import ch.icit.pegasus.client.gui.utils.DefaultLayout;
import ch.icit.pegasus.client.gui.utils.focus.VisibleContainer;
import ch.icit.pegasus.client.gui.utils.panels.DefaultPanel;
import ch.icit.pegasus.client.gui.utils.toolkit.DrawToolkit;
import ch.icit.pegasus.client.laf.LafLoader;
import ch.icit.pegasus.client.node.impls.Node;
import ch.icit.pegasus.server.core.dtos.flightschedule.FlightLegComplete;
import ch.icit.pegasus.server.core.dtos.flightschedule.FlightLight;
import ch.icit.pegasus.server.core.util.TimeUtil;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.geom.Area;
import java.sql.Date;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;

public class RadarPanelHour
extends DefaultPanel
implements Comparable<RadarPanelHour> {
    private static final long serialVersionUID = 1L;
    private final List<RadarFlightWidget> flights = new ArrayList<RadarFlightWidget>();
    private Area currentCollisionArea;
    private Area preferredCollision;
    private int selectedHour;
    private Date selectedDay;
    private boolean useTiger;
    private int[] widths;
    private final Color rowEvenColor;
    private final Color rowOddColor;
    private final Color lineColor;
    private final Color fontColor;
    private final Font font;
    private final int firstHborder = 1;
    private final int hborder = -5;
    private final int vborder = 0;
    private RadarContentPane panel;

    public RadarPanelHour(RadarContentPane panel) {
        this.panel = panel;
        this.rowEvenColor = AttributesConverter.getColor4String(LafLoader.getLafLoader().getAttribute("table_row_color_even"));
        this.rowOddColor = AttributesConverter.getColor4String(LafLoader.getLafLoader().getAttribute("table_row_color_odd"));
        this.lineColor = AttributesConverter.getColor4String(LafLoader.getLafLoader().getAttribute("leg_table_line_color"));
        this.fontColor = AttributesConverter.getColor4String(LafLoader.getLafLoader().getAttribute("default_foreground_color"));
        this.font = AttributesConverter.getFont4String(LafLoader.getLafLoader().getAttribute("default_font"), LafLoader.getLafLoader().getAttribute("default_font_size"), LafLoader.getLafLoader().getAttribute("default_font_type")).deriveFont(1);
        this.setLayout(new Layout());
    }

    public void addFlight(Node<FlightLight> flight, FlightLegComplete leg, Timestamp flightDate, String flightCode, boolean isOutbound) {
        if (flightCode == null || flightCode.trim().isEmpty()) {
            return;
        }
        for (RadarFlightWidget w : this.flights) {
            if (!((FlightLight)w.getNode().getValue()).equals(flight.getValue()) || !w.getLeg().equals((Object)leg)) continue;
            return;
        }
        RadarFlightWidget widget = new RadarFlightWidget(flight, leg, flightDate, flightCode, isOutbound, this);
        this.flights.add(widget);
        Collections.sort(this.flights);
        this.add(widget);
        widget.fadeIn();
    }

    @Override
    public void setEnabled(boolean isEnabled) {
        super.setEnabled(isEnabled);
    }

    @Override
    public void kill() {
        if (this.isKilled()) {
            return;
        }
        super.kill();
        List copyList = (List)((ArrayList)this.flights).clone();
        for (RadarFlightWidget w : copyList) {
            w.kill();
        }
        this.flights.clear();
    }

    @Override
    public List<Component> getFocusComponents() {
        return null;
    }

    @Override
    public void setVisibleContainer(VisibleContainer pane) {
    }

    @Override
    public void requestFocusInWindowNow() {
    }

    public void setWidths(int[] widths) {
        this.widths = widths;
    }

    public void setHour(int i) {
        this.selectedHour = i;
    }

    public void setDate(Date d) {
        this.selectedDay = d;
    }

    public Date getDate() {
        return this.selectedDay;
    }

    @Override
    public int compareTo(RadarPanelHour o) {
        return (int)(this.selectedDay.getTime() + (long)this.selectedHour - (o.selectedDay.getTime() + (long)o.selectedHour));
    }

    public int getHour() {
        return this.selectedHour;
    }

    @Override
    public void paint(Graphics g) {
        Graphics2D g2 = (Graphics2D)g;
        g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        DrawToolkit.setAlphaComposite(g2, this.getFader());
        if (this.useTiger) {
            g2.setColor(this.rowEvenColor);
        } else {
            g2.setColor(this.rowOddColor);
        }
        g2.fillRect(0, 0, this.getWidth(), this.getHeight());
        if (this.currentCollisionArea != null) {
            g2.setColor(Color.red);
            g2.fill(this.currentCollisionArea);
        }
        if (this.preferredCollision != null) {
            g2.setColor(new Color(0, 255, 0, 12));
            g2.fill(this.preferredCollision);
        }
        if (this.widths != null) {
            g2.setColor(this.lineColor);
            int cx = 0;
            for (int i = 0; i < this.widths.length; ++i) {
                g2.drawLine(cx += this.widths[i], 0, cx, this.getHeight());
            }
        }
        g2.setFont(this.font);
        g2.setColor(this.fontColor);
        String t = "" + this.selectedHour;
        if (t.length() == 1) {
            t = "0" + t;
        }
        t = t + ":00";
        g2.drawString(t, 5, 20);
        if (this.selectedDay != null) {
            g2.setFont(this.font);
            Calendar c = TimeUtil.createCalendar();
            c.setTimeInMillis(this.selectedDay.getTime());
            int d = c.get(7);
            t = "";
            switch (d) {
                case 1: {
                    t = "Sunday";
                    break;
                }
                case 2: {
                    t = "Monday";
                    break;
                }
                case 3: {
                    t = "Tuesday";
                    break;
                }
                case 4: {
                    t = "Wednesday";
                    break;
                }
                case 5: {
                    t = "Thursday";
                    break;
                }
                case 6: {
                    t = "Friday";
                    break;
                }
                case 7: {
                    t = "Saturday";
                }
            }
            g2.setFont(g2.getFont().deriveFont(2, 10.0f));
            g2.drawString(t, 5, 35);
            DateConverter cc = (DateConverter)ConverterRegistry.getConverter(DateConverter.class);
            t = cc.convert((Object)this.selectedDay, null, new Object[0]);
            g2.drawString(t, 5, 50);
        }
        this.paintChildren(g2);
    }

    public boolean tryToRemoveFlight(Node<FlightLight> flight) {
        Iterator<RadarFlightWidget> it = this.flights.iterator();
        while (it.hasNext()) {
            RadarFlightWidget rfw = it.next();
            if (!((FlightLight)rfw.getNode().getValue()).equals(flight.getValue())) continue;
            rfw.fadeOut(true);
            it.remove();
        }
        return false;
    }

    public void setTiger(boolean tiger) {
        this.useTiger = tiger;
    }

    private int getColumnWidth(int column) {
        for (int i = 0; i < this.widths.length; ++i) {
            if (i != column + 1) continue;
            return this.widths[i];
        }
        return 0;
    }

    public void removeFromList(RadarFlightWidget radarFlightWidget) {
        this.flights.remove(radarFlightWidget);
    }

    public RadarContentPane getRadarPanel() {
        return this.panel;
    }

    public RadarFlightWidget getNext(RadarFlightWidget selectedWidget) {
        if (selectedWidget == null && !this.flights.isEmpty()) {
            return this.flights.get(0);
        }
        if (!this.flights.contains(selectedWidget) && !this.flights.isEmpty()) {
            return this.flights.get(0);
        }
        int i = this.flights.indexOf(selectedWidget);
        if (++i < this.flights.size()) {
            return this.flights.get(i);
        }
        return null;
    }

    public RadarFlightWidget getPrevious(RadarFlightWidget selectedWidget) {
        if (selectedWidget == null && !this.flights.isEmpty()) {
            return this.flights.get(this.flights.size() - 1);
        }
        if (!this.flights.contains(selectedWidget) && !this.flights.isEmpty()) {
            return this.flights.get(this.flights.size() - 1);
        }
        int i = this.flights.indexOf(selectedWidget);
        if (--i >= 0) {
            return this.flights.get(i);
        }
        return null;
    }

    public List<FlightLight> getFlights() {
        ArrayList<FlightLight> ret = new ArrayList<FlightLight>();
        for (RadarFlightWidget widget : this.flights) {
            ret.add((FlightLight)widget.getNode().getValue());
        }
        return ret;
    }

    private class Layout
    extends DefaultLayout {
        private Layout() {
        }

        @Override
        public Dimension preferredLayoutSize(Container parent) {
            Calendar cal = TimeUtil.createCalendar();
            Area collisionDetection = new Area();
            for (RadarFlightWidget rfw : RadarPanelHour.this.flights) {
                Timestamp t = rfw.getOperationTime();
                cal.setTimeInMillis(t.getTime());
                int m = cal.get(12);
                int startOffSet = RadarPanelHour.this.getColumnWidth(0);
                int w = (int)((double)parent.getWidth() - (rfw.getPreferredSize().getWidth() + (double)startOffSet));
                int x = (int)((double)w * (double)m / 60.0);
                x += startOffSet;
                int y = 1;
                int h = (int)rfw.getPreferredSize().getHeight();
                while (collisionDetection.intersects(x, y, w, h)) {
                    y += h + -5;
                }
                collisionDetection.add(new Area(new Rectangle(x, y, (int)(rfw.getPreferredSize().getWidth() + -5.0), h + -5)));
            }
            Dimension d = collisionDetection.getBounds().getSize();
            if (d.height < 50) {
                d.height = 50;
            }
            d.height += 10;
            return new Dimension(d);
        }

        @Override
        public void layoutContainer(Container parent) {
            Calendar cal = TimeUtil.createCalendar();
            Area collisionDetection = new Area();
            for (RadarFlightWidget rfw : RadarPanelHour.this.flights) {
                Timestamp t = rfw.getOperationTime();
                cal.setTimeInMillis(t.getTime());
                int m = cal.get(12);
                int startOffSet = RadarPanelHour.this.getColumnWidth(0);
                int w = (int)((double)parent.getWidth() - (rfw.getPreferredSize().getWidth() + (double)startOffSet));
                int x = (int)((double)w * (double)m / 60.0);
                x += startOffSet;
                int y = 1;
                int h = (int)rfw.getPreferredSize().getHeight();
                while (collisionDetection.intersects(x, y, w, h)) {
                    y += h + -5;
                }
                rfw.setLocation(x, y);
                rfw.setSize(rfw.getPreferredSize());
                collisionDetection.add(new Area(new Rectangle(x, y, rfw.getWidth() + -5, h + -5)));
            }
        }
    }
}

