/*
 * Decompiled with CFR 0.152.
 */
package ch.icit.pegasus.client.gui.modules.serviceproduct.details;

import ch.icit.pegasus.client.converter.ModificationStateEConverter;
import ch.icit.pegasus.client.converter.controller.ConverterRegistry;
import ch.icit.pegasus.client.formatter.FormatterRegistry;
import ch.icit.pegasus.client.gui.screentemplates.details.StateDependantDetailsPanel;
import ch.icit.pegasus.client.gui.table.RowEditor;
import ch.icit.pegasus.client.gui.utils.CheckedListAdder;
import ch.icit.pegasus.client.gui.utils.DefaultLayout;
import ch.icit.pegasus.client.gui.utils.TitledItem;
import ch.icit.pegasus.client.gui.utils.buttons.Button;
import ch.icit.pegasus.client.gui.utils.combobox.InputComboBox;
import ch.icit.pegasus.client.gui.utils.rightdependant.RDComboBox;
import ch.icit.pegasus.client.gui.utils.rightdependant.RDInputComboBox;
import ch.icit.pegasus.client.gui.utils.rightdependant.RDProvider;
import ch.icit.pegasus.client.gui.utils.rightdependant.RDSearchTextField2;
import ch.icit.pegasus.client.gui.utils.rightdependant.RDTextField;
import ch.icit.pegasus.client.node.impls.Node;
import ch.icit.pegasus.client.node.impls.NodeListener;
import ch.icit.pegasus.client.node.impls.NodeToolkit;
import ch.icit.pegasus.client.util.ScreenValidationObject;
import ch.icit.pegasus.server.core.dtos.masterdata.AirportComplete;
import ch.icit.pegasus.server.core.dtos.masterdata.ModificationStateE;
import ch.icit.pegasus.server.core.dtos.rightmanagement.template.def.ServiceProductAccess;
import ch.icit.pegasus.server.core.dtos.serviceproduct.ServiceProductComplete;
import ch.icit.pegasus.server.core.dtos.serviceproduct.ServiceProductVariantComplete_;
import ch.icit.pegasus.server.core.dtos.supply.PriceComplete_;
import ch.icit.pegasus.server.core.dtos.system.SystemSettingsComplete;
import ch.icit.pegasus.server.core.dtos.utils.CompanyUtil;
import ch.icit.pegasus.server.core.i18n.Words;
import ch.icit.pegasus.server.dtos.metamodel.DtoField;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.sql.Date;
import java.util.ArrayList;
import java.util.List;

public class VariantSpecificationDetailsPanel
extends StateDependantDetailsPanel<ServiceProductComplete>
implements NodeListener {
    private static final long serialVersionUID = 1L;
    private final boolean isNoPro;
    private TitledItem<RDTextField> name;
    private TitledItem<RDTextField> customerNumber;
    private TitledItem<RDComboBox> state;
    private TitledItem<RDInputComboBox> salesPrice;
    private TitledItem<RDSearchTextField2<AirportComplete>> deliveryAirport;
    private boolean stateChangedNow;

    public VariantSpecificationDetailsPanel(RowEditor<ServiceProductComplete> editor, RDProvider provider) {
        super(editor, provider);
        this.isNoPro = CompanyUtil.isNoPro((SystemSettingsComplete)this.settings);
        this.setTitleText(Words.VARIANT_SPECIFICATION);
        this.name = new TitledItem<RDTextField>(new RDTextField(provider), Words.NAME, TitledItem.TitledItemOrientation.NORTH);
        this.customerNumber = new TitledItem<RDTextField>(new RDTextField(provider), Words.CUSTOMER_SERVICE_NUMBER, TitledItem.TitledItemOrientation.NORTH);
        this.state = new TitledItem<RDComboBox>(new RDComboBox(provider, ConverterRegistry.getConverter(ModificationStateEConverter.class)), Words.STATE, TitledItem.TitledItemOrientation.NORTH);
        Node n = new Node();
        n.setValue((Object)new Date(System.currentTimeMillis()), 0L);
        this.salesPrice = new TitledItem<RDInputComboBox>(new RDInputComboBox(provider, FormatterRegistry.getDecimalFormat(Words.EXTENDED_PRICE_PATTERN), InputComboBox.InputComboBoxType.PRICE_AND_UNIT_DOUBLE), "Sales Price", TitledItem.TitledItemOrientation.NORTH);
        this.salesPrice.getElement().setMaxKommaStellen(3);
        this.salesPrice.getElement().setOverrideName(ServiceProductVariantComplete_.salesPrice);
        if (!this.isNoPro) {
            this.deliveryAirport = new TitledItem(new RDSearchTextField2(provider, RDSearchTextField2.SearchTypes.AIRPORT, true), Words.DELIVERY_AIRPORT, TitledItem.TitledItemOrientation.NORTH);
        }
        this.setCustomLayouter(new Layout());
        this.addToView(this.name);
        this.addToView(this.customerNumber);
        this.addToView(this.state);
        this.addToView(this.salesPrice);
        if (!this.isNoPro) {
            this.addToView(this.deliveryAirport);
        }
    }

    @Override
    public DtoField<ModificationStateE> getStateChildName() {
        return ServiceProductVariantComplete_.state;
    }

    @Override
    public void requestFocusInWindowNow() {
        this.name.requestFocusInWindowNow();
    }

    @Override
    public List<ScreenValidationObject> validateParagraph() {
        Double p;
        Object o;
        ArrayList<ScreenValidationObject> validationObjects = new ArrayList<ScreenValidationObject>();
        if (this.name.getElement().isWritable() && ((o = this.name.getElement().getNode().getValue()) == null || ((String)o).isEmpty())) {
            validationObjects.add(new ScreenValidationObject(ScreenValidationObject.ValidationStateE.FATAL, Words.ENSURE_NAME_IS_SET));
        }
        if (this.salesPrice.getElement().isWritable() && (p = (Double)this.salesPrice.getElement().getValueNode().getValue()) <= 0.0) {
            validationObjects.add(new ScreenValidationObject(ScreenValidationObject.ValidationStateE.FATAL, Words.ENSURE_PRICE_IS_GREATER_THAN_ZERO));
        }
        return validationObjects;
    }

    @Override
    public void setEnabled(boolean isEnabled) {
        boolean isDraft = this.isStateDraft();
        boolean changeAnyWay = true;
        if (!isDraft) {
            changeAnyWay = this.stateChangedNow ? true : this.provider.isWritable(ServiceProductAccess.REDRAFT_SERVICE);
        }
        boolean b = isEnabled && isDraft;
        super.setEnabled(b);
        this.name.setEnabled(b);
        this.customerNumber.setEnabled(b);
        this.state.setEnabled(isEnabled && changeAnyWay);
        this.salesPrice.setEnabled(b);
        if (!this.isNoPro) {
            this.deliveryAirport.setEnabled(b);
        }
    }

    @Override
    public void kill() {
        if (this.isKilled()) {
            return;
        }
        super.kill();
        this.name.kill();
        this.customerNumber.kill();
        this.state.kill();
        this.salesPrice.kill();
        if (!this.isNoPro) {
            this.deliveryAirport.kill();
        }
        this.name = null;
        this.customerNumber = null;
        this.state = null;
        this.salesPrice = null;
        this.deliveryAirport = null;
    }

    @Override
    public List<Component> getFocusComponents() {
        ArrayList<Component> focusList = new ArrayList<Component>();
        CheckedListAdder.addToList(focusList, this.customerNumber);
        CheckedListAdder.addToList(focusList, this.name);
        CheckedListAdder.addToList(focusList, this.state);
        CheckedListAdder.addToList(focusList, this.salesPrice);
        CheckedListAdder.addToList(focusList, this.deliveryAirport);
        return focusList;
    }

    @Override
    public void setNode(Node<?> node) {
        super.setNode(node);
        this.customerNumber.getElement().setNode(node.getChildNamed(ServiceProductVariantComplete_.customerProductNumber));
        this.name.getElement().setNode(node.getChildNamed(ServiceProductVariantComplete_.name));
        this.state.getElement().setNode(node.getChildNamed(ServiceProductVariantComplete_.state));
        this.state.getElement().refreshPossibleValues(NodeToolkit.getAffixList(ModificationStateE.class));
        if (node.getChildNamed(new DtoField[]{ServiceProductVariantComplete_.salesPrice, PriceComplete_.currency}).getValue() == null) {
            SystemSettingsComplete s = (SystemSettingsComplete)NodeToolkit.getAffixClass(SystemSettingsComplete.class).getValue();
            node.getChildNamed(new DtoField[]{ServiceProductVariantComplete_.salesPrice, PriceComplete_.currency}).setValue((Object)s.getCurrency(), 0L);
        }
        this.salesPrice.getElement().setNode(node.getChildNamed(new DtoField[]{ServiceProductVariantComplete_.salesPrice, PriceComplete_.price}), node.getChildNamed(new DtoField[]{ServiceProductVariantComplete_.salesPrice, PriceComplete_.currency}));
        if (!this.isNoPro) {
            this.deliveryAirport.getElement().setNode(node.getChildNamed(ServiceProductVariantComplete_.deliveryAirport));
        } else {
            node.getChildNamed(ServiceProductVariantComplete_.deliveryAirport).setValue((Object)this.settings.getHomeBase(), 0L);
        }
    }

    @Override
    public void switchState(Button.ButtonState newState) {
    }

    @Override
    public void valueChanged(Node<?> node) {
        this.stateChangedNow = true;
        this.editor.setEnabled(this.editor.isEnabled());
    }

    @Override
    public void childAdded(Node<?> source, Node<?> child) {
    }

    @Override
    public void childRemoved(Node<?> source, Node<?> child) {
    }

    @Override
    public void childrenAdded(Node<?> source, Node<?> ... nodes) {
    }

    @Override
    public boolean isSwingOnly() {
        return true;
    }

    private class Layout
    extends DefaultLayout {
        private Layout() {
        }

        @Override
        public Dimension preferredLayoutSize(Container parent) {
            int h = VariantSpecificationDetailsPanel.this.verticalBorder;
            h = (int)((double)h + VariantSpecificationDetailsPanel.this.name.getPreferredSize().getHeight());
            h += VariantSpecificationDetailsPanel.this.inner_verticalBorder;
            h = (int)((double)h + VariantSpecificationDetailsPanel.this.salesPrice.getPreferredSize().getHeight());
            h += VariantSpecificationDetailsPanel.this.inner_verticalBorder;
            h = (int)((double)h + VariantSpecificationDetailsPanel.this.state.getPreferredSize().getHeight());
            return new Dimension(0, h += VariantSpecificationDetailsPanel.this.verticalBorder);
        }

        @Override
        public void layoutContainer(Container parent) {
            int w2tl = (parent.getWidth() - 3 * VariantSpecificationDetailsPanel.this.horizontalBorder) / 2;
            VariantSpecificationDetailsPanel.this.customerNumber.setLocation(VariantSpecificationDetailsPanel.this.horizontalBorder, VariantSpecificationDetailsPanel.this.verticalBorder);
            VariantSpecificationDetailsPanel.this.customerNumber.setSize(w2tl, (int)VariantSpecificationDetailsPanel.this.customerNumber.getPreferredSize().getHeight());
            VariantSpecificationDetailsPanel.this.name.setLocation(VariantSpecificationDetailsPanel.this.customerNumber.getX() + VariantSpecificationDetailsPanel.this.customerNumber.getWidth() + VariantSpecificationDetailsPanel.this.horizontalBorder, VariantSpecificationDetailsPanel.this.verticalBorder);
            VariantSpecificationDetailsPanel.this.name.setSize(parent.getWidth() - (VariantSpecificationDetailsPanel.this.name.getX() + VariantSpecificationDetailsPanel.this.horizontalBorder), (int)VariantSpecificationDetailsPanel.this.name.getPreferredSize().getHeight());
            int currentX = VariantSpecificationDetailsPanel.this.horizontalBorder;
            int currentY = VariantSpecificationDetailsPanel.this.customerNumber.getY() + VariantSpecificationDetailsPanel.this.customerNumber.getHeight();
            if (!VariantSpecificationDetailsPanel.this.isNoPro) {
                VariantSpecificationDetailsPanel.this.deliveryAirport.setLocation(VariantSpecificationDetailsPanel.this.horizontalBorder, VariantSpecificationDetailsPanel.this.customerNumber.getY() + VariantSpecificationDetailsPanel.this.customerNumber.getHeight() + VariantSpecificationDetailsPanel.this.inner_verticalBorder);
                VariantSpecificationDetailsPanel.this.deliveryAirport.setSize(230, (int)VariantSpecificationDetailsPanel.this.deliveryAirport.getPreferredSize().getHeight());
                currentX = VariantSpecificationDetailsPanel.this.deliveryAirport.getX() + VariantSpecificationDetailsPanel.this.deliveryAirport.getWidth();
                currentY = VariantSpecificationDetailsPanel.this.deliveryAirport.getY();
            }
            VariantSpecificationDetailsPanel.this.salesPrice.setLocation(currentX + VariantSpecificationDetailsPanel.this.horizontalBorder, currentY);
            VariantSpecificationDetailsPanel.this.salesPrice.setSize(VariantSpecificationDetailsPanel.this.salesPrice.getPreferredSize());
            VariantSpecificationDetailsPanel.this.state.setLocation(VariantSpecificationDetailsPanel.this.horizontalBorder, VariantSpecificationDetailsPanel.this.salesPrice.getY() + VariantSpecificationDetailsPanel.this.salesPrice.getHeight() + VariantSpecificationDetailsPanel.this.inner_verticalBorder);
            VariantSpecificationDetailsPanel.this.state.setSize(120, (int)VariantSpecificationDetailsPanel.this.state.getPreferredSize().getHeight());
        }
    }
}

