/*
 * Decompiled with CFR 0.152.
 */
package ch.icit.pegasus.client.gui.modules.stock;

import ch.icit.pegasus.client.converter.DateConverter;
import ch.icit.pegasus.client.converter.InventoryPeriodConverter;
import ch.icit.pegasus.client.converter.PriceConverter1;
import ch.icit.pegasus.client.converter.StoreTypeConverter;
import ch.icit.pegasus.client.converter.StringConverter;
import ch.icit.pegasus.client.gui.modules.Module;
import ch.icit.pegasus.client.gui.modules.stock.StockModuleDataHandler;
import ch.icit.pegasus.client.gui.modules.stock.details.ProductCountDetailsPanel;
import ch.icit.pegasus.client.gui.modules.stock.details.ProductStockDetailsPanel;
import ch.icit.pegasus.client.gui.modules.stock.details.RecipeCountDetailsPanel;
import ch.icit.pegasus.client.gui.modules.stock.details.RecipeStockDetailsPanel;
import ch.icit.pegasus.client.gui.modules.stock.details.StockContentDetailsPanel;
import ch.icit.pegasus.client.gui.screentemplates.overview.ScreenTableView;
import ch.icit.pegasus.client.gui.screentemplates.overview.data.IDataHandler;
import ch.icit.pegasus.client.gui.table.RowEditor;
import ch.icit.pegasus.client.gui.table.RowEditorFactory;
import ch.icit.pegasus.client.gui.table.RowModel;
import ch.icit.pegasus.client.gui.table.RowPanel;
import ch.icit.pegasus.client.gui.table.Table;
import ch.icit.pegasus.client.gui.table.TableColumnInfo;
import ch.icit.pegasus.client.gui.utils.TableLayoutConstraint;
import ch.icit.pegasus.client.gui.utils.buttons.TextButton;
import ch.icit.pegasus.client.gui.utils.combobox.ComboBox;
import ch.icit.pegasus.client.gui.utils.combobox.ComboBoxFactory;
import ch.icit.pegasus.client.gui.utils.filterchain.FilterChainConfiguration;
import ch.icit.pegasus.client.gui.utils.rightdependant.RDProvider;
import ch.icit.pegasus.client.node.impls.Node;
import ch.icit.pegasus.client.node.impls.NodeToolkit;
import ch.icit.pegasus.client.search.SearchAlgorithm;
import ch.icit.pegasus.client.search.controller.SearchAlgorithmRegistry;
import ch.icit.pegasus.client.search.impls.remote.StoreSearchAlgorithm;
import ch.icit.pegasus.client.services.ServiceManagerRegistry;
import ch.icit.pegasus.client.services.interfaces.system.UserServiceManager;
import ch.icit.pegasus.server.core.dtos.auth.UserComplete;
import ch.icit.pegasus.server.core.dtos.inventory.InventoryReference;
import ch.icit.pegasus.server.core.dtos.rightmanagement.access.SubModuleAccessRightComplete;
import ch.icit.pegasus.server.core.dtos.rightmanagement.definition.SubModuleDefinitionComplete;
import ch.icit.pegasus.server.core.dtos.rightmanagement.template.AccessDefinitionComplete;
import ch.icit.pegasus.server.core.dtos.rightmanagement.template.def.StoreAccess;
import ch.icit.pegasus.server.core.dtos.search.StoreSearchConfiguration;
import ch.icit.pegasus.server.core.dtos.store.StoreLight;
import ch.icit.pegasus.server.core.dtos.store.StoreLight_;
import ch.icit.pegasus.server.core.dtos.store.StoreTypeE;
import ch.icit.pegasus.server.core.dtos.system.SystemSettingsComplete;
import ch.icit.pegasus.server.core.dtos.system.SystemViewSettingsComplete;
import ch.icit.pegasus.server.core.dtos.utils.CompanyUtil;
import ch.icit.pegasus.server.core.dtos.utils.StoreToolkit;
import ch.icit.pegasus.server.core.dtos.utils.TransactionType;
import ch.icit.pegasus.server.core.general.ASearchConfiguration;
import ch.icit.pegasus.server.core.i18n.Words;
import ch.icit.pegasus.server.core.search.SortDirection;
import java.awt.Component;
import java.util.ArrayList;
import java.util.List;

public class StockModule
extends ScreenTableView<StoreLight, StoreSearchConfiguration.STORE_COLUMN>
implements Module {
    private static final long serialVersionUID = 1L;
    private static final String FILTER_NAME = "name";
    private static final String FILTER_CONSUMPTION_STORES = "consumptions";
    private ComboBox showBox;
    private String filterCriteria1 = null;
    private StoreTypeE filterCriteria5 = null;

    public StockModule() {
        super(StoreLight.class);
        this.isSynchronSearch = false;
    }

    @Override
    public void kill() {
        if (this.isKilled()) {
            return;
        }
        super.kill();
        this.showBox.kill();
        this.showBox = null;
    }

    @Override
    public AccessDefinitionComplete getInvoker() {
        return StoreAccess.MODULE_STORE;
    }

    @Override
    public FilterChainConfiguration getDefaultConfiguration() {
        FilterChainConfiguration c = new FilterChainConfiguration();
        c.addProperty("sortedColumn", StoreSearchConfiguration.STORE_COLUMN.CODE + "<>" + true);
        return c;
    }

    @Override
    protected void createFilterChain(long id) {
        SystemSettingsComplete settings = (SystemSettingsComplete)NodeToolkit.getAffixClass(SystemSettingsComplete.class).getValue();
        if (Boolean.TRUE.equals(settings.getCompany().getSolarCompanyType())) {
            this.filterChain.setResetButtonWidth(120);
        }
        this.filterChain.addSearchField(FILTER_NAME, Words.NAME, "");
        this.showBox = ComboBoxFactory.getStoreTypeComboBox(true);
        this.filterChain.addSelectionComboBox(this.showBox, 100, FILTER_CONSUMPTION_STORES, Words.STORE_TYPE, Words.ALL);
        this.filterChain.addResetButton();
    }

    @Override
    public ASearchConfiguration<StoreLight, StoreSearchConfiguration.STORE_COLUMN> getModuleSearchParameters(Object name, Object value, boolean isReset, boolean getEmptyConfig, Component source) {
        if (isReset) {
            this.filterCriteria1 = null;
            this.filterCriteria5 = null;
        } else if (name == FILTER_NAME) {
            this.filterCriteria1 = (String)value;
        } else if (name == FILTER_CONSUMPTION_STORES) {
            this.filterCriteria5 = value instanceof StoreTypeE ? (StoreTypeE)value : null;
        }
        StoreSearchConfiguration c = new StoreSearchConfiguration();
        c.setCodeAndName(this.filterCriteria1);
        c.setNumResults(this.numberOfShownResults);
        c.setStoreType(this.filterCriteria5);
        if (this.currentColumnAttribute != null) {
            c.setSortColumn(this.currentColumnAttribute);
        }
        if (this.isAsc) {
            c.setSortDirection(SortDirection.ASCENDING);
        } else {
            c.setSortDirection(SortDirection.DESCENDING);
        }
        if (source == this.pagination) {
            c.setPageNumber(this.pagination.getCurrentPage() - 1);
        } else {
            c.setPageNumber(0);
        }
        if (c.getPageNumber() < 0) {
            c.setPageNumber(0);
        }
        return c;
    }

    @Override
    public void remoteObjectLoaded(Node<?> node) {
        super.remoteObjectLoaded(node);
    }

    @Override
    public SearchAlgorithm<StoreLight> getSearchAlgorithm() {
        return SearchAlgorithmRegistry.getSearchAlgorithm(StoreSearchAlgorithm.class);
    }

    @Override
    public boolean isAnalysisModuleAllowed(SubModuleAccessRightComplete subModule) {
        if (subModule.getModule().getInvokingName().equals(StoreAccess.ANALYSIS_STORE_BARCODE.getIdentifier())) {
            return true;
        }
        return super.isAnalysisModuleAllowed(subModule);
    }

    @Override
    public boolean isSmartScreenAllowed(SubModuleDefinitionComplete screen, RowModel<StoreLight> model) {
        InventoryReference inProgress = (InventoryReference)model.getNode().getChildNamed(StoreLight_.inventoryInProgress).getValue();
        boolean blocked = (Boolean)model.getNode().getChildNamed(StoreLight_.blockedByInventory).getValue();
        boolean moveAnyway = this.getCurrentProvider().isWritable(StoreAccess.CAN_MOVE_CHARGE_WHEN_INVENTORY_IS_ACTIVE);
        if (screen.getInvokingName().equals(StoreAccess.TOOL_STORE_MOVEMENT_CB.getIdentifier()) || screen.getInvokingName().equals(StoreAccess.TOOL_STORE_MOVEMENT_PB.getIdentifier())) {
            if (moveAnyway) {
                return true;
            }
            if (inProgress != null) {
                return !blocked;
            }
        } else if (screen.getInvokingName().equals(StoreAccess.TOOL_STORE_INVENTORY_CB.getIdentifier()) || screen.getInvokingName().equals(StoreAccess.TOOL_STORE_INVENTORY_PB.getIdentifier()) || screen.getInvokingName().equals(StoreAccess.ACTION_STORE_INVENTORY_PRODUCTS.getIdentifier()) || screen.getInvokingName().equals(StoreAccess.ACTION_STORE_INVENTORY_RECIPES.getIdentifier()) || screen.getInvokingName().equals(StoreAccess.ACTION_STORE_INVENTORY_PRODUCT_CHARGE_COUNT.getIdentifier()) || screen.getInvokingName().equals(StoreAccess.ACTION_STORE_INVENTORY_RECIPE_CHARGE_COUNT.getIdentifier())) {
            UserComplete currentUser = ((UserServiceManager)ServiceManagerRegistry.getService(UserServiceManager.class)).getCurrentUser();
            SystemSettingsComplete settings = (SystemSettingsComplete)NodeToolkit.getAffixClass(SystemSettingsComplete.class).getValue();
            StoreLight store = (StoreLight)model.getNode().getValue();
            if (!StoreToolkit.isAllowed((StoreLight)store, (TransactionType)TransactionType.INVENTORY, (UserComplete)currentUser, (SystemSettingsComplete)settings)) {
                return false;
            }
            if (screen.getInvokingName().equals(StoreAccess.ACTION_STORE_INVENTORY_PRODUCTS.getIdentifier()) || screen.getInvokingName().equals(StoreAccess.ACTION_STORE_INVENTORY_PRODUCT_CHARGE_COUNT.getIdentifier())) {
                if (!Boolean.TRUE.equals(settings.getInventoryProductCountActive())) {
                    return false;
                }
                if (inProgress != null) {
                    return blocked;
                }
                return false;
            }
            if (screen.getInvokingName().equals(StoreAccess.ACTION_STORE_INVENTORY_RECIPES.getIdentifier()) || screen.getInvokingName().equals(StoreAccess.ACTION_STORE_INVENTORY_RECIPE_CHARGE_COUNT.getIdentifier())) {
                if (!Boolean.TRUE.equals(settings.getInventoryRecipeCountActive())) {
                    return false;
                }
                if (inProgress != null) {
                    return blocked;
                }
                return false;
            }
            if (inProgress != null) {
                return blocked;
            }
            boolean disablePermanentInventory = ((SystemSettingsComplete)NodeToolkit.getAffixClass(SystemSettingsComplete.class).getValue()).getDisablePermanentInventory();
            if (disablePermanentInventory) {
                return false;
            }
        } else if (screen.getInvokingName().equals(StoreAccess.ACTION_STORE_RESTORE_STOCK.getIdentifier())) {
            StoreLight store = (StoreLight)model.getNode().getValue();
            return store.getStoreType() == StoreTypeE.CONSUMPTION;
        }
        return model != null;
    }

    @Override
    public boolean isDeletable(RowModel<StoreLight> model) {
        return false;
    }

    @Override
    protected Table.SmartIconConfiguration getPossibleSmartIcons() {
        return Table.SmartIconConfiguration.TWO;
    }

    @Override
    protected RowEditorFactory<StoreLight> getRowEditorFactory() {
        return model -> {
            SystemSettingsComplete s;
            RowEditor<StoreLight> rowEditor = new RowEditor<StoreLight>(model);
            rowEditor.setIgnoreCancelQuestion(true);
            rowEditor.hideCloseButton();
            rowEditor.setCancelButtonText(TextButton.BUTTON_TYPES.CLOSE);
            RDProvider p = this.createProvider(model.isAddRow());
            StockContentDetailsPanel d1 = new StockContentDetailsPanel(rowEditor, p, ((UserServiceManager)ServiceManagerRegistry.getService(UserServiceManager.class)).getCurrentUser());
            rowEditor.add(d1, (Object)new TableLayoutConstraint(0, 0, 1.0, 1.0));
            SystemViewSettingsComplete settings = (SystemViewSettingsComplete)NodeToolkit.getAffixClass(SystemViewSettingsComplete.class).getValue();
            int count = 1;
            if (Boolean.TRUE.equals(settings.getShowProductStock())) {
                ProductStockDetailsPanel productStock = new ProductStockDetailsPanel(rowEditor, p);
                rowEditor.add(productStock, (Object)new TableLayoutConstraint(0, count++, 1.0, 1.0));
            }
            if (Boolean.TRUE.equals(settings.getShowRecipeStock())) {
                RecipeStockDetailsPanel recipeStock = new RecipeStockDetailsPanel(rowEditor, p);
                rowEditor.add(recipeStock, (Object)new TableLayoutConstraint(0, count++, 1.0, 1.0));
            }
            if (CompanyUtil.isFPB((SystemSettingsComplete)(s = (SystemSettingsComplete)NodeToolkit.getAffixClass(SystemSettingsComplete.class).getValue()))) {
                RecipeCountDetailsPanel recipeStock = new RecipeCountDetailsPanel(rowEditor, p);
                ProductCountDetailsPanel productStock = new ProductCountDetailsPanel(rowEditor, p);
                rowEditor.add(recipeStock, (Object)new TableLayoutConstraint(0, count++, 1.0, 1.0));
                rowEditor.add(productStock, (Object)new TableLayoutConstraint(0, count++, 1.0, 1.0));
            }
            rowEditor.allInstalled();
            rowEditor.setVisibleContainer(this.getTable());
            return rowEditor;
        };
    }

    @Override
    protected RowPanel<StoreLight> getNewAddRow() {
        return null;
    }

    @Override
    protected IDataHandler getModuleDataHandler() {
        return new StockModuleDataHandler(this.loadingId, this);
    }

    @Override
    protected List<TableColumnInfo> getTableColumnInfo() {
        SystemSettingsComplete settings = (SystemSettingsComplete)NodeToolkit.getAffixClass(SystemSettingsComplete.class).getValue();
        ArrayList<TableColumnInfo> info = new ArrayList<TableColumnInfo>();
        info.add(new TableColumnInfo(Words.NAME, "", (Class)StringConverter.class, (Enum<?>)StoreSearchConfiguration.STORE_COLUMN.NAME, StoreLight_.name, 80, Integer.MAX_VALUE, 80));
        info.add(new TableColumnInfo(Words.CODE, "", (Class)StringConverter.class, (Enum<?>)StoreSearchConfiguration.STORE_COLUMN.CODE, StoreLight_.code, 30, Integer.MAX_VALUE, 30));
        info.add(new TableColumnInfo(Words.TYPE, "", (Class)StoreTypeConverter.class, (Enum<?>)StoreSearchConfiguration.STORE_COLUMN.STORE_TYPE, StoreLight_.storeType, 150, 150, 150));
        if (Boolean.TRUE.equals(settings.getCompany().getSolarCompanyType())) {
            info.add(new TableColumnInfo(Words.NEXT_EXPIRY, "", (Class)DateConverter.class, (Enum<?>)StoreSearchConfiguration.STORE_COLUMN.NEXT_EXPIRY, StoreLight_.nextExpiryDate, TableColumnInfo.dateColumnWidth + 10, TableColumnInfo.dateColumnWidth + 10, TableColumnInfo.dateColumnWidth + 10));
        } else {
            info.add(new TableColumnInfo(Words.NEXT_EXPIRY, "", (Class)DateConverter.class, (Enum<?>)StoreSearchConfiguration.STORE_COLUMN.NEXT_EXPIRY, StoreLight_.nextExpiryDate, TableColumnInfo.dateColumnWidth, TableColumnInfo.dateColumnWidth, TableColumnInfo.dateColumnWidth));
        }
        info.add(new TableColumnInfo(Words.VALUE, "", (Class)PriceConverter1.class, (Enum<?>)StoreSearchConfiguration.STORE_COLUMN.VALUE, StoreLight_.totalCost, TableColumnInfo.priceColumnWidth + 20, TableColumnInfo.priceColumnWidth + 20, TableColumnInfo.priceColumnWidth + 20));
        info.add(new TableColumnInfo(Words.INVENTORY_PERIOD, "", (Class)InventoryPeriodConverter.class, (Enum<?>)StoreSearchConfiguration.STORE_COLUMN.INVENTORY_PERIOD, StoreLight_.inventoryPeriod, TableColumnInfo.periodColumnWidth, TableColumnInfo.periodColumnWidth, TableColumnInfo.periodColumnWidth));
        return info;
    }
}

