/*
 * Decompiled with CFR 0.152.
 */
package ch.icit.pegasus.client.gui.modules.tradegoods.details;

import ch.icit.pegasus.client.converter.ModificationStateEConverter;
import ch.icit.pegasus.client.converter.controller.ConverterRegistry;
import ch.icit.pegasus.client.gui.screentemplates.details.StateDependantDetailsPanel;
import ch.icit.pegasus.client.gui.table.RowEditor;
import ch.icit.pegasus.client.gui.utils.CheckedListAdder;
import ch.icit.pegasus.client.gui.utils.DefaultLayout;
import ch.icit.pegasus.client.gui.utils.LocationUtil;
import ch.icit.pegasus.client.gui.utils.TextLabel;
import ch.icit.pegasus.client.gui.utils.TitledItem;
import ch.icit.pegasus.client.gui.utils.buttons.Button;
import ch.icit.pegasus.client.gui.utils.rightdependant.RDComboBox;
import ch.icit.pegasus.client.gui.utils.rightdependant.RDDateChooser;
import ch.icit.pegasus.client.gui.utils.rightdependant.RDMultiLocationComboBox;
import ch.icit.pegasus.client.gui.utils.rightdependant.RDProvider;
import ch.icit.pegasus.client.gui.utils.rightdependant.RDSearchTextField2;
import ch.icit.pegasus.client.gui.utils.rightdependant.RDTextField;
import ch.icit.pegasus.client.node.impls.Node;
import ch.icit.pegasus.client.node.impls.NodeListener;
import ch.icit.pegasus.client.node.impls.NodeToolkit;
import ch.icit.pegasus.client.util.ScreenValidationObject;
import ch.icit.pegasus.server.core.dtos.ILocalizedDTO;
import ch.icit.pegasus.server.core.dtos.masterdata.ModificationStateE;
import ch.icit.pegasus.server.core.dtos.rightmanagement.template.def.TradeGoodsAccess;
import ch.icit.pegasus.server.core.dtos.tradegoods.TradeGoodsComplete_;
import ch.icit.pegasus.server.core.dtos.tradegoods.TradeGoodsLight;
import ch.icit.pegasus.server.core.dtos.tradegoods.TradeGoodsLight_;
import ch.icit.pegasus.server.core.i18n.Words;
import ch.icit.pegasus.server.dtos.metamodel.DtoField;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.util.ArrayList;
import java.util.List;

public class SpecificationDetailsPanel
extends StateDependantDetailsPanel<TradeGoodsLight>
implements NodeListener {
    private static final long serialVersionUID = 1L;
    private TitledItem<RDSearchTextField2> customer;
    private TitledItem<RDTextField> name;
    private TitledItem<TextLabel> number;
    private TitledItem<RDDateChooser> date;
    private TitledItem<RDComboBox> state;
    private TitledItem<RDMultiLocationComboBox> locations;
    private TitledItem<RDSearchTextField2> deliveryAirport;
    private boolean stateChangedNow;
    private TextLabel isInvoicedMessage;

    public SpecificationDetailsPanel(RowEditor<TradeGoodsLight> editor, RDProvider provider) {
        super(editor, provider);
        this.setTitleText(Words.SPECIFICATION);
        this.customer = new TitledItem<RDSearchTextField2<RDSearchTextField2>>(new RDSearchTextField2(provider, RDSearchTextField2.SearchTypes.CUSTOMER), Words.CUSTOMER, TitledItem.TitledItemOrientation.NORTH);
        this.name = new TitledItem<RDTextField>(new RDTextField(provider), Words.DELIVERY_NAME, TitledItem.TitledItemOrientation.NORTH);
        this.number = new TitledItem<TextLabel>(new TextLabel(), Words.NO_NUMBER, TitledItem.TitledItemOrientation.NORTH);
        this.number.getElement().setReadOnlyTextField(true);
        this.date = new TitledItem<RDDateChooser>(new RDDateChooser(provider), Words.DELIVERY_DATE, TitledItem.TitledItemOrientation.NORTH);
        this.state = new TitledItem<RDComboBox>(new RDComboBox(provider, ConverterRegistry.getConverter(ModificationStateEConverter.class)), Words.STATE, TitledItem.TitledItemOrientation.NORTH);
        if (Boolean.TRUE.equals(this.viewSettings.getShowLocation())) {
            this.locations = new TitledItem<RDMultiLocationComboBox>(new RDMultiLocationComboBox(provider, true), Words.LOCATIONS, TitledItem.TitledItemOrientation.NORTH);
        }
        this.deliveryAirport = new TitledItem<RDSearchTextField2<RDSearchTextField2>>(new RDSearchTextField2(provider, RDSearchTextField2.SearchTypes.AIRPORT, true), Words.DELIVERY_AIRPORT, TitledItem.TitledItemOrientation.NORTH);
        this.isInvoicedMessage = new TextLabel();
        this.setCustomLayouter(new Layout());
        this.addToView(this.customer);
        this.addToView(this.name);
        this.addToView(this.number);
        this.addToView(this.date);
        this.addToView(this.state);
        if (Boolean.TRUE.equals(this.viewSettings.getShowLocation())) {
            this.addToView(this.locations);
        }
        this.addToView(this.deliveryAirport);
        this.addToView(this.isInvoicedMessage);
    }

    @Override
    public DtoField<ModificationStateE> getStateChildName() {
        return TradeGoodsLight_.state;
    }

    @Override
    public List<ScreenValidationObject> validateParagraph() {
        ArrayList<ScreenValidationObject> validationObjects = new ArrayList<ScreenValidationObject>();
        if (this.customer.getElement().isWritable() && !this.customer.getElement().isItemSelected()) {
            this.customer.getElement().setInvalid();
            validationObjects.add(new ScreenValidationObject(ScreenValidationObject.ValidationStateE.FATAL, Words.CUSTOMER_MUST_BE_SET));
        }
        if (this.name.getElement().isWritable() && (this.name.getElement().getNode().getValue() == null || ((String)this.name.getElement().getNode().getValue()).isEmpty())) {
            this.name.getElement().setInvalid();
            validationObjects.add(new ScreenValidationObject(ScreenValidationObject.ValidationStateE.FATAL, Words.NAME_MUST_BE_SET));
        }
        if (this.date.getElement().isWritable() && this.date.getElement().getNode().getValue() == null) {
            this.date.getElement().setInvalid();
            validationObjects.add(new ScreenValidationObject(ScreenValidationObject.ValidationStateE.FATAL, Words.DATE_MUST_BE_SET));
        }
        if (Boolean.TRUE.equals(this.viewSettings.getShowLocation()) && this.locations.getElement().isWritable() && this.locations.getElement().getNode().getChildCount() != 1) {
            this.locations.getElement().setInvalid();
            validationObjects.add(new ScreenValidationObject(ScreenValidationObject.ValidationStateE.FATAL, Words.ENSURE_EXCALTY_ONE_LOCATION_IS_SET));
        }
        if (this.state.getElement().isWritable() && this.editor.getModel().getNode().getChildNamed(TradeGoodsLight_.state).getValue() == ModificationStateE.DRAFT && ((Boolean)this.editor.getModel().getNode().getChildNamed(TradeGoodsLight_.isInvoiced).getValue()).booleanValue()) {
            validationObjects.add(new ScreenValidationObject(ScreenValidationObject.ValidationStateE.FATAL, Words.INVOICED_TRADE_GOODS_CAN_T_BE_SET_TO_PLANNED));
        }
        return validationObjects;
    }

    @Override
    public void setEnabled(boolean isEnabled) {
        boolean isInvoiced;
        boolean isDraft = true;
        if (this.node != null) {
            isDraft = this.node.getChildNamed(TradeGoodsLight_.state).getValue() != ModificationStateE.ACCEPTED;
        }
        boolean canReDraftIfInvoiced = true;
        boolean canReDraftIfAccepted = true;
        if (!isDraft) {
            if (this.stateChangedNow) {
                canReDraftIfAccepted = true;
            } else {
                canReDraftIfInvoiced = this.provider.isWritable(TradeGoodsAccess.REDRAFT_ACCEPTED);
            }
        }
        if (isInvoiced = ((Boolean)this.editor.getModel().getNode().getChildNamed(TradeGoodsLight_.isInvoiced).getValue()).booleanValue()) {
            canReDraftIfInvoiced = this.provider.isWritable(TradeGoodsAccess.REDRAFT_INVOICED);
        }
        boolean b = isEnabled && isDraft;
        super.setEnabled(b);
        this.customer.setEnabled(b);
        this.name.setEnabled(b);
        this.number.setEnabled(b);
        this.date.setEnabled(b);
        if (isInvoiced) {
            this.state.setEnabled(isEnabled && canReDraftIfInvoiced);
        } else {
            this.state.setEnabled(isEnabled && canReDraftIfAccepted);
        }
        if (Boolean.TRUE.equals(this.viewSettings.getShowLocation())) {
            this.locations.setEnabled(b);
        }
        this.deliveryAirport.setEnabled(b);
        this.isInvoicedMessage.setEnabled(isEnabled);
    }

    @Override
    public void kill() {
        if (this.isKilled()) {
            return;
        }
        super.kill();
        if (this.node != null) {
            this.node.getChildNamed(TradeGoodsLight_.state).removeNodeListener((NodeListener)this);
        }
        this.customer.kill();
        this.name.kill();
        this.number.kill();
        this.date.kill();
        this.state.kill();
        if (Boolean.TRUE.equals(this.viewSettings.getShowLocation())) {
            this.locations.kill();
        }
        this.deliveryAirport.kill();
        this.isInvoicedMessage.kill();
        this.customer = null;
        this.name = null;
        this.number = null;
        this.date = null;
        this.state = null;
        this.locations = null;
        this.deliveryAirport = null;
        this.isInvoicedMessage = null;
    }

    @Override
    public List<Component> getFocusComponents() {
        ArrayList<Component> focusList = new ArrayList<Component>();
        CheckedListAdder.addToList(focusList, this.customer);
        CheckedListAdder.addToList(focusList, this.name);
        CheckedListAdder.addToList(focusList, this.date);
        CheckedListAdder.addToList(focusList, this.state);
        CheckedListAdder.addToList(focusList, this.locations);
        CheckedListAdder.addToList(focusList, this.deliveryAirport);
        return focusList;
    }

    @Override
    public void setNode(Node<?> node) {
        super.setNode(node);
        if (this.editor.getModel().isAddRow()) {
            TradeGoodsLight dto = (TradeGoodsLight)node.getValue();
            LocationUtil.ensureCurrentLocation((ILocalizedDTO)dto);
        }
        this.customer.getElement().setNode(node.getChildNamed(TradeGoodsLight_.customer));
        this.name.getElement().setNode(node.getChildNamed(TradeGoodsLight_.sellName));
        this.number.getElement().setNode(node.getChildNamed(TradeGoodsLight_.number));
        this.date.getElement().setNode(node.getChildNamed(TradeGoodsLight_.sellDate));
        this.state.getElement().refreshPossibleValues(NodeToolkit.getAffixList(ModificationStateE.class));
        this.state.getElement().setNode(node.getChildNamed(TradeGoodsLight_.state));
        if (Boolean.TRUE.equals(this.viewSettings.getShowLocation())) {
            this.locations.getElement().setNode(node.getChildNamed(TradeGoodsLight_.eligibleLocations));
        }
        this.deliveryAirport.getElement().setNode(node.getChildNamed(TradeGoodsComplete_.deliveryAirport));
        if (((Boolean)node.getChildNamed(TradeGoodsLight_.isInvoiced).getValue()).booleanValue()) {
            this.isInvoicedMessage.setText(Words.TRADE_GOOD_IS_ALREADY_INVOICED);
        } else {
            this.isInvoicedMessage.setText("");
        }
    }

    @Override
    public void requestFocusInWindowNow() {
        this.customer.getElement().requestFocusInWindowNow();
    }

    @Override
    public void switchState(Button.ButtonState newState) {
    }

    @Override
    public void valueChanged(Node<?> node) {
        this.stateChangedNow = true;
        this.editor.setEnabled(this.editor.isEnabled());
    }

    @Override
    public void childAdded(Node<?> source, Node<?> child) {
    }

    @Override
    public void childRemoved(Node<?> source, Node<?> child) {
    }

    @Override
    public void childrenAdded(Node<?> source, Node<?> ... nodes) {
    }

    @Override
    public boolean isSwingOnly() {
        return true;
    }

    private class Layout
    extends DefaultLayout {
        private Layout() {
        }

        @Override
        public Dimension preferredLayoutSize(Container parent) {
            int h = SpecificationDetailsPanel.this.verticalBorder;
            h = (int)((double)h + SpecificationDetailsPanel.this.customer.getPreferredSize().getHeight());
            h += SpecificationDetailsPanel.this.inner_verticalBorder;
            h = (int)((double)h + SpecificationDetailsPanel.this.name.getPreferredSize().getHeight());
            h += SpecificationDetailsPanel.this.inner_verticalBorder;
            h = (int)((double)h + SpecificationDetailsPanel.this.date.getPreferredSize().getHeight());
            h += SpecificationDetailsPanel.this.verticalBorder;
            h = (int)((double)h + SpecificationDetailsPanel.this.state.getPreferredSize().getHeight());
            h += SpecificationDetailsPanel.this.inner_verticalBorder;
            h = (int)((double)h + SpecificationDetailsPanel.this.deliveryAirport.getPreferredSize().getHeight());
            h += SpecificationDetailsPanel.this.verticalBorder;
            h = (int)((double)h + SpecificationDetailsPanel.this.isInvoicedMessage.getPreferredSize().getHeight());
            return new Dimension(0, h += SpecificationDetailsPanel.this.verticalBorder);
        }

        @Override
        public void layoutContainer(Container parent) {
            int w = parent.getWidth() - 2 * SpecificationDetailsPanel.this.horizontalBorder;
            SpecificationDetailsPanel.this.customer.setLocation(SpecificationDetailsPanel.this.horizontalBorder, SpecificationDetailsPanel.this.verticalBorder);
            SpecificationDetailsPanel.this.customer.setSize(w, (int)SpecificationDetailsPanel.this.customer.getPreferredSize().getHeight());
            SpecificationDetailsPanel.this.name.setLocation(SpecificationDetailsPanel.this.horizontalBorder, SpecificationDetailsPanel.this.customer.getY() + SpecificationDetailsPanel.this.customer.getHeight() + SpecificationDetailsPanel.this.inner_verticalBorder);
            SpecificationDetailsPanel.this.name.setSize((w -= SpecificationDetailsPanel.this.inner_horizontalBorder) / 3 * 2, (int)SpecificationDetailsPanel.this.name.getPreferredSize().getHeight());
            SpecificationDetailsPanel.this.number.setLocation(SpecificationDetailsPanel.this.name.getX() + SpecificationDetailsPanel.this.name.getWidth() + SpecificationDetailsPanel.this.inner_horizontalBorder, SpecificationDetailsPanel.this.name.getY());
            SpecificationDetailsPanel.this.number.setSize(w / 3, (int)SpecificationDetailsPanel.this.number.getPreferredSize().getHeight());
            SpecificationDetailsPanel.this.date.setLocation(SpecificationDetailsPanel.this.horizontalBorder, SpecificationDetailsPanel.this.name.getY() + SpecificationDetailsPanel.this.name.getHeight() + SpecificationDetailsPanel.this.verticalBorder);
            SpecificationDetailsPanel.this.date.setSize(SpecificationDetailsPanel.this.date.getPreferredSize());
            SpecificationDetailsPanel.this.state.setLocation(SpecificationDetailsPanel.this.horizontalBorder, SpecificationDetailsPanel.this.date.getY() + SpecificationDetailsPanel.this.date.getHeight() + SpecificationDetailsPanel.this.inner_verticalBorder);
            SpecificationDetailsPanel.this.state.setSize(150, (int)SpecificationDetailsPanel.this.state.getPreferredSize().getHeight());
            int cy = SpecificationDetailsPanel.this.state.getY() + SpecificationDetailsPanel.this.state.getHeight();
            if (Boolean.TRUE.equals(SpecificationDetailsPanel.this.viewSettings.getShowLocation())) {
                SpecificationDetailsPanel.this.locations.setLocation(SpecificationDetailsPanel.this.state.getX() + SpecificationDetailsPanel.this.state.getWidth() + SpecificationDetailsPanel.this.horizontalBorder, SpecificationDetailsPanel.this.state.getY());
                SpecificationDetailsPanel.this.locations.setSize(SpecificationDetailsPanel.this.locations.getPreferredSize());
                cy = SpecificationDetailsPanel.this.locations.getY() + SpecificationDetailsPanel.this.locations.getHeight();
            }
            SpecificationDetailsPanel.this.deliveryAirport.setLocation(SpecificationDetailsPanel.this.horizontalBorder, cy + SpecificationDetailsPanel.this.inner_verticalBorder);
            SpecificationDetailsPanel.this.deliveryAirport.setSize(parent.getWidth() - SpecificationDetailsPanel.this.deliveryAirport.getX() * 2, (int)SpecificationDetailsPanel.this.deliveryAirport.getPreferredSize().getHeight());
            SpecificationDetailsPanel.this.isInvoicedMessage.setLocation(SpecificationDetailsPanel.this.horizontalBorder, SpecificationDetailsPanel.this.deliveryAirport.getY() + SpecificationDetailsPanel.this.deliveryAirport.getHeight() + SpecificationDetailsPanel.this.verticalBorder);
            SpecificationDetailsPanel.this.isInvoicedMessage.setSize(parent.getWidth() - 2 * SpecificationDetailsPanel.this.horizontalBorder, (int)SpecificationDetailsPanel.this.isInvoicedMessage.getPreferredSize().getHeight());
        }
    }
}

