/*
 * Decompiled with CFR 0.152.
 */
package ch.icit.pegasus.client.gui.modules.truck;

import ch.icit.pegasus.client.gui.screentemplates.overview.ScreenTableView;
import ch.icit.pegasus.client.gui.screentemplates.overview.data.DefaultDataHandler;
import ch.icit.pegasus.client.node.INodeCreator;
import ch.icit.pegasus.client.node.impls.Node;
import ch.icit.pegasus.client.services.ServiceManagerRegistry;
import ch.icit.pegasus.client.services.interfaces.masterdata.MasterDataServiceManager;
import ch.icit.pegasus.client.services.interfaces.system.SystemSettingsServiceManager;
import ch.icit.pegasus.client.services.interfaces.system.UserServiceManager;
import ch.icit.pegasus.client.services.interfaces.tracking.TruckServiceManager;
import ch.icit.pegasus.client.util.ProgressListener;
import ch.icit.pegasus.client.util.RemoteLoader;
import ch.icit.pegasus.client.util.async.ThreadSafeExecutable;
import ch.icit.pegasus.client.util.async.ThreadSafeLoader;
import ch.icit.pegasus.server.core.dtos.ADTO;
import ch.icit.pegasus.server.core.dtos.tracking.TruckComplete;
import ch.icit.pegasus.server.core.dtos.tracking.TruckTypeComplete;

public class TruckModuleDataHandler
extends DefaultDataHandler<TruckComplete, TruckComplete> {
    public TruckModuleDataHandler(long id, ScreenTableView tableView) {
        super(id, tableView);
    }

    @Override
    public String getRemoteValidationText() {
        return null;
    }

    @Override
    public boolean reloadDataBeforeOpening(final Node node, final RemoteLoader listener, ProgressListener progressListener) {
        this.showMessage(progressListener, "Refresh Truck");
        ThreadSafeExecutable run = new ThreadSafeExecutable(this){

            @Override
            public Node<?> loadData() throws Exception {
                TruckComplete truck = (TruckComplete)node.getValue(TruckComplete.class);
                TruckComplete ntruck = (TruckComplete)((TruckServiceManager)ServiceManagerRegistry.getService(TruckServiceManager.class)).getTruck(truck).getValue();
                node.removeExistingValues();
                node.setValue((Object)ntruck, 0L);
                node.updateNode();
                return node;
            }

            @Override
            public RemoteLoader getInvoker() {
                return listener;
            }

            @Override
            public long getID() {
                return 0L;
            }
        };
        ThreadSafeLoader.run(run);
        return true;
    }

    @Override
    public void updateData(final Node<TruckComplete> node, final RemoteLoader model, ProgressListener l) {
        ThreadSafeExecutable run = new ThreadSafeExecutable(this){

            @Override
            public Node<?> loadData() throws Exception {
                TruckComplete d = (TruckComplete)node.getValue(TruckComplete.class);
                TruckComplete dto = (TruckComplete)((TruckServiceManager)ServiceManagerRegistry.getService(TruckServiceManager.class)).update(d).getValue();
                node.removeExistingValues();
                node.setValue((Object)dto, 0L);
                node.updateNode();
                return node;
            }

            @Override
            public RemoteLoader getInvoker() {
                return model;
            }

            @Override
            public long getID() {
                return System.currentTimeMillis();
            }
        };
        ThreadSafeLoader.run(run);
    }

    @Override
    public Node<TruckComplete> createEmptyNode() {
        TruckComplete d = new TruckComplete();
        d.setClientOId(Long.valueOf(ADTO.getNextId()));
        Node n = INodeCreator.getDefaultImpl().getNode4DTO((Object)d, false, false);
        return n;
    }

    @Override
    public void createNewData(final Node<TruckComplete> node, final RemoteLoader model, boolean sameNode, ProgressListener l) {
        ThreadSafeExecutable run = new ThreadSafeExecutable(this){

            @Override
            public Node<?> loadData() throws Exception {
                TruckComplete d = (TruckComplete)node.getValue(TruckComplete.class);
                if (d.getEligibleLocations().isEmpty()) {
                    d.getEligibleLocations().add(((UserServiceManager)ServiceManagerRegistry.getService(UserServiceManager.class)).getCurrentLocation().getValue());
                }
                TruckComplete dto = (TruckComplete)((TruckServiceManager)ServiceManagerRegistry.getService(TruckServiceManager.class)).create(d).getValue();
                node.removeExistingValues();
                node.setValue((Object)dto, 0L);
                node.updateNode();
                return node;
            }

            @Override
            public RemoteLoader getInvoker() {
                return model;
            }

            @Override
            public long getID() {
                return 0L;
            }
        };
        ThreadSafeLoader.run(run);
    }

    @Override
    public void loadMasterData(final long id, RemoteLoader loader, final ProgressListener progressListener) {
        ThreadSafeExecutable run = new ThreadSafeExecutable(this){

            @Override
            public Node<?> loadData() throws Exception {
                TruckModuleDataHandler.this.setCurrentLoadMaximum(3);
                TruckModuleDataHandler.this.showNextMessage(progressListener);
                ((SystemSettingsServiceManager)ServiceManagerRegistry.getService(SystemSettingsServiceManager.class)).getSettingsCached();
                TruckModuleDataHandler.this.showNextMessage(progressListener);
                ((MasterDataServiceManager)ServiceManagerRegistry.getService(MasterDataServiceManager.class)).getAllCached(TruckTypeComplete.class);
                TruckModuleDataHandler.this.showNextMessage(progressListener);
                ((SystemSettingsServiceManager)ServiceManagerRegistry.getService(SystemSettingsServiceManager.class)).getAllLocationsCached();
                return new Node();
            }

            @Override
            public RemoteLoader getInvoker() {
                return TruckModuleDataHandler.this.model;
            }

            @Override
            public long getID() {
                return id;
            }
        };
        ThreadSafeLoader.run(run);
    }

    @Override
    public Node<TruckComplete> resetData(Node<TruckComplete> node) {
        TruckComplete n = new TruckComplete();
        n.setClientOId(Long.valueOf(ADTO.getNextId()));
        return INodeCreator.getDefaultImpl().getNode4DTO((Object)n, true, false);
    }

    @Override
    public Class<TruckComplete> getCommittingClass() {
        return TruckComplete.class;
    }

    @Override
    public void doRemoteValidation(Node<TruckComplete> node, RemoteLoader listener, ProgressListener l, boolean validateAll) {
    }
}

